/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful.tier3;

import javax.annotation.Nullable;
import net.minecraft.AgeOfMinecraft.EngenderMod;
import net.minecraft.AgeOfMinecraft.LootTableListEngender;
import net.minecraft.AgeOfMinecraft.ModSoundEvents;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.helpful.tier3.EntitySlime;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityMagmaCube
extends EntitySlime {
    public EntityMagmaCube(World worldIn) {
        super(worldIn);
        this.field_70178_ae = true;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70026_G()) {
            this.func_184185_a(SoundEvents.field_187658_bx, 1.0f, 1.0f);
            this.func_70097_a(new DamageSource("cooler").func_76348_h().func_151518_m().func_76351_m(), 4.0f);
        }
    }

    @Override
    public int getNextLevelRequirement() {
        return 15 * this.getSlimeSize();
    }

    @Override
    protected boolean isValidLightLevel() {
        return true;
    }

    @Override
    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        if (EngenderMod.useMobTalkerModels) {
            String s = EntityList.func_75621_b((Entity)this);
            if (s == null) {
                s = "generic";
            }
            return this.getSlimeSize() >= 4 ? I18n.func_74838_a((String)"entity.LavaSlimeHelpful.cmm4.name") : (this.isSmallSlime() ? I18n.func_74838_a((String)"entity.LavaSlimeHelpful.cmm1.name") : I18n.func_74838_a((String)"entity.LavaSlimeHelpful.cmm2.name"));
        }
        String s = EntityList.func_75621_b((Entity)this);
        if (s == null) {
            s = "generic";
        }
        return I18n.func_74838_a((String)("entity." + s + ".name"));
    }

    public boolean func_70058_J() {
        return this.field_70170_p.func_72917_a(this.func_174813_aQ(), (Entity)this) && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && !this.field_70170_p.func_72953_d(this.func_174813_aQ());
    }

    @Override
    public void setSlimeSize(int size) {
        super.setSlimeSize(size);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a((double)(size * 2));
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float p_70070_1_) {
        return 0xF000F0;
    }

    public float func_70013_c(float p_70013_1_) {
        return 1.0f;
    }

    @Override
    protected EnumParticleTypes getParticleType() {
        return EnumParticleTypes.FLAME;
    }

    @Override
    protected EntitySlime createInstance() {
        return new EntityMagmaCube(this.field_70170_p);
    }

    @Override
    @Nullable
    protected ResourceLocation func_184647_J() {
        return this.isSmallSlime() ? LootTableList.field_186419_a : LootTableListEngender.ENTITIES_MAGMA_CUBE;
    }

    public boolean func_70027_ad() {
        return false;
    }

    @Override
    protected int getJumpDelay() {
        return super.getJumpDelay() * 4;
    }

    @Override
    protected void alterSquishAmount() {
        this.squishAmount *= 0.9f;
    }

    @Override
    protected void func_70664_aZ() {
        this.func_184185_a(this.getJumpSound(), this.func_70599_aP(), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) / (EngenderMod.useMobTalkerModels ? 1.35f : 1.1f));
        this.field_70181_x += (double)(0.42f + (float)this.getSlimeSize() * 0.1f);
        this.field_70160_al = true;
        ForgeHooks.onLivingJump((EntityLivingBase)this);
    }

    protected void func_180466_bG() {
        this.field_70181_x = 0.22f + (float)this.getSlimeSize() * 0.05f;
        this.field_70160_al = true;
    }

    @Override
    protected boolean canDamagePlayer() {
        return true;
    }

    @Override
    protected int getAttackStrength() {
        return super.getAttackStrength() + 2;
    }

    @Override
    protected SoundEvent getJumpSound() {
        return this.func_189101_db() ? SoundEvents.field_187894_fw : SoundEvents.field_187762_di;
    }

    @Override
    protected boolean makesSoundOnLand() {
        return true;
    }

    @Override
    protected SoundEvent func_184601_bQ() {
        if (EngenderMod.useMobTalkerModels) {
            this.func_184185_a(ModSoundEvents.girlHurt, this.func_70599_aP(), this.func_70647_i() + (this.getSlimeSize() > 6 ? 0.15f : 0.6f - (float)this.getSlimeSize() * 0.15f));
        }
        return this.func_189101_db() ? SoundEvents.field_187892_fv : SoundEvents.field_187760_dh;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        if (EngenderMod.useMobTalkerModels) {
            this.func_184185_a(ModSoundEvents.girlDeath, this.func_70599_aP(), this.func_70647_i() + (this.getSlimeSize() > 3 ? 0.15f : 0.6f - (float)this.getSlimeSize() * 0.15f));
        }
        return this.func_189101_db() ? SoundEvents.field_187890_fu : SoundEvents.field_187758_dg;
    }

    @Override
    protected SoundEvent func_184709_cY() {
        return this.func_189101_db() ? SoundEvents.field_187894_fw : SoundEvents.field_187764_dj;
    }

    @Override
    protected SoundEvent func_184710_cZ() {
        return this.func_189101_db() ? SoundEvents.field_187894_fw : SoundEvents.field_187762_di;
    }
}

