/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful.tier3;

import com.google.common.base.Predicate;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.AgeOfMinecraft.EngenderMod;
import net.minecraft.AgeOfMinecraft.LootTableListEngender;
import net.minecraft.AgeOfMinecraft.ModSoundEvents;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.EnumTier;
import net.minecraft.entity.helpful.Light;
import net.minecraft.entity.helpful.ai.EntityAIAvoidEntitySPC;
import net.minecraft.entity.helpful.ai.EntityAICreeperSwell;
import net.minecraft.entity.helpful.ai.EntityAIFollowLeader;
import net.minecraft.entity.helpful.ai.EntityAIFriendlyAttackMelee;
import net.minecraft.entity.monster.AbstractSkeleton;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityCreeper
extends EntityFriendlyCreature
implements Light {
    private static final DataParameter<Integer> STATE = EntityDataManager.func_187226_a(EntityCreeper.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> POWERED = EntityDataManager.func_187226_a(EntityCreeper.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IGNITED = EntityDataManager.func_187226_a(EntityCreeper.class, (DataSerializer)DataSerializers.field_187198_h);
    private int lastActiveTime;
    private int timeSinceIgnited;
    private int fuseTime = 30;
    private int explosionRadius = 3;

    public EntityCreeper(World worldIn) {
        super(worldIn);
        this.isOffensive = true;
        this.field_70714_bg.func_75776_a(0, new EntityAIAvoidEntitySPC<EntityOcelot>(this, EntityOcelot.class, new Predicate<EntityOcelot>(){

            public boolean apply(EntityOcelot p_apply_1_) {
                return p_apply_1_ != null && p_apply_1_.func_70089_S() && EntityCreeper.this.getIntelligence() < 10.0f;
            }
        }, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(0, new EntityAIAvoidEntitySPC<net.minecraft.entity.helpful.tier1.EntityOcelot>(this, net.minecraft.entity.helpful.tier1.EntityOcelot.class, new Predicate<net.minecraft.entity.helpful.tier1.EntityOcelot>(){

            public boolean apply(net.minecraft.entity.helpful.tier1.EntityOcelot p_apply_1_) {
                return p_apply_1_ != null && p_apply_1_.func_70089_S() && EntityCreeper.this.getIntelligence() < 10.0f;
            }
        }, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAICreeperSwell(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFollowLeader(this, 1.0, 32.0f, 6.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFriendlyAttackMelee(this, 1.2, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8, 80));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        if (EngenderMod.useMobTalkerModels) {
            this.func_70105_a(0.45f, 1.75f);
        } else {
            this.func_70105_a(0.5f, 1.625f);
        }
        this.field_70728_aV = 5;
    }

    @Override
    public EntityFriendlyCreature spawnBaby(EntityFriendlyCreature par1EntityAgeable) {
        return new EntityCreeper(this.field_70170_p);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
    }

    @Override
    public int getNextLevelRequirement() {
        return 25;
    }

    protected float func_70647_i() {
        return EngenderMod.useMobTalkerModels ? super.func_70647_i() + (this.getPowered() ? 0.1f : 0.2f) : super.func_70647_i();
    }

    public float func_70047_e() {
        return EngenderMod.useMobTalkerModels ? (this.getPowered() ? this.field_70131_O * 0.94f : this.field_70131_O * 0.83f) : super.func_70047_e();
    }

    @Override
    public int timesToConvert() {
        return 13;
    }

    @Override
    public EnumTier getTier() {
        return EnumTier.TIER3;
    }

    @Override
    public float getDefaultStrengthStat() {
        return 12.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    @Override
    public float getDefaultStaminaStat() {
        return 24.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    @Override
    public float getDefaultIntelligenceStat() {
        return 16.0f + this.field_70146_Z.nextFloat() * 8.0f;
    }

    @Override
    public float getDefaultDexterityStat() {
        return 4.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    @Override
    public float getDefaultAgilityStat() {
        return 4.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    @Override
    public void createChild() {
        super.createChild();
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 1 + this.field_70146_Z.nextInt(2); ++i) {
                EntityCreeper baby = new EntityCreeper(this.field_70170_p);
                baby.func_82149_j((Entity)this);
                baby.func_180482_a(this.field_70170_p.func_175649_E(this.func_180425_c()), null);
                baby.setGrowingAge(-36000);
                baby.setChild(true);
                baby.setOwnerId(this.func_184753_b());
                if (this.getPowered()) {
                    this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, baby.field_70165_t - 0.5, baby.field_70163_u + 1.0, baby.field_70161_v - 0.5, false));
                }
                if (this.isMarried()) {
                    for (int e = 0; e < 10 + this.field_70146_Z.nextInt(10); ++e) {
                        baby.levelUp();
                    }
                }
                this.field_70170_p.func_72838_d((Entity)baby);
            }
        }
    }

    @Override
    public float getBonusVSLight() {
        return 1.1f;
    }

    @Override
    public float getBonusVSArmored() {
        return 1.5f;
    }

    @Override
    public float getBonusVSMassive() {
        return 0.75f;
    }

    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        if (EngenderMod.useMobTalkerModels) {
            String s = EntityList.func_75621_b((Entity)this);
            if (s == null) {
                s = "generic";
            }
            return this.getPowered() ? I18n.func_74838_a((String)"entity.ChargedCreeperHelpful.cmm.name") : I18n.func_74838_a((String)("entity." + s + ".cmm.name"));
        }
        String s = EntityList.func_75621_b((Entity)this);
        if (s == null) {
            s = "generic";
        }
        return this.getPowered() ? I18n.func_74838_a((String)"entity.ChargedCreeperHelpful.name") : I18n.func_74838_a((String)("entity." + s + ".name"));
    }

    public int func_82143_as() {
        return this.func_70638_az() == null ? 3 : 3 + (int)(this.func_110143_aJ() - 1.0f);
    }

    @Override
    public void func_180430_e(float distance, float damageMultiplier) {
        super.func_180430_e(distance, damageMultiplier);
        this.timeSinceIgnited = (int)((float)this.timeSinceIgnited + distance * 1.5f);
        if (this.timeSinceIgnited > this.fuseTime - 5) {
            this.timeSinceIgnited = this.fuseTime - 5;
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STATE, (Object)-1);
        this.field_70180_af.func_187214_a(POWERED, (Object)false);
        this.field_70180_af.func_187214_a(IGNITED, (Object)false);
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        if (((Boolean)this.field_70180_af.func_187225_a(POWERED)).booleanValue()) {
            tagCompound.func_74757_a("powered", true);
        }
        tagCompound.func_74777_a("Fuse", (short)this.fuseTime);
        tagCompound.func_74774_a("ExplosionRadius", (byte)this.explosionRadius);
        tagCompound.func_74757_a("ignited", this.hasIgnited());
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.field_70180_af.func_187227_b(POWERED, (Object)tagCompund.func_74767_n("powered"));
        if (tagCompund.func_150297_b("Fuse", 99)) {
            this.fuseTime = tagCompund.func_74765_d("Fuse");
        }
        if (tagCompund.func_150297_b("ExplosionRadius", 99)) {
            this.explosionRadius = tagCompund.func_74771_c("ExplosionRadius");
        }
        if (tagCompund.func_74767_n("ignited")) {
            this.ignite();
        }
    }

    @Override
    public void func_70071_h_() {
        ItemStack charge = this.getPowered() ? new ItemStack(Items.field_151156_bN) : ItemStack.field_190927_a;
        charge.func_151001_c("Is Charged");
        this.basicInventory.func_70299_a(7, charge);
        if (this.func_70089_S()) {
            int i;
            this.lastActiveTime = this.timeSinceIgnited;
            if (this.hasIgnited()) {
                this.setCreeperState(1);
            }
            if ((i = this.getCreeperState()) > 0 && this.timeSinceIgnited == 0) {
                this.func_184185_a(SoundEvents.field_187572_ar, 1.0f, 0.5f);
            }
            this.timeSinceIgnited += i;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
            if (this.timeSinceIgnited >= this.fuseTime) {
                this.timeSinceIgnited = this.fuseTime;
                this.explode();
            }
        }
        if (this.field_70725_aQ == 1 && EngenderMod.useMobTalkerModels && this.getPowered()) {
            this.func_184185_a(this.func_184615_bR(), this.func_70599_aP(), this.func_70647_i() + 0.2f);
            this.func_184185_a(this.func_184615_bR(), this.func_70599_aP(), this.func_70647_i() - 0.2f);
        }
        super.func_70071_h_();
    }

    protected SoundEvent func_184601_bQ() {
        if (EngenderMod.useMobTalkerModels) {
            this.func_184185_a(ModSoundEvents.girlHurt, this.func_70599_aP(), this.func_70647_i() + 0.1f);
        }
        return SoundEvents.field_187570_aq;
    }

    protected SoundEvent func_184615_bR() {
        if (EngenderMod.useMobTalkerModels) {
            this.func_184185_a(ModSoundEvents.girlDeath, this.func_70599_aP(), this.func_70647_i() + 0.1f);
        }
        return SoundEvents.field_187568_ap;
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
            if (cause.func_76346_g() instanceof AbstractSkeleton) {
                int i = Item.func_150891_b((Item)Items.field_151096_cd);
                int j = Item.func_150891_b((Item)Items.field_151084_co);
                int k = i + this.field_70146_Z.nextInt(j - i + 1);
                this.func_145779_a(Item.func_150899_d((int)k), 1);
            } else if (cause.func_76346_g() instanceof EntityCreeper && cause.func_76346_g() != this && ((EntityCreeper)cause.func_76346_g()).getPowered()) {
                this.func_70099_a(new ItemStack(Items.field_151144_bL, 1, 4), 0.0f);
            }
        }
    }

    public float func_180428_a(Explosion explosionIn, World worldIn, BlockPos pos, IBlockState blockStateIn) {
        return blockStateIn.func_177230_c().getExplosionResistance(worldIn, pos, (Entity)this, explosionIn) * 0.5f;
    }

    @Override
    public void inflictEngenderMobDamage(EntityLivingBase entity, String killmessage, DamageSource attacktype, float damage) {
        if (this.getPowered()) {
            this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, entity.field_70165_t - 0.5, entity.field_70163_u + (double)entity.field_70131_O, entity.field_70161_v - 0.5, true));
            entity.func_70077_a(new EntityLightningBolt(this.field_70170_p, entity.field_70165_t - 0.5, entity.field_70163_u + (double)entity.field_70131_O, entity.field_70161_v - 0.5, true));
        }
        super.inflictEngenderMobDamage(entity, killmessage, attacktype, damage);
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        if (super.func_70652_k(entity)) {
            if (this.getPowered()) {
                this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, entity.field_70165_t - 0.5, entity.field_70163_u + (double)entity.field_70131_O, entity.field_70161_v - 0.5, true));
                entity.func_70077_a(new EntityLightningBolt(this.field_70170_p, entity.field_70165_t - 0.5, entity.field_70163_u + (double)entity.field_70131_O, entity.field_70161_v - 0.5, true));
            }
            return true;
        }
        return false;
    }

    public boolean getPowered() {
        return (Boolean)this.field_70180_af.func_187225_a(POWERED);
    }

    public void setPowered(boolean powered) {
        if (powered) {
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(7.0);
        }
        this.field_70180_af.func_187227_b(POWERED, (Object)powered);
    }

    @SideOnly(value=Side.CLIENT)
    public float getCreeperFlashIntensity(float p_70831_1_) {
        return ((float)this.lastActiveTime + (float)(this.timeSinceIgnited - this.lastActiveTime) * p_70831_1_) / (float)(this.fuseTime - 2);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableListEngender.ENTITIES_CREEPER;
    }

    public int getCreeperState() {
        return (Integer)this.field_70180_af.func_187225_a(STATE);
    }

    public void setCreeperState(int state) {
        this.field_70180_af.func_187227_b(STATE, (Object)state);
    }

    public void func_70077_a(EntityLightningBolt lightningBolt) {
        this.setPowered(true);
    }

    @Override
    public boolean interact(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        ItemStack heldItem = new ItemStack(stack.func_77973_b());
        if (!stack.func_190926_b() && stack.func_77973_b() == Items.field_151033_d) {
            this.field_70170_p.func_184148_a(player, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187649_bu, this.func_184176_by(), 1.0f, this.field_70146_Z.nextFloat() * 0.4f + 0.8f);
            player.func_184609_a(hand);
            if (!this.field_70170_p.field_72995_K) {
                if (this.hasOwner(player)) {
                    if (player.func_70093_af()) {
                        this.ignite();
                    }
                    if (!this.getPowered()) {
                        if (this.field_70170_p.func_175710_j(this.func_180425_c())) {
                            this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t - 0.5, this.field_70163_u + 1.625, this.field_70161_v - 0.5, false));
                        } else {
                            this.func_70656_aK();
                        }
                    } else {
                        this.func_70691_i(1.0f);
                    }
                } else {
                    this.ignite();
                }
                stack.func_77972_a(1, (EntityLivingBase)player);
            }
            return true;
        }
        return false;
    }

    @Override
    public void performSpecialAttack() {
        this.ignite();
        this.func_184185_a(SoundEvents.field_187941_ho, 10.0f, 1.0f);
    }

    private void explode() {
        if (!this.field_70170_p.field_72995_K) {
            float f;
            boolean flag = this.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
            float f2 = f = this.getPowered() ? 2.0f : 1.0f;
            if (this.func_70638_az() != null && this.getSpecialAttackTimer() <= 0 && this.isHero()) {
                EntityCreeper.createEngenderModExplosionFireless((Entity)this, this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, 20.0f * f, flag);
                this.field_70180_af.func_187227_b(IGNITED, (Object)false);
                this.setCreeperState(-1);
                this.setSpecialAttackTimer(800);
                this.timeSinceIgnited = 0;
                this.field_70181_x = 0.0;
            } else {
                this.timeSinceIgnited = 0;
                this.field_70180_af.func_187227_b(IGNITED, (Object)false);
                this.setCreeperState(-1);
                EntityCreeper.createEngenderModExplosionFireless((Entity)this, this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, (float)this.explosionRadius * f, flag);
            }
            if (this.func_110143_aJ() <= this.func_110138_aP() / 2.0f || this.isWild()) {
                this.field_70729_aU = true;
                this.func_70106_y();
                this.func_70645_a(DamageSource.func_188405_b((EntityLivingBase)this));
                Collection collection = this.func_70651_bq();
                if (!collection.isEmpty()) {
                    EntityAreaEffectCloud entityareaeffectcloud = new EntityAreaEffectCloud(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
                    entityareaeffectcloud.func_184483_a(2.5f);
                    entityareaeffectcloud.func_184495_b(-0.5f);
                    entityareaeffectcloud.func_184485_d(10);
                    entityareaeffectcloud.func_184486_b(entityareaeffectcloud.func_184489_o() / 2);
                    entityareaeffectcloud.func_184487_c(-entityareaeffectcloud.func_184490_j() / (float)entityareaeffectcloud.func_184489_o());
                    for (PotionEffect potioneffect : collection) {
                        entityareaeffectcloud.func_184496_a(new PotionEffect(potioneffect));
                    }
                    this.field_70170_p.func_72838_d((Entity)entityareaeffectcloud);
                }
                if (!this.field_70170_p.field_72995_K && EngenderMod.enableMessages && !this.isWild() && this.getOwner() instanceof EntityPlayerMP) {
                    this.getOwner().func_145747_a((ITextComponent)new TextComponentTranslation("death.attack.self_destruct", new Object[]{this.func_145748_c_()}));
                }
            } else {
                this.timeSinceIgnited = 0;
                this.field_70180_af.func_187227_b(IGNITED, (Object)false);
            }
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (EngenderMod.useMobTalkerModels) {
            this.func_70105_a(0.45f, 1.75f);
        } else {
            this.func_70105_a(0.5f, 1.625f);
        }
        if (this.getPowered()) {
            this.func_70066_B();
        }
        if (this.func_70638_az() != null && !this.hasIgnited() && this.func_70068_e((Entity)this.func_70638_az()) < 128.0 && this.getSpecialAttackTimer() <= 0 && this.isHero()) {
            this.performSpecialAttack();
        }
    }

    public boolean hasIgnited() {
        return (Boolean)this.field_70180_af.func_187225_a(IGNITED);
    }

    public void ignite() {
        this.field_70180_af.func_187227_b(IGNITED, (Object)true);
    }
}

