/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful.tier2;

import javax.annotation.Nullable;
import net.minecraft.AgeOfMinecraft.LootTableListEngender;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IJumpingMount;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.helpful.Animal;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.EnumTier;
import net.minecraft.entity.helpful.Light;
import net.minecraft.entity.helpful.ai.EntityAICustomLeapAttack;
import net.minecraft.entity.helpful.ai.EntityAIFollowLeader;
import net.minecraft.entity.helpful.ai.EntityAIFriendlyAttackMelee;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityWolf
extends EntityFriendlyCreature
implements IJumpingMount,
Light,
Animal {
    protected static final DataParameter<Byte> ANGRY = EntityDataManager.func_187226_a(EntityWolf.class, (DataSerializer)DataSerializers.field_187191_a);
    private float headRotationCourse;
    private float headRotationCourseOld;
    private boolean isWet;
    private boolean isShaking;
    private float timeWolfIsShaking;
    private float prevTimeWolfIsShaking;
    protected float jumpPower;

    public EntityWolf(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 0.8f);
        this.isOffensive = true;
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFollowLeader(this, 1.0, 15.0f, 4.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAICustomLeapAttack((EntityLiving)this, 0.4f, 0.75f, 0.8f, 0.5f, 4.0, 24.0, 3));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFriendlyAttackMelee(this, 1.0, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0, 80));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70728_aV = 3;
    }

    @Override
    public int getNextLevelRequirement() {
        return 15;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.3f);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
    }

    @Override
    public float getBonusVSLight() {
        return 2.0f;
    }

    @Override
    public float getBonusVSArmored() {
        return 0.5f;
    }

    @Override
    public float getBonusVSMassive() {
        return 0.1f;
    }

    @Override
    public float getDefaultStrengthStat() {
        return 12.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    @Override
    public float getDefaultStaminaStat() {
        return 48.0f + this.field_70146_Z.nextFloat() * 24.0f;
    }

    @Override
    public float getDefaultIntelligenceStat() {
        return 12.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    @Override
    public float getDefaultDexterityStat() {
        return 24.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    @Override
    public float getDefaultAgilityStat() {
        return 32.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    @Override
    public boolean canBeMatedWith() {
        return false;
    }

    @Override
    public boolean canBeMarried() {
        return false;
    }

    @Override
    public EntityFriendlyCreature spawnBaby(EntityFriendlyCreature par1EntityAgeable) {
        return new EntityWolf(this.field_70170_p);
    }

    @Override
    public EnumTier getTier() {
        return EnumTier.TIER2;
    }

    @Override
    public float func_180484_a(BlockPos pos) {
        return this.field_70170_p.func_180495_p(pos.func_177977_b()).func_177230_c() == this.spawnableBlock ? 10.0f : this.field_70170_p.func_175724_o(pos) - 0.5f;
    }

    @Override
    public void func_70624_b(EntityLivingBase p_70624_1_) {
        super.func_70624_b(p_70624_1_);
        this.setAngry(true);
    }

    @Override
    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.func_70638_az() != null) {
            this.setAngry(true);
        } else {
            this.setAngry(false);
        }
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187869_gK, 0.15f, 1.0f / this.getFittness());
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ANGRY, (Object)0);
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74757_a("Angry", this.isAngry());
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.setAngry(tagCompund.func_74767_n("Angry"));
    }

    protected SoundEvent func_184639_G() {
        return this.isAngry() ? SoundEvents.field_187861_gG : SoundEvents.field_187857_gE;
    }

    protected SoundEvent func_184601_bQ() {
        return SoundEvents.field_187863_gH;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187859_gF;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableListEngender.ENTITIES_WOLF;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        this.func_70105_a(0.6f, 0.8f);
        if (!this.field_70170_p.field_72995_K && this.isWet && !this.isShaking && !this.func_70781_l() && this.field_70122_E) {
            this.isShaking = true;
            this.timeWolfIsShaking = 0.0f;
            this.prevTimeWolfIsShaking = 0.0f;
            this.field_70170_p.func_72960_a((Entity)this, (byte)8);
        }
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() == null && this.isAngry()) {
            this.setAngry(false);
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.headRotationCourseOld = this.headRotationCourse;
        this.headRotationCourse += (0.0f - this.headRotationCourse) * 0.4f;
        if (this.func_70026_G()) {
            this.isWet = true;
            this.isShaking = false;
            this.timeWolfIsShaking = 0.0f;
            this.prevTimeWolfIsShaking = 0.0f;
        } else if ((this.isWet || this.isShaking) && this.isShaking) {
            if (this.timeWolfIsShaking == 0.0f) {
                this.func_184185_a(SoundEvents.field_187867_gJ, this.func_70599_aP(), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            }
            this.prevTimeWolfIsShaking = this.timeWolfIsShaking;
            this.timeWolfIsShaking += 0.05f;
            if (this.prevTimeWolfIsShaking >= 2.0f) {
                this.isWet = false;
                this.isShaking = false;
                this.prevTimeWolfIsShaking = 0.0f;
                this.timeWolfIsShaking = 0.0f;
            }
            if (this.timeWolfIsShaking > 0.4f) {
                float f = (float)this.func_174813_aQ().field_72338_b;
                int i = (int)(MathHelper.func_76126_a((float)((this.timeWolfIsShaking - 0.4f) * (float)Math.PI)) * 7.0f);
                for (int j = 0; j < i; ++j) {
                    float f1 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N * 0.5f;
                    float f2 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N * 0.5f;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_SPLASH, this.field_70165_t + (double)f1, (double)(f + 0.8f), this.field_70161_v + (double)f2, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isWolfWet() {
        return this.isWet;
    }

    @SideOnly(value=Side.CLIENT)
    public float getShadingWhileWet(float p_70915_1_) {
        return 0.75f + (this.prevTimeWolfIsShaking + (this.timeWolfIsShaking - this.prevTimeWolfIsShaking) * p_70915_1_) / 2.0f * 0.25f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getShakeAngle(float p_70923_1_, float p_70923_2_) {
        float f2 = (this.prevTimeWolfIsShaking + (this.timeWolfIsShaking - this.prevTimeWolfIsShaking) * p_70923_1_ + p_70923_2_) / 1.8f;
        if (f2 < 0.0f) {
            f2 = 0.0f;
        } else if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        return MathHelper.func_76126_a((float)(f2 * (float)Math.PI)) * MathHelper.func_76126_a((float)(f2 * (float)Math.PI * 11.0f)) * 0.15f * (float)Math.PI;
    }

    @SideOnly(value=Side.CLIENT)
    public float getInterestedAngle(float p_70917_1_) {
        return (this.headRotationCourseOld + (this.headRotationCourse - this.headRotationCourseOld) * p_70917_1_) * 0.15f * (float)Math.PI;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.8f;
    }

    @Override
    public boolean interact(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemFood) {
            ItemFood itemfood = (ItemFood)stack.func_77973_b();
            if (itemfood.func_77845_h() && this.func_110143_aJ() < this.func_110138_aP()) {
                stack.func_190918_g(1);
                this.func_70691_i(itemfood.func_150905_g(stack));
            }
            return true;
        }
        if (stack.func_190926_b() && this.func_184187_bx() == null) {
            if (!this.isWild() && this.isOnSameTeam((EntityLivingBase)player) && !this.func_70631_g_() && !this.field_70170_p.field_72995_K) {
                player.func_184220_m((Entity)this);
            }
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 8) {
            this.isShaking = true;
            this.timeWolfIsShaking = 0.0f;
            this.prevTimeWolfIsShaking = 0.0f;
        } else {
            super.func_70103_a(id);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getTailRotation() {
        return this.isAngry() ? 1.5393804f : 0.62831855f;
    }

    public boolean isAngry() {
        return ((Byte)this.field_70180_af.func_187225_a(ANGRY) & 2) != 0;
    }

    public void setAngry(boolean angry) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(ANGRY);
        if (angry) {
            this.field_70180_af.func_187227_b(ANGRY, (Object)((byte)(b0 | 2)));
        } else {
            this.field_70180_af.func_187227_b(ANGRY, (Object)((byte)(b0 & 0xFFFFFFFD)));
        }
    }

    public void func_110206_u(int jumpPowerIn) {
        if (this.func_184207_aI()) {
            if (jumpPowerIn < 0) {
                jumpPowerIn = 0;
            }
            if (jumpPowerIn >= 90) {
                this.func_184185_a(SoundEvents.field_187817_fK, 1.0f, 1.5f);
                this.jumpPower = 1.0f;
            } else {
                this.jumpPower = 0.4f + 0.4f * (float)jumpPowerIn / 90.0f;
            }
        }
    }

    public boolean func_184776_b() {
        return true;
    }

    public void func_184775_b(int p_184775_1_) {
        this.func_70642_aH();
    }

    public void func_184777_r_() {
    }

    public void func_70612_e(float strafe, float forward) {
        EntityLivingBase entitylivingbase = (EntityLivingBase)this.func_184179_bs();
        if (this.func_184207_aI() && this.func_82171_bF()) {
            this.field_70126_B = this.field_70177_z = entitylivingbase.field_70177_z;
            this.field_70125_A = entitylivingbase.field_70125_A;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            strafe = entitylivingbase.field_70702_br;
            forward = entitylivingbase.field_70701_bs;
            this.field_70747_aH = 0.05f;
            if (this.func_184186_bw()) {
                this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                super.func_70612_e(strafe, forward);
            } else if (entitylivingbase instanceof EntityPlayer) {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            if (this.jumpPower > 0.0f && this.field_70122_E) {
                this.field_70181_x = 0.6 * (double)this.jumpPower;
                if (this.func_70644_a(MobEffects.field_76430_j)) {
                    this.field_70181_x += (double)((float)(this.func_70660_b(MobEffects.field_76430_j).func_76458_c() + 1) * 0.1f);
                }
                this.field_70160_al = true;
                float f = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
                float f1 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
                this.field_70159_w = -2.0f * f * this.jumpPower;
                this.field_70179_y = 2.0f * f1 * this.jumpPower;
                this.jumpPower = 0.0f;
                ForgeHooks.onLivingJump((EntityLivingBase)this);
            }
            this.field_184618_aE = this.field_70721_aZ;
            double d5 = this.field_70165_t - this.field_70169_q;
            double d7 = this.field_70161_v - this.field_70166_s;
            float f10 = MathHelper.func_76133_a((double)(d5 * d5 + d7 * d7)) * 4.0f;
            if (f10 > 1.0f) {
                f10 = 1.0f;
            }
            this.field_70721_aZ += (f10 - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
        } else {
            this.field_70747_aH = 0.02f;
            super.func_70612_e(strafe, forward);
        }
    }
}

