/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful.tier2;

import javax.annotation.Nullable;
import net.minecraft.AgeOfMinecraft.LootTableListEngender;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.helpful.Animal;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.EnumTier;
import net.minecraft.entity.helpful.Light;
import net.minecraft.entity.helpful.ai.EntityAIFriendlyAttackMelee;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntitySquid
extends EntityFriendlyCreature
implements Light,
Animal {
    public float squidPitch;
    public float prevSquidPitch;
    public float squidYaw;
    public float prevSquidYaw;
    public float squidRotation;
    public float prevSquidRotation;
    public float tentacleAngle;
    public float lastTentacleAngle;
    private float randomMotionSpeed;
    private float rotationVelocity;
    private float rotateSpeed;
    private float randomMotionVecX;
    private float randomMotionVecY;
    private float randomMotionVecZ;

    public EntitySquid(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.9f, 0.9f);
        this.field_70146_Z.setSeed(1 + this.func_145782_y());
        this.rotationVelocity = 1.0f / (this.field_70146_Z.nextFloat() + 1.0f) * 0.2f;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AIMoveRandom(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFriendlyAttackMelee(this, 1.0, true));
        this.field_70728_aV = 2;
    }

    @Override
    public EntityFriendlyCreature spawnBaby(EntityFriendlyCreature par1EntityAgeable) {
        return new EntitySquid(this.field_70170_p);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
    }

    @Override
    public boolean canWearEasterEggs() {
        return false;
    }

    @Override
    public EnumTier getTier() {
        return EnumTier.TIER2;
    }

    @Override
    public float getDefaultStrengthStat() {
        return 1.0f;
    }

    @Override
    public float getDefaultStaminaStat() {
        return 24.0f + this.field_70146_Z.nextFloat() * 8.0f;
    }

    @Override
    public float getDefaultIntelligenceStat() {
        return 1.0f;
    }

    @Override
    public float getDefaultDexterityStat() {
        return 16.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    @Override
    public float getDefaultAgilityStat() {
        return 28.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    @Override
    public boolean canBeButchered() {
        return true;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.5f;
    }

    @Override
    public boolean canBeMatedWith() {
        return false;
    }

    @Override
    public boolean canBeMarried() {
        return false;
    }

    protected SoundEvent func_184639_G() {
        return !this.func_70090_H() ? SoundEvents.field_187833_fS : SoundEvents.field_187829_fQ;
    }

    protected SoundEvent func_184601_bQ() {
        return SoundEvents.field_187833_fS;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187831_fR;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    @Override
    public float func_180484_a(BlockPos pos) {
        return this.field_70170_p.func_180495_p(pos).func_185904_a() == Material.field_151586_h ? 10.0f + this.field_70170_p.func_175724_o(pos) - 0.5f : super.func_180484_a(pos);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableListEngender.ENTITIES_SQUID;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70725_aQ > 0) {
            this.field_70181_x = -0.6;
        }
        this.func_70105_a(0.9f, 0.9f);
        this.prevSquidPitch = this.squidPitch;
        this.prevSquidYaw = this.squidYaw;
        this.prevSquidRotation = this.squidRotation;
        this.lastTentacleAngle = this.tentacleAngle;
        this.squidRotation += this.rotationVelocity;
        if ((double)this.squidRotation > Math.PI * 2) {
            if (this.field_70170_p.field_72995_K) {
                this.squidRotation = (float)Math.PI * 2;
            } else {
                this.squidRotation = (float)((double)this.squidRotation - Math.PI * 2);
                if (this.field_70146_Z.nextInt(10) == 0) {
                    this.rotationVelocity = 1.0f / (this.field_70146_Z.nextFloat() + 1.0f) * 0.2f;
                }
                this.field_70170_p.func_72960_a((Entity)this, (byte)19);
            }
        }
        if (this.func_175446_cd()) {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
        } else if (this.field_70171_ac) {
            if (this.squidRotation < (float)Math.PI) {
                float f = this.squidRotation / (float)Math.PI;
                this.tentacleAngle = MathHelper.func_76126_a((float)(f * f * (float)Math.PI)) * (float)Math.PI * ((this.func_70638_az() != null ? 0.5f : 0.25f) * (float)(this.func_70631_g_() ? 2 : 1));
                if ((double)f > 0.9) {
                    this.randomMotionSpeed = 1.0f;
                    this.rotateSpeed = 1.0f;
                } else {
                    this.rotateSpeed *= 0.8f;
                }
            } else {
                this.tentacleAngle = 0.0f;
                this.randomMotionSpeed *= 0.9f;
                this.rotateSpeed *= 0.99f;
            }
            if (!this.field_70170_p.field_72995_K) {
                this.field_70159_w = this.randomMotionVecX * this.randomMotionSpeed;
                this.field_70181_x = this.randomMotionVecY * this.randomMotionSpeed;
                this.field_70179_y = this.randomMotionVecZ * this.randomMotionSpeed;
            }
            float f1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70761_aq += (-((float)MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y)) * 57.295776f - this.field_70761_aq) * 0.1f;
            this.field_70177_z = this.field_70761_aq;
            this.squidYaw = (float)((double)this.squidYaw + Math.PI * (double)this.rotateSpeed * 1.5);
            this.squidPitch += (-((float)MathHelper.func_181159_b((double)f1, (double)this.field_70181_x)) * 57.295776f - this.squidPitch) * 0.1f;
        } else {
            this.tentacleAngle = MathHelper.func_76135_e((float)MathHelper.func_76126_a((float)this.squidRotation)) * (float)Math.PI * 0.25f;
            if (!this.field_70170_p.field_72995_K) {
                this.field_70159_w = 0.0;
                this.field_70179_y = 0.0;
                if (this.func_70644_a(MobEffects.field_188424_y)) {
                    this.field_70181_x += 0.05 * (double)(this.func_70660_b(MobEffects.field_188424_y).func_76458_c() + 1) - this.field_70181_x;
                } else if (!this.func_189652_ae()) {
                    this.field_70181_x -= 0.08;
                }
                this.field_70181_x *= (double)0.98f;
            }
            this.squidPitch = (float)((double)this.squidPitch + (double)(-90.0f - this.squidPitch) * 0.02);
        }
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * 0.7;
    }

    public boolean shouldDismountInWater(Entity rider) {
        return false;
    }

    public void func_70612_e(float strafe, float forward) {
        if (this.func_70089_S()) {
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            if (!this.func_70090_H()) {
                if (this.field_70122_E) {
                    this.field_70159_w = 0.0;
                    this.field_70179_y = 0.0;
                }
                BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185345_c((double)this.field_70165_t, (double)(this.func_174813_aQ().field_72338_b - 1.0), (double)this.field_70161_v);
                if (this.func_70644_a(MobEffects.field_188424_y)) {
                    this.field_70181_x += (0.05 * (double)(this.func_70660_b(MobEffects.field_188424_y).func_76458_c() + 1) - this.field_70181_x) * 0.2;
                } else {
                    blockpos$pooledmutableblockpos.func_189532_c(this.field_70165_t, 0.0, this.field_70161_v);
                    if (!this.field_70170_p.field_72995_K || this.field_70170_p.func_175667_e((BlockPos)blockpos$pooledmutableblockpos) && this.field_70170_p.func_175726_f((BlockPos)blockpos$pooledmutableblockpos).func_177410_o()) {
                        if (!this.func_189652_ae()) {
                            this.field_70181_x -= 0.08;
                        }
                    } else {
                        this.field_70181_x = this.field_70163_u > 0.0 ? -0.1 : 0.0;
                    }
                }
                this.field_70181_x *= (double)0.98f;
            }
        } else {
            super.func_70612_e(strafe, forward);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 19) {
            this.squidRotation = 0.0f;
        } else {
            super.func_70103_a(id);
        }
    }

    public void setMovementVector(float randomMotionVecXIn, float randomMotionVecYIn, float randomMotionVecZIn) {
        this.randomMotionVecX = randomMotionVecXIn;
        this.randomMotionVecY = randomMotionVecYIn;
        this.randomMotionVecZ = randomMotionVecZIn;
    }

    public boolean hasMovementVector() {
        return this.randomMotionVecX != 0.0f || this.randomMotionVecY != 0.0f || this.randomMotionVecZ != 0.0f;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean handleLavaMovement() {
        return this.field_70170_p.func_72917_a(this.func_174813_aQ(), (Entity)this);
    }

    public int func_70627_aG() {
        return 120;
    }

    public void func_70030_z() {
        int i = this.func_70086_ai();
        super.func_70030_z();
        if (this.func_70089_S() && !this.func_70090_H()) {
            this.func_70050_g(--i);
            if (this.func_70086_ai() == -10) {
                this.func_70050_g(0);
                this.func_70097_a(DamageSource.field_82727_n, 3.0f);
                if (!this.field_70170_p.field_72995_K && this.field_70146_Z.nextInt(10) == 0 && this.field_70122_E) {
                    this.field_70159_w += (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.4f);
                    this.field_70179_y += (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.4f);
                    this.field_70177_z = this.field_70146_Z.nextFloat() * 360.0f;
                    this.func_70664_aZ();
                }
            }
        } else {
            this.func_70050_g(300);
        }
    }

    public boolean func_96092_aw() {
        return false;
    }

    @Override
    public boolean interact(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_190926_b() && this.func_184187_bx() == null) {
            if (!this.isWild() && this.isOnSameTeam((EntityLivingBase)player) && !this.func_70631_g_() && !this.field_70170_p.field_72995_K) {
                player.func_184220_m((Entity)this);
            }
            return true;
        }
        return false;
    }

    static class AIMoveRandom
    extends EntityAIBase {
        private final EntitySquid squid;

        public AIMoveRandom(EntitySquid p_i45859_1_) {
            this.squid = p_i45859_1_;
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            int i;
            if (this.squid.func_70089_S() && this.squid.func_70638_az() != null && this.squid.func_70638_az().func_70089_S() && !this.squid.func_70631_g_() && !this.squid.isOnSameTeam(this.squid.func_70638_az()) && this.squid.func_70068_e((Entity)this.squid.func_70638_az()) < (double)(this.squid.field_70130_N * this.squid.field_70130_N + this.squid.func_70638_az().field_70130_N * this.squid.func_70638_az().field_70130_N) + 4.0 && (this.squid.field_70173_aa + this.squid.func_145782_y()) % 20 == 0) {
                this.squid.func_70652_k((Entity)this.squid.func_70638_az());
            }
            if ((i = this.squid.func_70654_ax()) > 100) {
                this.squid.setMovementVector(0.0f, 0.0f, 0.0f);
            } else if (this.squid.func_184207_aI() && this.squid.func_184179_bs() instanceof EntityPlayer && this.squid.field_70171_ac && this.squid.hasMovementVector()) {
                EntityPlayer passenger = (EntityPlayer)this.squid.func_184179_bs();
                passenger.func_70690_d(new PotionEffect(MobEffects.field_76427_o, 200, 0, true, true));
                passenger.func_70690_d(new PotionEffect(MobEffects.field_76439_r, 200, 0, true, true));
                double d1 = 0.6;
                Vec3d vec3 = passenger.func_70676_i(1.0f);
                this.squid.setMovementVector((float)(vec3.field_72450_a * d1), (float)(vec3.field_72448_b * d1), (float)(vec3.field_72449_c * d1));
            } else if (this.squid.func_70638_az() != null && this.squid.field_70171_ac && this.squid.hasMovementVector()) {
                double d01 = this.squid.func_70638_az().field_70165_t - this.squid.field_70165_t;
                double d11 = this.squid.func_70638_az().field_70163_u - this.squid.field_70163_u;
                double d21 = this.squid.func_70638_az().field_70161_v - this.squid.field_70161_v;
                float fl2 = MathHelper.func_76133_a((double)(d01 * d01 + d11 * d11 + d21 * d21));
                float f1 = (float)(d01 / (double)fl2 * 0.2 + this.squid.field_70159_w);
                float f2 = (float)(d11 / (double)fl2 * 0.2 + this.squid.field_70181_x);
                float f3 = (float)(d21 / (double)fl2 * 0.2 + this.squid.field_70179_y);
                this.squid.setMovementVector(f1, f2, f3);
            } else if (this.squid.getOwner() != null && this.squid.func_70068_e((Entity)this.squid.getOwner()) > 128.0 && this.squid.field_70171_ac && this.squid.hasMovementVector()) {
                double d01 = this.squid.getOwner().field_70165_t - this.squid.field_70165_t;
                double d11 = this.squid.getOwner().field_70163_u - this.squid.field_70163_u;
                double d21 = this.squid.getOwner().field_70161_v - this.squid.field_70161_v;
                float fl2 = MathHelper.func_76133_a((double)(d01 * d01 + d11 * d11 + d21 * d21));
                float f1 = (float)(d01 / (double)fl2 * 0.2 + this.squid.field_70159_w);
                float f2 = (float)(d11 / (double)fl2 * 0.2 + this.squid.field_70181_x);
                float f3 = (float)(d21 / (double)fl2 * 0.2 + this.squid.field_70179_y);
                this.squid.setMovementVector(f1, f2, f3);
            } else if (this.squid.func_70681_au().nextInt(50) == 0 || !this.squid.field_70171_ac || !this.squid.hasMovementVector()) {
                float f = this.squid.func_70681_au().nextFloat() * ((float)Math.PI * 2);
                float f1 = MathHelper.func_76134_b((float)f) * 0.2f;
                float f2 = -0.1f + this.squid.func_70681_au().nextFloat() * 0.2f;
                float f3 = MathHelper.func_76126_a((float)f) * 0.2f;
                this.squid.setMovementVector(f1, f2, f3);
            }
        }
    }
}

