/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful.tier2;

import javax.annotation.Nullable;
import net.minecraft.AgeOfMinecraft.EngenderMod;
import net.minecraft.AgeOfMinecraft.LootTableListEngender;
import net.minecraft.AgeOfMinecraft.ModSoundEvents;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.helpful.Elemental;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.EnumTier;
import net.minecraft.entity.helpful.Light;
import net.minecraft.entity.helpful.ai.EntityAIAttackRangedAlly;
import net.minecraft.entity.helpful.ai.EntityAIFollowLeader;
import net.minecraft.entity.helpful.ai.EntityAIFriendlyHurtByTarget;
import net.minecraft.entity.helpful.ai.EntityAILeaderHurtByTarget;
import net.minecraft.entity.helpful.ai.EntityAILeaderHurtTarget;
import net.minecraft.entity.helpful.tier5.EntitySnowballHarmful;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class EntitySnowman
extends EntityFriendlyCreature
implements IRangedAttackMob,
Light,
Elemental {
    private static final DataParameter<Byte> PUMPKIN_EQUIPPED = EntityDataManager.func_187226_a(EntitySnowman.class, (DataSerializer)DataSerializers.field_187191_a);

    public EntitySnowman(World worldIn) {
        super(worldIn);
        if (EngenderMod.useMobTalkerModels) {
            this.func_70105_a(0.45f, 1.75f);
        } else {
            this.func_70105_a(0.7f, 1.9f);
        }
        this.isOffensive = true;
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.LAVA, -1.0f);
        this.func_184644_a(PathNodeType.DANGER_FIRE, -1.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, -1.0f);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFollowLeader(this, 1.0, 24.0f, 6.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackRangedAlly(this, 1.25, 30, 16.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0, 80));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIFriendlyHurtByTarget(this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAILeaderHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAILeaderHurtTarget(this));
        this.field_70728_aV = 1;
    }

    @Override
    public float getBonusVSArmored() {
        return 0.25f;
    }

    @Override
    public float getBonusVSMassive() {
        return 0.25f;
    }

    @Override
    public float getDefaultStrengthStat() {
        return 1.0f;
    }

    @Override
    public float getDefaultStaminaStat() {
        return 100.0f;
    }

    @Override
    public float getDefaultIntelligenceStat() {
        return 1.0f;
    }

    @Override
    public float getDefaultDexterityStat() {
        return 32.0f + this.field_70146_Z.nextFloat() * 8.0f;
    }

    @Override
    public float getDefaultAgilityStat() {
        return 4.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    @Override
    public int timesToConvert() {
        return 3;
    }

    @Override
    public boolean canWearEasterEggs() {
        return false;
    }

    @Override
    public EntityFriendlyCreature spawnBaby(EntityFriendlyCreature par1EntityAgeable) {
        return new EntitySnowman(this.field_70170_p);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.2f);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PUMPKIN_EQUIPPED, (Object)0);
    }

    @Override
    public EnumTier getTier() {
        return EnumTier.TIER2;
    }

    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        if (EngenderMod.useMobTalkerModels) {
            String s = EntityList.func_75621_b((Entity)this);
            if (s == null) {
                s = "generic";
            }
            return I18n.func_74838_a((String)("entity." + s + ".cmm.name"));
        }
        String s = EntityList.func_75621_b((Entity)this);
        if (s == null) {
            s = "generic";
        }
        return I18n.func_74838_a((String)("entity." + s + ".name"));
    }

    @Override
    public void createChild() {
        super.createChild();
        if (!this.field_70170_p.field_72995_K) {
            EntitySnowman baby = new EntitySnowman(this.field_70170_p);
            baby.func_82149_j((Entity)this);
            baby.func_180482_a(this.field_70170_p.func_175649_E(this.func_180425_c()), null);
            baby.setGrowingAge(-24000);
            baby.setChild(true);
            baby.setOwnerId(this.func_184753_b());
            if (this.isMarried()) {
                for (int e = 0; e < 10 + this.field_70146_Z.nextInt(10); ++e) {
                    baby.levelUp();
                }
            }
            this.field_70170_p.func_72838_d((Entity)baby);
        }
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EngenderMod.CONSTRUCT;
    }

    @Override
    public void func_70636_d() {
        block10: {
            int k;
            int j;
            int i;
            block12: {
                block11: {
                    ItemStack charge = this.isPumpkinEquipped() ? new ItemStack(Blocks.field_150423_aK) : ItemStack.field_190927_a;
                    charge.func_151001_c("Pumpkin Sheared");
                    this.basicInventory.func_70299_a(7, charge);
                    super.func_70636_d();
                    if (this.func_70089_S() && this.func_70638_az() != null && this.func_70638_az().func_70089_S() && this.isOffensive && !this.func_70631_g_() && !this.isOnSameTeam(this.func_70638_az())) {
                        double d = this.func_70068_e((Entity)this.func_70638_az());
                        float f = this.func_70638_az() instanceof EntityFriendlyCreature ? ((EntityFriendlyCreature)this.func_70638_az()).reachWidth : this.func_70638_az().field_70130_N;
                        float f2 = this.func_70638_az() instanceof EntityFriendlyCreature ? ((EntityFriendlyCreature)this.func_70638_az()).reachWidth : this.func_70638_az().field_70130_N;
                        if (d < (double)(this.reachWidth * this.reachWidth + f * f2) + 9.0 && (this.field_70173_aa + this.func_145782_y()) % 20 == 0) {
                            this.func_70652_k((Entity)this.func_70638_az());
                            this.func_184609_a(EnumHand.MAIN_HAND);
                            if (!this.func_184592_cb().func_190926_b()) {
                                this.func_184609_a(EnumHand.OFF_HAND);
                            }
                        }
                    }
                    if (EngenderMod.useMobTalkerModels) {
                        this.func_70105_a(0.45f, 1.75f);
                    } else {
                        this.func_70105_a(0.7f, 1.9f);
                    }
                    if (this.field_70170_p.field_72995_K) break block10;
                    i = MathHelper.func_76128_c((double)this.field_70165_t);
                    j = MathHelper.func_76128_c((double)this.field_70163_u);
                    k = MathHelper.func_76128_c((double)this.field_70161_v);
                    if (this.func_70026_G()) break block11;
                    BlockPos blockPos = new BlockPos(i, 0, k);
                    BlockPos blockPos2 = new BlockPos(i, j, k);
                    if (!(this.field_70170_p.func_180494_b(blockPos).func_180626_a(blockPos2) > 1.0f)) break block12;
                }
                this.func_70097_a(new DamageSource("melt").func_76361_j().func_76348_h(), 1.0f);
            }
            if (!this.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
                return;
            }
            for (int l = 0; l < 4; ++l) {
                i = MathHelper.func_76128_c((double)(this.field_70165_t + (double)((float)(l % 2 * 2 - 1) * 0.25f)));
                BlockPos blockpos = new BlockPos(i, j = MathHelper.func_76128_c((double)this.field_70163_u), k = MathHelper.func_76128_c((double)(this.field_70161_v + (double)((float)(l / 2 % 2 * 2 - 1) * 0.25f))));
                if (this.field_70170_p.func_180495_p(blockpos).func_185904_a() != Material.field_151579_a) continue;
                BlockPos blockPos = new BlockPos(i, 0, k);
                if (!(this.field_70170_p.func_180494_b(blockPos).func_180626_a(blockpos) < 0.8f) || !Blocks.field_150431_aC.func_176196_c(this.field_70170_p, blockpos)) continue;
                this.field_70170_p.func_175656_a(blockpos, Blocks.field_150431_aC.func_176223_P());
            }
        }
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableListEngender.ENTITIES_SNOWMAN;
    }

    @Override
    public boolean interact(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.func_70631_g_()) {
            if (this.hasOwner(player)) {
                player.func_184609_a(EnumHand.MAIN_HAND);
                if (this.func_184187_bx() == null) {
                    this.func_184205_a((Entity)player, true);
                } else {
                    this.func_184210_p();
                }
            }
            return true;
        }
        if (!stack.func_190926_b() && stack.func_77973_b() == Items.field_151097_aZ) {
            if (this.hasOwner(player) && !this.isPumpkinEquipped() && !this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_175718_b(2001, this.func_180425_c().func_177984_a(), Block.func_176210_f((IBlockState)Blocks.field_150423_aK.func_176223_P()));
                this.setPumpkinEquipped(true);
                stack.func_77972_a(1, (EntityLivingBase)player);
            }
            return true;
        }
        return false;
    }

    public boolean isPumpkinEquipped() {
        return ((Byte)this.field_70180_af.func_187225_a(PUMPKIN_EQUIPPED) & 0x10) != 0;
    }

    public void setPumpkinEquipped(boolean p_184747_1_) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(PUMPKIN_EQUIPPED);
        if (p_184747_1_) {
            this.field_70180_af.func_187227_b(PUMPKIN_EQUIPPED, (Object)((byte)(b0 | 0x10)));
        } else {
            this.field_70180_af.func_187227_b(PUMPKIN_EQUIPPED, (Object)((byte)(b0 & 0xFFFFFFEF)));
        }
    }

    public void func_82196_d(EntityLivingBase target, float p_82196_2_) {
        EntitySnowballHarmful entitysnowball = new EntitySnowballHarmful(this.field_70170_p, (EntityLivingBase)this);
        double d0 = target.field_70163_u + (double)target.func_70047_e() - 1.15;
        double d1 = target.field_70165_t - this.field_70165_t;
        double d2 = d0 - entitysnowball.field_70163_u;
        double d3 = target.field_70161_v - this.field_70161_v;
        float f = MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3)) * 0.2f;
        entitysnowball.func_70186_c(d1, d2 + (double)f, d3, 1.6f, this.isPumpkinEquipped() ? 45.0f : 1.0f);
        this.func_184185_a(SoundEvents.field_187805_fE, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)entitysnowball);
        this.func_184609_a(EnumHand.MAIN_HAND);
        entitysnowball.damage = target instanceof net.minecraft.entity.helpful.tier4.EntityBlaze || target instanceof EntityBlaze ? 3.0f : (this.field_70146_Z.nextInt(3) == 0 || !(target instanceof EntityFriendlyCreature) ? 1.0f : 0.0f);
    }

    protected float func_70647_i() {
        return EngenderMod.useMobTalkerModels ? super.func_70647_i() + 0.2f : super.func_70647_i();
    }

    public float func_70047_e() {
        return EngenderMod.useMobTalkerModels ? this.field_70131_O * 0.84f : this.field_70131_O * 0.89f;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187799_fB;
    }

    protected SoundEvent func_184601_bQ() {
        if (EngenderMod.useMobTalkerModels) {
            this.func_184185_a(ModSoundEvents.girlHurt, this.func_70599_aP(), this.func_70647_i() + 0.1f);
        }
        return SoundEvents.field_187803_fD;
    }

    protected SoundEvent func_184615_bR() {
        if (EngenderMod.useMobTalkerModels) {
            this.func_184185_a(ModSoundEvents.girlDeath, this.func_70599_aP(), this.func_70647_i() + 0.1f);
        }
        return SoundEvents.field_187801_fC;
    }
}

