/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful.tier2;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.AgeOfMinecraft.EngenderMod;
import net.minecraft.AgeOfMinecraft.LootTableListEngender;
import net.minecraft.AgeOfMinecraft.ModSoundEvents;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSilverfish;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.EnumTier;
import net.minecraft.entity.helpful.Light;
import net.minecraft.entity.helpful.Tiny;
import net.minecraft.entity.helpful.ai.EntityAIFollowLeader;
import net.minecraft.entity.helpful.ai.EntityAIFriendlyAttackMelee;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class EntitySilverfish
extends EntityFriendlyCreature
implements Light,
Tiny {
    private AISummonSilverfish summonSilverfish;

    public EntitySilverfish(World worldIn) {
        super(worldIn);
        if (EngenderMod.useMobTalkerModels) {
            this.func_70105_a(0.25f, 0.95f);
        } else {
            this.func_70105_a(0.4f, 0.3f);
        }
        this.isOffensive = true;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.summonSilverfish = new AISummonSilverfish(this);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.summonSilverfish);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFollowLeader(this, 1.2, 24.0f, 6.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFriendlyAttackMelee(this, 1.2, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0, 80));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70728_aV = 1;
    }

    @Override
    public int getNextLevelRequirement() {
        return 10;
    }

    @Override
    public float getBonusVSArmored() {
        return 0.25f;
    }

    @Override
    public float getBonusVSMassive() {
        return 0.25f;
    }

    @Override
    public float getDefaultStrengthStat() {
        return 4.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    @Override
    public float getDefaultStaminaStat() {
        return 24.0f + this.field_70146_Z.nextFloat() * 24.0f;
    }

    @Override
    public float getDefaultIntelligenceStat() {
        return 2.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    @Override
    public float getDefaultDexterityStat() {
        return 24.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    @Override
    public float getDefaultAgilityStat() {
        return 24.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    protected float func_70647_i() {
        return EngenderMod.useMobTalkerModels ? super.func_70647_i() + 0.3f : super.func_70647_i();
    }

    @Override
    public int timesToConvert() {
        return 3;
    }

    @Override
    public boolean isASwarmingMob() {
        return true;
    }

    @Override
    public EnumTier getTier() {
        return EnumTier.TIER2;
    }

    public float func_70047_e() {
        return EngenderMod.useMobTalkerModels ? this.field_70131_O * 0.84f : this.field_70131_O / 3.0f;
    }

    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        if (EngenderMod.useMobTalkerModels) {
            String s = EntityList.func_75621_b((Entity)this);
            if (s == null) {
                s = "generic";
            }
            return I18n.func_74838_a((String)("entity." + s + ".cmm.name"));
        }
        String s = EntityList.func_75621_b((Entity)this);
        if (s == null) {
            s = "generic";
        }
        return I18n.func_74838_a((String)("entity." + s + ".name"));
    }

    @Override
    public boolean func_70631_g_() {
        return false;
    }

    @Override
    public void setChild(boolean childZombie) {
    }

    @Override
    public boolean canBeMatedWith() {
        return false;
    }

    @Override
    public boolean canBeMarried() {
        return false;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187793_eY;
    }

    protected SoundEvent func_184601_bQ() {
        if (EngenderMod.useMobTalkerModels) {
            this.func_184185_a(ModSoundEvents.girlHurt, this.func_70599_aP(), this.func_70647_i() + 0.1f);
        }
        return SoundEvents.field_187850_fa;
    }

    protected SoundEvent func_184615_bR() {
        if (EngenderMod.useMobTalkerModels) {
            this.func_184185_a(ModSoundEvents.girlDeath, this.func_70599_aP(), this.func_70647_i() + 0.1f);
        }
        return SoundEvents.field_187795_eZ;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187852_fb, 0.1f, (EngenderMod.useMobTalkerModels ? 1.25f : 1.0f) / this.getFittness());
        if (EngenderMod.useMobTalkerModels) {
            super.func_180429_a(pos, blockIn);
        }
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableListEngender.ENTITIES_SILVERFISH;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if ((source instanceof EntityDamageSource || source == DamageSource.field_76376_m) && this.summonSilverfish != null) {
            this.summonSilverfish.func_179462_f();
        }
        return super.func_70097_a(source, amount);
    }

    @Override
    public float func_180484_a(BlockPos pos) {
        return this.field_70170_p.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150348_b ? 10.0f : super.func_180484_a(pos);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    @Override
    public void performSpecialAttack() {
        this.setSpecialAttackTimer(400);
        this.func_184185_a(ModSoundEvents.bugSpecial, 10.0f, 1.0f);
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                EntitySilverfish mob = new EntitySilverfish(this.field_70170_p);
                mob.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
                mob.func_180482_a(this.field_70170_p.func_175649_E(this.func_180425_c()), null);
                this.field_70170_p.func_72838_d((Entity)mob);
                mob.setOwnerId(this.func_184753_b());
            }
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y != 0.0) {
            this.field_70761_aq = this.field_70177_z = this.field_70759_as;
        }
        if (EngenderMod.useMobTalkerModels) {
            this.func_70105_a(0.25f, 0.95f);
        } else {
            this.func_70105_a(0.4f, 0.3f);
        }
        if (this.func_70638_az() != null && this.getSpecialAttackTimer() <= 0 && this.isHero()) {
            this.performSpecialAttack();
        }
        if (this.getSpecialAttackTimer() >= 380 && this.isHero()) {
            this.func_70661_as().func_75499_g();
            this.field_70159_w = 0.0;
            this.field_70179_y = 0.0;
            float f2 = this.field_70761_aq * ((float)Math.PI / 180);
            float f19 = MathHelper.func_76126_a((float)f2);
            float f3 = MathHelper.func_76134_b((float)f2);
            for (int i = 0; i < 32; ++i) {
                this.field_70170_p.func_175682_a(EnumParticleTypes.END_ROD, true, this.field_70165_t, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O * 2.0, this.field_70161_v, (double)(f3 * 0.15f), 0.01, (double)(f19 * 0.15f), new int[0]);
                this.field_70170_p.func_175682_a(EnumParticleTypes.END_ROD, true, this.field_70165_t, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O * 2.0, this.field_70161_v, (double)(f3 * -0.15f), 0.01, (double)(f19 * -0.15f), new int[0]);
            }
        }
    }

    static class AISummonSilverfish
    extends EntityAIBase {
        private EntitySilverfish silverfish;
        private int field_179463_b;

        public AISummonSilverfish(EntitySilverfish silverfishIn) {
            this.silverfish = silverfishIn;
        }

        public void func_179462_f() {
            if (this.field_179463_b == 0) {
                this.field_179463_b = 20;
            }
        }

        public boolean func_75250_a() {
            return this.field_179463_b > 0;
        }

        public void func_75246_d() {
            --this.field_179463_b;
            if (this.field_179463_b <= 0) {
                World world = this.silverfish.field_70170_p;
                Random random = this.silverfish.func_70681_au();
                BlockPos blockpos = new BlockPos((Entity)this.silverfish);
                int i = 0;
                while (i <= 5 && i >= -5) {
                    int j = 0;
                    while (j <= 10 && j >= -10) {
                        int k = 0;
                        while (k <= 10 && k >= -10) {
                            BlockPos blockpos1 = blockpos.func_177982_a(j, i, k);
                            IBlockState iblockstate = world.func_180495_p(blockpos1);
                            if (iblockstate.func_177230_c() == Blocks.field_150418_aU) {
                                if (world.func_82736_K().func_82766_b("mobGriefing")) {
                                    world.func_175655_b(blockpos1, true);
                                } else {
                                    world.func_180501_a(blockpos1, ((BlockSilverfish.EnumType)iblockstate.func_177229_b((IProperty)BlockSilverfish.field_176378_a)).func_176883_d(), 3);
                                }
                                if (random.nextBoolean()) {
                                    return;
                                }
                            }
                            k = k <= 0 ? 1 - k : 0 - k;
                        }
                        j = j <= 0 ? 1 - j : 0 - j;
                    }
                    i = i <= 0 ? 1 - i : 0 - i;
                }
            }
        }
    }
}

