/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful.tier1;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.AgeOfMinecraft.LootTableListEngender;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IJumpingMount;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.helpful.Animal;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.Light;
import net.minecraft.entity.helpful.ai.EntityAIFollowLeader;
import net.minecraft.entity.helpful.ai.EntityAIFriendlyAttackMelee;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityCow
extends EntityFriendlyCreature
implements IJumpingMount,
Light,
Animal {
    protected float jumpPower;

    public EntityCow(World worldIn) {
        super(worldIn);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFollowLeader(this, 1.0, 15.0f, 4.0f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFriendlyAttackMelee(this, 1.0, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.5, 80));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70728_aV = 2;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
    }

    @Override
    public float getBonusVSArmored() {
        return 0.5f;
    }

    @Override
    public float getBonusVSMassive() {
        return 0.1f;
    }

    @Override
    public float getDefaultStrengthStat() {
        return 4.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    @Override
    public float getDefaultStaminaStat() {
        return 12.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    @Override
    public float getDefaultIntelligenceStat() {
        return 4.0f + this.field_70146_Z.nextFloat() * 2.0f;
    }

    @Override
    public float getDefaultDexterityStat() {
        return 4.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    @Override
    public float getDefaultAgilityStat() {
        return 16.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    @Override
    public boolean canBeButchered() {
        return true;
    }

    @Override
    public EntityFriendlyCreature spawnBaby(EntityFriendlyCreature par1EntityAgeable) {
        return new EntityCow(this.field_70170_p);
    }

    @Override
    public boolean canBeMatedWith() {
        return false;
    }

    @Override
    public boolean canBeMarried() {
        return false;
    }

    @Override
    public float func_180484_a(BlockPos pos) {
        return this.field_70170_p.func_180495_p(pos.func_177977_b()).func_177230_c() == this.spawnableBlock ? 10.0f : this.field_70170_p.func_175724_o(pos) - 0.5f;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187558_ak;
    }

    protected SoundEvent func_184601_bQ() {
        return SoundEvents.field_187562_am;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187560_al;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187566_ao, 0.15f, 1.0f / this.getFittness());
    }

    @Override
    protected float func_70599_aP() {
        return 0.4f;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableListEngender.ENTITIES_COW;
    }

    @Override
    public boolean interact(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b() && stack.func_77973_b() == Items.field_151133_ar && this.hasOwner(player)) {
            player.func_184185_a(SoundEvents.field_187564_an, 1.0f, 1.0f);
            stack.func_190918_g(1);
            if (stack.func_190926_b()) {
                player.func_184611_a(hand, new ItemStack(Items.field_151117_aB));
            } else if (!player.field_71071_by.func_70441_a(new ItemStack(Items.field_151117_aB))) {
                player.func_71019_a(new ItemStack(Items.field_151117_aB), false);
            }
            return true;
        }
        if (stack.func_190926_b() && this.func_184187_bx() == null) {
            if (!this.isWild() && this.isOnSameTeam((EntityLivingBase)player) && !this.func_70631_g_() && !this.field_70170_p.field_72995_K) {
                player.func_184220_m((Entity)this);
            }
            return true;
        }
        return false;
    }

    public void func_110206_u(int jumpPowerIn) {
        if (this.func_184207_aI()) {
            if (jumpPowerIn < 0) {
                jumpPowerIn = 0;
            }
            this.jumpPower = jumpPowerIn >= 90 ? 1.0f : 0.4f + 0.4f * (float)jumpPowerIn / 90.0f;
        }
    }

    public boolean func_184776_b() {
        return true;
    }

    public void func_184775_b(int p_184775_1_) {
        this.func_70642_aH();
    }

    public void func_184777_r_() {
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        this.func_70105_a(0.9f, 1.4f);
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * 0.825;
    }

    public void func_70612_e(float strafe, float forward) {
        if (this.func_184207_aI()) {
            this.field_70138_W = 1.0f;
            EntityLivingBase entitylivingbase = (EntityLivingBase)this.func_184179_bs();
            this.field_70759_as = entitylivingbase.field_70759_as;
            this.field_70125_A = 90.0f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            strafe = entitylivingbase.field_70702_br;
            forward = entitylivingbase.field_70701_bs;
            if (forward != 0.0f) {
                this.field_70177_z = this.field_70761_aq = this.field_70759_as;
                this.field_70126_B = this.field_70177_z = entitylivingbase.field_70177_z;
            }
            if (this.func_184186_bw()) {
                this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                super.func_70612_e(strafe, forward);
            } else if (entitylivingbase instanceof EntityPlayer) {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            if (this.jumpPower > 0.0f && this.field_70122_E) {
                this.field_70181_x = 0.8 * (double)this.jumpPower * (double)this.getFittness();
                if (this.func_70644_a(MobEffects.field_76430_j)) {
                    this.field_70181_x += (double)((float)(this.func_70660_b(MobEffects.field_76430_j).func_76458_c() + 1) * 0.1f);
                }
                this.field_70160_al = true;
                if (forward > 0.0f) {
                    float f = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
                    float f1 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
                    this.field_70159_w += (double)(-0.4f * f * this.jumpPower);
                    this.field_70179_y += (double)(0.4f * f1 * this.jumpPower);
                }
                this.jumpPower = 0.0f;
            }
            if (forward > 0.0f) {
                List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(2.0, 1.0, 2.0));
                for (int i = 0; i < list.size(); ++i) {
                    Entity entity = (Entity)list.get(i);
                    if (!(entity instanceof EntityLivingBase) || this.isOnSameTeam((EntityLivingBase)entity)) continue;
                    this.func_70652_k(entity);
                    double d01 = (this.func_174813_aQ().field_72340_a + this.func_174813_aQ().field_72336_d) / 2.0;
                    double d11 = (this.func_174813_aQ().field_72339_c + this.func_174813_aQ().field_72334_f) / 2.0;
                    double d2 = entity.field_70165_t - d01;
                    double d3 = entity.field_70161_v - d11;
                    double d4 = d2 * d2 + d3 * d3;
                    entity.func_70024_g(d2 / d4 * 3.0, 0.1, d3 / d4 * 3.0);
                    if (!(this.func_70068_e(entity) < 9.0) && entity.func_70089_S()) continue;
                    entity.func_70024_g(d2 / d4 * 3.0, 0.1, d3 / d4 * 3.0);
                }
                if (this.moralRaisedTimer > 100) {
                    List list1 = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(2.0, 2.0, 2.0));
                    for (int i = 0; i < list1.size(); ++i) {
                        Entity entity = (Entity)list1.get(i);
                        if (!(entity instanceof EntityLivingBase) || this.isOnSameTeam((EntityLivingBase)entity)) continue;
                        this.func_70652_k(entity);
                        double d01 = (this.func_174813_aQ().field_72340_a + this.func_174813_aQ().field_72336_d) / 2.0;
                        double d11 = (this.func_174813_aQ().field_72339_c + this.func_174813_aQ().field_72334_f) / 2.0;
                        double d2 = entity.field_70165_t - d01;
                        double d3 = entity.field_70161_v - d11;
                        double d4 = d2 * d2 + d3 * d3;
                        entity.func_70024_g(d2 / d4 * (3.0 * (double)this.getFittness()), 0.15, d3 / d4 * (3.0 * (double)this.getFittness()));
                        if (!(this.func_70068_e(entity) < 9.0) && entity.func_70089_S()) continue;
                        entity.func_70024_g(d2 / d4 * (3.0 * (double)this.getFittness()), 0.15, d3 / d4 * (3.0 * (double)this.getFittness()));
                    }
                }
            }
            this.field_184618_aE = this.field_70721_aZ;
            double d5 = this.field_70165_t - this.field_70169_q;
            double d7 = this.field_70161_v - this.field_70166_s;
            float f10 = MathHelper.func_76133_a((double)(d5 * d5 + d7 * d7)) * 4.0f;
            if (f10 > 1.0f) {
                f10 = 1.0f;
            }
            this.field_70721_aZ += (f10 - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
        } else {
            super.func_70612_e(strafe, forward);
        }
    }

    public float func_70047_e() {
        return this.field_70131_O;
    }
}

