/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful.tier1;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.AgeOfMinecraft.LootTableListEngender;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IJumpingMount;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.helpful.Animal;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.Light;
import net.minecraft.entity.helpful.Tiny;
import net.minecraft.entity.helpful.ai.EntityAIFollowLeader;
import net.minecraft.entity.helpful.tier3.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityEgg;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityChicken
extends EntityFriendlyCreature
implements IJumpingMount,
Light,
Tiny,
Animal {
    public float wingRotation;
    public float destPos;
    public float field_70884_g;
    public float field_70888_h;
    public float wingRotDelta = 1.0f;
    public int timeUntilNextEgg = this.field_70146_Z.nextInt(600) + 600;
    public boolean chickenJockey;
    protected float jumpPower;

    public EntityChicken(World worldIn) {
        super(worldIn);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFollowLeader(this, 1.4, 24.0f, 8.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0, 80));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70728_aV = 1;
    }

    @Override
    public float getBonusVSArmored() {
        return 0.5f;
    }

    @Override
    public float getBonusVSMassive() {
        return 0.1f;
    }

    @Override
    public boolean canBeButchered() {
        return true;
    }

    @Override
    public EntityFriendlyCreature spawnBaby(EntityFriendlyCreature par1EntityAgeable) {
        return new EntityChicken(this.field_70170_p);
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.95f;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
    }

    @Override
    public boolean canBeMatedWith() {
        return false;
    }

    @Override
    public boolean canBeMarried() {
        return false;
    }

    @Override
    public float getDefaultStrengthStat() {
        return 1.0f;
    }

    @Override
    public float getDefaultStaminaStat() {
        return 8.0f + this.field_70146_Z.nextFloat() * 8.0f;
    }

    @Override
    public float getDefaultIntelligenceStat() {
        return 4.0f + this.field_70146_Z.nextFloat() * 2.0f;
    }

    @Override
    public float getDefaultDexterityStat() {
        return 8.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    @Override
    public float getDefaultAgilityStat() {
        return 8.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    @Override
    public float func_180484_a(BlockPos pos) {
        return this.field_70170_p.func_180495_p(pos.func_177977_b()).func_177230_c() == this.spawnableBlock ? 10.0f : this.field_70170_p.func_175724_o(pos) - 0.5f;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        this.func_70105_a(0.4f, 0.7f);
        if (this.func_184207_aI() && this.field_70146_Z.nextInt(100) == 0 && this.func_184179_bs().field_70131_O > this.getFittness() + 0.5f) {
            this.func_70097_a(DamageSource.field_76368_d, 1.0f);
        }
        if (this.isHero() && !this.field_70170_p.field_72995_K && this.func_70638_az() != null) {
            this.func_70638_az().field_70172_ad = 0;
            this.func_70671_ap().func_75651_a((Entity)this.func_70638_az(), 180.0f, 40.0f);
            EntityEgg entitysnowball = new EntityEgg(this.field_70170_p, (EntityLivingBase)this);
            double d0 = this.func_70638_az().field_70163_u + (double)this.func_70638_az().func_70047_e() - (double)1.1f;
            double d1 = this.func_70638_az().field_70165_t - this.field_70165_t;
            double d2 = d0 - entitysnowball.field_70163_u;
            double d3 = this.func_70638_az().field_70161_v - this.field_70161_v;
            float f = MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3)) * 0.2f;
            entitysnowball.func_70186_c(d1, d2 + (double)f, d3, 1.6f, 4.0f);
            this.func_184185_a(SoundEvents.field_187511_aA, 1.0f, 1.5f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            this.field_70170_p.func_72838_d((Entity)entitysnowball);
        }
        this.isOffensive = this.isChickenJockey();
        if (this.func_184179_bs() != null && this.func_184179_bs() instanceof EntityZombie) {
            EntityZombie passenger = (EntityZombie)this.func_184179_bs();
            this.field_70177_z = this.field_70759_as = passenger.field_70759_as;
            this.field_70761_aq = this.field_70759_as;
            this.field_70125_A = passenger.field_70125_A;
            if (passenger.func_70638_az() != null) {
                this.func_70661_as().func_75497_a((Entity)passenger.func_70638_az(), 1.0);
            }
        }
        this.field_70888_h = this.wingRotation;
        this.field_70884_g = this.destPos;
        this.destPos = (float)((double)this.destPos + (double)(this.field_70122_E ? -1 : 4) * 0.3);
        this.destPos = MathHelper.func_76131_a((float)this.destPos, (float)0.0f, (float)1.0f);
        if (!this.field_70122_E && this.wingRotDelta < 1.0f) {
            this.wingRotDelta = 1.0f;
        }
        this.wingRotDelta = (float)((double)this.wingRotDelta * 0.9);
        if (!this.field_70122_E && this.field_70181_x < 0.0 && this.func_70089_S()) {
            this.field_70181_x *= 0.6;
        }
        this.wingRotation += this.wingRotDelta * 2.0f;
        if (!(this.field_70170_p.field_72995_K || this.func_70631_g_() || this.isChickenJockey() || --this.timeUntilNextEgg > 0)) {
            this.func_184185_a(SoundEvents.field_187665_Y, this.func_70599_aP(), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            this.func_145779_a(Items.field_151110_aK, 1);
            this.timeUntilNextEgg = this.field_70146_Z.nextInt(600) + 600;
        }
    }

    @Override
    public boolean takesFallDamage() {
        return false;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187660_W;
    }

    protected SoundEvent func_184601_bQ() {
        return SoundEvents.field_187666_Z;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187663_X;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187538_aa, 0.15f, 1.0f / this.getFittness());
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableListEngender.ENTITIES_CHICKEN;
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.chickenJockey = tagCompund.func_74767_n("IsChickenJockey");
        if (tagCompund.func_74764_b("EggLayTime")) {
            this.timeUntilNextEgg = tagCompund.func_74762_e("EggLayTime");
        }
    }

    @Override
    protected int func_70693_a(EntityPlayer player) {
        return this.isChickenJockey() ? 10 : super.func_70693_a(player);
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74757_a("IsChickenJockey", this.chickenJockey);
        tagCompound.func_74768_a("EggLayTime", this.timeUntilNextEgg);
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * 0.65;
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        float f = MathHelper.func_76126_a((float)(this.field_70761_aq * ((float)Math.PI / 180)));
        float f1 = MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180)));
        float f2 = 0.1f;
        float f3 = 0.0f;
        passenger.func_70107_b(this.field_70165_t + (double)(f2 * f), this.field_70163_u + this.func_70042_X() + passenger.func_70033_W() + (double)f3, this.field_70161_v - (double)(f2 * f1));
        if (passenger instanceof EntityLivingBase) {
            ((EntityLivingBase)passenger).field_70761_aq = this.field_70761_aq;
        }
    }

    @Override
    public boolean interact(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_190926_b() && this.func_184187_bx() == null) {
            if (player.func_70093_af()) {
                List list = this.field_70170_p.func_175647_a(EntityZombie.class, this.func_174813_aQ().func_72314_b(16.0, 16.0, 16.0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_94557_a}));
                if (this.func_184187_bx() == null && list != null && !list.isEmpty() && !this.func_184207_aI() && this.hasOwner(player)) {
                    for (int i1 = 0; i1 < list.size(); ++i1) {
                        EntityZombie entity = (EntityZombie)list.get(i1);
                        if (entity == null || !entity.func_70631_g_() || !this.isOnSameTeam((EntityLivingBase)entity) || entity.func_184218_aH() || this.field_70170_p.field_72995_K) continue;
                        player.func_184609_a(EnumHand.MAIN_HAND);
                        entity.func_184220_m((Entity)this);
                        this.func_184185_a(SoundEvents.field_187660_W, 1.0f, 1.5f);
                        break;
                    }
                }
                return true;
            }
            if (!this.isWild() && this.isOnSameTeam((EntityLivingBase)player) && !this.func_70631_g_() && !this.field_70170_p.field_72995_K) {
                player.func_184220_m((Entity)this);
            }
            return true;
        }
        return false;
    }

    public void func_110206_u(int jumpPowerIn) {
        if (this.func_184207_aI()) {
            if (jumpPowerIn < 0) {
                jumpPowerIn = 0;
            }
            this.jumpPower = jumpPowerIn >= 90 ? 1.0f : 0.4f + 0.4f * (float)jumpPowerIn / 90.0f;
        }
    }

    public boolean func_184776_b() {
        return true;
    }

    public void func_184775_b(int p_184775_1_) {
        this.func_70642_aH();
    }

    public void func_184777_r_() {
    }

    public void func_70612_e(float strafe, float forward) {
        if (this.func_184207_aI()) {
            this.field_70138_W = 1.0f;
            EntityLivingBase entitylivingbase = (EntityLivingBase)this.func_184179_bs();
            this.field_70759_as = entitylivingbase.field_70759_as;
            this.field_70125_A = entitylivingbase.field_70125_A;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            strafe = entitylivingbase.field_70702_br;
            forward = entitylivingbase.field_70701_bs;
            if (forward != 0.0f) {
                this.field_70177_z = this.field_70761_aq = this.field_70759_as;
                this.field_70126_B = this.field_70177_z = entitylivingbase.field_70177_z;
            }
            if (this.jumpPower > 0.0f && this.field_70122_E) {
                this.field_70181_x = 0.6 * (double)this.jumpPower * (double)this.getFittness();
                if (this.func_70644_a(MobEffects.field_76430_j)) {
                    this.field_70181_x += (double)((float)(this.func_70660_b(MobEffects.field_76430_j).func_76458_c() + 1) * 0.1f);
                }
                this.field_70160_al = true;
                if (forward > 0.0f) {
                    float f = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
                    float f1 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
                    this.field_70159_w += (double)(-0.4f * f * this.jumpPower);
                    this.field_70179_y += (double)(0.4f * f1 * this.jumpPower);
                }
                this.jumpPower = 0.0f;
            }
            if (this.func_184186_bw()) {
                this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                super.func_70612_e(strafe, forward);
            } else if (entitylivingbase instanceof EntityPlayer) {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            this.field_184618_aE = this.field_70721_aZ;
            double d5 = this.field_70165_t - this.field_70169_q;
            double d7 = this.field_70161_v - this.field_70166_s;
            float f10 = MathHelper.func_76133_a((double)(d5 * d5 + d7 * d7)) * 4.0f;
            if (f10 > 1.0f) {
                f10 = 1.0f;
            }
            this.field_70721_aZ += (f10 - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
        } else {
            super.func_70612_e(strafe, forward);
        }
    }

    public boolean isChickenJockey() {
        return this.chickenJockey;
    }

    public void setChickenJockey(boolean jockey) {
        this.chickenJockey = jockey;
    }
}

