/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful.tier1;

import java.util.Calendar;
import javax.annotation.Nullable;
import net.minecraft.AgeOfMinecraft.LootTableListEngender;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.helpful.Animal;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.Flying;
import net.minecraft.entity.helpful.Light;
import net.minecraft.entity.helpful.Tiny;
import net.minecraft.entity.helpful.ai.EntityAIFollowLeader;
import net.minecraft.entity.helpful.ai.EntityAIFriendlyAttackMelee;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityBat
extends EntityFriendlyCreature
implements Light,
Flying,
Tiny,
Animal {
    private static final DataParameter<Byte> HANGING = EntityDataManager.func_187226_a(EntityBat.class, (DataSerializer)DataSerializers.field_187191_a);
    private BlockPos spawnPosition;

    public EntityBat(World worldIn) {
        super(worldIn);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFriendlyAttackMelee(this, 1.0, true));
        this.setIsBatHanging(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFollowLeader(this, 2.0, 16.0f, 8.0f));
        this.field_70728_aV = 1;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HANGING, (Object)0);
    }

    @Override
    public float getBonusVSArmored() {
        return 0.5f;
    }

    @Override
    public float getBonusVSMassive() {
        return 0.1f;
    }

    @Override
    public boolean canBeMatedWith() {
        return false;
    }

    @Override
    public boolean canBeMarried() {
        return false;
    }

    @Override
    public float getDefaultStrengthStat() {
        return 2.0f + this.field_70146_Z.nextFloat() * 2.0f;
    }

    @Override
    public float getDefaultStaminaStat() {
        return 12.0f + this.field_70146_Z.nextFloat() * 2.0f;
    }

    @Override
    public float getDefaultIntelligenceStat() {
        return 8.0f + this.field_70146_Z.nextFloat() * 2.0f;
    }

    @Override
    public float getDefaultDexterityStat() {
        return 24.0f + this.field_70146_Z.nextFloat() * 8.0f;
    }

    @Override
    public float getDefaultAgilityStat() {
        return 24.0f + this.field_70146_Z.nextFloat() * 12.0f;
    }

    @Override
    public float getDefaultFittnessStat() {
        return 0.8f + this.field_70146_Z.nextFloat() * 0.4f;
    }

    @Override
    protected float func_70599_aP() {
        return 0.1f;
    }

    protected float func_70647_i() {
        return super.func_70647_i() * 0.95f;
    }

    protected SoundEvent func_184639_G() {
        return this.getIsBatHanging() && this.field_70146_Z.nextInt(4) != 0 ? null : SoundEvents.field_187740_w;
    }

    protected SoundEvent func_184601_bQ() {
        return SoundEvents.field_187743_y;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187742_x;
    }

    public boolean func_70104_M() {
        return false;
    }

    @Override
    protected void func_82167_n(Entity entityIn) {
    }

    protected void func_85033_bc() {
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(6.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
    }

    public boolean getIsBatHanging() {
        return ((Byte)this.field_70180_af.func_187225_a(HANGING) & 1) != 0;
    }

    public void setIsBatHanging(boolean isHanging) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(HANGING);
        if (isHanging) {
            this.field_70180_af.func_187227_b(HANGING, (Object)((byte)(b0 | 1)));
        } else {
            this.field_70180_af.func_187227_b(HANGING, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        this.func_70105_a(0.5f, 0.9f);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getIsBatHanging()) {
            this.field_70179_y = 0.0;
            this.field_70181_x = 0.0;
            this.field_70159_w = 0.0;
            this.field_70163_u = (double)MathHelper.func_76128_c((double)this.field_70163_u) + 1.0 - (double)this.field_70131_O;
        } else if (!this.field_70122_E && this.field_70181_x < 0.0 && this.func_70089_S()) {
            this.field_70181_x *= 0.6;
        }
    }

    @Override
    protected void func_70619_bc() {
        super.func_70619_bc();
        BlockPos blockpos = new BlockPos((Entity)this);
        BlockPos blockpos1 = blockpos.func_177984_a();
        if (this.getIsBatHanging()) {
            if (!this.field_70170_p.func_180495_p(blockpos1).func_185915_l()) {
                this.setIsBatHanging(false);
                this.field_70170_p.func_180498_a((EntityPlayer)null, 1025, blockpos, 0);
            } else {
                if (this.field_70146_Z.nextInt(200) == 0) {
                    this.field_70759_as = this.field_70146_Z.nextInt(360);
                }
                if (this.field_70170_p.func_184136_b((Entity)this, 4.0) != null) {
                    this.setIsBatHanging(false);
                    this.field_70170_p.func_180498_a((EntityPlayer)null, 1025, blockpos, 0);
                }
            }
        } else {
            if (!(this.spawnPosition == null || this.field_70170_p.func_175623_d(this.spawnPosition) && this.spawnPosition.func_177956_o() >= 1)) {
                this.spawnPosition = null;
            }
            if (this.spawnPosition == null || this.field_70146_Z.nextInt(30) == 0 || this.spawnPosition.func_177954_c((double)((int)this.field_70165_t), (double)((int)this.field_70163_u), (double)((int)this.field_70161_v)) < 4.0) {
                this.spawnPosition = new BlockPos((int)this.field_70165_t + this.field_70146_Z.nextInt(7) - this.field_70146_Z.nextInt(7), (int)this.field_70163_u + this.field_70146_Z.nextInt(6) - 2, (int)this.field_70161_v + this.field_70146_Z.nextInt(7) - this.field_70146_Z.nextInt(7));
            }
            if (this.field_70146_Z.nextInt(100) == 0 && this.field_70170_p.func_180495_p(blockpos1).func_185915_l()) {
                this.setIsBatHanging(true);
            }
            if (this.func_70660_b(MobEffects.field_188425_z) == null) {
                if (this.field_70170_p.func_72890_a((Entity)this, 200.0) != null && this.func_70638_az() == null && this.field_70170_p.func_72890_a((Entity)this, 200.0) == this.getOwner() && this.func_70068_e((Entity)this.getOwner()) > 200.0) {
                    double d01 = this.getOwner().field_70165_t - this.field_70165_t;
                    double d11 = this.getOwner().field_70163_u - this.field_70163_u;
                    double d21 = this.getOwner().field_70161_v - this.field_70161_v;
                    float f2 = MathHelper.func_76133_a((double)(d01 * d01 + d11 * d11 + d21 * d21));
                    this.field_70159_w = d01 / (double)f2 * 0.5 * 0.5 + this.field_70159_w * 0.5;
                    this.field_70181_x = d11 / (double)f2 * 0.5 * 0.5 + this.field_70179_y * 0.5;
                    this.field_70179_y = d21 / (double)f2 * 0.5 * 0.5 + this.field_70179_y * 0.5;
                    this.func_70625_a((Entity)this.getOwner(), 180.0f, 30.0f);
                } else if (this.func_70638_az() != null) {
                    double d01 = this.func_70638_az().field_70165_t - this.field_70165_t;
                    double d11 = this.func_70638_az().field_70161_v - this.field_70161_v;
                    float f2 = MathHelper.func_76133_a((double)(d01 * d01 + d11 * d11));
                    this.field_70159_w = d01 / (double)f2 * 0.5 * 0.5 + this.field_70159_w;
                    this.field_70179_y = d11 / (double)f2 * 0.5 * 0.5 + this.field_70179_y;
                    this.func_70625_a((Entity)this.func_70638_az(), 180.0f, 30.0f);
                    if (this.field_70163_u < this.func_70638_az().field_70163_u + 0.5) {
                        this.field_70181_x += 0.25 - this.field_70181_x;
                    }
                } else {
                    double d0 = (double)this.spawnPosition.func_177958_n() + 0.5 - this.field_70165_t;
                    double d1 = (double)this.spawnPosition.func_177956_o() + 0.1 - this.field_70163_u;
                    double d2 = (double)this.spawnPosition.func_177952_p() + 0.5 - this.field_70161_v;
                    this.field_70159_w += (Math.signum(d0) * 0.5 - this.field_70159_w) * (double)0.1f;
                    this.field_70181_x += (Math.signum(d1) * (double)0.7f - this.field_70181_x) * (double)0.1f;
                    this.field_70179_y += (Math.signum(d2) * 0.5 - this.field_70179_y) * (double)0.1f;
                    float f = (float)(Math.atan2(this.field_70179_y, this.field_70159_w) * 180.0 / Math.PI) - 90.0f;
                    float f1 = MathHelper.func_76142_g((float)(f - this.field_70177_z));
                    this.field_70701_bs = 0.5f;
                    this.field_70177_z += f1;
                }
            }
        }
    }

    @Override
    public boolean interact(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_190926_b() && this.hasOwner(player)) {
            this.func_184581_c(null);
            this.func_70057_ab();
            player.func_184609_a(EnumHand.MAIN_HAND);
            this.func_70690_d(new PotionEffect(MobEffects.field_188425_z, 100));
            player.func_70690_d(new PotionEffect(MobEffects.field_76439_r, player.func_70660_b(MobEffects.field_76439_r) != null ? player.func_70660_b(MobEffects.field_76439_r).func_76459_b() + 200 : 200));
            return true;
        }
        return false;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    @Override
    public boolean takesFallDamage() {
        return false;
    }

    protected void func_180433_a(double p_180433_1_, boolean p_180433_3_, Block p_180433_4_, BlockPos p_180433_5_) {
    }

    @Override
    public boolean func_145773_az() {
        return true;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && this.getIsBatHanging()) {
            this.setIsBatHanging(false);
        }
        return super.func_70097_a(source, amount);
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.field_70180_af.func_187227_b(HANGING, (Object)tagCompund.func_74771_c("BatFlags"));
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74774_a("BatFlags", ((Byte)this.field_70180_af.func_187225_a(HANGING)).byteValue());
    }

    public float func_70047_e() {
        return this.field_70131_O / 2.0f;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableListEngender.ENTITIES_BAT;
    }

    @Override
    public boolean func_70601_bi() {
        BlockPos blockpos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        if (blockpos.func_177956_o() >= this.field_70170_p.func_181545_F()) {
            return false;
        }
        int i = this.field_70170_p.func_175671_l(blockpos);
        int j = 4;
        if (this.isDateAroundHalloween(this.field_70170_p.func_83015_S())) {
            j = 7;
        } else if (this.field_70146_Z.nextBoolean()) {
            return false;
        }
        return i >= this.field_70146_Z.nextInt(j) ? false : super.func_70601_bi();
    }

    private boolean isDateAroundHalloween(Calendar p_175569_1_) {
        return p_175569_1_.get(2) + 1 == 10 && p_175569_1_.get(5) >= 20 || p_175569_1_.get(2) + 1 == 11 && p_175569_1_.get(5) <= 3;
    }
}

