/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful.ai;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.AgeOfMinecraft.EngenderMod;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.helpful.tier3.EntityCreeper;
import net.minecraft.entity.helpful.tier3.EntitySkeleton;
import net.minecraft.entity.helpful.tier3.EntityZombie;
import net.minecraft.entity.helpful.tier5.EntityWither;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;

public class EntityAINearestAttackableTargetBox<T extends EntityLivingBase>
extends EntityAITarget {
    protected final Class<T> targetClass;
    private final int targetChance;
    protected final Sorter theNearestAttackableTargetSorter;
    protected final Predicate<? super T> targetEntitySelector;
    protected T targetEntity;

    public EntityAINearestAttackableTargetBox(EntityCreature creature, Class<T> classTarget, boolean checkSight) {
        this(creature, classTarget, checkSight, false);
    }

    public EntityAINearestAttackableTargetBox(EntityCreature creature, Class<T> classTarget, boolean checkSight, boolean onlyNearby) {
        this(creature, classTarget, 10, checkSight, onlyNearby, null);
    }

    public EntityAINearestAttackableTargetBox(EntityCreature creature, Class<T> classTarget, int chance, boolean checkSight, boolean onlyNearby, final Predicate<? super T> targetSelector) {
        super(creature, checkSight, onlyNearby);
        this.targetClass = classTarget;
        this.targetChance = chance;
        this.theNearestAttackableTargetSorter = new Sorter((Entity)creature);
        this.func_75248_a(1);
        this.targetEntitySelector = new Predicate<T>(){

            public boolean apply(T p_apply_1_) {
                return !EntitySelectors.field_180132_d.apply(p_apply_1_) ? false : (targetSelector != null && !targetSelector.apply(p_apply_1_) ? false : (p_apply_1_ == null ? false : EntityAINearestAttackableTargetBox.this.func_75296_a(p_apply_1_, false)));
            }
        };
    }

    public boolean func_75250_a() {
        if (!this.field_75299_d.func_70089_S()) {
            return false;
        }
        if (EngenderMod.useMobTalkerModels && this.field_75299_d.func_70631_g_()) {
            return false;
        }
        if (this.field_75299_d instanceof EntityWither && ((EntityWither)this.field_75299_d).getInvulTime() > 0) {
            return false;
        }
        if (this.field_75299_d.func_175446_cd()) {
            return false;
        }
        if (this.targetChance > 0 && !this.field_75299_d.func_70093_af() && this.field_75299_d.func_70681_au().nextInt(this.targetChance) != 0) {
            return false;
        }
        if (this.targetClass != EntityPlayer.class && this.targetClass != EntityPlayerMP.class) {
            List list = this.field_75299_d.field_70170_p.func_175647_a(this.targetClass, this.func_188511_a(this.func_111175_f()), this.targetEntitySelector);
            if (list.isEmpty()) {
                return false;
            }
            Collections.sort(list, this.theNearestAttackableTargetSorter);
            this.targetEntity = (EntityLivingBase)list.get(0);
            return true;
        }
        this.targetEntity = this.field_75299_d.field_70170_p.func_184150_a(this.field_75299_d.field_70165_t, this.field_75299_d.field_70163_u + (double)this.field_75299_d.func_70047_e(), this.field_75299_d.field_70161_v, this.func_111175_f(), this.func_111175_f(), (Function)new Function<EntityPlayer, Double>(){

            public Double apply(EntityPlayer p_apply_1_) {
                ItemStack itemstack = p_apply_1_.func_184582_a(EntityEquipmentSlot.HEAD);
                if (itemstack != null && itemstack.func_77973_b() == Items.field_151144_bL) {
                    boolean flag2;
                    int i = itemstack.func_77952_i();
                    boolean flag = EntityAINearestAttackableTargetBox.this.field_75299_d instanceof EntitySkeleton && ((EntitySkeleton)EntityAINearestAttackableTargetBox.this.field_75299_d).getSkeletonType() == 0 && i == 0;
                    boolean flag1 = EntityAINearestAttackableTargetBox.this.field_75299_d instanceof EntityZombie && i == 2;
                    boolean bl = flag2 = EntityAINearestAttackableTargetBox.this.field_75299_d instanceof EntityCreeper && i == 4;
                    if (flag || flag1 || flag2) {
                        return 0.5;
                    }
                }
                return 1.0;
            }
        }, this.targetEntitySelector);
        return this.targetEntity != null;
    }

    protected AxisAlignedBB func_188511_a(double p_188511_1_) {
        return this.field_75299_d.func_174813_aQ().func_72314_b(p_188511_1_, p_188511_1_, p_188511_1_);
    }

    public void func_75249_e() {
        this.field_75299_d.func_70624_b(this.targetEntity);
        super.func_75249_e();
    }

    public static class Sorter
    implements Comparator<Entity> {
        private final Entity theEntity;

        public Sorter(Entity theEntityIn) {
            this.theEntity = theEntityIn;
        }

        @Override
        public int compare(Entity p_compare_1_, Entity p_compare_2_) {
            double d1;
            double d0 = this.theEntity.func_70068_e(p_compare_1_);
            return d0 > (d1 = this.theEntity.func_70068_e(p_compare_2_)) ? 1 : (d0 < d1 ? -1 : 0);
        }
    }
}

