/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.tier5.EntityEvoker;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityAIFriendlyAttackMelee
extends EntityAIBase {
    World world;
    protected EntityFriendlyCreature attacker;
    protected double attackTick;
    double speedTowardsTarget;
    boolean longMemory;
    Path entityPathEntity;
    private int delayCounter;
    private double targetX;
    private double targetY;
    private double targetZ;
    protected final int attackInterval = 20;
    private int failedPathFindingPenalty = 0;
    private boolean canPenalize = false;
    private int field_188495_i;

    public EntityAIFriendlyAttackMelee(EntityFriendlyCreature creature, double speedIn, boolean useLongMemory) {
        this.attacker = creature;
        this.world = creature.field_70170_p;
        this.speedTowardsTarget = speedIn;
        this.longMemory = useLongMemory;
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        EntityLivingBase entitylivingbase = this.attacker.func_70638_az();
        if (entitylivingbase == null) {
            return false;
        }
        if (!entitylivingbase.func_70089_S()) {
            return false;
        }
        if (entitylivingbase.field_70173_aa < 20) {
            return false;
        }
        if (this.canPenalize) {
            if (--this.delayCounter <= 0) {
                this.entityPathEntity = this.attacker.func_70661_as().func_75494_a((Entity)entitylivingbase);
                this.delayCounter = 4 + this.attacker.func_70681_au().nextInt(7);
                return this.entityPathEntity != null;
            }
            return true;
        }
        this.entityPathEntity = this.attacker.func_70661_as().func_75494_a((Entity)entitylivingbase);
        return this.entityPathEntity != null;
    }

    public boolean func_75253_b() {
        EntityLivingBase entitylivingbase = this.attacker.func_70638_az();
        if (this.attacker instanceof EntityEvoker && ((EntityEvoker)this.attacker).isCastingSpell()) {
            return false;
        }
        return entitylivingbase == null ? false : (!entitylivingbase.func_70089_S() ? false : (!this.longMemory ? !this.attacker.func_70661_as().func_75500_f() : (!this.attacker.func_180485_d(new BlockPos((Entity)entitylivingbase)) ? false : !(entitylivingbase instanceof EntityPlayer) || !((EntityPlayer)entitylivingbase).func_175149_v() && !((EntityPlayer)entitylivingbase).func_184812_l_())));
    }

    public void func_75249_e() {
        this.attacker.func_70661_as().func_75484_a(this.entityPathEntity, this.speedTowardsTarget);
        this.attacker.setArmsRaised(true);
        this.attacker.setSitResting(false);
        this.delayCounter = 0;
        this.field_188495_i = 0;
    }

    public void func_75251_c() {
        EntityLivingBase entitylivingbase = this.attacker.func_70638_az();
        if (entitylivingbase instanceof EntityPlayer && (((EntityPlayer)entitylivingbase).func_175149_v() || ((EntityPlayer)entitylivingbase).func_184812_l_())) {
            this.attacker.func_70624_b(null);
        }
        this.attacker.func_70661_as().func_75499_g();
        this.attacker.setArmsRaised(false);
    }

    public void func_75246_d() {
        this.attacker.setSitResting(false);
        EntityLivingBase entitylivingbase = this.attacker.func_70638_az();
        if (entitylivingbase != null) {
            this.attacker.func_70671_ap().func_75651_a((Entity)entitylivingbase, (float)this.attacker.func_184649_cE(), (float)this.attacker.func_70646_bf());
            double d0 = this.attacker.func_70092_e(entitylivingbase.field_70165_t, entitylivingbase.func_174813_aQ().field_72338_b, entitylivingbase.field_70161_v);
            --this.delayCounter;
            if (!(this.attacker instanceof EntityEvoker) && (this.longMemory || this.attacker.func_70635_at().func_75522_a((Entity)entitylivingbase)) && this.delayCounter <= 0 && (this.targetX == 0.0 && this.targetY == 0.0 && this.targetZ == 0.0 || entitylivingbase.func_70092_e(this.targetX, this.targetY, this.targetZ) != 0.0 || this.attacker.func_70681_au().nextFloat() < 0.05f)) {
                this.targetX = entitylivingbase.field_70165_t;
                this.targetY = entitylivingbase.func_174813_aQ().field_72338_b;
                this.targetZ = entitylivingbase.field_70161_v;
                this.delayCounter = 4 + this.attacker.func_70681_au().nextInt(7);
                if (this.canPenalize) {
                    PathPoint finalPathPoint;
                    this.delayCounter += this.failedPathFindingPenalty;
                    this.failedPathFindingPenalty = this.attacker.func_70661_as().func_75505_d() != null ? ((finalPathPoint = this.attacker.func_70661_as().func_75505_d().func_75870_c()) != null && entitylivingbase.func_70092_e((double)finalPathPoint.field_75839_a, (double)finalPathPoint.field_75837_b, (double)finalPathPoint.field_75838_c) != 0.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
                }
                if (d0 > 1024.0) {
                    this.delayCounter += 10;
                } else if (d0 > 128.0) {
                    this.delayCounter += 5;
                }
            }
            this.attackTick = Math.max(this.attackTick - 1.0, 0.0);
            this.checkAndPerformAttack(entitylivingbase, d0);
            if (this.attacker instanceof EntityEvoker) {
                this.attacker.func_70661_as().func_75499_g();
            }
        }
        ++this.field_188495_i;
        if (this.field_188495_i >= 5 && this.attackTick < 10.0) {
            this.attacker.setArmsRaised(true);
            if (this.speedTowardsTarget != 0.0 && entitylivingbase != null && this.attacker.field_70122_E) {
                this.attacker.func_70661_as().func_75497_a((Entity)entitylivingbase, this.speedTowardsTarget);
            }
        } else {
            this.attacker.setArmsRaised(false);
        }
    }

    protected void checkAndPerformAttack(EntityLivingBase attackTarget, double p_190102_2_) {
        double d0 = this.getAttackReachSqr(attackTarget);
        if (p_190102_2_ <= d0 && this.attackTick <= 0.0 && this.attacker.field_70163_u + (double)this.attacker.field_70131_O > attackTarget.field_70163_u) {
            this.attackTick = 30.0 - this.attacker.func_110148_a(EntityFriendlyCreature.DEXTERITY).func_111125_b() * 0.2;
            this.attacker.func_70652_k((Entity)attackTarget);
            if (attackTarget.field_70759_as != (float)MathHelper.func_181159_b((double)attackTarget.field_70179_y, (double)attackTarget.field_70159_w) * 57.295776f - 90.0f) {
                this.attacker.attackWithAdditionalEffects((Entity)attackTarget);
            }
        }
    }

    protected double getAttackReachSqr(EntityLivingBase attackTarget) {
        return this.attacker.isOffensive ? (double)(this.attacker.reachWidth * this.attacker.reachWidth + (attackTarget instanceof EntityFriendlyCreature ? ((EntityFriendlyCreature)attackTarget).reachWidth : attackTarget.field_70130_N) * (attackTarget instanceof EntityFriendlyCreature ? ((EntityFriendlyCreature)attackTarget).reachWidth : attackTarget.field_70130_N)) + 9.0 : (double)(this.attacker.field_70130_N * 3.0f * this.attacker.field_70130_N * 3.0f + attackTarget.field_70130_N);
    }
}

