/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful.ai;

import com.google.common.base.Predicate;
import java.util.Collections;
import java.util.List;
import net.minecraft.AgeOfMinecraft.EngenderMod;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.Flying;
import net.minecraft.entity.helpful.ai.EntityAINearestAttackableTargetBox;
import net.minecraft.entity.helpful.tier1.EntityRabbit;
import net.minecraft.entity.helpful.tier4.EntityGuardian;
import net.minecraft.entity.helpful.tier4.EntityWitch;
import net.minecraft.entity.helpful.tier5.EntityEvoker;
import net.minecraft.entity.helpful.tier5.EntityWither;
import net.minecraft.entity.helpful.tier6.EntityWitherStorm;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;

public class EntityAIFindNearestUnalliedTarget
extends EntityAIBase {
    private EntityFriendlyCreature mob;
    private final Predicate<EntityLivingBase> field_179443_c;
    private final EntityAINearestAttackableTargetBox.Sorter field_179440_d;
    private EntityLivingBase target;
    private Class<? extends EntityLivingBase> field_179439_f;

    public EntityAIFindNearestUnalliedTarget(EntityFriendlyCreature mobIn, Class<? extends EntityLivingBase> p_i45884_2_) {
        this.mob = mobIn;
        this.field_179439_f = p_i45884_2_;
        this.field_179443_c = new Predicate<EntityLivingBase>(){

            public boolean apply(EntityLivingBase p_apply_1_) {
                if (p_apply_1_ instanceof EntityPlayer && ((EntityPlayer)p_apply_1_).field_71075_bZ.field_75102_a) {
                    return false;
                }
                if ((p_apply_1_.func_82150_aj() || p_apply_1_.func_70093_af()) && !EntityAIFindNearestUnalliedTarget.this.mob.func_70644_a(MobEffects.field_76439_r)) {
                    return false;
                }
                return !(EntityAIFindNearestUnalliedTarget.this.mob instanceof EntityWitherStorm) && p_apply_1_.func_70089_S() && !EntityAIFindNearestUnalliedTarget.this.mob.isOnSameTeam(p_apply_1_) && !EntityAIFindNearestUnalliedTarget.this.mob.isInLove() && !EntityAIFindNearestUnalliedTarget.this.mob.func_70093_af() && p_apply_1_.func_110143_aJ() > 0.0f && (EntityAIFindNearestUnalliedTarget.this.mob.func_70685_l((Entity)p_apply_1_) || EntityAIFindNearestUnalliedTarget.this.mob.isABoss());
            }
        };
        this.field_179440_d = new EntityAINearestAttackableTargetBox.Sorter((Entity)mobIn);
    }

    public boolean func_75250_a() {
        if (!this.mob.func_70089_S()) {
            return false;
        }
        if (this.mob instanceof EntityWither && ((EntityWither)this.mob).getInvulTime() > 1) {
            return false;
        }
        double d0 = this.getFollowRange();
        List list = this.mob.field_70170_p.func_175647_a(this.field_179439_f, this.mob.func_174813_aQ().func_72314_b(d0, d0, d0), this.field_179443_c);
        Collections.sort(list, this.field_179440_d);
        if (list.isEmpty()) {
            return false;
        }
        this.target = (EntityLivingBase)list.get(0);
        return true;
    }

    public boolean func_75253_b() {
        EntityLivingBase entitylivingbase = this.mob.func_70638_az();
        if (entitylivingbase == null) {
            return false;
        }
        if (!entitylivingbase.func_70089_S()) {
            return false;
        }
        if (!this.mob.isWild() && !entitylivingbase.func_70685_l((Entity)this.mob.getOwner())) {
            return false;
        }
        if (!(this.mob.field_70122_E || this.mob.func_70648_aU() || this.mob instanceof EntityRabbit || this.mob instanceof EntityGuardian || this.mob instanceof EntityEvoker || this.mob instanceof EntityWitch || this.mob instanceof Flying || this.mob.isABoss())) {
            return false;
        }
        if (EngenderMod.useMobTalkerModels && this.mob.func_70631_g_()) {
            return false;
        }
        double d0 = this.getFollowRange();
        return this.mob.func_70068_e((Entity)entitylivingbase) <= d0 * d0;
    }

    public void func_75249_e() {
        this.mob.func_70624_b(this.target);
        super.func_75249_e();
    }

    public void func_75251_c() {
        this.mob.func_70624_b(null);
        super.func_75249_e();
    }

    protected double getFollowRange() {
        IAttributeInstance iattributeinstance = this.mob.func_110148_a(SharedMonsterAttributes.field_111265_b);
        return iattributeinstance == null ? 32.0 : iattributeinstance.func_111126_e();
    }
}

