/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.AgeOfMinecraft.EngenderAchievments;
import net.minecraft.AgeOfMinecraft.EngenderMod;
import net.minecraft.AgeOfMinecraft.LootTableListEngender;
import net.minecraft.AgeOfMinecraft.ModSoundEvents;
import net.minecraft.AgeOfMinecraft.SpawnerItems;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.helpful.Armored;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.EnumTier;
import net.minecraft.entity.helpful.Massive;
import net.minecraft.entity.helpful.Structure;
import net.minecraft.entity.helpful.tier1.EntityBat;
import net.minecraft.entity.helpful.tier1.EntityChicken;
import net.minecraft.entity.helpful.tier1.EntityCow;
import net.minecraft.entity.helpful.tier1.EntityMooshroom;
import net.minecraft.entity.helpful.tier1.EntityOcelot;
import net.minecraft.entity.helpful.tier1.EntityPig;
import net.minecraft.entity.helpful.tier1.EntityRabbit;
import net.minecraft.entity.helpful.tier1.EntitySheep;
import net.minecraft.entity.helpful.tier2.EntityEndermite;
import net.minecraft.entity.helpful.tier2.EntityLlama;
import net.minecraft.entity.helpful.tier2.EntitySilverfish;
import net.minecraft.entity.helpful.tier2.EntitySnowman;
import net.minecraft.entity.helpful.tier2.EntitySquid;
import net.minecraft.entity.helpful.tier2.EntityVillager;
import net.minecraft.entity.helpful.tier2.EntityWolf;
import net.minecraft.entity.helpful.tier3.EntityCreeper;
import net.minecraft.entity.helpful.tier3.EntityMagmaCube;
import net.minecraft.entity.helpful.tier3.EntitySkeleton;
import net.minecraft.entity.helpful.tier3.EntitySlime;
import net.minecraft.entity.helpful.tier3.EntitySpider;
import net.minecraft.entity.helpful.tier3.EntityVex;
import net.minecraft.entity.helpful.tier3.EntityZombie;
import net.minecraft.entity.helpful.tier4.EntityBlaze;
import net.minecraft.entity.helpful.tier4.EntityCaveSpider;
import net.minecraft.entity.helpful.tier4.EntityEnderman;
import net.minecraft.entity.helpful.tier4.EntityGhast;
import net.minecraft.entity.helpful.tier4.EntityGuardian;
import net.minecraft.entity.helpful.tier4.EntityPigZombie;
import net.minecraft.entity.helpful.tier4.EntityShulker;
import net.minecraft.entity.helpful.tier4.EntityVindicator;
import net.minecraft.entity.helpful.tier4.EntityWitch;
import net.minecraft.entity.helpful.tier5.EntityElderGuardian;
import net.minecraft.entity.helpful.tier5.EntityEvoker;
import net.minecraft.entity.helpful.tier5.EntityGiant;
import net.minecraft.entity.helpful.tier5.EntityIronGolem;
import net.minecraft.entity.helpful.tier5.EntityWither;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.AbstractSkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityPortal
extends EntityFriendlyCreature
implements IEntityMultiPart,
Massive,
Armored,
Structure {
    private static final DataParameter<Integer> TOWER1_TARGET = EntityDataManager.func_187226_a(EntityPortal.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> TOWER2_TARGET = EntityDataManager.func_187226_a(EntityPortal.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> TOWER3_TARGET = EntityDataManager.func_187226_a(EntityPortal.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> TOWER4_TARGET = EntityDataManager.func_187226_a(EntityPortal.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer>[] TARGETS = new DataParameter[]{TOWER1_TARGET, TOWER2_TARGET, TOWER3_TARGET, TOWER4_TARGET};
    private static final DataParameter<Integer> LIGHTNINGTIMER = EntityDataManager.func_187226_a(EntityPortal.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> METADATA = EntityDataManager.func_187226_a(EntityPortal.class, (DataSerializer)DataSerializers.field_187192_b);
    private int[] towerUpdate = new int[4];
    public double targetX;
    public double targetY;
    public double targetZ;
    public EntityDragonPart[] partArray;
    public EntityDragonPart portal = new EntityDragonPart((IEntityMultiPart)this, "portal", 4.0f, 1.0f);
    public EntityDragonPart tower1 = new EntityDragonPart((IEntityMultiPart)this, "tower1", 1.0f, 4.0f);
    public EntityDragonPart tower2 = new EntityDragonPart((IEntityMultiPart)this, "tower2", 1.0f, 4.0f);
    public EntityDragonPart tower3 = new EntityDragonPart((IEntityMultiPart)this, "tower3", 1.0f, 4.0f);
    public EntityDragonPart tower4 = new EntityDragonPart((IEntityMultiPart)this, "tower4", 1.0f, 4.0f);
    public EntityDragonPart side1 = new EntityDragonPart((IEntityMultiPart)this, "side1", 1.0f, 1.0f);
    public EntityDragonPart side2 = new EntityDragonPart((IEntityMultiPart)this, "side2", 1.0f, 1.0f);
    public EntityDragonPart side3 = new EntityDragonPart((IEntityMultiPart)this, "side3", 1.0f, 1.0f);
    public EntityDragonPart side4 = new EntityDragonPart((IEntityMultiPart)this, "side4", 1.0f, 1.0f);

    public EntityPortal(World worldIn) {
        super(worldIn);
        this.partArray = new EntityDragonPart[]{this.portal, this.tower1, this.tower2, this.tower3, this.tower4, this.side1, this.side2, this.side3, this.side4};
        this.func_70105_a(4.0f, 1.0f);
        this.field_70178_ae = true;
        this.func_184185_a(ModSoundEvents.portalMake, 100.0f, 1.0f);
        this.func_184185_a(ModSoundEvents.portalAmbient, 5.0f, 1.0f);
        this.field_70728_aV = 18000;
        this.setLevel(300);
        this.func_70012_b((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 0.0f, -90.0f);
    }

    public int getMetaData() {
        return (Integer)this.field_70180_af.func_187225_a(METADATA);
    }

    public void setMetaData(int p_82215_1_) {
        this.field_70180_af.func_187227_b(METADATA, (Object)p_82215_1_);
    }

    @Override
    public int getSpawnTimer() {
        return 80;
    }

    @Override
    public boolean canWearEasterEggs() {
        return false;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EngenderMod.CONSTRUCT;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(METADATA, (Object)0);
        this.field_70180_af.func_187214_a(TOWER1_TARGET, (Object)0);
        this.field_70180_af.func_187214_a(TOWER2_TARGET, (Object)0);
        this.field_70180_af.func_187214_a(TOWER3_TARGET, (Object)0);
        this.field_70180_af.func_187214_a(TOWER4_TARGET, (Object)0);
    }

    public int getWatchedTargetId(int p_82203_1_) {
        return (Integer)this.field_70180_af.func_187225_a(TARGETS[p_82203_1_]);
    }

    public void updateWatchedTargetId(int targetOffset, int newId) {
        this.field_70180_af.func_187227_b(TARGETS[targetOffset], (Object)newId);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(1000.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(96.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111128_a(20.0);
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a("MetaData", this.getMetaData());
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.setMetaData(tagCompund.func_74762_e("MetaData"));
    }

    @Override
    public boolean canUseGuardBlock() {
        return false;
    }

    @Override
    public boolean func_70631_g_() {
        return false;
    }

    @Override
    public void setChild(boolean childZombie) {
    }

    @Override
    public float getDefaultStrengthStat() {
        return 100.0f;
    }

    @Override
    public float getDefaultStaminaStat() {
        return 100.0f;
    }

    @Override
    public float getDefaultIntelligenceStat() {
        return 0.0f;
    }

    @Override
    public float getDefaultDexterityStat() {
        return 0.0f;
    }

    @Override
    public float getDefaultAgilityStat() {
        return 100.0f;
    }

    @Override
    public float getDefaultFittnessStat() {
        return 1.0f;
    }

    @Override
    public boolean isEntityImmuneToCoralium() {
        return true;
    }

    @Override
    public boolean isEntityImmuneToDread() {
        return true;
    }

    @Override
    public boolean isEntityImmuneToAntiMatter() {
        return true;
    }

    @Override
    public boolean isEntityImmuneToDarkness() {
        return true;
    }

    @Override
    public void func_70074_a(EntityLivingBase entityLivingIn) {
        float f;
        super.func_70074_a(entityLivingIn);
        EntityLightningBolt shot = new EntityLightningBolt(this.field_70170_p, entityLivingIn.field_70165_t - 0.5, entityLivingIn.field_70163_u, entityLivingIn.field_70161_v - 0.5, true);
        shot.field_70177_z = f = -((float)(MathHelper.func_181159_b((double)(shot.field_70161_v - this.field_70161_v), (double)(shot.field_70161_v - this.field_70161_v)) * 57.29577951308232)) - 90.0f;
        this.field_70170_p.func_72942_c((Entity)shot);
        entityLivingIn.func_70077_a(shot);
        entityLivingIn.field_70181_x += 4.0;
        if (entityLivingIn instanceof net.minecraft.entity.monster.EntityCreeper || entityLivingIn instanceof net.minecraft.entity.monster.EntityZombie || entityLivingIn instanceof AbstractSkeleton) {
            net.minecraft.entity.monster.EntityCreeper creeper = new net.minecraft.entity.monster.EntityCreeper(this.field_70170_p);
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72838_d((Entity)creeper);
            }
            creeper.func_82149_j((Entity)entityLivingIn);
            creeper.func_70077_a(shot);
            entityLivingIn.func_70645_a(DamageSource.func_76358_a((EntityLivingBase)creeper).func_76348_h());
            creeper.func_70106_y();
            entityLivingIn.field_70159_w = 0.0;
            entityLivingIn.field_70179_y = 0.0;
            entityLivingIn.func_70653_a((Entity)shot, 2.0f, (double)MathHelper.func_76126_a((float)(shot.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(shot.field_70177_z * ((float)Math.PI / 180)))));
            entityLivingIn.field_70181_x = 0.0;
            entityLivingIn.field_70181_x = entityLivingIn.field_70160_al ? (entityLivingIn.field_70181_x += this.field_70146_Z.nextDouble() * 1.5) : (entityLivingIn.field_70181_x += this.field_70146_Z.nextDouble() * 3.0);
        }
        if (entityLivingIn.field_70131_O < 2.0f && entityLivingIn.field_70130_N < 2.0f && entityLivingIn.func_184222_aU()) {
            entityLivingIn.func_184185_a(SoundEvents.field_187539_bB, 2.0f, 2.0f);
            entityLivingIn.func_184185_a(SoundEvents.field_187659_cY, 2.0f, 2.0f);
            entityLivingIn.func_184185_a(SoundEvents.field_187662_cZ, 2.0f, 2.0f);
            entityLivingIn.field_70170_p.func_72960_a((Entity)entityLivingIn, (byte)20);
            entityLivingIn.func_70106_y();
        }
    }

    @Override
    public boolean takesFallDamage() {
        return false;
    }

    @Override
    public void func_180430_e(float distance, float damageMultiplier) {
        int i = MathHelper.func_76123_f((float)((distance - 6.0f) * damageMultiplier));
        if (i > 0) {
            this.func_184185_a(ModSoundEvents.golemSmash, 10.0f, 0.75f);
            this.func_184185_a(ModSoundEvents.golemSmash, 10.0f, 0.5f);
            List list = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(4.0 + (double)i, 2.0, 4.0 + (double)i), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_94557_a}));
            if (list != null && !list.isEmpty()) {
                for (int i1 = 0; i1 < list.size(); ++i1) {
                    EntityLivingBase entity = (EntityLivingBase)list.get(i1);
                    if (entity == null) continue;
                    if (!this.isOnSameTeam(entity)) {
                        entity.field_70181_x += 1.0 + (double)i * 0.05;
                        entity.func_70097_a(DamageSource.func_94539_a((Explosion)null), 5.0f + (float)i);
                        entity.field_70160_al = true;
                        float f = MathHelper.func_76129_c((float)(MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) + -MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * -MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                        entity.field_70159_w /= 2.0;
                        entity.field_70179_y /= 2.0;
                        entity.field_70159_w -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) / f) * 1.0;
                        entity.field_70179_y -= (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) / f) * 1.0;
                    }
                    if (!EngenderMod.enableMessages || entity.func_70089_S() || this.isWild()) continue;
                    this.getOwner().func_145747_a((ITextComponent)new TextComponentTranslation(entity.func_70005_c_() + " was blown up by " + this.func_70005_c_() + " (" + this.getOwner().func_70005_c_() + ")", new Object[0]));
                }
            }
        }
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        super.func_70652_k(entityIn);
        entityIn.field_70181_x += 1.0;
        this.func_184185_a(ModSoundEvents.lightningShot, 10.0f, 1.0f);
        if (entityIn instanceof EntityLivingBase) {
            if (!entityIn.func_70089_S() && !entityIn.field_70128_L) {
                this.func_70074_a((EntityLivingBase)entityIn);
            }
            ((EntityLivingBase)entityIn).func_70653_a((Entity)this, 1.0f, (double)MathHelper.func_76126_a((float)(entityIn.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(entityIn.field_70177_z * ((float)Math.PI / 180)))));
            if (!(entityIn instanceof EntityFriendlyCreature)) {
                entityIn.field_70181_x += this.field_70146_Z.nextDouble();
            }
        }
        entityIn.func_70015_d(100);
        if (entityIn instanceof EntityLivingBase && entityIn instanceof IEntityMultiPart) {
            ((EntityLivingBase)entityIn).field_70159_w = 0.0;
            ((EntityLivingBase)entityIn).field_70179_y = 0.0;
        }
        return true;
    }

    private double func_82214_u(int p_82214_1_) {
        switch (p_82214_1_) {
            case 0: {
                return this.field_70165_t + 3.25;
            }
            case 1: {
                return this.field_70165_t + 3.25;
            }
            case 2: {
                return this.field_70165_t - 3.25;
            }
            case 3: {
                return this.field_70165_t - 3.25;
            }
        }
        return this.field_70165_t;
    }

    private double func_82208_v(int p_82208_1_) {
        return this.field_70163_u + 3.5;
    }

    private double func_82213_w(int p_82213_1_) {
        switch (p_82213_1_) {
            case 0: {
                return this.field_70161_v + 3.25;
            }
            case 1: {
                return this.field_70161_v - 3.25;
            }
            case 2: {
                return this.field_70161_v + 3.25;
            }
            case 3: {
                return this.field_70161_v - 3.25;
            }
        }
        return this.field_70161_v;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void func_70636_d() {
        block139: {
            int i;
            List list;
            this.func_70105_a(4.0f, 1.0f);
            if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
                int x = MathHelper.func_76128_c((double)this.field_70165_t);
                int y = MathHelper.func_76128_c((double)this.field_70163_u);
                int z = MathHelper.func_76128_c((double)this.field_70161_v);
                for (int x1 = -3; x1 <= 3; ++x1) {
                    for (int z1 = -3; z1 <= 3; ++z1) {
                        for (int y1 = 0; y1 <= 3; ++y1) {
                            BlockPos blockpos = new BlockPos(x + x1, y + y1, z + z1);
                            IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
                            Block block = iblockstate.func_177230_c();
                            if (block.isAir(iblockstate, (IBlockAccess)this.field_70170_p, blockpos) || !(block.func_176195_g(iblockstate, this.field_70170_p, blockpos) >= 0.0f)) continue;
                            this.field_70170_p.func_175655_b(blockpos, true);
                        }
                    }
                }
            }
            if (!this.field_70170_p.field_72995_K && !this.isWild() && this.getOwner() instanceof EntityPlayer && this.getMetaData() >= 4) {
                ((EntityPlayer)this.getOwner()).func_71029_a((StatBase)EngenderAchievments.createMaxPortal);
            }
            float f = this.getJukeboxToDanceTo() != null ? MathHelper.func_76134_b((float)((float)this.field_70173_aa * 0.25f)) * 0.25f : MathHelper.func_76134_b((float)((float)this.field_70173_aa * 0.05f)) * 0.25f;
            this.portal.func_70071_h_();
            this.portal.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0f, 0.0f);
            this.tower1.func_70071_h_();
            this.tower1.func_70012_b(this.field_70165_t + 2.75 + (double)f, this.field_70163_u + 0.325, this.field_70161_v + 2.75 + (double)f, 0.0f, 0.0f);
            this.tower2.func_70071_h_();
            this.tower2.func_70012_b(this.field_70165_t + 2.75 + (double)f, this.field_70163_u + 0.325, this.field_70161_v - 2.75 - (double)f, 0.0f, 0.0f);
            this.tower3.func_70071_h_();
            this.tower3.func_70012_b(this.field_70165_t - 2.75 - (double)f, this.field_70163_u + 0.325, this.field_70161_v - 2.75 - (double)f, 0.0f, 0.0f);
            this.tower4.func_70071_h_();
            this.tower4.func_70012_b(this.field_70165_t - 2.75 - (double)f, this.field_70163_u + 0.325, this.field_70161_v + 2.75 + (double)f, 0.0f, 0.0f);
            this.side1.func_70071_h_();
            this.side1.func_70012_b(this.field_70165_t + 2.5, this.field_70163_u + 0.5, this.field_70161_v, 0.0f, 0.0f);
            this.side1.func_174826_a(new AxisAlignedBB(this.side1.field_70165_t - 0.5, this.side1.field_70163_u, this.side1.field_70161_v - 2.0, this.side1.field_70165_t + 0.5, this.side1.field_70163_u + 1.0, this.side1.field_70161_v + 2.0));
            this.side2.func_70071_h_();
            this.side2.func_70012_b(this.field_70165_t - 2.5, this.field_70163_u + 0.5, this.field_70161_v, 0.0f, 0.0f);
            this.side2.func_174826_a(new AxisAlignedBB(this.side2.field_70165_t - 0.5, this.side2.field_70163_u, this.side2.field_70161_v - 2.0, this.side2.field_70165_t + 0.5, this.side2.field_70163_u + 1.0, this.side2.field_70161_v + 2.0));
            this.side3.func_70071_h_();
            this.side3.func_70012_b(this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v + 2.5, 0.0f, 0.0f);
            this.side3.func_174826_a(new AxisAlignedBB(this.side3.field_70165_t - 2.0, this.side3.field_70163_u, this.side3.field_70161_v - 0.5, this.side3.field_70165_t + 2.0, this.side3.field_70163_u + 1.0, this.side3.field_70161_v + 0.5));
            this.side4.func_70071_h_();
            this.side4.func_70012_b(this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v - 2.5, 0.0f, 0.0f);
            this.side4.func_174826_a(new AxisAlignedBB(this.side4.field_70165_t - 2.0, this.side4.field_70163_u, this.side4.field_70161_v - 0.5, this.side4.field_70165_t + 2.0, this.side4.field_70163_u + 1.0, this.side4.field_70161_v + 0.5));
            if (!this.field_70170_p.field_72995_K) {
                for (int i2 = 0; i2 < 4; ++i2) {
                    if (this.func_70643_av() != null) {
                        this.updateWatchedTargetId(i2, this.func_70643_av().func_145782_y());
                    }
                    if (this.field_70173_aa <= 80 || !this.func_70089_S() || this.field_70173_aa < this.towerUpdate[i2]) continue;
                    int i1 = this.getWatchedTargetId(i2);
                    if (i1 > 0) {
                        Entity entity = this.field_70170_p.func_73045_a(i1);
                        if (entity != null && entity.func_70089_S() && (double)this.func_70032_d(entity) <= this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111125_b() && this.func_70685_l(entity)) {
                            double d1 = this.func_82214_u(i2);
                            double d2 = this.func_82208_v(i2);
                            double d3 = this.func_82213_w(i2);
                            this.fireLightning(entity, d1, d2, d3);
                            if (this.moralRaisedTimer > 200) {
                                this.towerUpdate[i2] = this.field_70173_aa + 1;
                                continue;
                            }
                            if (this.getMetaData() > 1) {
                                this.towerUpdate[i2] = this.field_70173_aa + 30;
                                continue;
                            }
                            this.towerUpdate[i2] = this.field_70173_aa + 60;
                            continue;
                        }
                        this.updateWatchedTargetId(i2, 0);
                        continue;
                    }
                    List list2 = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_186662_g(this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e()), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_94557_a}));
                    for (int k1 = 0; k1 < 10 && !list2.isEmpty(); ++k1) {
                        EntityLivingBase entitylivingbase = (EntityLivingBase)list2.get(this.field_70146_Z.nextInt(list2.size()));
                        if (entitylivingbase != this && entitylivingbase.func_70089_S() && this.func_70685_l((Entity)entitylivingbase) && !this.isOnSameTeam(entitylivingbase)) {
                            if (entitylivingbase instanceof EntityPlayer) {
                                if (((EntityPlayer)entitylivingbase).field_71075_bZ.field_75102_a) continue;
                                this.updateWatchedTargetId(i2, entitylivingbase.func_145782_y());
                                continue;
                            }
                            this.updateWatchedTargetId(i2, entitylivingbase.func_145782_y());
                            continue;
                        }
                        list2.remove(entitylivingbase);
                    }
                }
            }
            this.field_70728_aV = 6000 * (1 + this.getMetaData());
            if (this.getMetaData() > 0) {
                this.func_70690_d(new PotionEffect(MobEffects.field_76429_m, Integer.MAX_VALUE, this.getMetaData() > 2 ? 1 : 0));
                this.func_70690_d(new PotionEffect(MobEffects.field_76420_g, Integer.MAX_VALUE, this.getMetaData() > 2 ? 1 : 0));
            }
            if (!(list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72314_b(1.0, 4.0, 1.0).func_72317_d(0.0, 2.0, 0.0), EntitySelectors.field_94557_a)).isEmpty()) {
                for (int l = 0; l < list.size(); ++l) {
                    Entity[] aentity = this.func_70021_al();
                    if (aentity == null) continue;
                    for (Entity part : aentity) {
                        List partlist = this.field_70170_p.func_175674_a((Entity)this, part.func_174813_aQ(), EntitySelectors.field_94557_a);
                        if (partlist.isEmpty()) continue;
                        for (int l1 = 0; l1 < partlist.size(); ++l1) {
                            Entity entity = (Entity)partlist.get(l1);
                            if (!(entity instanceof EntityLivingBase) || entity.field_70145_X || entity instanceof IEntityMultiPart) continue;
                            if (entity.field_70132_H) {
                                entity.func_70097_a(DamageSource.field_76368_d, 1.0f);
                            }
                            part.func_70108_f(entity);
                            entity.func_70108_f(part);
                            entity.field_70181_x += 0.1;
                        }
                    }
                }
            }
            this.field_70159_w = 0.0;
            this.field_70179_y = 0.0;
            if (this.field_70181_x > 0.0) {
                this.field_70181_x = 0.0;
            }
            super.func_70636_d();
            this.field_70759_as = 0.0f;
            this.field_70758_at = 0.0f;
            this.field_70177_z = 0.0f;
            this.field_70126_B = 0.0f;
            this.field_70761_aq = 0.0f;
            this.field_70760_ar = 0.0f;
            this.field_70125_A = 90.0f;
            this.field_70127_C = 90.0f;
            this.field_70160_al = false;
            this.field_70122_E = true;
            this.func_70031_b(false);
            if (this.field_70170_p.field_72995_K && this.func_70089_S()) {
                for (i = 0; i < 3 && this.field_70173_aa > 60; ++i) {
                    if (this.towerUpdate[i] > 20) {
                        this.field_70170_p.func_175688_a(EnumParticleTypes.ENCHANTMENT_TABLE, this.func_82214_u(i), this.func_82208_v(i), this.func_82208_v(i), (double)((float)this.func_82214_u(i) + this.field_70146_Z.nextFloat()) - 0.5, (double)((float)this.func_82208_v(i) - this.field_70146_Z.nextFloat() - 1.0f), (double)((float)this.func_82208_v(i) + this.field_70146_Z.nextFloat()) - 0.5, new int[0]);
                    }
                    if (this.getMetaData() > 0) {
                        this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + 1.0, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 1.0, 0.0, 0.0, new int[0]);
                    }
                    if (this.getMetaData() > 1) {
                        this.field_70170_p.func_175682_a(EnumParticleTypes.SPELL_INSTANT, true, this.field_70165_t + 3.25 + (double)f + (this.field_70146_Z.nextDouble() - 0.5), this.field_70163_u + 4.0 + (this.field_70146_Z.nextDouble() - 0.5), this.field_70161_v + 3.25 + (double)f + (this.field_70146_Z.nextDouble() - 0.5), (double)f * 0.1, 0.02, (double)f * 0.1, new int[0]);
                        this.field_70170_p.func_175682_a(EnumParticleTypes.SPELL_INSTANT, true, this.field_70165_t + 3.25 + (double)f + (this.field_70146_Z.nextDouble() - 0.5), this.field_70163_u + 4.0 + (this.field_70146_Z.nextDouble() - 0.5), this.field_70161_v - 3.25 - (double)f + (this.field_70146_Z.nextDouble() - 0.5), (double)f * 0.1, 0.02, (double)f * 0.1, new int[0]);
                        this.field_70170_p.func_175682_a(EnumParticleTypes.SPELL_INSTANT, true, this.field_70165_t - 3.25 - (double)f + (this.field_70146_Z.nextDouble() - 0.5), this.field_70163_u + 4.0 + (this.field_70146_Z.nextDouble() - 0.5), this.field_70161_v - 3.25 - (double)f + (this.field_70146_Z.nextDouble() - 0.5), (double)f * 0.1, 0.02, (double)f * 0.1, new int[0]);
                        this.field_70170_p.func_175682_a(EnumParticleTypes.SPELL_INSTANT, true, this.field_70165_t - 3.25 - (double)f + (this.field_70146_Z.nextDouble() - 0.5), this.field_70163_u + 4.0 + (this.field_70146_Z.nextDouble() - 0.5), this.field_70161_v + 3.25 + (double)f + (this.field_70146_Z.nextDouble() - 0.5), (double)f * 0.1, 0.02, (double)f * 0.1, new int[0]);
                    }
                    if (this.getMetaData() > 2) {
                        this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + 1.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 1.0, 0.0, 0.5, new int[0]);
                    }
                    if (this.getMetaData() > 3) {
                        this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + 0.8, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.05, 0.0, new int[0]);
                        this.field_70170_p.func_175688_a(EnumParticleTypes.ENCHANTMENT_TABLE, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + 0.8, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.05, 0.0, new int[0]);
                        this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + 0.8, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.05, 0.0, new int[0]);
                    }
                    this.field_70170_p.func_175688_a(EnumParticleTypes.TOWN_AURA, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + 1.0 + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0 + (this.field_70146_Z.nextDouble() * 0.1 - 0.05), 0.0 + this.field_70146_Z.nextDouble() * 0.2, 0.0 + (this.field_70146_Z.nextDouble() * 0.1 - 0.05), new int[0]);
                    this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + 0.8 + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.5, 0.0, new int[0]);
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + 0.8, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.05, 0.0, new int[0]);
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + 0.8, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.05, 0.0, new int[0]);
                    this.field_70170_p.func_175682_a(EnumParticleTypes.FIREWORKS_SPARK, true, this.field_70165_t + 3.25 + (double)f + (this.field_70146_Z.nextDouble() - 0.5), this.field_70163_u + 4.0 + (this.field_70146_Z.nextDouble() - 0.5), this.field_70161_v + 3.25 + (double)f + (this.field_70146_Z.nextDouble() - 0.5), (double)f * 0.1, 0.02, (double)f * 0.1, new int[0]);
                    this.field_70170_p.func_175682_a(EnumParticleTypes.FIREWORKS_SPARK, true, this.field_70165_t + 3.25 + (double)f + (this.field_70146_Z.nextDouble() - 0.5), this.field_70163_u + 4.0 + (this.field_70146_Z.nextDouble() - 0.5), this.field_70161_v - 3.25 - (double)f + (this.field_70146_Z.nextDouble() - 0.5), (double)f * 0.1, 0.02, (double)f * 0.1, new int[0]);
                    this.field_70170_p.func_175682_a(EnumParticleTypes.FIREWORKS_SPARK, true, this.field_70165_t - 3.25 - (double)f + (this.field_70146_Z.nextDouble() - 0.5), this.field_70163_u + 4.0 + (this.field_70146_Z.nextDouble() - 0.5), this.field_70161_v - 3.25 - (double)f + (this.field_70146_Z.nextDouble() - 0.5), (double)f * 0.1, 0.02, (double)f * 0.1, new int[0]);
                    this.field_70170_p.func_175682_a(EnumParticleTypes.FIREWORKS_SPARK, true, this.field_70165_t - 3.25 - (double)f + (this.field_70146_Z.nextDouble() - 0.5), this.field_70163_u + 4.0 + (this.field_70146_Z.nextDouble() - 0.5), this.field_70161_v + 3.25 + (double)f + (this.field_70146_Z.nextDouble() - 0.5), (double)f * 0.1, 0.02, (double)f * 0.1, new int[0]);
                }
            }
            if ((this.field_70173_aa + this.func_145782_y()) % (this.getJukeboxToDanceTo() != null ? 20 : 200) == 0) {
                this.func_184185_a(ModSoundEvents.portalWhoosh, 5.0f, 1.0f);
            }
            if ((this.field_70173_aa + this.func_145782_y()) % 670 == 0) {
                this.func_184185_a(ModSoundEvents.portalAmbient, 5.0f, 1.0f);
            }
            if (this.field_70173_aa + this.func_145782_y() <= 60 || (this.field_70173_aa + this.func_145782_y()) % (this.getJukeboxToDanceTo() != null ? 20 : (this.getMetaData() > 2 ? 50 : 100)) != 0 || this.field_70146_Z.nextInt(this.getJukeboxToDanceTo() != null ? 5 : 10) != 0) return;
            this.func_184185_a(ModSoundEvents.portalWhoosh, 10.0f, this.func_70647_i() + 1.9f);
            i = 0;
            if (this.field_70146_Z.nextInt(2) == 0) {
                ++i;
            }
            if (this.field_70146_Z.nextInt(3) == 0) {
                ++i;
            }
            if (this.field_70146_Z.nextInt(6) == 0) {
                ++i;
            }
            if (this.field_70146_Z.nextInt(12) == 0) {
                ++i;
            }
            switch (i) {
                case 0: {
                    switch (this.field_70146_Z.nextInt(8)) {
                        case 0: {
                            EntityBat bat = new EntityBat(this.field_70170_p);
                            bat.func_70012_b(this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), this.field_70163_u + 1.5, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), 0.0f, 0.0f);
                            if (!this.isWild()) {
                                bat.setOwnerId(this.func_184753_b());
                            }
                            bat.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)bat)), null);
                            if (this.field_70170_p.field_72995_K) break;
                            this.field_70170_p.func_72838_d((Entity)bat);
                            return;
                        }
                        case 1: {
                            EntityChicken chicken = new EntityChicken(this.field_70170_p);
                            chicken.func_70012_b(this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), this.field_70163_u + 1.5, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), 0.0f, 0.0f);
                            if (!this.isWild()) {
                                chicken.setOwnerId(this.func_184753_b());
                            }
                            chicken.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)chicken)), null);
                            if (this.field_70170_p.field_72995_K) break;
                            this.field_70170_p.func_72838_d((Entity)chicken);
                            return;
                        }
                        case 2: {
                            EntityCow cow = new EntityCow(this.field_70170_p);
                            cow.func_70012_b(this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), this.field_70163_u + 1.5, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), 0.0f, 0.0f);
                            if (!this.isWild()) {
                                cow.setOwnerId(this.func_184753_b());
                            }
                            cow.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)cow)), null);
                            if (this.field_70170_p.field_72995_K) break;
                            this.field_70170_p.func_72838_d((Entity)cow);
                            return;
                        }
                        case 3: {
                            EntityMooshroom mooshroom = new EntityMooshroom(this.field_70170_p);
                            mooshroom.func_70012_b(this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), this.field_70163_u + 1.5, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), 0.0f, 0.0f);
                            if (!this.isWild()) {
                                mooshroom.setOwnerId(this.func_184753_b());
                            }
                            mooshroom.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)mooshroom)), null);
                            if (this.field_70170_p.field_72995_K) break;
                            this.field_70170_p.func_72838_d((Entity)mooshroom);
                            return;
                        }
                        case 4: {
                            EntityOcelot ocelot = new EntityOcelot(this.field_70170_p);
                            ocelot.func_70012_b(this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), this.field_70163_u + 1.5, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), 0.0f, 0.0f);
                            if (!this.isWild()) {
                                ocelot.setOwnerId(this.func_184753_b());
                            }
                            ocelot.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)ocelot)), null);
                            if (this.field_70170_p.field_72995_K) break;
                            this.field_70170_p.func_72838_d((Entity)ocelot);
                            return;
                        }
                        case 5: {
                            EntityPig pig = new EntityPig(this.field_70170_p);
                            pig.func_70012_b(this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), this.field_70163_u + 1.5, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), 0.0f, 0.0f);
                            if (!this.isWild()) {
                                pig.setOwnerId(this.func_184753_b());
                            }
                            pig.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)pig)), null);
                            if (this.field_70170_p.field_72995_K) break;
                            this.field_70170_p.func_72838_d((Entity)pig);
                            return;
                        }
                        case 6: {
                            EntityRabbit rabbit = new EntityRabbit(this.field_70170_p);
                            rabbit.func_70012_b(this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), this.field_70163_u + 1.5, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), 0.0f, 0.0f);
                            if (!this.isWild()) {
                                rabbit.setOwnerId(this.func_184753_b());
                            }
                            rabbit.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)rabbit)), null);
                            if (this.field_70170_p.field_72995_K) break;
                            this.field_70170_p.func_72838_d((Entity)rabbit);
                            return;
                        }
                        case 7: {
                            EntitySheep sheep = new EntitySheep(this.field_70170_p);
                            sheep.func_70012_b(this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), this.field_70163_u + 1.5, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), 0.0f, 0.0f);
                            if (!this.isWild()) {
                                sheep.setOwnerId(this.func_184753_b());
                            }
                            sheep.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)sheep)), null);
                            if (this.field_70170_p.field_72995_K) break;
                            this.field_70170_p.func_72838_d((Entity)sheep);
                        }
                    }
                    return;
                }
                case 1: {
                    switch (this.field_70146_Z.nextInt(7)) {
                        case 0: {
                            EntityEndermite endermite = new EntityEndermite(this.field_70170_p);
                            endermite.func_70012_b(this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), this.field_70163_u + 1.5, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), 0.0f, 0.0f);
                            if (!this.isWild()) {
                                endermite.setOwnerId(this.func_184753_b());
                            }
                            endermite.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)endermite)), null);
                            if (this.field_70170_p.field_72995_K) break;
                            this.field_70170_p.func_72838_d((Entity)endermite);
                            return;
                        }
                        case 1: {
                            EntitySilverfish silverfish = new EntitySilverfish(this.field_70170_p);
                            silverfish.func_70012_b(this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), this.field_70163_u + 1.5, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), 0.0f, 0.0f);
                            if (!this.isWild()) {
                                silverfish.setOwnerId(this.func_184753_b());
                            }
                            silverfish.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)silverfish)), null);
                            if (this.field_70170_p.field_72995_K) break;
                            this.field_70170_p.func_72838_d((Entity)silverfish);
                            return;
                        }
                        case 2: {
                            EntitySnowman snowgolem = new EntitySnowman(this.field_70170_p);
                            snowgolem.func_70012_b(this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), this.field_70163_u + 1.5, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), 0.0f, 0.0f);
                            if (!this.isWild()) {
                                snowgolem.setOwnerId(this.func_184753_b());
                            }
                            snowgolem.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)snowgolem)), null);
                            if (this.field_70170_p.field_72995_K) break;
                            this.field_70170_p.func_72838_d((Entity)snowgolem);
                            return;
                        }
                        case 3: {
                            EntitySquid squid = new EntitySquid(this.field_70170_p);
                            squid.func_70012_b(this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), this.field_70163_u + 1.5, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), 0.0f, 0.0f);
                            if (!this.isWild()) {
                                squid.setOwnerId(this.func_184753_b());
                            }
                            squid.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)squid)), null);
                            if (this.field_70170_p.field_72995_K) break;
                            this.field_70170_p.func_72838_d((Entity)squid);
                            return;
                        }
                        case 4: {
                            EntityVillager villager = new EntityVillager(this.field_70170_p);
                            villager.func_70012_b(this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), this.field_70163_u + 1.5, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), 0.0f, 0.0f);
                            if (!this.isWild()) {
                                villager.setOwnerId(this.func_184753_b());
                            }
                            villager.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)villager)), null);
                            if (this.field_70170_p.field_72995_K) break;
                            this.field_70170_p.func_72838_d((Entity)villager);
                            return;
                        }
                        case 5: {
                            EntityWolf wolf = new EntityWolf(this.field_70170_p);
                            wolf.func_70012_b(this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), this.field_70163_u + 1.5, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), 0.0f, 0.0f);
                            if (!this.isWild()) {
                                wolf.setOwnerId(this.func_184753_b());
                            }
                            wolf.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)wolf)), null);
                            if (this.field_70170_p.field_72995_K) break;
                            this.field_70170_p.func_72838_d((Entity)wolf);
                            return;
                        }
                        case 6: {
                            EntityLlama llama = new EntityLlama(this.field_70170_p);
                            llama.func_70012_b(this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), this.field_70163_u + 1.5, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), 0.0f, 0.0f);
                            if (!this.isWild()) {
                                llama.setOwnerId(this.func_184753_b());
                            }
                            llama.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)llama)), null);
                            if (this.field_70170_p.field_72995_K) break;
                            this.field_70170_p.func_72838_d((Entity)llama);
                        }
                    }
                    return;
                }
                case 2: {
                    switch (this.field_70146_Z.nextInt(7)) {
                        case 0: {
                            EntityCreeper creeper = new EntityCreeper(this.field_70170_p);
                            creeper.func_70012_b(this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), this.field_70163_u + 1.5, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), 0.0f, 0.0f);
                            if (!this.isWild()) {
                                creeper.setOwnerId(this.func_184753_b());
                            }
                            creeper.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)creeper)), null);
                            if (this.field_70170_p.field_72995_K) break;
                            this.field_70170_p.func_72838_d((Entity)creeper);
                            return;
                        }
                        case 1: {
                            EntityMagmaCube magmacube = new EntityMagmaCube(this.field_70170_p);
                            magmacube.func_70012_b(this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), this.field_70163_u + 1.5, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), 0.0f, 0.0f);
                            if (!this.isWild()) {
                                magmacube.setOwnerId(this.func_184753_b());
                            }
                            magmacube.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)magmacube)), null);
                            if (this.field_70170_p.field_72995_K) break;
                            this.field_70170_p.func_72838_d((Entity)magmacube);
                            return;
                        }
                        case 2: {
                            EntitySkeleton skeleton = new EntitySkeleton(this.field_70170_p);
                            skeleton.func_70012_b(this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), this.field_70163_u + 1.5, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), 0.0f, 0.0f);
                            if (!this.isWild()) {
                                skeleton.setOwnerId(this.func_184753_b());
                            }
                            skeleton.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)skeleton)), null);
                            if (this.field_70170_p.field_72995_K) break;
                            this.field_70170_p.func_72838_d((Entity)skeleton);
                            return;
                        }
                        case 3: {
                            EntitySlime slime = new EntitySlime(this.field_70170_p);
                            slime.func_70012_b(this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), this.field_70163_u + 1.5, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), 0.0f, 0.0f);
                            if (!this.isWild()) {
                                slime.setOwnerId(this.func_184753_b());
                            }
                            slime.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)slime)), null);
                            if (this.field_70170_p.field_72995_K) break;
                            this.field_70170_p.func_72838_d((Entity)slime);
                            return;
                        }
                        case 4: {
                            EntitySpider spider = new EntitySpider(this.field_70170_p);
                            spider.func_70012_b(this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), this.field_70163_u + 1.5, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), 0.0f, 0.0f);
                            if (!this.isWild()) {
                                spider.setOwnerId(this.func_184753_b());
                            }
                            spider.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)spider)), null);
                            if (this.field_70170_p.field_72995_K) break;
                            this.field_70170_p.func_72838_d((Entity)spider);
                            return;
                        }
                        case 5: {
                            EntityZombie zombie = new EntityZombie(this.field_70170_p);
                            zombie.func_70012_b(this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), this.field_70163_u + 1.5, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), 0.0f, 0.0f);
                            if (!this.isWild()) {
                                zombie.setOwnerId(this.func_184753_b());
                            }
                            zombie.setZombieType(0);
                            zombie.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)zombie)), null);
                            if (this.field_70170_p.field_72995_K) break;
                            this.field_70170_p.func_72838_d((Entity)zombie);
                            return;
                        }
                        case 6: {
                            EntityVex vex = new EntityVex(this.field_70170_p);
                            vex.func_70012_b(this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), this.field_70163_u + 1.5, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), 0.0f, 0.0f);
                            if (!this.isWild()) {
                                vex.setOwnerId(this.func_184753_b());
                            }
                            vex.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)vex)), null);
                            if (this.field_70170_p.field_72995_K) break;
                            this.field_70170_p.func_72838_d((Entity)vex);
                        }
                    }
                    return;
                }
                case 3: {
                    switch (this.field_70146_Z.nextInt(12)) {
                        case 0: {
                            EntityBlaze blaze = new EntityBlaze(this.field_70170_p);
                            blaze.func_70012_b(this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), this.field_70163_u + 1.5, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), 0.0f, 0.0f);
                            if (!this.isWild()) {
                                blaze.setOwnerId(this.func_184753_b());
                            }
                            blaze.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)blaze)), null);
                            if (this.field_70170_p.field_72995_K) break;
                            this.field_70170_p.func_72838_d((Entity)blaze);
                            return;
                        }
                        case 1: {
                            EntityCaveSpider cavespider = new EntityCaveSpider(this.field_70170_p);
                            cavespider.func_70012_b(this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), this.field_70163_u + 1.5, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), 0.0f, 0.0f);
                            if (!this.isWild()) {
                                cavespider.setOwnerId(this.func_184753_b());
                            }
                            cavespider.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)cavespider)), null);
                            if (this.field_70170_p.field_72995_K) break;
                            this.field_70170_p.func_72838_d((Entity)cavespider);
                            return;
                        }
                        case 2: {
                            EntityEnderman enderman = new EntityEnderman(this.field_70170_p);
                            enderman.func_70012_b(this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), this.field_70163_u + 1.5, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), 0.0f, 0.0f);
                            if (!this.isWild()) {
                                enderman.setOwnerId(this.func_184753_b());
                            }
                            enderman.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)enderman)), null);
                            if (this.field_70170_p.field_72995_K) break;
                            this.field_70170_p.func_72838_d((Entity)enderman);
                            return;
                        }
                        case 3: {
                            EntityGhast ghast = new EntityGhast(this.field_70170_p);
                            ghast.func_70012_b(this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), this.field_70163_u + 1.5, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), 0.0f, 0.0f);
                            if (!this.isWild()) {
                                ghast.setOwnerId(this.func_184753_b());
                            }
                            ghast.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)ghast)), null);
                            if (this.field_70170_p.field_72995_K) break;
                            this.field_70170_p.func_72838_d((Entity)ghast);
                            return;
                        }
                        case 4: {
                            EntityGuardian guardian = new EntityGuardian(this.field_70170_p);
                            guardian.func_70012_b(this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), this.field_70163_u + 1.5, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), 0.0f, 0.0f);
                            if (!this.isWild()) {
                                guardian.setOwnerId(this.func_184753_b());
                            }
                            guardian.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)guardian)), null);
                            if (this.field_70170_p.field_72995_K) break;
                            this.field_70170_p.func_72838_d((Entity)guardian);
                            return;
                        }
                        case 5: {
                            EntityPigZombie pigzombie = new EntityPigZombie(this.field_70170_p);
                            pigzombie.func_70012_b(this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), this.field_70163_u + 1.5, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), 0.0f, 0.0f);
                            if (!this.isWild()) {
                                pigzombie.setOwnerId(this.func_184753_b());
                            }
                            pigzombie.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)pigzombie)), null);
                            if (this.field_70170_p.field_72995_K) break;
                            this.field_70170_p.func_72838_d((Entity)pigzombie);
                            return;
                        }
                        case 6: {
                            EntityRabbit killerrabbit = new EntityRabbit(this.field_70170_p);
                            killerrabbit.func_70012_b(this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), this.field_70163_u + 1.5, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), 0.0f, 0.0f);
                            if (!this.isWild()) {
                                killerrabbit.setOwnerId(this.func_184753_b());
                            }
                            killerrabbit.setRabbitType(99);
                            killerrabbit.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)killerrabbit)), null);
                            if (this.field_70170_p.field_72995_K) break;
                            this.field_70170_p.func_72838_d((Entity)killerrabbit);
                            return;
                        }
                        case 7: {
                            EntitySkeleton witherskeleton = new EntitySkeleton(this.field_70170_p);
                            witherskeleton.func_70012_b(this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), this.field_70163_u + 1.5, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), 0.0f, 0.0f);
                            if (!this.isWild()) {
                                witherskeleton.setOwnerId(this.func_184753_b());
                            }
                            witherskeleton.setSkeletonType(1);
                            witherskeleton.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151052_q));
                            if (this.func_70681_au().nextInt(2) > 0) {
                                witherskeleton.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(Items.field_151052_q));
                            }
                            witherskeleton.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)witherskeleton)), null);
                            if (this.field_70170_p.field_72995_K) break;
                            this.field_70170_p.func_72838_d((Entity)witherskeleton);
                            return;
                        }
                        case 8: {
                            EntityShulker shulker = new EntityShulker(this.field_70170_p);
                            shulker.func_70012_b(this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), this.field_70163_u + 1.5, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), 0.0f, 0.0f);
                            if (!this.isWild()) {
                                shulker.setOwnerId(this.func_184753_b());
                            }
                            shulker.func_70108_f((Entity)this);
                            shulker.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)shulker)), null);
                            if (this.field_70170_p.field_72995_K) break;
                            this.field_70170_p.func_72838_d((Entity)shulker);
                            return;
                        }
                        case 9: {
                            EntityWitch witch = new EntityWitch(this.field_70170_p);
                            witch.func_70012_b(this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), this.field_70163_u + 1.5, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), 0.0f, 0.0f);
                            if (!this.isWild()) {
                                witch.setOwnerId(this.func_184753_b());
                            }
                            witch.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)witch)), null);
                            if (this.field_70170_p.field_72995_K) break;
                            this.field_70170_p.func_72838_d((Entity)witch);
                            return;
                        }
                        case 10: {
                            EntityZombie zombie = new EntityZombie(this.field_70170_p);
                            zombie.func_70012_b(this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), this.field_70163_u + 1.5, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), 0.0f, 0.0f);
                            if (!this.isWild()) {
                                zombie.setOwnerId(this.func_184753_b());
                            }
                            zombie.setZombieType(1);
                            zombie.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)zombie)), null);
                            if (this.field_70170_p.field_72995_K) break;
                            this.field_70170_p.func_72838_d((Entity)zombie);
                            return;
                        }
                        case 11: {
                            EntitySkeleton stray = new EntitySkeleton(this.field_70170_p);
                            stray.func_70012_b(this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), this.field_70163_u + 1.5, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), 0.0f, 0.0f);
                            if (!this.isWild()) {
                                stray.setOwnerId(this.func_184753_b());
                            }
                            stray.setSkeletonType(2);
                            stray.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)stray)), null);
                            if (this.field_70170_p.field_72995_K) break;
                            this.field_70170_p.func_72838_d((Entity)stray);
                            return;
                        }
                        case 12: {
                            EntityVindicator vindicator = new EntityVindicator(this.field_70170_p);
                            vindicator.func_70012_b(this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), this.field_70163_u + 1.5, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), 0.0f, 0.0f);
                            if (!this.isWild()) {
                                vindicator.setOwnerId(this.func_184753_b());
                            }
                            vindicator.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)vindicator)), null);
                            if (this.field_70170_p.field_72995_K) break;
                            this.field_70170_p.func_72838_d((Entity)vindicator);
                        }
                    }
                    return;
                }
                case 4: {
                    if (!this.field_70170_p.field_72995_K && !this.isWild() && this.getOwner() instanceof EntityPlayer && this.getMetaData() >= 4) {
                        ((EntityPlayer)this.getOwner()).func_71029_a((StatBase)EngenderAchievments.summonTier5);
                    }
                    switch (this.field_70146_Z.nextInt(5)) {
                        case 0: {
                            EntityElderGuardian elderguardian = new EntityElderGuardian(this.field_70170_p);
                            elderguardian.func_70012_b(this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), this.field_70163_u + 1.5, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), 0.0f, 0.0f);
                            if (!this.isWild()) {
                                elderguardian.setOwnerId(this.func_184753_b());
                            }
                            elderguardian.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)elderguardian)), null);
                            if (this.field_70170_p.field_72995_K) return;
                            this.field_70170_p.func_72838_d((Entity)elderguardian);
                            break block139;
                        }
                        case 1: {
                            EntityGiant giant = new EntityGiant(this.field_70170_p);
                            giant.func_70012_b(this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), this.field_70163_u + 1.5, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), 0.0f, 0.0f);
                            if (!this.isWild()) {
                                giant.setOwnerId(this.func_184753_b());
                            }
                            giant.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)giant)), null);
                            if (this.field_70170_p.field_72995_K) return;
                            this.field_70170_p.func_72838_d((Entity)giant);
                            break block139;
                        }
                        case 2: {
                            EntityIronGolem irongolem = new EntityIronGolem(this.field_70170_p);
                            irongolem.func_70012_b(this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), this.field_70163_u + 1.5, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), 0.0f, 0.0f);
                            if (!this.isWild()) {
                                irongolem.setOwnerId(this.func_184753_b());
                            }
                            irongolem.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)irongolem)), null);
                            if (this.field_70170_p.field_72995_K) return;
                            this.field_70170_p.func_72838_d((Entity)irongolem);
                            break block139;
                        }
                        case 3: {
                            EntityWither wither = new EntityWither(this.field_70170_p);
                            wither.func_70012_b(this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), this.field_70163_u + 1.5, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), 0.0f, 0.0f);
                            if (!this.isWild()) {
                                wither.setOwnerId(this.func_184753_b());
                            }
                            wither.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)wither)), null);
                            if (this.field_70170_p.field_72995_K) return;
                            this.field_70170_p.func_72838_d((Entity)wither);
                            break block139;
                        }
                        case 4: {
                            EntityEvoker evoker = new EntityEvoker(this.field_70170_p);
                            evoker.func_70012_b(this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), this.field_70163_u + 1.5, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 4.0f - 2.0f), 0.0f, 0.0f);
                            if (!this.isWild()) {
                                evoker.setOwnerId(this.func_184753_b());
                            }
                            evoker.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)evoker)), null);
                            if (this.field_70170_p.field_72995_K) return;
                            this.field_70170_p.func_72838_d((Entity)evoker);
                        }
                    }
                }
            }
        }
    }

    @Override
    protected void func_70609_aI() {
        ++this.field_70725_aQ;
        if (this.field_70725_aQ == 1) {
            this.func_184185_a(ModSoundEvents.buildingDeath, 10.0f, 1.0f);
            if (!this.field_70170_p.field_72995_K) {
                this.func_70099_a(new ItemStack(SpawnerItems.portalStaff, 1, this.getMetaData()), 1.0f);
            }
            for (int k = 0; k < 2500; ++k) {
                double d2 = this.field_70146_Z.nextGaussian() * 0.05;
                double d0 = this.field_70146_Z.nextGaussian() * 0.05;
                double d1 = this.field_70146_Z.nextGaussian() * 0.05;
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O * 4.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d2, -0.25, d1, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O * 4.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d2, -0.25, d1, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O * 4.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d2, 0.5, d1, new int[0]);
            }
        }
        if (!this.field_70170_p.field_72995_K && (this.func_70684_aJ() || this.field_70718_bc > 0 && this.func_146066_aG() && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot"))) {
            int j;
            int i = this.func_70693_a(this.field_70717_bb) / 60;
            for (i = ForgeEventFactory.getExperienceDrop((EntityLivingBase)this, (EntityPlayer)this.field_70717_bb, (int)i); i > 0; i -= j) {
                j = EntityXPOrb.func_70527_a((int)i);
                this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
            }
        }
        if (this.field_70725_aQ == 60) {
            this.func_70106_y();
        }
    }

    @Override
    public EnumTier getTier() {
        return EnumTier.TIER6;
    }

    @Override
    public boolean func_180427_aV() {
        return true;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableListEngender.ENTITIES_PORTAL;
    }

    protected SoundEvent func_184615_bR() {
        return null;
    }

    protected SoundEvent func_184601_bQ() {
        return null;
    }

    @Override
    public void func_70624_b(EntityLivingBase entitylivingbaseIn) {
        if (this.func_70089_S() && this.field_70173_aa > 80) {
            super.func_70624_b(entitylivingbaseIn);
        }
    }

    @Override
    protected SoundEvent getRegularHurtSound() {
        return ModSoundEvents.woodHit;
    }

    @Override
    protected SoundEvent getPierceHurtSound() {
        return ModSoundEvents.woodHitPierce;
    }

    @Override
    protected SoundEvent getCrushHurtSound() {
        return ModSoundEvents.woodHitCrush;
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.field_70173_aa > 40 && stack.func_190926_b() && !this.isWild() && player == this.getOwner()) {
            if (player.func_70093_af()) {
                List list = this.field_70170_p.func_175647_a(EntityFriendlyCreature.class, this.func_174813_aQ().func_186662_g(256.0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_94557_a}));
                if (list != null && !list.isEmpty() && !this.func_184207_aI()) {
                    for (int i1 = 0; i1 < list.size(); ++i1) {
                        EntityFriendlyCreature entity = (EntityFriendlyCreature)list.get(i1);
                        if (entity == null || !this.isOnSameTeam((EntityLivingBase)entity)) continue;
                        this.func_184185_a(SoundEvents.field_191263_gW, 1.0f, 1.0f);
                        entity.func_184204_a(1);
                    }
                }
                this.func_184185_a(SoundEvents.field_191263_gW, 1.0f, 1.0f);
                player.func_184204_a(1);
                return true;
            }
            player.field_70170_p.func_184133_a(player, new BlockPos((Entity)player), SoundEvents.field_187698_i, SoundCategory.PLAYERS, 100.0f, 0.5f);
            this.func_70606_j(0.0f);
            return true;
        }
        return false;
    }

    @Override
    public boolean func_70067_L() {
        return true;
    }

    public World func_82194_d() {
        return this.field_70170_p;
    }

    @Override
    public int getDamageCap() {
        return 100;
    }

    public boolean func_70965_a(EntityDragonPart portalPart, DamageSource source, float damage) {
        if (portalPart == this.side1 || portalPart == this.side2 || portalPart == this.side3 || portalPart == this.side4) {
            damage = 0.0f;
        }
        return super.func_70097_a(source, damage);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        return this.func_70965_a(this.portal, source, amount);
    }

    public Entity[] func_70021_al() {
        return this.partArray;
    }

    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    public void func_70108_f(Entity entity) {
        if (entity instanceof EntityLivingBase && !(entity instanceof IEntityMultiPart) && entity.field_70163_u + (double)entity.func_70047_e() <= this.field_70163_u + 1.0) {
            entity.func_70097_a(DamageSource.field_76368_d, 1.0f);
        }
    }

    @Override
    public void func_70653_a(Entity entityIn, float strength, double xRatio, double zRatio) {
    }
}

