/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.helpful;

import com.brandon3055.draconicevolution.entity.EntityGuardianCrystal;
import com.github.alexthe666.iceandfire.entity.EntityDragonEgg;
import com.github.alexthe666.iceandfire.entity.EntityGorgon;
import com.github.alexthe666.iceandfire.entity.IBlacklistedFromStatues;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.shinoow.abyssalcraft.api.AbyssalCraftAPI;
import com.shinoow.abyssalcraft.common.blocks.BlockAbyssPortal;
import com.shinoow.abyssalcraft.common.blocks.BlockDreadlandsPortal;
import com.shinoow.abyssalcraft.common.blocks.BlockOmotholPortal;
import com.shinoow.abyssalcraft.common.entity.EntityAbygolem;
import com.shinoow.abyssalcraft.common.entity.EntityRemnant;
import com.shinoow.abyssalcraft.lib.ACLib;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.AgeOfMinecraft.EngenderAchievments;
import net.minecraft.AgeOfMinecraft.EngenderExplosion;
import net.minecraft.AgeOfMinecraft.EngenderMod;
import net.minecraft.AgeOfMinecraft.ModSoundEvents;
import net.minecraft.AgeOfMinecraft.SpawnerItems;
import net.minecraft.AgeOfMinecraft.abyssalcraft.entity.EntityAbyssalZombie;
import net.minecraft.AgeOfMinecraft.abyssalcraft.entity.EntityChagaroth;
import net.minecraft.AgeOfMinecraft.abyssalcraft.entity.EntityCoraliumSquid;
import net.minecraft.AgeOfMinecraft.abyssalcraft.entity.EntityDepthsGhoul;
import net.minecraft.AgeOfMinecraft.abyssalcraft.entity.EntityDragonMinion;
import net.minecraft.AgeOfMinecraft.abyssalcraft.entity.EntityDreadling;
import net.minecraft.AgeOfMinecraft.blocks.BlockGuardBlock;
import net.minecraft.AgeOfMinecraft.items.ItemLearningBook;
import net.minecraft.block.Block;
import net.minecraft.block.BlockEndGateway;
import net.minecraft.block.BlockEndPortal;
import net.minecraft.block.BlockJukebox;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.INpc;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.boss.dragon.phase.PhaseDying;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.helpful.Animal;
import net.minecraft.entity.helpful.Armored;
import net.minecraft.entity.helpful.Elemental;
import net.minecraft.entity.helpful.Ender;
import net.minecraft.entity.helpful.EntityPortal;
import net.minecraft.entity.helpful.EntityPortalLightning;
import net.minecraft.entity.helpful.EnumTier;
import net.minecraft.entity.helpful.Flying;
import net.minecraft.entity.helpful.ITeamedMobs;
import net.minecraft.entity.helpful.Light;
import net.minecraft.entity.helpful.Massive;
import net.minecraft.entity.helpful.Structure;
import net.minecraft.entity.helpful.Tiny;
import net.minecraft.entity.helpful.Undead;
import net.minecraft.entity.helpful.ai.EntityAIAvoidEntitySPC;
import net.minecraft.entity.helpful.ai.EntityAIBabyMobGirlFollowParent;
import net.minecraft.entity.helpful.ai.EntityAIFindNearestUnalliedTarget;
import net.minecraft.entity.helpful.ai.EntityAIFollowWildAdult;
import net.minecraft.entity.helpful.ai.EntityAIFriendlyHurtByTarget;
import net.minecraft.entity.helpful.ai.EntityAILeaderHurtByTarget;
import net.minecraft.entity.helpful.ai.EntityAILeaderHurtTarget;
import net.minecraft.entity.helpful.ai.EntityAIMobGirlMate;
import net.minecraft.entity.helpful.tier1.EntityChicken;
import net.minecraft.entity.helpful.tier1.EntityCow;
import net.minecraft.entity.helpful.tier2.EntitySquid;
import net.minecraft.entity.helpful.tier2.EntityVillager;
import net.minecraft.entity.helpful.tier3.EntityCreeper;
import net.minecraft.entity.helpful.tier3.EntitySlime;
import net.minecraft.entity.helpful.tier3.EntitySpider;
import net.minecraft.entity.helpful.tier3.EntityVex;
import net.minecraft.entity.helpful.tier3.EntityZombie;
import net.minecraft.entity.helpful.tier4.EntityEnderman;
import net.minecraft.entity.helpful.tier4.EntityGhast;
import net.minecraft.entity.helpful.tier4.EntityGuardian;
import net.minecraft.entity.helpful.tier4.EntityPigZombie;
import net.minecraft.entity.helpful.tier4.EntityShulker;
import net.minecraft.entity.helpful.tier4.EntityVindicator;
import net.minecraft.entity.helpful.tier5.EntityEnderDragon;
import net.minecraft.entity.helpful.tier5.EntityEvoker;
import net.minecraft.entity.helpful.tier5.EntityIronGolem;
import net.minecraft.entity.helpful.tier5.EntityWither;
import net.minecraft.entity.helpful.tier6.EntityWitherStormHead;
import net.minecraft.entity.helpful.tier6.EntityWitherStormTentacle;
import net.minecraft.entity.helpful.tier6.EntityWitherStormTentacleDevourer;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityAmbientCreature;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.scoreboard.Team;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.util.CombatRules;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.Interface(iface="com.github.alexthe666.iceandfire.entity.IBlacklistedFromStatues", modid="iceandfire")
public abstract class EntityFriendlyCreature
extends EntityCreature
implements IEntityOwnable,
ITeamedMobs,
IBlacklistedFromStatues {
    private static final UUID BABY_SPEED_BOOST_ID = UUID.fromString("B9766B59-9566-4402-BC1F-2EE2A276D836");
    private static final AttributeModifier BABY_SPEED_BOOST = new AttributeModifier(BABY_SPEED_BOOST_ID, "Baby speed boost", 0.5, 1);
    private static final DataParameter<Boolean> ARMS_RAISED = EntityDataManager.func_187226_a(EntityFriendlyCreature.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_MARRIED = EntityDataManager.func_187226_a(EntityFriendlyCreature.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_CHILD = EntityDataManager.func_187226_a(EntityFriendlyCreature.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> HERO = EntityDataManager.func_187226_a(EntityFriendlyCreature.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> REBIRTH = EntityDataManager.func_187226_a(EntityFriendlyCreature.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> ANTIMOB = EntityDataManager.func_187226_a(EntityFriendlyCreature.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SITRESTING = EntityDataManager.func_187226_a(EntityFriendlyCreature.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Optional<UUID>> OWNER_UNIQUE_ID = EntityDataManager.func_187226_a(EntityFriendlyCreature.class, (DataSerializer)DataSerializers.field_187203_m);
    private static final UUID attackingSpeedBoostModifierUUID = UUID.fromString("B9766B59-9566-4402-BC1F-2EE2A276D838");
    private static final AttributeModifier attackingSpeedBoostModifier = new AttributeModifier(attackingSpeedBoostModifierUUID, "Attacking speed boost", 0.5, 1).func_111168_a(false);
    private static final UUID attackingBoostModifierUUID = UUID.fromString("B9766B59-9566-4402-BC1F-2EE2A276D839");
    private static final AttributeModifier attackingBoostModifier = new AttributeModifier(attackingBoostModifierUUID, "Attacking boost", 0.5, 1).func_111168_a(false);
    private static final DataParameter<Integer> HEROSPECIALATTACKTIMER = EntityDataManager.func_187226_a(EntityFriendlyCreature.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final IAttribute STRENGTH = new RangedAttribute((IAttribute)null, "engender.strength", 9.0, 1.0, 100.0).func_111117_a("Mob Strength").func_111112_a(true);
    public static final IAttribute STAMINA = new RangedAttribute((IAttribute)null, "engender.stamina", 9.0, 1.0, 100.0).func_111117_a("Mob Stamina").func_111112_a(true);
    public static final IAttribute INTELLIGENCE = new RangedAttribute((IAttribute)null, "engender.intelligence", 9.0, 1.0, 100.0).func_111117_a("Mob Intelligence").func_111112_a(true);
    public static final IAttribute DEXTERITY = new RangedAttribute((IAttribute)null, "engender.dexterity", 9.0, 1.0, 100.0).func_111117_a("Mob Dexterity").func_111112_a(true);
    public static final IAttribute AGILITY = new RangedAttribute((IAttribute)null, "engender.agility", 9.0, 1.0, 100.0).func_111117_a("Mob Agility").func_111112_a(true);
    public static final IAttribute FITTNESS = new RangedAttribute((IAttribute)null, "engender.fittness", 1.0, 0.75, 1.5).func_111117_a("Mob Fittness").func_111112_a(true);
    private static final DataParameter<Float> STRENGTH_FLOAT = EntityDataManager.func_187226_a(EntityFriendlyCreature.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> STAMINA_FLOAT = EntityDataManager.func_187226_a(EntityFriendlyCreature.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> INTELLIGENCE_FLOAT = EntityDataManager.func_187226_a(EntityFriendlyCreature.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> DEXTERITY_FLOAT = EntityDataManager.func_187226_a(EntityFriendlyCreature.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> AGILITY_FLOAT = EntityDataManager.func_187226_a(EntityFriendlyCreature.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> FITTNESS_FLOAT = EntityDataManager.func_187226_a(EntityFriendlyCreature.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> AGE = EntityDataManager.func_187226_a(EntityFriendlyCreature.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> LEVEL = EntityDataManager.func_187226_a(EntityFriendlyCreature.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> EXP = EntityDataManager.func_187226_a(EntityFriendlyCreature.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> TOTALEXP = EntityDataManager.func_187226_a(EntityFriendlyCreature.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> ENERGY = EntityDataManager.func_187226_a(EntityFriendlyCreature.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Optional<BlockPos>> GUARD_BLOCK_POS = EntityDataManager.func_187226_a(EntityFriendlyCreature.class, (DataSerializer)DataSerializers.field_187201_k);
    private static final DataParameter<Integer> BOOK_ID = EntityDataManager.func_187226_a(EntityFriendlyCreature.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> BOOK_DURABILITY = EntityDataManager.func_187226_a(EntityFriendlyCreature.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> FAKE_HEALTH = EntityDataManager.func_187226_a(EntityFriendlyCreature.class, (DataSerializer)DataSerializers.field_187193_c);
    public boolean isOffensive;
    public double randPosX;
    public double randPosY;
    public double randPosZ;
    public double prevChasingPosX;
    public double prevChasingPosY;
    public double prevChasingPosZ;
    public double chasingPosX;
    public double chasingPosY;
    public double chasingPosZ;
    public BlockPos jukeBoxToDanceTo;
    public int moralRaisedTimer;
    public int convertionInt;
    protected Block spawnableBlock = Blocks.field_150349_c;
    protected int inLove;
    public float reachWidth;
    public int attackTimer;
    public int holdRoseTick;
    public int lastChanceInvul;
    public float pageFlip;
    public float pageFlipPrev;
    public float bookSpread;
    public float bookSpreadPrev;
    public float flipT;
    public float flipA;
    public int deathTicks;
    protected int blockTimer;
    protected int exptobeadded;
    public float rotationPitchFalling;
    public float prevRotationPitchFalling;
    protected BossInfoServer bossInfo = new BossInfoServer((ITextComponent)new TextComponentTranslation(this.func_70005_c_(), new Object[0]), BossInfo.Color.WHITE, BossInfo.Overlay.PROGRESS);
    private EnumStudy currentStudy = EnumStudy.Physical;
    private ItemStack currentReadingBook = ItemStack.field_190927_a;
    public static final Item[] books = new Item[]{null, SpawnerItems.learningBook101, SpawnerItems.learningBookForDummies, SpawnerItems.learningBookTraining, SpawnerItems.learningBookCombat, SpawnerItems.learningBookJodging, SpawnerItems.learningBookAthletics, SpawnerItems.learningBookAdvancedCombat};
    EntityAINearestAttackableTarget trainingAI = new EntityAINearestAttackableTarget((EntityCreature)this, EntityFriendlyCreature.class, 0, false, false, (Predicate)new Predicate<Entity>(){

        public boolean apply(@Nullable Entity p_apply_1_) {
            return p_apply_1_ != null && p_apply_1_ instanceof EntityFriendlyCreature && EntityFriendlyCreature.this.isOnSameTeam((EntityLivingBase)((EntityFriendlyCreature)p_apply_1_)) && (EntityFriendlyCreature)p_apply_1_ != EntityFriendlyCreature.this && ((EntityFriendlyCreature)p_apply_1_).getFakeHealth() > 0.0f && EntityFriendlyCreature.this.getFakeHealth() > 0.0f;
        }
    });
    public InventoryBasic basicInventory;
    private final EntityAIBreakDoor breakDoor = new EntityAIBreakDoor((EntityLiving)this);
    private final EntityAIOpenDoor openDoor = new EntityAIOpenDoor((EntityLiving)this, true);

    public EntityFriendlyCreature(World worldIn) {
        super(worldIn);
        this.basicInventory = new InventoryBasic("Basic inventory", false, 8);
        this.lastChanceInvul = this.getSpawnTimer();
        this.updateBossBar();
        this.chasingPosX = this.field_70165_t;
        this.chasingPosY = this.field_70163_u + (double)this.func_70047_e();
        this.chasingPosZ = this.field_70161_v;
        this.func_70656_aK();
        this.setDoorAItask(this.getIntelligence() < 12.0f);
        this.field_70177_z = this.field_70759_as = this.field_70146_Z.nextFloat() * 360.0f;
        this.field_70761_aq = this.field_70759_as;
        this.field_70122_E = true;
        for (int i = 0; i < this.field_184655_bs.length; ++i) {
            this.field_184655_bs[i] = 0.0f;
        }
        for (int j = 0; j < this.field_82174_bp.length; ++j) {
            this.field_82174_bp[j] = 0.0f;
        }
        this.field_70728_aV = 10;
        this.field_70714_bg.func_75776_a(0, new EntityAIAvoidEntitySPC<EntityLivingBase>(this, EntityLivingBase.class, new Predicate<EntityLivingBase>(){

            public boolean apply(EntityLivingBase p_apply_1_) {
                return p_apply_1_ != null && (EntityFriendlyCreature.this.shouldFleeAtLowHealth() && !EntityFriendlyCreature.this.isOnSameTeam(p_apply_1_) && p_apply_1_.func_70089_S() && EntityFriendlyCreature.this.getIntelligence() > 4.0f || EntityFriendlyCreature.this.func_70631_g_() && EngenderMod.useMobTalkerModels && !EntityFriendlyCreature.this.isOnSameTeam(p_apply_1_) || p_apply_1_ instanceof EntityLiving && p_apply_1_.func_110143_aJ() <= 0.0f && p_apply_1_.field_70725_aQ <= 0 && !(p_apply_1_ instanceof EntityFriendlyCreature) || p_apply_1_ instanceof net.minecraft.entity.boss.EntityWither && ((net.minecraft.entity.boss.EntityWither)p_apply_1_).func_82212_n() > 0);
            }
        }, 16.0f, 1.25, 1.25));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIMobGirlMate(this, 1.2));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIFollowWildAdult(this, 1.25));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIBabyMobGirlFollowParent(this, 1.25));
        this.field_70714_bg.func_75776_a(13, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLivingBase.class, 8.0f){

            public boolean func_75250_a() {
                if (!EntityFriendlyCreature.this.getCurrentBook().func_190926_b() || EntityFriendlyCreature.this instanceof EntityWitherStormHead) {
                    return false;
                }
                return super.func_75250_a();
            }
        });
        this.field_70714_bg.func_75776_a(12, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.5));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIFriendlyHurtByTarget(this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAILeaderHurtByTarget(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAILeaderHurtTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIFindNearestUnalliedTarget(this, EntityLivingBase.class));
        this.func_174805_g(true);
        if (this.getBookID() != 0) {
            this.setCurrentBook(new ItemStack(books[this.getBookID()], 1, this.getBookDurability()));
        }
    }

    public void setCurrentBook(ItemStack stack) {
        this.currentReadingBook = stack;
    }

    public ItemStack getCurrentBook() {
        return this.getBookID() != 0 ? this.currentReadingBook : ItemStack.field_190927_a;
    }

    protected boolean func_70610_aX() {
        return this.func_110143_aJ() <= 0.0f || !this.func_184582_a(EntityEquipmentSlot.MAINHAND).func_190926_b() && this.func_184582_a(EntityEquipmentSlot.MAINHAND).func_77973_b() instanceof ItemLearningBook;
    }

    public int getHoldRoseTick() {
        return this.holdRoseTick;
    }

    public int getAttackTimer() {
        return this.attackTimer;
    }

    public boolean shouldFleeAtLowHealth() {
        return this.func_110143_aJ() <= 4.0f && this.func_110143_aJ() < this.func_110138_aP();
    }

    public static EngenderExplosion createEngenderModExplosion(@Nullable Entity entityIn, double x, double y, double z, float strength, boolean isFlaming, boolean isSmoking) {
        EngenderExplosion explosion = new EngenderExplosion(entityIn.field_70170_p, entityIn, x, y, z, strength, isFlaming, isSmoking);
        if (ForgeEventFactory.onExplosionStart((World)entityIn.field_70170_p, (Explosion)explosion)) {
            return explosion;
        }
        explosion.func_77278_a();
        explosion.func_77279_a(true);
        return explosion;
    }

    public static EngenderExplosion createEngenderModExplosionFireless(@Nullable Entity entityIn, double x, double y, double z, float strength, boolean isSmoking) {
        return EntityFriendlyCreature.createEngenderModExplosion(entityIn, x, y, z, strength, false, isSmoking);
    }

    public void setArmsRaised(boolean armsRaised) {
        this.func_184212_Q().func_187227_b(ARMS_RAISED, (Object)armsRaised);
    }

    public boolean isArmsRaised() {
        return (Boolean)this.func_184212_Q().func_187225_a(ARMS_RAISED);
    }

    public int timesToConvert() {
        switch (this.getTier()) {
            case TIER2: {
                return 5;
            }
            case TIER3: {
                return 11;
            }
            case TIER4: {
                return 23;
            }
            case TIER5: {
                return 79;
            }
            case TIER6: {
                return Integer.MAX_VALUE;
            }
        }
        return 3;
    }

    public final float getStrength() {
        return ((Float)this.field_70180_af.func_187225_a(STRENGTH_FLOAT)).floatValue();
    }

    public void setStrength(float health) {
        if (!this.field_70170_p.field_72995_K) {
            if (health <= 1.0f) {
                health = 1.0f;
            }
            if (health >= 100.0f) {
                health = 100.0f;
            }
            this.func_110148_a(STRENGTH).func_111128_a((double)health);
            this.field_70180_af.func_187227_b(STRENGTH_FLOAT, (Object)Float.valueOf(health));
        }
    }

    public final float getStamina() {
        return ((Float)this.field_70180_af.func_187225_a(STAMINA_FLOAT)).floatValue();
    }

    public void setStamina(float health) {
        if (!this.field_70170_p.field_72995_K) {
            if (health <= 1.0f) {
                health = 1.0f;
            }
            if (health >= 100.0f) {
                health = 100.0f;
            }
            this.func_110148_a(STAMINA).func_111128_a((double)health);
            this.field_70180_af.func_187227_b(STAMINA_FLOAT, (Object)Float.valueOf(health));
        }
    }

    public final float getIntelligence() {
        return ((Float)this.field_70180_af.func_187225_a(INTELLIGENCE_FLOAT)).floatValue();
    }

    public void setIntelligence(float health) {
        if (!this.field_70170_p.field_72995_K) {
            if (health <= 1.0f) {
                health = 1.0f;
            }
            if (health >= 100.0f) {
                health = 100.0f;
            }
            this.func_110148_a(INTELLIGENCE).func_111128_a((double)health);
            this.field_70180_af.func_187227_b(INTELLIGENCE_FLOAT, (Object)Float.valueOf(health));
        }
    }

    public final float getDexterity() {
        return ((Float)this.field_70180_af.func_187225_a(DEXTERITY_FLOAT)).floatValue();
    }

    public void setDexterity(float health) {
        if (!this.field_70170_p.field_72995_K) {
            if (health <= 1.0f) {
                health = 1.0f;
            }
            if (health >= 100.0f) {
                health = 100.0f;
            }
            this.func_110148_a(DEXTERITY).func_111128_a((double)health);
            this.field_70180_af.func_187227_b(DEXTERITY_FLOAT, (Object)Float.valueOf(health));
        }
    }

    public final float getAgility() {
        return ((Float)this.field_70180_af.func_187225_a(AGILITY_FLOAT)).floatValue();
    }

    public void setAgility(float health) {
        if (!this.field_70170_p.field_72995_K) {
            if (health <= 1.0f) {
                health = 1.0f;
            }
            if (health >= 100.0f) {
                health = 100.0f;
            }
            this.func_110148_a(AGILITY).func_111128_a((double)health);
            this.field_70180_af.func_187227_b(AGILITY_FLOAT, (Object)Float.valueOf(health));
        }
    }

    public final float getFittness() {
        return ((Float)this.field_70180_af.func_187225_a(FITTNESS_FLOAT)).floatValue();
    }

    public void setFittness(float health) {
        if (!this.field_70170_p.field_72995_K) {
            if (health <= 0.75f) {
                health = 0.75f;
            }
            if (health >= 1.5f) {
                health = 1.5f;
            }
            this.func_110148_a(FITTNESS).func_111128_a((double)health);
            this.field_70180_af.func_187227_b(FITTNESS_FLOAT, (Object)Float.valueOf(health));
        }
    }

    public final float getStrengthStat() {
        return (float)this.func_110148_a(STRENGTH).func_111126_e();
    }

    public final float getStaminaStat() {
        return (float)this.func_110148_a(STAMINA).func_111126_e();
    }

    public final float getIntelligenceStat() {
        return (float)this.func_110148_a(INTELLIGENCE).func_111126_e();
    }

    public final float getDexterityStat() {
        return (float)this.func_110148_a(DEXTERITY).func_111126_e();
    }

    public final float getAgilityStat() {
        return (float)this.func_110148_a(AGILITY).func_111126_e();
    }

    public final float getFittnessStat() {
        return (float)this.func_110148_a(FITTNESS).func_111126_e();
    }

    public float getDefaultStrengthStat() {
        return 8.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    public float getDefaultStaminaStat() {
        return 8.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    public float getDefaultIntelligenceStat() {
        return 8.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    public float getDefaultDexterityStat() {
        return 8.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    public float getDefaultAgilityStat() {
        return 8.0f + this.field_70146_Z.nextFloat() * 4.0f;
    }

    public float getDefaultFittnessStat() {
        return 0.9f + this.field_70146_Z.nextFloat() * 0.2f;
    }

    public final float getEnergy() {
        return ((Float)this.field_70180_af.func_187225_a(ENERGY)).floatValue();
    }

    public void setEnergy(float health) {
        this.field_70180_af.func_187227_b(ENERGY, (Object)Float.valueOf(health));
    }

    public EnumStudy getCurrentStudy() {
        return this.currentStudy;
    }

    public void setCurrentStudy(EnumStudy study, int exp) {
        if (!this.field_70170_p.field_72995_K) {
            this.currentStudy = study;
            this.exptobeadded += exp;
            if (this.isHero()) {
                this.exptobeadded += exp;
            }
            if (this.func_70631_g_()) {
                this.exptobeadded += exp;
            }
            if (study == EnumStudy.Mental && this instanceof EntityWither) {
                this.exptobeadded += exp;
                this.exptobeadded += exp;
            }
            this.func_184185_a(SoundEvents.field_187604_bf, 0.1f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.35f + 0.9f);
        }
    }

    public final float getFakeHealth() {
        return ((Float)this.field_70180_af.func_187225_a(FAKE_HEALTH)).floatValue();
    }

    public void setFakeHealth(float health) {
        this.field_70180_af.func_187227_b(FAKE_HEALTH, (Object)Float.valueOf(MathHelper.func_76131_a((float)health, (float)0.0f, (float)(this.func_110138_aP() * 2.0f))));
    }

    protected void func_70664_aZ() {
        if (this.getEnergy() > 5.0f) {
            super.func_70664_aZ();
        }
        this.setEnergy(this.getEnergy() - 0.05f);
    }

    public void levelUp() {
        this.setEXP(0.0f);
        this.func_70656_aK();
        this.func_70674_bp();
        this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 200));
        switch (this.getTier()) {
            case TIER2: {
                this.func_70691_i(2.0f);
            }
            case TIER3: {
                this.func_70691_i(4.0f);
            }
            case TIER4: {
                this.func_70691_i(8.0f);
            }
            case TIER5: {
                this.func_70691_i(16.0f);
            }
            case TIER6: {
                this.func_70691_i(32.0f);
            }
        }
        this.func_70691_i(1.0f);
        this.setEnergy(100.0f);
        if (this.getLevel() > 300) {
            if (!this.field_70170_p.field_72995_K && !this.isWild()) {
                this.getOwner().func_145747_a((ITextComponent)new TextComponentTranslation(this.func_70005_c_() + " has reached Max Level 300!", new Object[0]));
            }
            this.func_184185_a(SoundEvents.field_187802_ec, 0.5f, 0.75f);
            this.setLevel(300);
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v, 10 + this.field_70146_Z.nextInt(40)));
            }
        } else {
            if (!this.field_70170_p.field_72995_K && !this.isWild()) {
                this.getOwner().func_145747_a((ITextComponent)new TextComponentTranslation(this.func_70005_c_() + " has gone to Level " + (this.getLevel() + 1) + " and became " + (this.getCurrentStudy() == EnumStudy.Combative ? "stronger." : (this.getCurrentStudy() == EnumStudy.Mental ? "smarter." : "more durable.")), new Object[0]));
            }
            this.func_184185_a(SoundEvents.field_187802_ec, 0.5f, 1.0f);
            this.setLevel(this.getLevel() + 1);
            this.setFittness(this.getFittnessStat() + 0.005f);
            switch (this.getCurrentStudy()) {
                case Mental: {
                    this.setDexterity(this.getDexterityStat() + 1.0f);
                    this.setIntelligence(this.getIntelligenceStat() + 1.0f);
                    break;
                }
                case Combative: {
                    this.setStamina(this.getStaminaStat() + 1.0f);
                    this.setDexterity(this.getDexterityStat() + 1.0f);
                    this.setStrength(this.getStrengthStat() + 1.0f);
                    break;
                }
                case Physical: {
                    this.setStamina(this.getStaminaStat() + 1.0f);
                    this.setAgility(this.getAgilityStat() + 1.0f);
                    this.setStrength(this.getStrengthStat() + 1.0f);
                }
            }
        }
    }

    public void func_174812_G() {
        this.func_184185_a(this.func_184615_bR(), this.func_70599_aP(), this.func_70647_i());
        this.func_70106_y();
    }

    protected void func_70675_k(float damage) {
        if ((damage /= 4.0f) < 1.0f) {
            damage = 1.0f;
        }
        if (!this.field_70170_p.field_72995_K) {
            for (EntityEquipmentSlot entityequipmentslot : EntityEquipmentSlot.values()) {
                ItemStack itemstack = this.func_184582_a(entityequipmentslot);
                if (itemstack.func_190926_b() || entityequipmentslot == EntityEquipmentSlot.MAINHAND || entityequipmentslot == EntityEquipmentSlot.OFFHAND || !(itemstack.func_77973_b() instanceof ItemArmor)) continue;
                this.setCurrentStudy(EnumStudy.Combative, (int)damage);
                itemstack.func_77972_a((int)damage, (EntityLivingBase)this);
            }
        }
    }

    protected void func_184590_k(float damage) {
        if (!this.field_70170_p.field_72995_K && damage >= 3.0f && this.field_184627_bm.func_77973_b() == Items.field_185159_cQ) {
            this.setCurrentStudy(EnumStudy.Combative, (int)damage);
            this.blockTimer = 40;
            int i = 1 + MathHelper.func_76141_d((float)damage);
            this.field_184627_bm.func_77972_a(i, (EntityLivingBase)this);
            this.func_184185_a(SoundEvents.field_187767_eL, 1.0f, 1.0f);
            if (this.field_184627_bm.func_190926_b()) {
                EnumHand enumhand = this.func_184600_cs();
                if (enumhand == EnumHand.MAIN_HAND) {
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
                } else {
                    this.func_184201_a(EntityEquipmentSlot.OFFHAND, ItemStack.field_190927_a);
                }
                this.field_184627_bm = ItemStack.field_190927_a;
                this.func_184185_a(SoundEvents.field_187769_eM, 0.8f, 0.8f + this.field_70170_p.field_73012_v.nextFloat() * 0.4f);
            }
        }
    }

    public boolean func_184585_cz() {
        return this.func_70638_az() != null && this.blockTimer <= 0 && this.func_184592_cb() != null && !this.func_184587_cr() && this.func_184592_cb().func_77973_b().func_77661_b(this.func_184592_cb()) == EnumAction.BLOCK && this.func_70068_e((Entity)this.func_70638_az()) < 25.0;
    }

    protected boolean func_146066_aG() {
        return this.isOffensive || !this.func_70631_g_();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(ARMS_RAISED, (Object)false);
        this.func_184212_Q().func_187214_a(IS_CHILD, (Object)false);
        this.func_184212_Q().func_187214_a(IS_MARRIED, (Object)false);
        this.func_184212_Q().func_187214_a(OWNER_UNIQUE_ID, (Object)Optional.absent());
        this.func_184212_Q().func_187214_a(HERO, (Object)false);
        this.func_184212_Q().func_187214_a(REBIRTH, (Object)false);
        this.func_184212_Q().func_187214_a(ANTIMOB, (Object)false);
        this.func_184212_Q().func_187214_a(SITRESTING, (Object)false);
        this.func_184212_Q().func_187214_a(HEROSPECIALATTACKTIMER, (Object)0);
        this.func_184212_Q().func_187214_a(STRENGTH_FLOAT, (Object)Float.valueOf(1.0f));
        this.func_184212_Q().func_187214_a(STAMINA_FLOAT, (Object)Float.valueOf(1.0f));
        this.func_184212_Q().func_187214_a(INTELLIGENCE_FLOAT, (Object)Float.valueOf(1.0f));
        this.func_184212_Q().func_187214_a(DEXTERITY_FLOAT, (Object)Float.valueOf(1.0f));
        this.func_184212_Q().func_187214_a(AGILITY_FLOAT, (Object)Float.valueOf(1.0f));
        this.func_184212_Q().func_187214_a(FITTNESS_FLOAT, (Object)Float.valueOf(1.0f));
        this.func_184212_Q().func_187214_a(AGE, (Object)0);
        this.func_184212_Q().func_187214_a(LEVEL, (Object)0);
        this.func_184212_Q().func_187214_a(EXP, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(TOTALEXP, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(ENERGY, (Object)Float.valueOf(100.0f));
        this.func_184212_Q().func_187214_a(FAKE_HEALTH, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(GUARD_BLOCK_POS, (Object)Optional.absent());
        this.func_184212_Q().func_187214_a(BOOK_ID, (Object)0);
        this.func_184212_Q().func_187214_a(BOOK_DURABILITY, (Object)0);
    }

    public int getBookID() {
        return (Integer)this.field_70180_af.func_187225_a(BOOK_ID);
    }

    public void setBookID(int age) {
        this.field_70180_af.func_187227_b(BOOK_ID, (Object)age);
    }

    public int getBookDurability() {
        return (Integer)this.field_70180_af.func_187225_a(BOOK_DURABILITY);
    }

    public void setBookDurability(int age) {
        this.field_70180_af.func_187227_b(BOOK_DURABILITY, (Object)age);
    }

    public boolean canBeMarried() {
        return EngenderMod.useMobTalkerModels && !this.func_70631_g_() && this.getTier() != EnumTier.TIER6 && this.func_70089_S() && this.func_184188_bt().isEmpty() && this.func_184187_bx() == null;
    }

    public boolean isMarried() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_MARRIED);
    }

    public void setMarried(boolean childZombie) {
        this.func_184212_Q().func_187227_b(IS_MARRIED, (Object)childZombie);
    }

    public boolean func_70631_g_() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_CHILD);
    }

    public void setChild(boolean childZombie) {
        this.func_184212_Q().func_187227_b(IS_CHILD, (Object)childZombie);
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
            iattributeinstance.func_111124_b(BABY_SPEED_BOOST);
            if (childZombie) {
                iattributeinstance.func_111121_a(BABY_SPEED_BOOST);
            }
        }
        this.func_70105_a(this.field_70130_N, this.field_70131_O);
    }

    protected int func_70693_a(EntityPlayer player) {
        int xp = super.func_70693_a(player);
        if (this.func_70631_g_()) {
            xp = (int)((float)xp * 2.5f);
        }
        xp = (int)((float)xp + this.getStrength() / 10.0f);
        xp = (int)((float)xp + this.getStamina() / 10.0f);
        xp = (int)((float)xp + this.getAgility() / 10.0f);
        xp = (int)((float)xp + this.getIntelligence() / 10.0f);
        xp = (int)((float)xp + this.getDexterity() / 10.0f);
        xp = (int)((float)xp * this.getFittness());
        return xp;
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        this.func_184641_n(this.field_70146_Z.nextFloat() < 0.1f);
        this.setGrowingAge(this.field_70170_p.field_73012_v.nextFloat() <= 0.05f ? -20000 : 4000);
        this.setEnergy(100.0f);
        this.setLevel(1);
        this.setStrength(this.getDefaultStrengthStat());
        this.setStamina(this.getDefaultStaminaStat());
        this.setIntelligence(this.getDefaultIntelligenceStat());
        this.setDexterity(this.getDefaultDexterityStat());
        this.setAgility(this.getDefaultAgilityStat());
        this.setFittness(this.getDefaultFittnessStat());
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111121_a(new AttributeModifier("Random spawn bonus", this.field_70146_Z.nextGaussian() * 0.05, 1));
        return livingdata;
    }

    public void createChild() {
        this.func_184185_a(ModSoundEvents.girlMoan, 1.0f, this.func_70647_i());
        for (int i = 0; i < 10; ++i) {
            this.spawnHeartParticle();
        }
    }

    public void func_184185_a(SoundEvent soundIn, float volume, float pitch) {
        if (soundIn != null) {
            super.func_184185_a(soundIn, volume, pitch);
        }
    }

    public float getBonusVSLight() {
        return 1.0f;
    }

    public float getBonusVSArmored() {
        return 1.0f;
    }

    public float getBonusVSFlying() {
        return 1.0f;
    }

    public float getBonusVSMassive() {
        return 1.0f;
    }

    public float getBonusVSTiny() {
        return 1.0f;
    }

    public float getBonusVSStructure() {
        return 1.0f;
    }

    public float getBonusVSElemental() {
        return 1.0f;
    }

    public float getBonusVSUndead() {
        return 1.0f;
    }

    public float getBonusVSEnder() {
        return 1.0f;
    }

    public float getBonusVSAnimal() {
        return 1.0f;
    }

    public boolean canBeMatedWith() {
        return EngenderMod.useMobTalkerModels && this.field_70131_O >= 1.365f && !this.func_70631_g_() && this.getGrowingAge() > 0;
    }

    public boolean func_82171_bF() {
        return this.func_184179_bs() instanceof EntityLivingBase;
    }

    public void incrementConversion(EntityPlayer player) {
        if (this.isWild()) {
            if (this.convertionInt >= this.timesToConvert()) {
                this.field_70170_p.func_175682_a(EnumParticleTypes.EXPLOSION_HUGE, true, this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
                this.setOwnerId(player.func_110124_au());
                this.field_70173_aa = 0;
                this.func_184185_a(ModSoundEvents.converted, 3.0f, 1.0f);
                this.func_184185_a(ModSoundEvents.converted, 3.0f, 1.0f);
                this.func_184185_a(ModSoundEvents.converted, 3.0f, 1.0f);
                this.func_184185_a(ModSoundEvents.converted, 3.0f, 1.0f);
                this.func_184185_a(ModSoundEvents.converted, 3.0f, 1.0f);
                this.func_184185_a(ModSoundEvents.converted, 3.0f, 1.0f);
                this.func_184185_a(ModSoundEvents.converted, 3.0f, 1.0f);
                this.func_184185_a(ModSoundEvents.converted, 3.0f, 1.0f);
                player.func_71029_a((StatBase)EngenderAchievments.conversion);
                if (!this.isWild() && !this.field_70170_p.field_72995_K) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation(this.func_70005_c_() + " has been converted by " + player.func_70005_c_() + " (" + this.field_70165_t + ", " + this.field_70163_u + ", " + this.field_70161_v + ", )", new Object[0]));
                }
            } else {
                ++this.convertionInt;
                this.func_184185_a(ModSoundEvents.converting, 3.0f, 1.0f);
            }
        } else {
            this.field_70715_bh.func_85156_a((EntityAIBase)this.trainingAI);
            if (this.getFakeHealth() > 0.0f) {
                this.field_70715_bh.func_75776_a(3, (EntityAIBase)this.trainingAI);
            }
        }
    }

    @Override
    public EnumTier getTier() {
        return EnumTier.TIER1;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b();
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return this.field_70158_ak ? true : distance < (d0 *= this.func_70093_af() ? 32.0 : 512.0) * d0;
    }

    public boolean shouldAttackEntity(EntityLivingBase p_142018_1_, EntityLivingBase p_142018_2_) {
        return !this.isOnSameTeam(p_142018_1_);
    }

    protected boolean func_70692_ba() {
        return this.isWild();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_188790_f);
        this.func_110140_aT().func_111150_b(FITTNESS);
        this.func_110140_aT().func_111150_b(STRENGTH);
        this.func_110140_aT().func_111150_b(STAMINA);
        this.func_110140_aT().func_111150_b(INTELLIGENCE);
        this.func_110140_aT().func_111150_b(DEXTERITY);
        this.func_110140_aT().func_111150_b(AGILITY);
    }

    public boolean func_70601_bi() {
        if (this.field_70170_p.func_82736_K().func_82766_b("disableNaturalEngenderMobSpawning")) {
            return false;
        }
        return (this.field_70170_p.func_72912_H().func_76067_t() == WorldType.field_77138_c ? this.field_70146_Z.nextInt(this.getSpawnChanceReduction() * 5) == 0 : this.field_70146_Z.nextInt(this.getSpawnChanceReduction()) == 0) && super.func_70601_bi();
    }

    public float func_180484_a(BlockPos pos) {
        return 0.0f;
    }

    public int getSpawnChanceReduction() {
        switch (this.getTier()) {
            case TIER2: {
                return 100;
            }
            case TIER3: {
                return 200;
            }
            case TIER4: {
                return 400;
            }
            case TIER5: {
                return 800;
            }
        }
        return 50;
    }

    public int getDoorBreakingThreashHold() {
        return 32;
    }

    public int getInstaDoorBreakingThreashHold() {
        return 64;
    }

    public int getIronDoorBreakingThreashHold() {
        return 96;
    }

    public boolean teleportTo_(double x, double y, double z) {
        double d0 = this.field_70165_t;
        double d1 = this.field_70163_u;
        double d2 = this.field_70161_v;
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        boolean flag = false;
        BlockPos blockpos = new BlockPos((Entity)this);
        World world = this.field_70170_p;
        Random random = this.func_70681_au();
        if (world.func_175667_e(blockpos)) {
            boolean flag1 = false;
            while (!flag1 && blockpos.func_177956_o() > 0) {
                BlockPos blockpos1 = blockpos.func_177977_b();
                IBlockState iblockstate = world.func_180495_p(blockpos1);
                if (iblockstate.func_185904_a().func_76230_c()) {
                    flag1 = true;
                    continue;
                }
                this.field_70163_u -= 1.0;
                blockpos = blockpos1;
            }
            if (flag1) {
                this.func_70634_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                if (world.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && !world.func_72953_d(this.func_174813_aQ())) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            this.func_70634_a(d0, d1, d2);
            return false;
        }
        this.func_70661_as().func_75499_g();
        return true;
    }

    protected boolean isValidLightLevel() {
        return true;
    }

    public boolean func_145773_az() {
        return this.getDexterity() > 8.0f;
    }

    public int getSpecialAttackTimer() {
        return (Integer)this.field_70180_af.func_187225_a(HEROSPECIALATTACKTIMER);
    }

    public void setSpecialAttackTimer(int p_82215_1_) {
        this.field_70180_af.func_187227_b(HEROSPECIALATTACKTIMER, (Object)p_82215_1_);
    }

    public void performSpecialAttack() {
    }

    public void setDoorAItask(boolean enabled) {
        ((PathNavigateGround)this.func_70661_as()).func_179688_b(enabled);
        ((PathNavigateGround)this.func_70661_as()).func_179691_c(!enabled);
        if (enabled) {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.openDoor);
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.breakDoor);
        } else {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.breakDoor);
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.openDoor);
        }
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        if (tagCompund.func_150297_b("FakeHealth", 99)) {
            this.setFakeHealth(tagCompund.func_74760_g("FakeHealth"));
        }
        if (tagCompund.func_150297_b("CurrentBook", 9)) {
            NBTTagList nbttaglist1 = tagCompund.func_150295_c("CurrentBook", 10);
            this.setCurrentBook(new ItemStack(nbttaglist1.func_150305_b(0)));
        }
        if (tagCompund.func_150297_b("STR", 99)) {
            this.setStrength(tagCompund.func_74760_g("STR"));
        }
        if (tagCompund.func_150297_b("STA", 99)) {
            this.setStamina(tagCompund.func_74760_g("STA"));
        }
        if (tagCompund.func_150297_b("INT", 99)) {
            this.setIntelligence(tagCompund.func_74760_g("INT"));
        }
        if (tagCompund.func_150297_b("DEX", 99)) {
            this.setDexterity(tagCompund.func_74760_g("DEX"));
        }
        if (tagCompund.func_150297_b("AGI", 99)) {
            this.setAgility(tagCompund.func_74760_g("AGI"));
        }
        if (tagCompund.func_150297_b("FIT", 99)) {
            this.setFittness(tagCompund.func_74760_g("FIT"));
        }
        String s = "";
        this.setMarried(tagCompund.func_74767_n("IsMarried"));
        this.setChild(tagCompund.func_74767_n("IsBaby"));
        s = tagCompund.func_150297_b("OwnerUUID", 8) ? tagCompund.func_74779_i("OwnerUUID") : PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)tagCompund.func_74779_i("Owner"));
        if (s.length() > 0) {
            this.setOwnerId(UUID.fromString(s));
        }
        this.field_70180_af.func_187227_b(REBIRTH, (Object)tagCompund.func_74767_n("LastChance"));
        this.field_70180_af.func_187227_b(HERO, (Object)tagCompund.func_74767_n("Hero"));
        this.field_70180_af.func_187227_b(ANTIMOB, (Object)tagCompund.func_74767_n("Anti"));
        this.field_70180_af.func_187227_b(SITRESTING, (Object)tagCompund.func_74767_n("SitResting"));
        this.setSpecialAttackTimer(tagCompund.func_74762_e("SAT"));
        this.inLove = tagCompund.func_74762_e("InLove");
        this.setGrowingAge(tagCompund.func_74762_e("Age"));
        this.setLevel(tagCompund.func_74762_e("Level"));
        this.setEXP(tagCompund.func_74760_g("EXP"));
        this.setTotalEXP(tagCompund.func_74760_g("TotalEXP"));
        this.setBookID(tagCompund.func_74762_e("BookID"));
        this.setBookDurability(tagCompund.func_74762_e("BookDurability"));
        if (tagCompund.func_150297_b("Energy", 99)) {
            this.setEnergy(tagCompund.func_74760_g("Energy"));
        }
        this.setDoorAItask(this.getIntelligence() < 12.0f);
        if (tagCompund.func_74764_b("GPX")) {
            int i = tagCompund.func_74762_e("GPX");
            int j = tagCompund.func_74762_e("GPY");
            int k = tagCompund.func_74762_e("GPZ");
            this.field_70180_af.func_187227_b(GUARD_BLOCK_POS, (Object)Optional.of((Object)new BlockPos(i, j, k)));
            this.randPosX = i;
            this.randPosY = j;
            this.randPosZ = k;
        } else {
            this.field_70180_af.func_187227_b(GUARD_BLOCK_POS, (Object)Optional.absent());
        }
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        NBTTagList nbttaglist = new NBTTagList();
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        if (!this.getCurrentBook().func_190926_b()) {
            this.getCurrentBook().func_77955_b(nbttagcompound);
        }
        nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        tagCompound.func_74782_a("CurrentBook", (NBTBase)nbttaglist);
        tagCompound.func_74776_a("FakeHealth", this.getFakeHealth());
        tagCompound.func_74776_a("STR", this.getStrength());
        tagCompound.func_74776_a("STA", this.getStamina());
        tagCompound.func_74776_a("INT", this.getIntelligence());
        tagCompound.func_74776_a("DEX", this.getDexterity());
        tagCompound.func_74776_a("AGI", this.getAgility());
        tagCompound.func_74776_a("FIT", this.getFittness());
        if (this.func_184753_b() == null) {
            tagCompound.func_74778_a("OwnerUUID", "");
        } else {
            tagCompound.func_74778_a("OwnerUUID", this.func_184753_b().toString());
        }
        tagCompound.func_74757_a("IsBaby", ((Boolean)this.field_70180_af.func_187225_a(IS_CHILD)).booleanValue());
        tagCompound.func_74757_a("Hero", ((Boolean)this.field_70180_af.func_187225_a(HERO)).booleanValue());
        tagCompound.func_74757_a("LastChance", ((Boolean)this.field_70180_af.func_187225_a(REBIRTH)).booleanValue());
        tagCompound.func_74757_a("Anti", ((Boolean)this.field_70180_af.func_187225_a(ANTIMOB)).booleanValue());
        tagCompound.func_74757_a("SitResting", ((Boolean)this.field_70180_af.func_187225_a(SITRESTING)).booleanValue());
        tagCompound.func_74768_a("SAT", this.getSpecialAttackTimer());
        tagCompound.func_74776_a("EXP", this.getEXP());
        tagCompound.func_74776_a("TotalEXP", this.getTotalEXP());
        tagCompound.func_74768_a("Age", this.getGrowingAge());
        tagCompound.func_74768_a("Level", this.getLevel());
        tagCompound.func_74768_a("BookID", this.getBookID());
        tagCompound.func_74768_a("BookDurability", this.getBookDurability());
        tagCompound.func_74776_a("Energy", this.getEnergy());
        tagCompound.func_74768_a("InLove", this.inLove);
        if (this.getGuardBlock() != null) {
            tagCompound.func_74768_a("GPX", this.getGuardBlock().func_177958_n());
            tagCompound.func_74768_a("GPY", this.getGuardBlock().func_177956_o());
            tagCompound.func_74768_a("GPZ", this.getGuardBlock().func_177952_p());
        }
    }

    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public boolean func_70686_a(Class<? extends EntityLivingBase> cls) {
        return true;
    }

    public boolean isCameo() {
        return false;
    }

    public boolean canBeButchered() {
        return false;
    }

    public boolean isSitResting() {
        return (Boolean)this.field_70180_af.func_187225_a(SITRESTING);
    }

    public void setSitResting(boolean bool) {
        this.field_70180_af.func_187227_b(SITRESTING, (Object)bool);
    }

    public boolean isAntiMob() {
        return (Boolean)this.field_70180_af.func_187225_a(ANTIMOB);
    }

    public void setIsAntiMob(boolean bool) {
        this.field_70180_af.func_187227_b(ANTIMOB, (Object)bool);
    }

    public boolean isHero() {
        return (Boolean)this.field_70180_af.func_187225_a(HERO);
    }

    public void setIsHero(boolean bool) {
        this.field_70180_af.func_187227_b(HERO, (Object)bool);
    }

    public void becomeAHero() {
        this.setIsHero(true);
        this.func_184185_a(ModSoundEvents.hero, 100.0f, 1.0f);
        this.field_70173_aa = -20;
    }

    public boolean hasLastChance() {
        return (Boolean)this.field_70180_af.func_187225_a(REBIRTH);
    }

    public void setLastChance(boolean bool) {
        this.field_70180_af.func_187227_b(REBIRTH, (Object)bool);
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.MASTER;
    }

    @Nullable
    public BlockPos getGuardBlock() {
        return (BlockPos)((Optional)this.field_70180_af.func_187225_a(GUARD_BLOCK_POS)).orNull();
    }

    public void setGuardBlock(@Nullable BlockPos pos) {
        this.field_70180_af.func_187227_b(GUARD_BLOCK_POS, (Object)Optional.fromNullable((Object)pos));
    }

    public BlockPos getJukeboxToDanceTo() {
        return this.jukeBoxToDanceTo;
    }

    public void setJukeboxToDanceTo(BlockPos block) {
        this.jukeBoxToDanceTo = block;
    }

    @Nullable
    public UUID func_184753_b() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(OWNER_UNIQUE_ID)).orNull();
    }

    public void setOwnerId(@Nullable UUID p_184754_1_) {
        this.field_70180_af.func_187227_b(OWNER_UNIQUE_ID, (Object)Optional.fromNullable((Object)p_184754_1_));
    }

    @Nullable
    public EntityLivingBase getOwner() {
        try {
            UUID uuid = this.func_184753_b();
            return uuid == null ? null : this.field_70170_p.func_152378_a(uuid);
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }

    public boolean isOwner(EntityLivingBase entityIn) {
        return entityIn == this.getOwner();
    }

    public boolean isWild() {
        return this.getOwner() == null;
    }

    public boolean hasOwner(EntityPlayer player) {
        return !this.isWild() && this.getOwner() == player;
    }

    protected void dropEquipmentUndamaged() {
        if (!this.field_70170_p.field_72995_K) {
            for (EntityEquipmentSlot entityequipmentslot : EntityEquipmentSlot.values()) {
                ItemStack itemstack = this.func_184582_a(entityequipmentslot);
                if (itemstack.func_190926_b()) continue;
                if (EnchantmentHelper.func_190938_b((ItemStack)itemstack)) {
                    this.func_70097_a(new DamageSource("cramming").func_76348_h().func_151518_m().func_76351_m(), 10.0f);
                }
                if (EnchantmentHelper.func_190939_c((ItemStack)itemstack)) {
                    this.func_184185_a(SoundEvents.field_191263_gW, 1.0f, 1.0f);
                    this.field_70173_aa = 2;
                    this.func_184201_a(entityequipmentslot, ItemStack.field_190927_a);
                    continue;
                }
                this.func_184606_a_(itemstack);
                this.func_70099_a(itemstack, this.func_70047_e());
                this.func_184201_a(entityequipmentslot, ItemStack.field_190927_a);
                if (this.isWild() || itemstack.func_77973_b() != Items.field_151045_i) continue;
                ((EntityPlayer)this.getOwner()).func_71029_a((StatBase)AchievementList.field_187996_x);
            }
        }
    }

    public Team func_96124_cp() {
        EntityLivingBase entitylivingbase = this.getOwner();
        if (!this.isWild()) {
            return entitylivingbase.func_96124_cp();
        }
        return super.func_96124_cp();
    }

    public boolean affectedByCommandingStaff() {
        return !this.isHero() && !this.isCameo();
    }

    public boolean func_190631_cK() {
        return !this.func_175446_cd() || !this.func_70089_S();
    }

    public boolean isASwarmingMob() {
        return false;
    }

    public EnumPushReaction func_184192_z() {
        return this.func_175446_cd() ? EnumPushReaction.IGNORE : super.func_184192_z();
    }

    @Override
    public boolean isOnSameTeam(EntityLivingBase otherEntity) {
        if (!this.isWild()) {
            if (Loader.isModLoaded((String)"iceandfire") && otherEntity instanceof EntityDragonEgg) {
                return true;
            }
            if (Loader.isModLoaded((String)"abyssalcraft") && otherEntity instanceof EntityRemnant && (EntityRemnant)otherEntity != this.getOwner().func_110144_aD() && !((EntityRemnant)otherEntity).isAngry()) {
                return true;
            }
            if (Loader.isModLoaded((String)"abyssalcraft") && otherEntity instanceof EntityAbygolem && ((EntityAbygolem)otherEntity).func_70638_az() == null && (EntityAbygolem)otherEntity != this.getOwner().func_110144_aD()) {
                return true;
            }
            if (Loader.isModLoaded((String)"draconicevolution") && otherEntity instanceof EntityGuardianCrystal && ((EntityGuardianCrystal)otherEntity).health <= 0.0f) {
                return true;
            }
            if (!otherEntity.func_190631_cK() || !otherEntity.func_70089_S() || otherEntity instanceof EntityDragon && ((EntityDragon)otherEntity).func_184670_cT().func_188756_a() instanceof PhaseDying || otherEntity instanceof EntityLivingBase && !(otherEntity instanceof EntityPlayer) && !(otherEntity instanceof EntityLiving) && this.field_70173_aa % 120 == 0 || otherEntity instanceof AbstractHorse || otherEntity instanceof EntitySnowman || otherEntity instanceof EntityZombieVillager && ((EntityZombieVillager)otherEntity).func_82230_o() && !(this instanceof EntityIronGolem) || otherEntity instanceof EntityAmbientCreature && !(this instanceof EntitySpider) || otherEntity instanceof EntityWaterMob && ((EntityWaterMob)otherEntity).func_70638_az() == null || otherEntity instanceof EntityAnimal && ((EntityAnimal)otherEntity).func_70638_az() == null || otherEntity instanceof EntityTameable && ((EntityTameable)otherEntity).func_70902_q() != null && ((EntityTameable)otherEntity).func_70902_q() == this.getOwner() || otherEntity instanceof EntityPlayer && (otherEntity == this.getOwner() || otherEntity != this.getOwner() && otherEntity.func_184191_r((Entity)this.getOwner())) || otherEntity instanceof INpc && !(otherEntity instanceof EntityVillager) || otherEntity instanceof EntityFriendlyCreature && (((EntityFriendlyCreature)otherEntity).getOwner() == this.getOwner() || ((EntityFriendlyCreature)otherEntity).getOwner() != this.getOwner() && ((EntityFriendlyCreature)otherEntity).isOnSameTeam(this.getOwner())) || otherEntity instanceof net.minecraft.entity.monster.EntityEnderman && (net.minecraft.entity.monster.EntityEnderman)otherEntity != this.getOwner().func_110144_aD() && ((net.minecraft.entity.monster.EntityEnderman)otherEntity).func_70638_az() == null || otherEntity instanceof net.minecraft.entity.monster.EntityPigZombie && (net.minecraft.entity.monster.EntityPigZombie)otherEntity != this.getOwner().func_110144_aD() && !((net.minecraft.entity.monster.EntityPigZombie)otherEntity).func_175457_ck() || otherEntity instanceof net.minecraft.entity.monster.EntitySpider && (net.minecraft.entity.monster.EntitySpider)otherEntity != this.getOwner().func_110144_aD() && ((net.minecraft.entity.monster.EntitySpider)otherEntity).func_70638_az() == null && ((net.minecraft.entity.monster.EntitySpider)otherEntity).func_70013_c(1.0f) >= 0.5f || otherEntity instanceof net.minecraft.entity.monster.EntityIronGolem && (((net.minecraft.entity.monster.EntityIronGolem)otherEntity).func_70638_az() == null || ((net.minecraft.entity.monster.EntityIronGolem)otherEntity).func_70638_az() != null && ((net.minecraft.entity.monster.EntityIronGolem)otherEntity).func_70638_az() != this.getOwner())) {
                return true;
            }
            if (otherEntity instanceof EntityFriendlyCreature && ((EntityFriendlyCreature)otherEntity).convertionInt > 0) {
                return true;
            }
            if (otherEntity.isCreatureType(EnumCreatureType.MONSTER, false)) {
                return false;
            }
            if (otherEntity instanceof EntityPlayer && (((EntityPlayer)otherEntity).field_71075_bZ.field_75102_a || otherEntity == this.getOwner() || this.getOwner().func_184191_r((Entity)otherEntity) || super.func_184191_r((Entity)otherEntity))) {
                return true;
            }
        } else if (this.isWild()) {
            if (!otherEntity.func_190631_cK()) {
                return true;
            }
            if (otherEntity instanceof EntityMob && (((EntityMob)otherEntity).func_70638_az() == null || this instanceof EntityWither && !(otherEntity instanceof net.minecraft.entity.boss.EntityWither) && ((EntityMob)otherEntity).func_70668_bt() != EnumCreatureAttribute.UNDEAD)) {
                return true;
            }
            if (otherEntity instanceof EntityFriendlyCreature && ((EntityFriendlyCreature)otherEntity).isWild()) {
                return true;
            }
            if (!(!(otherEntity instanceof net.minecraft.entity.passive.EntityVillager) || this instanceof EntityWither || this instanceof EntityVindicator || this instanceof EntityVex || this instanceof EntityEvoker || this instanceof EntityZombie || this instanceof EntityAbyssalZombie || this instanceof EntityDreadling || this instanceof EntityDepthsGhoul)) {
                return true;
            }
            if (otherEntity instanceof net.minecraft.entity.passive.EntitySquid && !(this instanceof EntityWither) && !(this instanceof EntityGuardian)) {
                return true;
            }
            if (this.convertionInt > 0) {
                return true;
            }
        }
        return super.func_184191_r((Entity)otherEntity);
    }

    protected void func_70623_bb() {
        if (this.isWild() && this.func_184222_aU() && !(this instanceof EntityPortal)) {
            if (this.func_104002_bU()) {
                this.field_70708_bq = 0;
            } else {
                EntityPlayer entity = this.field_70170_p.func_72890_a((Entity)this, -1.0);
                if (entity != null) {
                    double d0 = entity.field_70165_t - this.field_70165_t;
                    double d1 = entity.field_70163_u - this.field_70163_u;
                    double d2 = entity.field_70161_v - this.field_70161_v;
                    double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                    if (this.func_70692_ba() && d3 > 50000.0) {
                        this.func_70106_y();
                    }
                    if (this.field_70708_bq > 10000 && this.field_70146_Z.nextInt(1000) == 0 && d3 > 2000.0 && this.func_70692_ba()) {
                        this.func_70106_y();
                    } else if (d3 < 2000.0) {
                        this.field_70708_bq = 0;
                    }
                }
            }
        }
    }

    protected float func_70599_aP() {
        return this.func_70093_af() ? 0.1f : 1.0f;
    }

    public boolean func_180431_b(DamageSource source) {
        return this.isWild() && this.func_184753_b() != null ? true : super.func_180431_b(source);
    }

    protected float func_70672_c(DamageSource source, float damage) {
        damage = super.func_70672_c(source, damage);
        if (source.func_76346_g() == this) {
            damage = 0.0f;
        }
        if (source.func_82725_o() && this.isHero()) {
            damage = (float)((double)damage * 0.25);
        }
        return damage;
    }

    protected float func_70655_b(DamageSource source, float damage) {
        if (!source.func_76363_c()) {
            this.func_70675_k(damage);
            damage = CombatRules.func_189427_a((float)damage, (float)this.func_70658_aO(), (float)((float)this.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111126_e()));
        } else {
            damage *= 0.5f;
        }
        return damage;
    }

    protected void func_70665_d(DamageSource source, float amount) {
        if (!this.func_180431_b(source)) {
            amount = ForgeHooks.onLivingHurt((EntityLivingBase)this, (DamageSource)source, (float)amount);
            Entity entity = source.func_76346_g();
            if (amount <= 0.0f) {
                return;
            }
            if (this.isHero() && source.func_76355_l() == "fall" && amount > 4.0f) {
                amount = 4.0f;
            }
            if (this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
                amount = 0.0f;
            }
            if (this.field_70170_p.func_175659_aa() == EnumDifficulty.EASY) {
                amount *= 0.75f;
            }
            if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                amount *= 1.5f;
            }
            if (source.func_76346_g() instanceof net.minecraft.entity.monster.EntityVex) {
                amount *= 0.33f;
            }
            if (this.isHero() && (source.func_76355_l() == "chaosImplosion" || source.func_76355_l() == "de.GuardianFireball" || source.func_76355_l() == "de.GuardianEnergyBall" || source.func_76355_l() == "de.GuardianChaosBall")) {
                amount *= 0.05f;
            }
            if (this.isHero() && entity != null) {
                amount *= entity instanceof IMob ? 0.33333334f : 0.75f;
            }
            String s = TextFormatting.func_110646_a((String)this.func_70005_c_());
            if (this.getClass().equals(EntityCow.class) && s != null && s.equals("Bessy")) {
                amount *= 0.01f;
            }
            amount = this.func_70655_b(source, amount);
            float f = amount = this.func_70672_c(source, amount);
            amount = Math.max(amount - this.func_110139_bj(), 0.0f);
            this.func_110149_m(this.func_110139_bj() - (f - amount));
            amount /= this.getFittness();
            if (this.getDamageCap() > 0 && amount >= (float)(this.getDamageCap() / 2)) {
                amount /= this.field_70131_O + this.field_70130_N;
            }
            if (this.getDamageCap() > 0 && amount >= (float)this.getDamageCap()) {
                amount = this.getDamageCap();
            }
            if (amount != 0.0f && this.lastChanceInvul <= 0) {
                this.field_70721_aZ += 1.0f;
                this.setEnergy(this.getEnergy() - 0.1f);
                float f1 = this.func_110143_aJ();
                this.func_70606_j(f1 - amount);
                this.func_110142_aN().func_94547_a(source, f1, amount);
                this.func_110149_m(this.func_110139_bj() - amount);
                this.setCurrentStudy(EnumStudy.Physical, (int)amount);
            }
        }
    }

    protected void damageEntityTraining(DamageSource source, float amount) {
        if (!this.func_180431_b(source) && this.getFakeHealth() > 0.0f) {
            Entity entity = source.func_76346_g();
            if (amount <= 0.0f) {
                return;
            }
            if (this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
                amount = 0.0f;
            }
            if (this.field_70170_p.func_175659_aa() == EnumDifficulty.EASY) {
                amount *= 0.75f;
            }
            if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                amount *= 1.5f;
            }
            if (source.func_76346_g() instanceof net.minecraft.entity.monster.EntityVex) {
                amount *= 0.33f;
            }
            if (this.isHero() && entity != null) {
                amount *= entity instanceof IMob ? 0.33333334f : 0.75f;
            }
            amount = this.func_70655_b(source, amount);
            float f = amount = this.func_70672_c(source, amount);
            amount = Math.max(amount - this.func_110139_bj(), 0.0f);
            this.func_110149_m(this.func_110139_bj() - (f - amount));
            if (amount != 0.0f) {
                if (EngenderMod.isWoodLikeMob((Entity)this)) {
                    if (amount >= 7.0f || source.func_94541_c() || source.func_151517_h() || source.func_76363_c() || source == DamageSource.field_82728_o || source.func_76357_e() || source.func_82725_o() || source == DamageSource.field_76371_c) {
                        this.func_184185_a(ModSoundEvents.woodHitCrush, 3.0f, 1.0f);
                    } else if (source.func_76352_a() && !source.func_76347_k()) {
                        this.func_184185_a(ModSoundEvents.woodHitPierce, 3.0f, 1.0f);
                    } else {
                        this.func_184185_a(ModSoundEvents.woodHit, 3.0f, 1.0f);
                    }
                } else if (EngenderMod.isMetalLikeMob((Entity)this)) {
                    if (amount >= 7.0f || source.func_94541_c() || source.func_151517_h() || source.func_76363_c() || source == DamageSource.field_82728_o || source.func_76357_e() || source.func_82725_o() || source == DamageSource.field_76371_c) {
                        this.func_184185_a(ModSoundEvents.metalHitCrush, 3.0f, 1.0f);
                    } else if (source.func_76352_a() && !source.func_76347_k()) {
                        this.func_184185_a(ModSoundEvents.metalHitPierce, 3.0f, 1.0f);
                    } else {
                        this.func_184185_a(ModSoundEvents.metalHit, 3.0f, 1.0f);
                    }
                } else if (amount >= 7.0f || source.func_94541_c() || source.func_151517_h() || source.func_76363_c() || source == DamageSource.field_82728_o || source.func_76357_e() || source.func_82725_o() || source == DamageSource.field_76371_c) {
                    if (this.field_70131_O >= 5.0f) {
                        this.func_184185_a(ModSoundEvents.fleshHitCrushHeavy, 3.0f, 1.0f);
                    } else {
                        this.func_184185_a(ModSoundEvents.fleshHitCrush, 3.0f, 1.0f);
                    }
                } else if (source.func_76352_a() && !source.func_76347_k()) {
                    this.func_184185_a(ModSoundEvents.fleshHitPierce, 3.0f, 1.0f);
                } else {
                    this.func_184185_a(ModSoundEvents.fleshHit, 3.0f, 1.0f);
                }
                this.field_70721_aZ += 1.0f;
                float f1 = this.getFakeHealth();
                this.setFakeHealth(f1 - amount);
                this.func_70691_i(this.func_110138_aP());
                this.func_110142_aN().func_94547_a(source, f1, amount);
                this.func_110149_m(this.func_110139_bj() - amount);
                this.setCurrentStudy(EnumStudy.Physical, (int)(amount <= 2.0f ? 1.0f : amount / 2.0f));
                if (this.getFakeHealth() <= 0.0f) {
                    this.field_70173_aa = 0;
                    this.lastChanceInvul = 100;
                    this.func_70674_bp();
                    this.func_70691_i(this.func_110138_aP());
                    this.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 4));
                    this.func_184185_a(this.func_184615_bR(), this.func_70599_aP(), this.func_70647_i());
                    this.func_70624_b(null);
                    if (entity instanceof EntityFriendlyCreature) {
                        ((EntityFriendlyCreature)entity).func_70674_bp();
                        ((EntityFriendlyCreature)entity).func_70691_i(this.func_110138_aP());
                        ((EntityFriendlyCreature)entity).func_70624_b(null);
                    }
                    if (!this.isWild()) {
                        this.incrementConversion((EntityPlayer)this.getOwner());
                        this.getOwner().func_145747_a((ITextComponent)new TextComponentTranslation(this.func_70005_c_() + " has been defeated in training by " + entity.func_70005_c_(), new Object[0]));
                    }
                }
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        Entity entity = source.func_76346_g();
        if (!this.func_70089_S()) {
            return false;
        }
        if (entity instanceof EntityFriendlyCreature && this.isOnSameTeam((EntityLivingBase)((EntityFriendlyCreature)entity)) && this.getFakeHealth() > 0.0f) {
            boolean flag1 = true;
            if ((float)this.field_70172_ad > (float)this.field_70771_an / 2.0f) {
                this.damageEntityTraining(source, amount - this.field_110153_bc);
                flag1 = false;
            } else {
                this.field_110153_bc = amount;
                this.field_70172_ad = this.field_70771_an;
                this.damageEntityTraining(source, amount);
                this.field_70737_aN = this.field_70738_aO = 10;
            }
            if (flag1) {
                if (source instanceof EntityDamageSource && ((EntityDamageSource)source).func_180139_w()) {
                    this.field_70170_p.func_72960_a((Entity)this, (byte)33);
                } else {
                    this.field_70170_p.func_72960_a((Entity)this, (byte)2);
                }
                this.func_70018_K();
                double d1 = entity.field_70165_t - this.field_70165_t;
                double d0 = entity.field_70161_v - this.field_70161_v;
                while (d1 * d1 + d0 * d0 < 1.0E-4) {
                    d1 = (Math.random() - Math.random()) * 0.01;
                    d0 = (Math.random() - Math.random()) * 0.01;
                }
                this.field_70739_aP = (float)(MathHelper.func_181159_b((double)d0, (double)d1) * 57.29577951308232 - (double)this.field_70177_z);
                this.func_70653_a(entity, 0.4f, d1, d0);
                if (entity instanceof EntityLivingBase) {
                    this.func_70624_b((EntityLivingBase)entity);
                }
            }
            this.func_184581_c(source);
        }
        if (this.getFakeHealth() <= 0.0f && entity != null && entity instanceof EntityFriendlyCreature && this.isOnSameTeam((EntityLivingBase)((EntityFriendlyCreature)entity))) {
            ((EntityFriendlyCreature)entity).func_70624_b(null);
        }
        if (!ForgeHooks.onLivingAttack((EntityLivingBase)this, (DamageSource)source, (float)amount)) {
            return false;
        }
        if (this.getOwner() != null && entity == this.getOwner()) {
            if (this instanceof EntityChicken) {
                ((EntityChicken)this).timeUntilNextEgg -= 40;
            }
            this.moralRaisedTimer += 40;
            this.prevChasingPosX = this.chasingPosX = this.field_70165_t + (double)MathHelper.func_76126_a((float)(this.field_70761_aq * ((float)Math.PI / 180))) * 6.0;
            this.prevChasingPosY = this.chasingPosY = this.field_70163_u + (double)this.func_70047_e();
            this.prevChasingPosZ = this.chasingPosZ = this.field_70165_t - (double)MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180))) * 6.0;
            this.field_70140_Q = 0.0f;
            this.func_70624_b(null);
            this.func_70604_c(null);
            this.func_70661_as().func_75499_g();
            this.func_70661_as().func_75497_a((Entity)this, 0.0);
            if (!this.field_70170_p.field_72995_K && this.func_85035_bI() > 0) {
                this.func_85034_r(this.func_85035_bI() - 1);
                this.func_70097_a(DamageSource.field_76367_g, 2.0f);
                this.func_184185_a(SoundEvents.field_187903_gc, this.func_70599_aP(), this.func_70647_i());
                EntityTippedArrow entityarrow = new EntityTippedArrow(this.field_70170_p, (EntityLivingBase)this);
                entityarrow.func_82149_j((Entity)this);
                entityarrow.field_70163_u = this.field_70163_u + (double)this.func_70047_e();
                entityarrow.func_184547_a((Entity)this, -30.0f, this.field_70146_Z.nextFloat() * 360.0f, 0.0f, 0.35f, 1.0f);
                entityarrow.field_70251_a = EntityArrow.PickupStatus.ALLOWED;
                this.field_70170_p.func_72838_d((Entity)entityarrow);
            }
        }
        if (this.func_180431_b(source) || amount == 0.0f || !this.takesFallDamage() && source.func_76355_l() == "fall" || this.func_180427_aV() && source.func_94541_c() || this.isHero() && (source.func_76355_l() == "sulphuric_acid" || source.func_76355_l() == "thermal" || source.func_76355_l() == "oxygen_suffocation" || source.func_76355_l() == "wither" || source.func_76355_l() == "inFire" || source.func_76355_l() == "onFire" || source.func_76355_l() == "lava" || source.func_76355_l() == "hotFloor" || source.func_76355_l() == "magic" || source.func_76355_l() == "indirectMagic") || source.func_76347_k() && (this.func_70644_a(MobEffects.field_76426_n) || this.func_70045_F()) || this.isEntityImmuneToCoralium() && source.func_76355_l() == "coralium" || this.isEntityImmuneToDread() && source.func_76355_l() == "dread" || this.isEntityImmuneToAntiMatter() && source.func_76355_l() == "antimatter" || this.isEntityImmuneToDarkness() && source.func_76355_l() == "shadow" || entity != null && entity instanceof EntityLivingBase && this.isOnSameTeam((EntityLivingBase)entity) && !this.field_70170_p.func_82736_K().func_82766_b("friendlyFire") || this.getTier() == EnumTier.TIER6 && (source.func_76355_l() == "sulphuric_acid" || source.func_76355_l() == "thermal" || source.func_76355_l() == "oxygen_suffocation" || source.func_76355_l() == "wither" || source.func_76355_l() == "inFire" || source.func_76355_l() == "onFire" || source.func_76355_l() == "lava" || source.func_76355_l() == "hotFloor" || source.func_76355_l() == "chaosImplosion") || source == DamageSource.field_191291_g) {
            return false;
        }
        this.setSitResting(false);
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() == null && entity != null && entity instanceof EntityLivingBase && !this.isOnSameTeam((EntityLivingBase)entity) && !source.func_94541_c()) {
            this.func_70624_b((EntityLivingBase)entity);
        }
        if (source.func_76352_a()) {
            this.func_184185_a(this.getPierceHurtSound(), 3.0f, 1.0f);
        } else if (amount >= 7.0f || source.func_94541_c() || source.func_151517_h() || source.func_76363_c() || source == DamageSource.field_82728_o || source.func_76357_e() || source.func_82725_o() || source == DamageSource.field_76371_c) {
            this.func_184185_a(this.getCrushHurtSound(), 3.0f, 1.0f);
        } else {
            this.func_184185_a(this.getRegularHurtSound(), 3.0f, 1.0f);
        }
        this.setCurrentStudy(EnumStudy.Combative, (int)amount);
        return super.func_70097_a(source, amount);
    }

    public int getDamageCap() {
        return 0;
    }

    public void func_70653_a(Entity entityIn, float strength, double xRatio, double zRatio) {
        double d = this.field_70146_Z.nextDouble();
        double d2 = this.func_70089_S() || this.field_70146_Z.nextInt(200) != 0 ? this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111126_e() : 0.0;
        if (d >= d2) {
            this.field_70160_al = true;
            this.field_70181_x += (double)strength;
            this.func_70661_as().func_75499_g();
            this.field_70177_z = this.field_70759_as = (float)MathHelper.func_181159_b((double)this.field_70179_y, (double)this.field_70159_w) * 57.295776f - 90.0f;
            this.field_70761_aq = this.field_70759_as;
            this.field_70758_at = this.field_70759_as;
            this.field_70126_B = this.field_70759_as;
            this.field_70760_ar = this.field_70759_as;
            if (!this.func_70089_S() && strength >= 1.0f) {
                strength *= 2.0f;
            }
            float f = MathHelper.func_76133_a((double)(xRatio * xRatio + zRatio * zRatio));
            this.field_70159_w /= 2.0;
            this.field_70179_y /= 2.0;
            this.field_70159_w -= xRatio / (double)f * (double)strength;
            this.field_70179_y -= zRatio / (double)f * (double)strength;
        }
    }

    public void cleave(int lootingModifier, DamageSource source) {
        this.func_70057_ab();
        if (!this.field_70170_p.field_72995_K) {
            this.field_70718_bc = 100;
            this.func_70097_a(source, this.func_110138_aP());
            for (int ai = 0; ai <= lootingModifier; ++ai) {
                EntityFriendlyCreature addon = this.spawnBaby(this);
                addon.func_82149_j((Entity)this);
                this.field_70170_p.func_72838_d((Entity)addon);
                addon.func_70645_a(source);
                addon.func_70106_y();
            }
            this.func_70645_a(source);
            this.func_184185_a(this.func_184615_bR(), this.func_70599_aP(), this.func_70647_i());
            this.func_70606_j(0.0f);
        }
    }

    public void attackWithAdditionalEffects(Entity entity) {
    }

    public boolean func_70652_k(Entity entity) {
        if (!this.func_70089_S()) {
            return false;
        }
        if (this instanceof EntityEnderman && ((EntityEnderman)this).canDodgeAllAttacks()) {
            entity.field_70172_ad = 0;
        }
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() * (float)((this.func_70093_af() || this.func_82150_aj() || !this.func_70685_l(entity)) && entity instanceof EntityLiving && ((EntityLiving)entity).func_70638_az() != this ? 3 : 1) * (this.isHero() ? (entity instanceof IMob ? 3.0f : 1.5f) : 1.0f);
        int i = 0;
        f *= (this.getStrength() + 50.0f) / 100.0f;
        if (entity instanceof EntityFriendlyCreature && this.isOnSameTeam((EntityLivingBase)((EntityFriendlyCreature)entity)) && this.getFakeHealth() > 0.0f) {
            this.setCurrentStudy(EnumStudy.Combative, (int)(f <= 2.0f ? 1.0f : f / 2.0f));
            entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f);
            ((EntityLivingBase)entity).func_70653_a((Entity)this, (float)i * 0.5f + 0.3f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
        }
        if (entity instanceof EntityLivingBase && this.isOnSameTeam((EntityLivingBase)entity) && !this.field_70170_p.func_82736_K().func_82766_b("friendlyFire")) {
            return false;
        }
        if (entity instanceof EntityAmbientCreature) {
            entity.func_184220_m((Entity)this);
            this.func_184185_a(SoundEvents.field_187739_dZ, 1.0f, 1.5f);
            this.func_70691_i(2.0f);
        }
        this.setSitResting(false);
        try {
            ReflectionHelper.findField(entity.getClass(), (String[])new String[]{"recentlyHit", "field_70718_bc"}).setInt(entity, 100);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.isASwarmingMob() && entity != null) {
            List allies = this.field_70170_p.func_72872_a(this.getClass(), this.func_174813_aQ().func_186662_g(3.0));
            if (!this.field_70170_p.field_72995_K && !allies.isEmpty()) {
                for (int i1 = 0; i1 < allies.size(); ++i1) {
                    EntityFriendlyCreature entities = (EntityFriendlyCreature)allies.get(i1);
                    if (!entities.func_70089_S() || !this.isOnSameTeam((EntityLivingBase)entities) || !entities.isASwarmingMob() || entities.getClass() != this.getClass()) continue;
                    f += 0.1f;
                }
            }
        }
        IAttributeInstance bonus = this.func_110148_a(SharedMonsterAttributes.field_111264_e);
        AttributeModifier vslight = new AttributeModifier(UUID.fromString("B9766B59-8566-4402-BC1F-3EE2A276D831"), "Light Bonus", (double)this.getBonusVSLight(), 1).func_111168_a(false);
        AttributeModifier vsarmored = new AttributeModifier(UUID.fromString("B9766B59-8566-4402-BC1F-3EE2A276D832"), "Armored Bonus", (double)this.getBonusVSArmored(), 1).func_111168_a(false);
        AttributeModifier vsmassive = new AttributeModifier(UUID.fromString("B9766B59-8566-4402-BC1F-3EE2A276D833"), "Massive Bonus", (double)this.getBonusVSMassive(), 1).func_111168_a(false);
        AttributeModifier vsflying = new AttributeModifier(UUID.fromString("B9766B59-8566-4402-BC1F-3EE2A276D834"), "Flying Bonus", (double)this.getBonusVSFlying(), 1).func_111168_a(false);
        AttributeModifier vstiny = new AttributeModifier(UUID.fromString("B9766B59-8566-4402-BC1F-3EE2A276D835"), "Tiny Bonus", (double)this.getBonusVSTiny(), 1).func_111168_a(false);
        AttributeModifier vselemental = new AttributeModifier(UUID.fromString("B9766B59-8566-4402-BC1F-3EE2A276D836"), "Elemental Bonus", (double)this.getBonusVSElemental(), 1).func_111168_a(false);
        AttributeModifier vsstructure = new AttributeModifier(UUID.fromString("B9766B59-8566-4402-BC1F-3EE2A276D837"), "Structure Bonus", (double)this.getBonusVSStructure(), 1).func_111168_a(false);
        AttributeModifier vsundead = new AttributeModifier(UUID.fromString("B9766B59-8566-4402-BC1F-3EE2A276D838"), "Undead Bonus", (double)this.getBonusVSUndead(), 1).func_111168_a(false);
        AttributeModifier vsender = new AttributeModifier(UUID.fromString("B9766B59-8566-4402-BC1F-3EE2A276D839"), "Ender Bonus", (double)this.getBonusVSEnder(), 1).func_111168_a(false);
        AttributeModifier vsanimal = new AttributeModifier(UUID.fromString("B9766B59-8566-4402-BC1F-3EE2A276D840"), "Animal Bonus", (double)this.getBonusVSAnimal(), 1).func_111168_a(false);
        if (entity instanceof EntityLivingBase) {
            if (entity instanceof Light && !bonus.func_180374_a(vslight)) {
                bonus.func_111121_a(vslight);
            }
            if (entity instanceof Armored && !bonus.func_180374_a(vsarmored)) {
                bonus.func_111121_a(vsarmored);
            }
            if (entity instanceof Flying && !bonus.func_180374_a(vsflying)) {
                bonus.func_111121_a(vsflying);
            }
            if (entity instanceof Massive && !bonus.func_180374_a(vsmassive)) {
                bonus.func_111121_a(vsmassive);
            }
            if (entity instanceof Tiny && !bonus.func_180374_a(vsmassive)) {
                bonus.func_111121_a(vsmassive);
            }
            if (entity instanceof Elemental && !bonus.func_180374_a(vsmassive)) {
                bonus.func_111121_a(vsmassive);
            }
            if (entity instanceof Structure && !bonus.func_180374_a(vsmassive)) {
                bonus.func_111121_a(vsmassive);
            }
            if (entity instanceof Undead && !bonus.func_180374_a(vsmassive)) {
                bonus.func_111121_a(vsmassive);
            }
            if (entity instanceof Ender && !bonus.func_180374_a(vsender)) {
                bonus.func_111121_a(vsender);
            }
            if (entity instanceof Animal && !bonus.func_180374_a(vsender)) {
                bonus.func_111121_a(vsender);
            }
        }
        if (EngenderMod.useMobTalkerModels && this instanceof EntityEnderman && ((EntityEnderman)this).andr) {
            i += 60;
            f *= 10000.0f;
            if (entity instanceof EntityLivingBase) {
                entity.field_70172_ad = 0;
                entity.field_70181_x = (double)this.field_70131_O * 0.25;
                ((EntityLivingBase)entity).func_70653_a((Entity)this, (float)i * 0.5f + 0.3f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
            }
            if (!this.field_70170_p.field_72995_K) {
                EntityFriendlyCreature.createEngenderModExplosionFireless((Entity)this, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 7.0f + entity.field_70131_O + entity.field_70130_N, false);
            }
        }
        if (EngenderMod.useMobTalkerModels && this instanceof EntityGhast && ((EntityGhast)this).eleanor) {
            i += 30;
            f *= 1000.0f;
            if (entity instanceof EntityLivingBase) {
                entity.field_70172_ad = 0;
                entity.field_70181_x = (double)this.field_70131_O * 0.25;
                ((EntityLivingBase)entity).func_70653_a((Entity)this, (float)i * 0.5f + 0.3f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
            }
            if (!this.field_70170_p.field_72995_K) {
                EntityFriendlyCreature.createEngenderModExplosionFireless((Entity)this, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 7.0f + entity.field_70131_O + entity.field_70130_N, false);
            }
        }
        if (this.func_70093_af() && entity instanceof EntityLiving && ((EntityLiving)entity).func_70638_az() != this) {
            i += 4;
        }
        if (entity instanceof EntityLivingBase) {
            double d4;
            double d3;
            double d2;
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)entity).func_70668_bt());
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184592_cb(), (EnumCreatureAttribute)((EntityLivingBase)entity).func_70668_bt());
            i += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
            if (this instanceof EntityWitherStormHead) {
                i += 3;
                d2 = entity.field_70165_t - this.field_70165_t;
                d3 = entity.field_70161_v - this.field_70161_v;
                d4 = d2 * d2 + d3 * d3;
                entity.field_70159_w += d2 / d4 * 2.0;
                entity.field_70181_x += 0.5;
                entity.field_70179_y += d3 / d4 * 2.0;
            }
            if (this instanceof EntityEnderDragon) {
                i += 4;
                d2 = entity.field_70165_t - this.field_70165_t;
                d3 = entity.field_70161_v - this.field_70161_v;
                d4 = d2 * d2 + d3 * d3;
                entity.field_70159_w += d2 / d4 * 2.0;
                entity.field_70181_x += 0.5;
                entity.field_70179_y += d3 / d4 * 2.0;
            }
            if (this instanceof EntityWitherStormTentacle) {
                i += 9;
                d2 = entity.field_70165_t - this.field_70165_t;
                d3 = entity.field_70161_v - this.field_70161_v;
                d4 = d2 * d2 + d3 * d3;
                entity.field_70159_w += d2 / d4 * 4.0;
                entity.field_70181_x += 0.5;
                entity.field_70179_y += d3 / d4 * 4.0;
            }
            if (this instanceof EntityWitherStormTentacleDevourer) {
                i += 12;
                d2 = entity.field_70165_t - this.field_70165_t;
                d3 = entity.field_70161_v - this.field_70161_v;
                d4 = d2 * d2 + d3 * d3;
                entity.field_70159_w += d2 / d4 * 6.0;
                entity.field_70181_x += 0.5;
                entity.field_70179_y += d3 / d4 * 6.0;
            }
        }
        if (Loader.isModLoaded((String)"iceandfire") && entity instanceof EntityLivingBase && EntityGorgon.isStoneMob((EntityLivingBase)((EntityLivingBase)entity))) {
            entity.field_70172_ad = 0;
        }
        if (this.func_110148_a(AGILITY).func_111125_b() >= this.field_70146_Z.nextDouble() * 10000.0) {
            entity.field_70172_ad = 0;
            f *= 10.0f;
            this.func_184185_a(SoundEvents.field_187539_bB, 5.0f, 1.0f);
            if (EngenderMod.enableMessages && !this.isWild()) {
                this.getOwner().func_145747_a((ITextComponent)new TextComponentTranslation(this.func_70005_c_() + " got a critical hit!", new Object[0]));
            }
        }
        boolean flag = entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f);
        if (this instanceof EntityPortal) {
            flag = entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this).func_76348_h(), f);
        }
        if (entity instanceof EntityLivingBase && !(entity instanceof EntityFriendlyCreature) && this.func_70668_bt() == ((EntityLivingBase)entity).func_70668_bt() && ((EntityLivingBase)entity).func_70668_bt() != EnumCreatureAttribute.UNDEFINED) {
            flag = entity.func_70097_a(!this.isWild() ? DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)this.getOwner())) : new DamageSource("generic"), f);
        }
        if (entity instanceof EntityPlayer && this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            flag = ((EntityPlayer)entity).func_70097_a(DamageSource.field_76377_j, f);
        }
        if (Loader.isModLoaded((String)"draconicevolution") && entity instanceof EntityGuardianCrystal) {
            flag = entity.func_70097_a(!this.isWild() ? DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)this.getOwner())) : new DamageSource("generic"), f);
            ((EntityGuardianCrystal)entity).shieldTime = 0;
            entity.field_70159_w = 0.0;
            entity.field_70181_x = 0.0;
            entity.field_70179_y = 0.0;
        }
        if (entity instanceof IEntityMultiPart) {
            Entity parts;
            Entity[] aentity;
            i = 0;
            if (entity != null && (aentity = entity.func_70021_al()) != null && (parts = aentity[this.field_70146_Z.nextInt(entity.func_70021_al().length)]) instanceof EntityDragonPart) {
                flag = ((IEntityMultiPart)entity).func_70965_a((EntityDragonPart)parts, entity instanceof EntityFriendlyCreature ? DamageSource.func_76358_a((EntityLivingBase)this) : DamageSource.func_76365_a((EntityPlayer)(this.isWild() ? this.field_70170_p.func_72890_a((Entity)this, -1.0) : (EntityPlayer)this.getOwner())), f);
            }
        }
        if (entity instanceof EntityLivingBase && (!this.isOnSameTeam((EntityLivingBase)entity) || entity instanceof EntityFriendlyCreature && this.isOnSameTeam((EntityLivingBase)((EntityFriendlyCreature)entity)) && this.getFakeHealth() <= 0.0f) && !this.field_70170_p.func_82736_K().func_82766_b("friendlyFire")) {
            flag = false;
        }
        if (flag && entity != null) {
            if (!(this instanceof IEntityMultiPart)) {
                this.func_70625_a(entity, 180.0f, this.func_70646_bf());
                this.field_70761_aq = this.field_70177_z = this.field_70759_as;
            }
            if (this instanceof EntitySlime) {
                this.func_184185_a(SoundEvents.field_187870_fk, this.func_70599_aP(), this.func_70647_i());
            }
            EntityPlayer player = this.field_70170_p.func_72890_a((Entity)this, 16.0);
            if (this.isHero()) {
                entity.func_184185_a(SoundEvents.field_187730_dW, 1.0f, this.func_70647_i());
                if (player != null) {
                    player.func_71009_b(entity);
                }
                if (entity instanceof IMob) {
                    entity.func_184185_a(SoundEvents.field_187718_dS, 1.0f, this.func_70647_i());
                    if (player != null) {
                        player.func_71047_c(entity);
                    }
                }
            }
        }
        if (entity instanceof EntityPlayer) {
            ItemStack itemstack1;
            EntityPlayer entityplayer = (EntityPlayer)entity;
            ItemStack itemstack = this.func_184614_ca();
            ItemStack itemStack = itemstack1 = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : null;
            if ((this instanceof EntityGuardian || !this.func_184222_aU()) && itemstack1 != null && itemstack1.func_77973_b() == Items.field_185159_cQ) {
                entityplayer.func_184811_cZ().func_185145_a(Items.field_185159_cQ, 100);
                this.field_70170_p.func_72960_a((Entity)entityplayer, (byte)30);
            }
            if (itemstack != null && itemstack.func_77973_b() instanceof ItemAxe && itemstack1 != null && itemstack1.func_77973_b() == Items.field_185159_cQ) {
                float f1 = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)this) * 0.05f;
                if (this.field_70146_Z.nextFloat() < f1) {
                    entityplayer.func_184811_cZ().func_185145_a(Items.field_185159_cQ, 100);
                    this.field_70170_p.func_72960_a((Entity)entityplayer, (byte)30);
                }
            }
        }
        if ((entity instanceof EntityLivingBase || entity instanceof EntityPlayer && !((EntityPlayer)entity).field_71075_bZ.field_75102_a) && (!this.isOnSameTeam((EntityLivingBase)entity) || entity instanceof EntityFriendlyCreature && this.isOnSameTeam((EntityLivingBase)((EntityFriendlyCreature)entity)) && this.getFakeHealth() <= 0.0f) && (entity != this || !this.isWild() && entity != this.getOwner())) {
            this.setCurrentStudy(EnumStudy.Combative, (int)f);
            this.func_174815_a((EntityLivingBase)this, entity);
            if (entity instanceof EntityLivingBase && !((EntityLivingBase)entity).func_184222_aU() && ((EntityLivingBase)entity).func_110143_aJ() <= 1.0f) {
                ((EntityLivingBase)entity).func_70606_j(0.0f);
            }
            if (this instanceof EntityVex) {
                ((EntityVex)this).setIsCharging(false);
            }
            ((EntityLivingBase)entity).field_70721_aZ += 1.0f;
            if (((EntityLivingBase)entity).func_110143_aJ() > 1.0f) {
                ((EntityLivingBase)entity).func_70606_j(((EntityLivingBase)entity).func_110143_aJ() - (this.isHero() ? 0.03f : 0.01f));
            }
            if (EngenderMod.isWoodLikeMob(entity)) {
                if (f >= 7.0f) {
                    entity.func_184185_a(ModSoundEvents.woodHitCrush, 3.0f, 1.0f);
                } else {
                    entity.func_184185_a(ModSoundEvents.woodHit, 3.0f, 1.0f);
                }
            } else if (EngenderMod.isMetalLikeMob(entity)) {
                if (f >= 7.0f) {
                    entity.func_184185_a(ModSoundEvents.metalHitCrush, 3.0f, 1.0f);
                } else {
                    entity.func_184185_a(ModSoundEvents.metalHit, 3.0f, 1.0f);
                }
            } else if (f >= 7.0f) {
                if (entity.field_70131_O >= 5.0f) {
                    entity.func_184185_a(ModSoundEvents.fleshHitCrushHeavy, 3.0f, 1.0f);
                } else {
                    entity.func_184185_a(ModSoundEvents.fleshHitCrush, 3.0f, 1.0f);
                }
            } else {
                entity.func_184185_a(ModSoundEvents.fleshHit, 3.0f, 1.0f);
            }
        }
        if (entity instanceof EntityLivingBase && (entity != this || !this.isWild() && entity != this.getOwner()) && flag) {
            int j;
            ((EntityLivingBase)entity).func_70653_a((Entity)this, (float)i * 0.5f + 0.3f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
            if (entity instanceof EntityPlayerMP) {
                ((EntityPlayerMP)entity).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity((Entity)((EntityPlayerMP)entity)));
            }
            if ((j = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                entity.func_70015_d(j * 4);
            }
            if (!this.func_184614_ca().func_190926_b() && this.func_184614_ca().func_77973_b() != null && !this.isWild()) {
                this.func_184614_ca().func_77961_a((EntityLivingBase)entity, (EntityPlayer)this.getOwner());
            }
            if (!this.func_184592_cb().func_190926_b() && this.func_184592_cb().func_77973_b() != null && !this.isWild()) {
                this.func_184592_cb().func_77961_a((EntityLivingBase)entity, (EntityPlayer)this.getOwner());
            }
            if (!this.func_184614_ca().func_190926_b() && this.func_184614_ca().func_77973_b() != null && this instanceof EntityPigZombie && this.func_184614_ca().func_77973_b() == Items.field_151010_B) {
                this.func_184614_ca().func_77964_b(0);
            }
            if (!this.func_184592_cb().func_190926_b() && this.func_184592_cb().func_77973_b() != null && this instanceof EntityPigZombie && this.func_184592_cb().func_77973_b() == Items.field_151010_B) {
                this.func_184592_cb().func_77964_b(0);
            }
            if (!this.func_184614_ca().func_190926_b() && this.func_184614_ca().func_77973_b() != null && this instanceof EntityVex && this.func_184614_ca().func_77973_b() == Items.field_151040_l) {
                this.func_184614_ca().func_77964_b(0);
            }
            if (!this.func_184592_cb().func_190926_b() && this.func_184592_cb().func_77973_b() != null && this instanceof EntityVex && this.func_184592_cb().func_77973_b() == Items.field_151040_l) {
                this.func_184592_cb().func_77964_b(0);
            }
            this.func_174815_a((EntityLivingBase)this, entity);
        }
        this.setEnergy(this.getEnergy() - 0.1f);
        if (EngenderMod.enableMessages && !entity.func_70089_S() && !this.isWild()) {
            boolean flag1 = false;
            try {
                flag1 = ReflectionHelper.findField(entity.getClass(), (String[])new String[]{"dead", "field_70729_aU"}).getBoolean(entity);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!flag1) {
                if (entity instanceof EntityLivingBase) {
                    this.setCurrentStudy(EnumStudy.Combative, (int)((EntityLivingBase)entity).func_110138_aP());
                }
                this.getOwner().func_145747_a((ITextComponent)new TextComponentTranslation(entity.func_70005_c_() + " was " + (this.func_82150_aj() ? "ambushed" : (this.func_70093_af() ? "assassinated" : "slain")) + " by " + this.func_70005_c_() + " (" + this.getOwner().func_70005_c_() + ")", new Object[0]));
            }
        }
        if (bonus.func_180374_a(vslight)) {
            bonus.func_111124_b(vslight);
        }
        if (bonus.func_180374_a(vsarmored)) {
            bonus.func_111124_b(vsarmored);
        }
        if (bonus.func_180374_a(vsmassive)) {
            bonus.func_111124_b(vsmassive);
        }
        if (bonus.func_180374_a(vsflying)) {
            bonus.func_111124_b(vsflying);
        }
        return true;
    }

    public void func_70624_b(EntityLivingBase entitylivingbaseIn) {
        if (entitylivingbaseIn != null && entitylivingbaseIn instanceof EntityFriendlyCreature && this.isOnSameTeam((EntityLivingBase)((EntityFriendlyCreature)entitylivingbaseIn)) && ((EntityFriendlyCreature)entitylivingbaseIn).getFakeHealth() > 0.0f && this.getFakeHealth() <= 0.0f) {
            entitylivingbaseIn = null;
        }
        if (entitylivingbaseIn != null) {
            this.setSitResting(false);
        }
        if (entitylivingbaseIn != this || entitylivingbaseIn == null) {
            super.func_70624_b(entitylivingbaseIn);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_98034_c(EntityPlayer player) {
        if (player.func_175149_v()) {
            return false;
        }
        return this.isOnSameTeam((EntityLivingBase)player) || !this.func_70089_S() ? false : this.func_82150_aj();
    }

    public void fireLightning(Entity entity, double x, double y, double z) {
        if (entity != null && entity.func_70089_S()) {
            double d3 = x;
            double d4 = y;
            double d5 = z;
            double d6 = entity.field_70165_t - d3;
            double d7 = entity.field_70163_u - d4;
            double d8 = entity.field_70161_v - d5;
            EntityPortalLightning entitywitherskull = new EntityPortalLightning(this.field_70170_p, entity, (EntityLivingBase)this, d6, d7, d8);
            entitywitherskull.field_70163_u = d4;
            entitywitherskull.field_70165_t = d3;
            entitywitherskull.field_70161_v = d5;
            entitywitherskull.field_70233_c = d4;
            entitywitherskull.field_70232_b = d3;
            entitywitherskull.field_70230_d = d5;
            entitywitherskull.targetEntity = entity;
            this.field_70170_p.func_72838_d((Entity)entitywitherskull);
        }
    }

    public void inflictCustomStatusEffect(EnumDifficulty scaling, EntityLivingBase entity, Potion effect, int time, int power) {
        if ((scaling == EnumDifficulty.PEACEFUL || this.isOnSameTeam(entity)) && effect.func_76398_f()) {
            return;
        }
        if (scaling == EnumDifficulty.NORMAL) {
            time *= 2;
        }
        if (scaling == EnumDifficulty.HARD) {
            time *= 5;
        }
        if (time > 0) {
            entity.func_70690_d(new PotionEffect(effect, time * 20, power - 1 + scaling.func_151525_a()));
        }
    }

    public void inflictEngenderMobDamage(EntityLivingBase entity, String killmessage, DamageSource attacktype, float damage) {
        IAttributeInstance bonus = this.func_110148_a(SharedMonsterAttributes.field_111264_e);
        AttributeModifier vslight = new AttributeModifier(UUID.fromString("B9766B59-8566-4402-BC1F-3EE2A276D831"), "Light Bonus", (double)this.getBonusVSLight(), 1).func_111168_a(false);
        AttributeModifier vsarmored = new AttributeModifier(UUID.fromString("B9766B59-8566-4402-BC1F-3EE2A276D832"), "Armored Bonus", (double)this.getBonusVSArmored(), 1).func_111168_a(false);
        AttributeModifier vsmassive = new AttributeModifier(UUID.fromString("B9766B59-8566-4402-BC1F-3EE2A276D833"), "Massive Bonus", (double)this.getBonusVSMassive(), 1).func_111168_a(false);
        AttributeModifier vsflying = new AttributeModifier(UUID.fromString("B9766B59-8566-4402-BC1F-3EE2A276D834"), "Flying Bonus", (double)this.getBonusVSFlying(), 1).func_111168_a(false);
        AttributeModifier vstiny = new AttributeModifier(UUID.fromString("B9766B59-8566-4402-BC1F-3EE2A276D835"), "Tiny Bonus", (double)this.getBonusVSTiny(), 1).func_111168_a(false);
        AttributeModifier vselemental = new AttributeModifier(UUID.fromString("B9766B59-8566-4402-BC1F-3EE2A276D836"), "Elemental Bonus", (double)this.getBonusVSElemental(), 1).func_111168_a(false);
        AttributeModifier vsstructure = new AttributeModifier(UUID.fromString("B9766B59-8566-4402-BC1F-3EE2A276D837"), "Structure Bonus", (double)this.getBonusVSStructure(), 1).func_111168_a(false);
        AttributeModifier vsundead = new AttributeModifier(UUID.fromString("B9766B59-8566-4402-BC1F-3EE2A276D838"), "Undead Bonus", (double)this.getBonusVSUndead(), 1).func_111168_a(false);
        AttributeModifier vsender = new AttributeModifier(UUID.fromString("B9766B59-8566-4402-BC1F-3EE2A276D839"), "Ender Bonus", (double)this.getBonusVSEnder(), 1).func_111168_a(false);
        AttributeModifier vsanimal = new AttributeModifier(UUID.fromString("B9766B59-8566-4402-BC1F-3EE2A276D840"), "Animal Bonus", (double)this.getBonusVSAnimal(), 1).func_111168_a(false);
        if (entity instanceof EntityLivingBase) {
            if (entity instanceof Light && !bonus.func_180374_a(vslight)) {
                bonus.func_111121_a(vslight);
            }
            if (entity instanceof Armored && !bonus.func_180374_a(vsarmored)) {
                bonus.func_111121_a(vsarmored);
            }
            if (entity instanceof Flying && !bonus.func_180374_a(vsflying)) {
                bonus.func_111121_a(vsflying);
            }
            if (entity instanceof Massive && !bonus.func_180374_a(vsmassive)) {
                bonus.func_111121_a(vsmassive);
            }
            if (entity instanceof Tiny && !bonus.func_180374_a(vsmassive)) {
                bonus.func_111121_a(vsmassive);
            }
            if (entity instanceof Elemental && !bonus.func_180374_a(vsmassive)) {
                bonus.func_111121_a(vsmassive);
            }
            if (entity instanceof Structure && !bonus.func_180374_a(vsmassive)) {
                bonus.func_111121_a(vsmassive);
            }
            if (entity instanceof Undead && !bonus.func_180374_a(vsmassive)) {
                bonus.func_111121_a(vsmassive);
            }
            if (entity instanceof Ender && !bonus.func_180374_a(vsender)) {
                bonus.func_111121_a(vsender);
            }
            if (entity instanceof Animal && !bonus.func_180374_a(vsender)) {
                bonus.func_111121_a(vsender);
            }
        }
        if (!this.isOnSameTeam(entity) || entity instanceof EntityFriendlyCreature && this.isOnSameTeam((EntityLivingBase)((EntityFriendlyCreature)entity)) && this.getFakeHealth() > 0.0f) {
            entity.field_70721_aZ += 1.0f;
            damage *= (float)((this.func_70093_af() || this.func_82150_aj() || !this.func_70685_l((Entity)entity)) && entity instanceof EntityLiving && ((EntityLiving)entity).func_70638_az() != this ? 3 : 1) * (this.isHero() ? (entity instanceof IMob ? 3.0f : 1.5f) : 1.0f);
            try {
                ReflectionHelper.findField(entity.getClass(), (String[])new String[]{"recentlyHit", "field_70718_bc"}).setInt(entity, 100);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (Loader.isModLoaded((String)"iceandfire") && entity instanceof EntityLivingBase && EntityGorgon.isStoneMob((EntityLivingBase)entity)) {
                entity.field_70172_ad = 0;
            }
            if (Loader.isModLoaded((String)"draconicevolution") && entity instanceof EntityGuardianCrystal) {
                entity.func_70097_a(!this.isWild() ? DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)this.getOwner())) : new DamageSource("generic"), damage);
                ((EntityGuardianCrystal)entity).shieldTime = 0;
                entity.field_70159_w = 0.0;
                entity.field_70181_x = 0.0;
                entity.field_70179_y = 0.0;
            }
            if (attacktype.func_76346_g() != null && !(attacktype instanceof EntityDamageSourceIndirect) && this.func_110148_a(AGILITY).func_111125_b() >= this.field_70146_Z.nextDouble() * 10000.0) {
                entity.field_70172_ad = 0;
                damage *= 10.0f;
                this.func_184185_a(SoundEvents.field_187539_bB, 5.0f, 1.0f);
                if (EngenderMod.enableMessages && !this.isWild()) {
                    this.getOwner().func_145747_a((ITextComponent)new TextComponentTranslation(this.func_70005_c_() + " got a critical hit!", new Object[0]));
                }
            }
            if (entity instanceof IEntityMultiPart) {
                Entity mob;
                Entity[] aentity;
                if (entity != null && (aentity = entity.func_70021_al()) != null && (mob = aentity[this.field_70146_Z.nextInt(entity.func_70021_al().length)]) instanceof EntityDragonPart) {
                    ((IEntityMultiPart)entity).func_70965_a((EntityDragonPart)mob, entity instanceof EntityFriendlyCreature ? DamageSource.func_76358_a((EntityLivingBase)this) : DamageSource.func_76365_a((EntityPlayer)(this.isWild() ? this.field_70170_p.func_72890_a((Entity)this, -1.0) : (EntityPlayer)this.getOwner())), damage);
                }
            } else {
                entity.func_70097_a(attacktype, damage);
            }
            --entity.field_70172_ad;
            if (this.isABoss()) {
                entity.field_70172_ad = 0;
            }
            this.setCurrentStudy(EnumStudy.Combative, (int)(damage / 4.0f));
            if (EngenderMod.isWoodLikeMob((Entity)entity)) {
                if (damage >= 7.0f || attacktype.func_94541_c() || attacktype.func_151517_h() || attacktype.func_76363_c() || attacktype == DamageSource.field_82728_o || attacktype.func_76357_e() || attacktype.func_82725_o() || attacktype == DamageSource.field_76371_c) {
                    entity.func_184185_a(ModSoundEvents.woodHitCrush, 3.0f, 1.0f);
                } else if (attacktype.func_76352_a() && attacktype.func_76355_l() != "fireball") {
                    entity.func_184185_a(ModSoundEvents.woodHitPierce, 3.0f, 1.0f);
                } else {
                    entity.func_184185_a(ModSoundEvents.woodHit, 3.0f, 1.0f);
                }
            } else if (EngenderMod.isMetalLikeMob((Entity)entity)) {
                if (damage >= 7.0f || attacktype.func_94541_c() || attacktype.func_151517_h() || attacktype.func_76363_c() || attacktype == DamageSource.field_82728_o || attacktype.func_76357_e() || attacktype.func_82725_o() || attacktype == DamageSource.field_76371_c) {
                    entity.func_184185_a(ModSoundEvents.metalHitCrush, 3.0f, 1.0f);
                } else if (attacktype.func_76352_a() && attacktype.func_76355_l() != "fireball") {
                    entity.func_184185_a(ModSoundEvents.metalHitPierce, 3.0f, 1.0f);
                } else {
                    entity.func_184185_a(ModSoundEvents.metalHit, 3.0f, 1.0f);
                }
            } else if (damage >= 7.0f || attacktype.func_94541_c() || attacktype.func_151517_h() || attacktype.func_76363_c() || attacktype == DamageSource.field_82728_o || attacktype.func_76357_e() || attacktype.func_82725_o() || attacktype == DamageSource.field_76371_c) {
                if (entity.field_70131_O >= 5.0f) {
                    entity.func_184185_a(ModSoundEvents.fleshHitCrushHeavy, 3.0f, 1.0f);
                } else {
                    entity.func_184185_a(ModSoundEvents.fleshHitCrush, 3.0f, 1.0f);
                }
            } else if (attacktype.func_76352_a() && attacktype.func_76355_l() != "fireball") {
                entity.func_184185_a(ModSoundEvents.fleshHitPierce, 3.0f, 1.0f);
            } else {
                entity.func_184185_a(ModSoundEvents.fleshHit, 3.0f, 1.0f);
            }
            entity.field_70721_aZ += 1.0f;
            if (entity.func_110143_aJ() > 1.0f) {
                entity.func_70606_j(entity.func_110143_aJ() - (this.isHero() ? 0.03f : 0.01f));
            }
            if (EngenderMod.enableMessages && !entity.func_70089_S() && !this.isWild() && entity.func_110143_aJ() <= 0.0f) {
                boolean flag1 = false;
                try {
                    flag1 = ReflectionHelper.findField(entity.getClass(), (String[])new String[]{"dead", "field_70729_aU"}).getBoolean(entity);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!flag1) {
                    this.setCurrentStudy(EnumStudy.Combative, (int)entity.func_110138_aP());
                    this.getOwner().func_145747_a((ITextComponent)new TextComponentTranslation(entity.func_70005_c_() + killmessage + this.func_70005_c_() + " (" + this.getOwner().func_70005_c_() + ")", new Object[0]));
                }
            }
            if (bonus.func_180374_a(vslight)) {
                bonus.func_111124_b(vslight);
            }
            if (bonus.func_180374_a(vsarmored)) {
                bonus.func_111124_b(vsarmored);
            }
            if (bonus.func_180374_a(vsmassive)) {
                bonus.func_111124_b(vsmassive);
            }
            if (bonus.func_180374_a(vsflying)) {
                bonus.func_111124_b(vsflying);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_145770_h(double x, double y, double z) {
        return true;
    }

    protected final void func_70105_a(float width, float height) {
        if (this.field_70173_aa >= 1 && this.getTier() != EnumTier.TIER6) {
            float fit = this.getFittness();
            width *= fit;
            height *= fit;
        }
        if (this.func_70631_g_()) {
            width *= 0.5f;
            height *= 0.5f;
        } else {
            width *= 1.0f;
            height *= 1.0f;
        }
        this.reachWidth = width;
        if (width != this.field_70130_N || height != this.field_70131_O) {
            float f = this.field_70130_N;
            this.field_70130_N = width;
            this.field_70131_O = height;
            if (this.field_70130_N < f) {
                double d0 = (double)width / 2.0;
                this.func_174826_a(new AxisAlignedBB(this.field_70165_t - d0, this.field_70163_u, this.field_70161_v - d0, this.field_70165_t + d0, this.field_70163_u + (double)this.field_70131_O, this.field_70161_v + d0));
                return;
            }
            AxisAlignedBB axisalignedbb = this.func_174813_aQ();
            this.func_174826_a(new AxisAlignedBB(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b, axisalignedbb.field_72339_c, axisalignedbb.field_72340_a + (double)this.field_70130_N, axisalignedbb.field_72338_b + (double)this.field_70131_O, axisalignedbb.field_72339_c + (double)this.field_70130_N));
        }
    }

    public int getGrowingAge() {
        return (Integer)this.field_70180_af.func_187225_a(AGE);
    }

    public void setGrowingAge(int age) {
        this.field_70180_af.func_187227_b(AGE, (Object)age);
        if (age == 0) {
            this.resetInLove();
        }
        if (age < 0 && !this.func_70631_g_()) {
            this.setChild(true);
        }
    }

    public int getLevel() {
        return (Integer)this.field_70180_af.func_187225_a(LEVEL);
    }

    public void setLevel(int age) {
        this.field_70180_af.func_187227_b(LEVEL, (Object)age);
    }

    public float getEXP() {
        return ((Float)this.field_70180_af.func_187225_a(EXP)).floatValue();
    }

    public void setEXP(float age) {
        this.field_70180_af.func_187227_b(EXP, (Object)Float.valueOf(age));
    }

    public float getTotalEXP() {
        return ((Float)this.field_70180_af.func_187225_a(TOTALEXP)).floatValue();
    }

    public void setTotalEXP(float age) {
        this.field_70180_af.func_187227_b(TOTALEXP, (Object)Float.valueOf(age));
    }

    public int getNextLevelRequirement() {
        return 5;
    }

    public boolean func_180427_aV() {
        return this.field_70173_aa <= 20 || this.lastChanceInvul > 0 || this.isHero() || this.func_175446_cd();
    }

    public boolean takesFallDamage() {
        return !this.func_184207_aI() || this.getFakeHealth() > 0.0f || this.lastChanceInvul > 0 || this instanceof Flying || this instanceof Massive;
    }

    protected void func_70619_bc() {
        Block block;
        IBlockState iblockstate;
        BlockPos blockpos;
        int l;
        int k;
        int i3;
        int j;
        int l2;
        int k2;
        boolean flag;
        int i2;
        this.setGrowingAge(this.getGrowingAge() + 1);
        if (!this.isWild() && !this.getOwner().func_184614_ca().func_190926_b() && this.getOwner().func_184614_ca().func_77973_b() == SpawnerItems.weddingring) {
            this.func_70671_ap().func_75651_a((Entity)this.getOwner(), (float)this.func_184649_cE(), (float)this.func_70646_bf());
        }
        if (this.getGrowingAge() < 0) {
            this.inLove = 0;
        }
        if (this.getGrowingAge() < 0 && !this.func_70631_g_()) {
            this.setChild(true);
        } else if (this.getGrowingAge() >= 0 && this.func_70631_g_()) {
            this.setChild(false);
            this.field_70173_aa = 1;
            this.func_184185_a(ModSoundEvents.hero, 1.0f, 1.5f);
        }
        if (this.getGuardBlock() != null) {
            IBlockState iblockstate2;
            Block block2;
            if (this.field_70173_aa % 20 == 0 && this.field_70146_Z.nextInt(20) == 0 || this.randPosX == (double)this.getGuardBlock().func_177958_n() && this.randPosZ == (double)this.getGuardBlock().func_177952_p()) {
                this.randPosX = (float)this.getGuardBlock().func_177958_n() + (this.field_70146_Z.nextFloat() * 24.0f - 12.0f);
                this.randPosZ = (float)this.getGuardBlock().func_177952_p() + (this.field_70146_Z.nextFloat() * 24.0f - 12.0f);
                this.randPosY = this.field_70170_p.func_175672_r(new BlockPos(this.randPosX, 1.0, this.randPosZ)).func_177956_o();
            }
            BlockPos blockPos = new BlockPos(this.randPosX, this.randPosY, this.randPosZ);
            if (this.func_174831_c(blockPos) > 4.0 && this.func_70638_az() == null) {
                this.func_70661_as().func_75492_a(this.randPosX, this.randPosY, this.randPosZ, 1.0);
                this.func_70671_ap().func_75650_a(this.randPosX, this.randPosY, this.randPosZ, 10.0f, 0.0f);
                BlockPos blockPos2 = new BlockPos(this.randPosX, this.randPosY, this.randPosZ);
                if (this.func_174831_c(blockPos2) > this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e() * this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e()) {
                    this.func_70107_b(this.randPosX, this.randPosY + 1.0, this.randPosZ);
                    if (this.func_184218_aH()) {
                        this.func_184187_bx().func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                    }
                }
            }
            if (!((block2 = (iblockstate2 = this.field_70170_p.func_180495_p(this.getGuardBlock())).func_177230_c()) instanceof BlockGuardBlock)) {
                this.setGuardBlock(null);
            }
        } else {
            this.randPosX = this.field_70165_t;
            this.randPosY = this.field_70163_u;
            this.randPosZ = this.field_70161_v;
        }
        if (Loader.isModLoaded((String)"abyssalcraft") && this.field_71088_bW <= 0 && this.func_70638_az() == null && !this.isWild() && !this.func_184218_aH() && !this.func_184207_aI()) {
            int i11 = MathHelper.func_76128_c((double)this.getOwner().field_70163_u);
            int l1 = MathHelper.func_76128_c((double)this.getOwner().field_70165_t);
            i2 = MathHelper.func_76128_c((double)this.getOwner().field_70161_v);
            flag = false;
            for (k2 = -2; k2 <= 2; ++k2) {
                for (l2 = -2; l2 <= 2; ++l2) {
                    for (j = -2; j <= 2; ++j) {
                        i3 = l1 + k2;
                        k = i11 + j;
                        l = i2 + l2;
                        blockpos = new BlockPos((double)i3 + 0.5, (double)k, (double)l + 0.5);
                        iblockstate = this.field_70170_p.func_180495_p(blockpos);
                        block = iblockstate.func_177230_c();
                        if (!(block instanceof BlockAbyssPortal) && !(block instanceof BlockDreadlandsPortal) && !(block instanceof BlockOmotholPortal) || this.field_70170_p.func_180495_p(blockpos.func_177977_b()).func_177230_c() == Blocks.field_150350_a || this.field_70170_p.func_180495_p(blockpos.func_177977_b()).func_177230_c() == Blocks.field_150427_aO) continue;
                        if (this instanceof EntityVex || this instanceof EntityGhast) {
                            this.func_70605_aq().func_75642_a((double)i3, (double)k, (double)l, 1.0);
                        } else {
                            this.func_70661_as().func_75492_a((double)i3, (double)k, (double)l, 1.0);
                        }
                        if (!(this instanceof EntityGuardian) && !(this instanceof EntityShulker) && !(this instanceof EntityGhast) && !(this.func_174831_c(blockpos) < 4.0)) continue;
                        this.func_70634_a((double)i3 + 0.5, k, (double)l + 0.5);
                        if (!(this instanceof EntityShulker)) continue;
                        this.func_184185_a(SoundEvents.field_187791_eX, this.func_70599_aP(), 0.95f);
                    }
                }
            }
        }
        if (!(this.field_71088_bW > 0 || this.func_70638_az() != null || this.isWild() || this.func_184218_aH() || this.func_184207_aI())) {
            int i11 = MathHelper.func_76128_c((double)this.getOwner().field_70163_u);
            int l1 = MathHelper.func_76128_c((double)this.getOwner().field_70165_t);
            i2 = MathHelper.func_76128_c((double)this.getOwner().field_70161_v);
            flag = false;
            for (k2 = -2; k2 <= 2; ++k2) {
                for (l2 = -2; l2 <= 2; ++l2) {
                    for (j = -2; j <= 2; ++j) {
                        i3 = l1 + k2;
                        k = i11 + j;
                        l = i2 + l2;
                        blockpos = new BlockPos((double)i3 + 0.5, (double)k, (double)l + 0.5);
                        iblockstate = this.field_70170_p.func_180495_p(blockpos);
                        block = iblockstate.func_177230_c();
                        if (!(block instanceof BlockEndGateway) && !(block instanceof BlockEndPortal) && !(block instanceof BlockPortal) || this.field_70170_p.func_180495_p(blockpos.func_177977_b()).func_177230_c() == Blocks.field_150350_a || this.field_70170_p.func_180495_p(blockpos.func_177977_b()).func_177230_c() == Blocks.field_150427_aO) continue;
                        if (this instanceof EntityVex || this instanceof EntityGhast) {
                            this.func_70605_aq().func_75642_a((double)i3, (double)k, (double)l, 1.0);
                        } else {
                            this.func_70661_as().func_75492_a((double)i3, (double)k, (double)l, 1.0);
                        }
                        if (!(this instanceof EntityGuardian) && !(this instanceof EntityShulker) && !(this instanceof EntityGhast) && !(this.func_174831_c(blockpos) < 4.0)) continue;
                        if (block instanceof BlockEndPortal && !this.func_184222_aU()) {
                            this.func_184204_a(1);
                        }
                        this.func_70634_a((double)i3 + 0.5, k, (double)l + 0.5);
                        if (this instanceof EntityShulker) {
                            this.func_184185_a(SoundEvents.field_187791_eX, this.func_70599_aP(), 0.95f);
                        }
                        if (!(block instanceof BlockEndGateway)) continue;
                        this.field_70170_p.func_175698_g(blockpos.func_177981_b(1));
                        this.field_70170_p.func_175698_g(blockpos.func_177981_b(2));
                        this.field_70170_p.func_175698_g(blockpos.func_177981_b(1).func_177974_f());
                        this.field_70170_p.func_175698_g(blockpos.func_177981_b(1).func_177978_c());
                        this.field_70170_p.func_175698_g(blockpos.func_177981_b(1).func_177976_e());
                        this.field_70170_p.func_175698_g(blockpos.func_177981_b(1).func_177968_d());
                    }
                }
            }
        }
        if (Loader.isModLoaded((String)"abyssalcraft") && this.field_70173_aa > 220 && this.func_70638_az() == null && !this.isWild()) {
            int i11 = MathHelper.func_76128_c((double)this.getOwner().field_70163_u);
            int l1 = MathHelper.func_76128_c((double)this.getOwner().field_70165_t);
            i2 = MathHelper.func_76128_c((double)this.getOwner().field_70161_v);
            flag = false;
            for (k2 = -2; k2 <= 2; ++k2) {
                for (l2 = -2; l2 <= 2; ++l2) {
                    for (j = -2; j <= 2; ++j) {
                        i3 = l1 + k2;
                        k = i11 + j;
                        l = i2 + l2;
                        blockpos = new BlockPos((double)i3 + 0.5, (double)k, (double)l + 0.5);
                        iblockstate = this.field_70170_p.func_180495_p(blockpos);
                        block = iblockstate.func_177230_c();
                        if (!(block instanceof BlockAbyssPortal) && !(block instanceof BlockDreadlandsPortal) && !(block instanceof BlockOmotholPortal) || !this.field_70170_p.func_180495_p(blockpos.func_177977_b()).func_177230_c().func_149662_c(this.field_70170_p.func_180495_p(blockpos.func_177977_b()))) continue;
                        if (this instanceof EntityVex || this instanceof EntityGhast) {
                            this.func_70605_aq().func_75642_a((double)i3, (double)k, (double)l, 1.0);
                        } else {
                            this.func_70661_as().func_75492_a((double)i3, (double)k, (double)l, 1.0);
                        }
                        if (!(this instanceof EntityGuardian) && !(this instanceof EntityShulker) && !(this instanceof EntityGhast) && !(this.func_174831_c(blockpos) < 4.0)) continue;
                        if (block instanceof BlockAbyssPortal && (!this.func_184222_aU() || this.func_184207_aI() || this.func_184218_aH())) {
                            if (this.field_71093_bK == ACLib.abyssal_wasteland_id) {
                                this.func_184204_a(0);
                            } else {
                                this.func_184204_a(ACLib.abyssal_wasteland_id);
                            }
                        }
                        if (block instanceof BlockDreadlandsPortal && (!this.func_184222_aU() || this.func_184207_aI() || this.func_184218_aH())) {
                            if (this.field_71093_bK == ACLib.dreadlands_id) {
                                this.func_184204_a(ACLib.abyssal_wasteland_id);
                            } else {
                                this.func_184204_a(ACLib.dreadlands_id);
                            }
                        }
                        if (block instanceof BlockOmotholPortal && (!this.func_184222_aU() || this.func_184207_aI() || this.func_184218_aH())) {
                            if (this.field_71093_bK == ACLib.omothol_id) {
                                this.func_184204_a(ACLib.dreadlands_id);
                            } else {
                                this.func_184204_a(ACLib.omothol_id);
                            }
                        }
                        this.func_70634_a((double)i3 + 0.5, k, (double)l + 0.5);
                        if (!(this instanceof EntityShulker)) continue;
                        this.func_184185_a(SoundEvents.field_187791_eX, this.func_70599_aP(), 0.95f);
                    }
                }
            }
        }
        if (!this.field_70145_X && this.func_70094_T()) {
            this.field_70159_w += this.field_70146_Z.nextDouble() - 0.5;
            this.field_70179_y += this.field_70146_Z.nextDouble() - 0.5;
            this.field_70181_x += 0.5;
            this.func_70107_b(this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v);
            if (this.func_184218_aH() && this.func_184187_bx().func_70094_T()) {
                this.func_184187_bx().field_70159_w += this.field_70146_Z.nextDouble() - 0.5;
                this.func_184187_bx().field_70179_y += this.field_70146_Z.nextDouble() - 0.5;
                this.func_184187_bx().field_70181_x += 0.5;
                this.func_184187_bx().func_70107_b(this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v);
            }
        }
        if (this.field_70173_aa > 20 && this.func_70089_S()) {
            super.func_70619_bc();
        }
    }

    public double getKnockbackResistance() {
        return this.func_110148_a(STRENGTH).func_111125_b() / 100.0;
    }

    public boolean canUseGuardBlock() {
        return !this.func_70631_g_() && !this.isInLove() && !this.isCameo();
    }

    public boolean canTrample(World world, Block block, BlockPos pos, float fallDistance) {
        return false;
    }

    public boolean func_70687_e(PotionEffect potioneffectIn) {
        Potion potion = potioneffectIn.func_188419_a();
        if (this.func_70662_br() && (potion == MobEffects.field_76428_l || potion == MobEffects.field_76436_u)) {
            return false;
        }
        if (this.isEntityImmuneToCoralium() && potion.func_76393_a() == "potion.Cplague") {
            this.func_70688_c(potioneffectIn);
            return false;
        }
        if (this.isEntityImmuneToDread() && potion.func_76393_a() == "potion.Dplague") {
            this.func_70688_c(potioneffectIn);
            return false;
        }
        if (this.isEntityImmuneToAntiMatter() && potion.func_76393_a() == "potion.Antimatter") {
            this.func_70688_c(potioneffectIn);
            return false;
        }
        return true;
    }

    public boolean isInLove() {
        return this.inLove > 0;
    }

    public void resetInLove() {
        this.inLove = 0;
    }

    public void setInLove(EntityPlayer player) {
        this.inLove = 600;
    }

    public double func_70033_W() {
        return this.field_70131_O <= 0.5f ? 0.2 : 0.0;
    }

    public void func_184210_p() {
        Entity entity = this.func_184187_bx();
        super.func_184210_p();
        if (entity != null && entity != this.func_184187_bx()) {
            this.func_82149_j(entity);
            this.field_70167_r = this.field_70163_u += (double)entity.field_70131_O;
            this.field_70137_T = this.field_70163_u;
        }
    }

    public EntityFriendlyCreature spawnBaby(EntityFriendlyCreature par1EntityAgeable) {
        return null;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        ItemStack heldItem = new ItemStack(itemstack.func_77973_b());
        if (this.func_70089_S() && this.isOnSameTeam((EntityLivingBase)player) && itemstack.func_77973_b() != null && !itemstack.func_190926_b() && itemstack.func_77973_b() == SpawnerItems.statChecker) {
            itemstack.func_77973_b().func_111207_a(itemstack, player, (EntityLivingBase)this, hand);
            return true;
        }
        if (itemstack.func_190926_b() && player.func_70093_af() && this.getGuardBlock() != null) {
            player.func_184609_a(hand);
            this.func_184185_a(SoundEvents.field_187941_ho, 1.0f, 2.0f);
            this.func_70656_aK();
            this.randPosX = this.field_70165_t;
            this.randPosY = this.field_70163_u;
            this.randPosZ = this.field_70161_v;
            this.setGuardBlock(null);
            return true;
        }
        if (itemstack.func_77973_b() != null && !itemstack.func_190926_b() && this.getBookID() == 0 && itemstack.func_77973_b() instanceof ItemLearningBook) {
            player.func_184609_a(hand);
            int i = 0;
            while (true) {
                if (i >= books.length) break;
                if (itemstack.func_77973_b() == books[i]) {
                    this.setBookID(i);
                    break;
                }
                ++i;
            }
            this.setBookDurability(itemstack.func_77952_i());
            heldItem = new ItemStack(books[this.getBookID()], 1, this.getBookDurability());
            heldItem.func_77982_d(itemstack.func_77978_p());
            heldItem.func_77964_b(itemstack.func_77952_i());
            itemstack.func_190918_g(1);
            return true;
        }
        if (this.getBookID() != 0 && itemstack.func_190926_b()) {
            player.func_184609_a(hand);
            this.func_184185_a(SoundEvents.field_187694_dK, 1.0f, 1.3f + this.field_70146_Z.nextFloat() * 0.4f);
            if (!this.field_70170_p.field_72995_K) {
                this.func_70099_a(new ItemStack(books[this.getBookID()], 1, this.getBookDurability()), 1.0f);
            }
            this.setBookID(0);
            this.setBookDurability(0);
            return true;
        }
        if (itemstack.func_77973_b() == Items.field_151063_bx) {
            EntityFriendlyCreature entityageable;
            Class oclass;
            if (!this.field_70170_p.field_72995_K && (oclass = EntityList.getClass((ResourceLocation)ItemMonsterPlacer.func_190908_h((ItemStack)itemstack))) != null && this.getClass() == oclass && (entityageable = this.spawnBaby(this)) != null) {
                entityageable.setOwnerId(this.func_184753_b());
                entityageable.func_82149_j((Entity)this);
                this.field_70170_p.func_72838_d((Entity)entityageable);
                entityageable.func_180482_a(this.field_70170_p.func_175649_E(this.func_180425_c()), null);
                entityageable.setGrowingAge(-24000);
                if (itemstack.func_82837_s()) {
                    entityageable.func_96094_a(itemstack.func_82833_r());
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
            }
            return true;
        }
        if (this.func_70631_g_()) {
            if (this.hasOwner(player)) {
                player.func_184609_a(EnumHand.MAIN_HAND);
                if (this.func_184187_bx() == null) {
                    this.func_184205_a((Entity)player, true);
                } else {
                    this.func_184210_p();
                }
            }
            return true;
        }
        if (this.hasOwner(player) && this.func_184187_bx() != null) {
            player.func_184609_a(EnumHand.MAIN_HAND);
            this.func_184210_p();
            return true;
        }
        if (EngenderMod.enableBreeding && this.canBeMatedWith() && itemstack.func_77973_b() == Items.field_151153_ao && itemstack.func_77960_j() == (this.getTier() == EnumTier.TIER5 || this.getTier() == EnumTier.TIER6 ? 1 : 0)) {
            if (this.hasOwner(player)) {
                if (this.isInLove()) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation(this.func_70005_c_() + " is already horny!!", new Object[0]), true);
                } else if (this.getGrowingAge() < 4000) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation(this.func_70005_c_() + " can't breed yet as they're too tired!", new Object[0]), true);
                } else if (this.getJukeboxToDanceTo() != null) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("You can't breed with " + this.func_70005_c_() + " as she's already having fun!", new Object[0]), true);
                } else if (this.func_70638_az() != null) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("You can't breed with " + this.func_70005_c_() + " as it isn't safe yet!", new Object[0]), true);
                } else if (this.func_180799_ab()) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("You can't breed with " + this.func_70005_c_() + " as she's swimming in lava!", new Object[0]), true);
                } else if (this.func_70027_ad()) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("You can't breed with " + this.func_70005_c_() + " as she's on fire!", new Object[0]), true);
                } else if (this.field_70134_J) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("You can't breed with " + this.func_70005_c_() + " as she's too stuck in a web to do anything!", new Object[0]), true);
                } else if (!this.func_70089_S()) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("You can't breed with a dead girl...", new Object[0]), true);
                } else {
                    this.setInLove(player);
                    player.func_184609_a(EnumHand.MAIN_HAND);
                    itemstack.func_190918_g(1);
                }
            }
            return true;
        }
        if (itemstack.func_77973_b().func_111207_a(itemstack, player, (EntityLivingBase)this, hand)) {
            return true;
        }
        if (this.canWearEasterEggs() && this.isOnSameTeam((EntityLivingBase)player) && !itemstack.func_190926_b() && this.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b() && (itemstack.func_77973_b() == Items.field_151144_bL || itemstack.func_77973_b() == Items.field_151115_aP || itemstack.func_77973_b() == Items.field_151103_aS || itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_185764_cQ) || itemstack.func_77973_b() == Items.field_151008_G)) {
            this.func_184201_a(EntityEquipmentSlot.HEAD, itemstack);
            this.func_184606_a_(itemstack);
            player.func_184609_a(hand);
            if (!this.field_70170_p.field_72995_K) {
                heldItem.func_77982_d(itemstack.func_77978_p());
                heldItem.func_77964_b(itemstack.func_77952_i());
                this.func_184201_a(EntityEquipmentSlot.HEAD, heldItem);
                itemstack.func_190918_g(1);
            }
            return true;
        }
        if (this.canWearEasterEggs() && this.isOnSameTeam((EntityLivingBase)player) && player.func_70093_af() && itemstack.func_190926_b() && !this.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b()) {
            this.dropEquipmentUndamaged();
            player.func_184609_a(hand);
            return true;
        }
        if (this.isOnSameTeam((EntityLivingBase)player) && !itemstack.func_190926_b() && this.func_184582_a(EntityEquipmentSlot.MAINHAND).func_190926_b() && itemstack.func_77973_b() != Items.field_151057_cb && itemstack.func_77973_b() instanceof ItemFood && this.getEnergy() <= 100.0f) {
            this.func_184185_a(SoundEvents.field_187739_dZ, 1.0f, 1.0f);
            player.func_184609_a(hand);
            if (!this.field_70170_p.field_72995_K) {
                heldItem.func_77982_d(itemstack.func_77978_p());
                heldItem.func_77964_b(itemstack.func_77952_i());
                heldItem.func_190920_e(itemstack.func_190916_E());
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, heldItem);
                itemstack.func_190918_g(itemstack.func_190916_E());
            }
            return true;
        }
        return this.interact(player, hand);
    }

    public boolean canWearEasterEggs() {
        return true;
    }

    public boolean interact(EntityPlayer player, EnumHand hand) {
        return false;
    }

    protected void func_82160_b(boolean wasRecentlyHit, int lootingModifier) {
        super.func_82160_b(wasRecentlyHit, lootingModifier);
        if (!this.getCurrentBook().func_190926_b()) {
            this.func_184185_a(SoundEvents.field_187694_dK, 1.0f, 1.3f + this.field_70146_Z.nextFloat() * 0.4f);
            if (!this.field_70170_p.field_72995_K) {
                this.func_70099_a(new ItemStack(books[this.getBookID()], 1, this.getBookDurability()), 1.0f);
            }
            this.setBookID(0);
            this.setBookDurability(0);
        }
        if (this.isMarried() && !this.field_70170_p.field_72995_K) {
            ((EntityPlayerMP)this.getOwner()).func_145747_a((ITextComponent)new TextComponentTranslation("Your wife is unconcious!", new Object[0]));
            ItemStack stack = new ItemStack(SpawnerItems.weddingring);
            stack.func_77982_d(new NBTTagCompound());
            NBTTagCompound tag = this.serializeNBT();
            stack.func_77978_p().func_74782_a("Entity", (NBTBase)tag);
            stack.func_77978_p().func_74778_a("EntityName", this.func_70005_c_());
            EntityItem entityitem = new EntityItem(this.field_70170_p, this.getOwner().field_70165_t, this.getOwner().field_70163_u, this.getOwner().field_70161_v, stack);
            entityitem.func_174869_p();
            this.field_70170_p.func_72838_d((Entity)entityitem);
        }
    }

    public int func_70646_bf() {
        return !this.func_70089_S() ? 180 : 60;
    }

    protected void func_70609_aI() {
        this.field_70761_aq = this.field_70177_z = this.field_70759_as;
        this.func_70661_as().func_75499_g();
        this.func_70066_B();
        this.func_70674_bp();
        this.func_70624_b(null);
        if (this.field_70122_E) {
            ++this.field_70725_aQ;
            this.field_70721_aZ = 0.0f;
            this.field_184619_aG = 0.0f;
            this.setArmsRaised(false);
            this.rotationPitchFalling = 0.0f;
            this.prevRotationPitchFalling = 0.0f;
        } else {
            this.field_70725_aQ = this.getTier() == EnumTier.TIER6 || this instanceof EntityVex || this instanceof EntityShulker || this instanceof EntityWither ? ++this.field_70725_aQ : 0;
        }
        if (!this.field_70170_p.field_72995_K && this.field_70725_aQ == 2) {
            this.field_70714_bg.field_75782_a.clear();
            this.field_70715_bh.field_75782_a.clear();
            this.field_70761_aq = this.field_70177_z = this.field_70759_as;
            if (this.getOwner() != null && this.isHero()) {
                for (EntityPlayer entityplayer : this.field_70170_p.field_73010_i) {
                    entityplayer.func_146105_b((ITextComponent)new TextComponentTranslation("\u00a74" + this.getOwner().func_70005_c_() + "'s " + this.func_70005_c_() + " has been killed!!!", new Object[0]), true);
                }
                ((EntityPlayerMP)this.getOwner()).func_145747_a((ITextComponent)new TextComponentTranslation("A Hero mob has fallen!", new Object[0]));
            }
            if (!this.field_70170_p.field_72995_K && this.func_146066_aG() && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
                int j;
                int i = this.func_70693_a(this.field_70717_bb);
                for (i = ForgeEventFactory.getExperienceDrop((EntityLivingBase)this, (EntityPlayer)this.field_70717_bb, (int)i); i > 0; i -= j) {
                    j = EntityXPOrb.func_70527_a((int)i);
                    this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v, j));
                }
                this.field_70728_aV = 0;
            }
        }
        if (this.field_70718_bc > 0) {
            ++this.field_70718_bc;
        }
        if (this.field_70725_aQ < 22 && this.field_70725_aQ > 2) {
            this.field_70125_A -= 1.0f;
        }
        if (this.field_70725_aQ > 40) {
            if (this.field_70122_E) {
                this.func_94061_f(true);
            }
            if (this.field_70725_aQ > 80 && !this.field_70170_p.func_180495_p(this.func_180425_c().func_177981_b((int)this.field_70131_O + 1)).func_185904_a().func_76220_a()) {
                this.field_70163_u -= 0.00125;
            }
        }
        if (this.field_70170_p.func_82736_K().func_82766_b("disableCorpses") && this.field_70725_aQ > 20) {
            this.field_70725_aQ = 1600;
        }
        if (!this.field_70170_p.field_72995_K && this.field_70725_aQ >= (this.isMarried() || this.getTier() == EnumTier.TIER6 || this instanceof EntityDragonMinion || this instanceof EntityVex || this instanceof EntityShulker || this instanceof EntitySlime ? 20 : 1600)) {
            this.field_70170_p.func_72900_e((Entity)this);
        }
    }

    public void func_70645_a(DamageSource cause) {
        if (cause.func_76355_l() == "antimatter") {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b() * 2.0);
            this.func_70606_j(this.func_110138_aP());
            this.field_70725_aQ = 0;
            this.field_70729_aU = false;
            this.setIsAntiMob(true);
            this.field_70173_aa = 0;
            this.field_70759_as = 0.0f;
            this.field_70177_z = 0.0f;
            this.field_70761_aq = 0.0f;
            this.field_70125_A = 0.0f;
            int i = this.field_70728_aV;
            if (this instanceof EntityEvoker) {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_190929_cY));
                this.func_184642_a(EntityEquipmentSlot.MAINHAND, 0.0f);
                this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(Items.field_190929_cY));
                this.func_184642_a(EntityEquipmentSlot.OFFHAND, 0.0f);
            }
            while (i > 0 && !this.field_70170_p.field_72995_K) {
                int j = EntityXPOrb.func_70527_a((int)i);
                i -= j;
                this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
            }
        } else if (this.hasLastChance()) {
            this.lastChanceInvul = 200;
            this.func_70606_j(1.0f);
            this.func_70674_bp();
            this.inflictCustomStatusEffect(EnumDifficulty.PEACEFUL, (EntityLivingBase)this, MobEffects.field_188423_x, 10, 1);
            this.func_70604_c(null);
            this.func_70624_b(null);
            this.setEnergy(100.0f);
            this.field_70170_p.func_72960_a((Entity)this, (byte)35);
            if (!this.isWild()) {
                this.func_82149_j((Entity)this.getOwner());
            }
            this.setLastChance(false);
        } else {
            if (EngenderMod.enableMessages && !this.isWild() && this.getOwner() instanceof EntityPlayerMP && !(this instanceof EntityWitherStormHead) && !(this instanceof EntityWitherStormTentacle) && !(this instanceof EntityWitherStormTentacleDevourer)) {
                if (!this.field_70170_p.field_72995_K) {
                    ((EntityPlayerMP)this.getOwner()).func_145747_a(this.func_110142_aN().func_151521_b());
                }
                this.field_70170_p.func_184133_a((EntityPlayer)((EntityPlayerMP)this.getOwner()), this.getOwner().func_180425_c(), this.func_184615_bR(), this.func_184176_by(), this.func_70599_aP(), this.func_70647_i());
                ForgeHooks.onLivingDeath((EntityLivingBase)this, (DamageSource)DamageSource.func_76358_a((EntityLivingBase)this.getOwner()));
            }
            this.dropEquipmentUndamaged();
            if (cause.func_76346_g() != null && cause.func_76346_g() instanceof EntityPlayer && !this.isOnSameTeam((EntityLivingBase)((EntityPlayer)cause.func_76346_g())) && !this.field_70170_p.field_72995_K) {
                ((EntityPlayer)cause.func_76346_g()).func_71029_a((StatBase)EngenderAchievments.firstMurder);
                if (this.getTier() == EnumTier.TIER5) {
                    ((EntityPlayer)cause.func_76346_g()).func_71029_a((StatBase)EngenderAchievments.killTier5);
                }
            }
            this.func_70624_b(null);
            this.func_70604_c(null);
            if (this instanceof Flying) {
                float xRatio = MathHelper.func_76126_a((float)(this.field_70759_as * ((float)Math.PI / 180)));
                float zRatio = -MathHelper.func_76134_b((float)(this.field_70759_as * ((float)Math.PI / 180)));
                float f = MathHelper.func_76129_c((float)(xRatio * xRatio + zRatio * zRatio));
                this.field_70159_w -= (double)xRatio / (double)f * (double)((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() + 1.0f);
                this.field_70179_y -= (double)zRatio / (double)f * (double)((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() + 1.0f);
            }
            super.func_70645_a(cause);
        }
    }

    protected void func_82167_n(Entity p_82167_1_) {
        if (this.func_70643_av() == null && p_82167_1_ instanceof EntityLivingBase && !this.isOnSameTeam((EntityLivingBase)p_82167_1_) && (!(p_82167_1_ instanceof EntityPlayer) || p_82167_1_ instanceof EntityPlayer && !((EntityPlayer)p_82167_1_).field_71075_bZ.field_75102_a)) {
            this.func_70624_b((EntityLivingBase)p_82167_1_);
        }
        if (p_82167_1_ instanceof EntityLivingBase && this.func_70089_S()) {
            super.func_82167_n(p_82167_1_);
        }
    }

    public void func_70074_a(EntityLivingBase entityLivingIn) {
        super.func_70074_a(entityLivingIn);
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() * (this.func_70631_g_() ? 0.5f : 1.0f) * (float)((this.func_70093_af() || this.func_82150_aj() || !this.func_70685_l((Entity)entityLivingIn)) && entityLivingIn instanceof EntityLiving && ((EntityLiving)entityLivingIn).func_70638_az() != this ? 3 : 1) * (this.isHero() ? (entityLivingIn instanceof IMob ? 3.0f : 1.5f) : 1.0f);
        if (EngenderMod.isWoodLikeMob((Entity)entityLivingIn)) {
            if (f >= 7.0f) {
                entityLivingIn.func_184185_a(ModSoundEvents.woodHitCrush, 3.0f, 1.0f);
            } else {
                entityLivingIn.func_184185_a(ModSoundEvents.woodHit, 3.0f, 1.0f);
            }
        } else if (EngenderMod.isMetalLikeMob((Entity)entityLivingIn)) {
            if (f >= 7.0f) {
                entityLivingIn.func_184185_a(ModSoundEvents.metalHitCrush, 3.0f, 1.0f);
            } else {
                entityLivingIn.func_184185_a(ModSoundEvents.metalHit, 3.0f, 1.0f);
            }
        } else if (f >= 7.0f) {
            if (entityLivingIn.field_70131_O >= 5.0f) {
                entityLivingIn.func_184185_a(ModSoundEvents.fleshHitCrushHeavy, 3.0f, 1.0f);
            } else {
                entityLivingIn.func_184185_a(ModSoundEvents.fleshHitCrush, 3.0f, 1.0f);
            }
        } else {
            entityLivingIn.func_184185_a(ModSoundEvents.fleshHit, 3.0f, 1.0f);
        }
        this.func_70661_as().func_75499_g();
        this.func_70661_as().func_75497_a((Entity)this, 1.0);
        if (this.func_70638_az() != null && !this.func_70638_az().func_70089_S() && entityLivingIn == this.func_70638_az()) {
            this.func_70624_b(null);
        }
        if (this.func_70638_az() != null && this.func_70638_az() instanceof EntityFriendlyCreature && this.isOnSameTeam((EntityLivingBase)((EntityFriendlyCreature)this.func_70638_az())) && ((EntityFriendlyCreature)this.func_70638_az()).getFakeHealth() <= 0.0f) {
            this.func_70624_b(null);
        }
        if (!this.isWild()) {
            EntityPlayer player = (EntityPlayer)this.getOwner();
            player.func_70074_a(entityLivingIn);
        }
        if (Loader.isModLoaded((String)"abyssalcraft") && !this.field_70170_p.field_72995_K && EngenderMod.canBeTurned((Entity)entityLivingIn)) {
            EntityFriendlyCreature EntityDephsZombie;
            if (this.passesDreadPlague()) {
                EntityDephsZombie = new EntityDreadling(this.field_70170_p);
                EntityDephsZombie.func_82149_j((Entity)entityLivingIn);
                this.field_70170_p.func_72900_e((Entity)entityLivingIn);
                ((EntityDreadling)EntityDephsZombie).func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)EntityDephsZombie)), null);
                EntityDephsZombie.setOwnerId(this.func_184753_b());
                this.field_70170_p.func_72838_d((Entity)EntityDephsZombie);
                this.field_70170_p.func_180498_a((EntityPlayer)null, 1026, new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v), 0);
            }
            if (this.passesCoraliumPlague()) {
                if (entityLivingIn instanceof EntitySquid || entityLivingIn instanceof net.minecraft.entity.passive.EntitySquid || entityLivingIn instanceof EntityCoraliumSquid || entityLivingIn instanceof com.shinoow.abyssalcraft.common.entity.EntityCoraliumSquid) {
                    EntityDephsZombie = new EntityCoraliumSquid(this.field_70170_p);
                    EntityDephsZombie.func_82149_j((Entity)entityLivingIn);
                    this.field_70170_p.func_72900_e((Entity)entityLivingIn);
                    EntityDephsZombie.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)EntityDephsZombie)), null);
                    EntityDephsZombie.setOwnerId(this.func_184753_b());
                    if (entityLivingIn.func_70631_g_()) {
                        EntityDephsZombie.setGrowingAge(-60000);
                    }
                    this.field_70170_p.func_72838_d((Entity)EntityDephsZombie);
                    this.field_70170_p.func_180498_a((EntityPlayer)null, 1026, new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v), 0);
                } else {
                    EntityDephsZombie = new EntityAbyssalZombie(this.field_70170_p);
                    EntityDephsZombie.func_82149_j((Entity)entityLivingIn);
                    this.field_70170_p.func_72900_e((Entity)entityLivingIn);
                    ((EntityAbyssalZombie)EntityDephsZombie).func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)EntityDephsZombie)), null);
                    EntityDephsZombie.setOwnerId(this.func_184753_b());
                    if (entityLivingIn.func_70631_g_()) {
                        EntityDephsZombie.setGrowingAge(-60000);
                    }
                    this.field_70170_p.func_72838_d((Entity)EntityDephsZombie);
                    this.field_70170_p.func_180498_a((EntityPlayer)null, 1026, new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v), 0);
                }
            }
        }
    }

    protected void func_110159_bB() {
        if (this.func_110167_bD()) {
            if (!this.func_70089_S() || this instanceof EntityPortal || this instanceof EntityWitherStormHead || this instanceof EntityWitherStormTentacle || this instanceof EntityWitherStormTentacleDevourer) {
                this.func_110160_i(true, true);
            }
            if (this.func_110166_bE() == null || this.func_110166_bE().field_70128_L) {
                this.func_110160_i(true, true);
            }
        }
        if (this.func_110167_bD() && this.func_110166_bE() != null && this.func_110166_bE().field_70170_p == this.field_70170_p) {
            Entity entity = this.func_110166_bE();
            this.func_175449_a(new BlockPos((int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v), 5);
            float f = this.func_70032_d(entity);
            this.func_142017_o(f);
            if (f > 3.0f) {
                this.func_70661_as().func_75497_a(entity, 1.0);
            }
            if (f > 9.0f) {
                double d0 = (entity.field_70165_t - this.field_70165_t) / (double)f;
                double d1 = (entity.field_70163_u - this.field_70163_u) / (double)f;
                double d2 = (entity.field_70161_v - this.field_70161_v) / (double)f;
                this.field_70159_w += d0 * Math.abs(d0) * 0.4;
                this.field_70181_x += d1 * Math.abs(d1) * 0.4;
                this.field_70179_y += d2 * Math.abs(d2) * 0.4;
            }
        }
    }

    public void spawnHeartParticle() {
        if (this.field_70170_p.field_72995_K) {
            if (this.func_70089_S()) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.HEART, this.field_70165_t, this.field_70163_u + (double)this.field_70131_O, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            this.field_70170_p.func_72960_a((Entity)this, (byte)22);
        }
    }

    public void spawnStressParticle() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 20; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                if (!this.func_70089_S()) continue;
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_SPLASH, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
            }
        } else {
            this.field_70170_p.func_72960_a((Entity)this, (byte)23);
        }
    }

    public void func_70656_aK() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 20; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                double d3 = 10.0;
                if (!this.func_70089_S()) continue;
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N - d0 * 10.0, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O) - d1 * 10.0, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N - d2 * 10.0, d0, d1, d2, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_WITCH, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N - d0 * 10.0, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O) - d1 * 10.0, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N - d2 * 10.0, d0, d1, d2, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N - d0 * 10.0, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O) - d1 * 10.0, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N - d2 * 10.0, d0, d1, d2, new int[0]);
            }
        } else {
            this.field_70170_p.func_72960_a((Entity)this, (byte)20);
        }
    }

    public void spawnConversionParticle() {
        if (this.field_70170_p.field_72995_K) {
            for (int i1 = 0; i1 < this.convertionInt; ++i1) {
                float f1 = (float)i1 * (float)Math.PI / ((float)this.timesToConvert() * 0.5f);
                if (!this.func_70089_S()) continue;
                this.field_70170_p.func_175682_a(EnumParticleTypes.END_ROD, true, this.field_70165_t + (double)MathHelper.func_76134_b((float)f1) * (double)(this.field_70130_N > 6.0f ? 6.0f : this.field_70130_N), this.field_70163_u + (double)this.field_70131_O + 1.0, this.field_70161_v + (double)MathHelper.func_76126_a((float)f1) * (double)(this.field_70130_N > 6.0f ? 6.0f : this.field_70130_N), this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
            }
        } else {
            this.field_70170_p.func_72960_a((Entity)this, (byte)21);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 23) {
            this.spawnStressParticle();
        } else if (id == 22) {
            this.spawnHeartParticle();
        } else if (id == 21) {
            this.spawnConversionParticle();
        } else {
            super.func_70103_a(id);
        }
    }

    protected int func_70682_h(int air) {
        return this.func_70668_bt() == EngenderMod.CONSTRUCT ? air : super.func_70682_h(air);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        PotionEffect potioneffect;
        float f;
        int i;
        this.field_70159_w = 0.0;
        this.field_70179_y = 0.0;
        this.field_70737_aN = 0;
        this.rotationPitchFalling = 0.0f;
        this.prevRotationPitchFalling = 0.0f;
        float[] ret = ForgeHooks.onLivingFall((EntityLivingBase)this, (float)distance, (float)damageMultiplier);
        if (ret == null) {
            return;
        }
        distance = ret[0];
        damageMultiplier = ret[1];
        if (this.func_184207_aI()) {
            for (Entity entity : this.func_184188_bt()) {
                entity.func_180430_e(distance, damageMultiplier);
            }
        }
        if ((i = MathHelper.func_76123_f((float)((distance - 3.0f - (f = (potioneffect = this.func_70660_b(MobEffects.field_76430_j)) == null ? 0.0f : (float)(potioneffect.func_76458_c() + 1))) * damageMultiplier))) > 0) {
            int l;
            int k;
            int j;
            IBlockState iblockstate;
            this.func_184185_a(this.func_184588_d(i), 1.0f, 1.0f);
            if (this.takesFallDamage()) {
                this.func_70097_a(DamageSource.field_76379_h, i);
            }
            if ((iblockstate = this.field_70170_p.func_180495_p(new BlockPos(j = MathHelper.func_76128_c((double)this.field_70165_t), k = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f)), l = MathHelper.func_76128_c((double)this.field_70161_v)))).func_185904_a() != Material.field_151579_a) {
                SoundType soundtype = iblockstate.func_177230_c().getSoundType(iblockstate, this.field_70170_p, new BlockPos(j, k, l), (Entity)this);
                this.func_184185_a(soundtype.func_185842_g(), soundtype.func_185843_a() * 0.5f, soundtype.func_185847_b() * 0.75f);
            }
        }
        this.field_70122_E = true;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.func_70089_S() || this.func_70638_az() != null && !this.func_70638_az().func_70089_S() || this.func_70638_az() != null && this.func_70638_az() instanceof EntityFriendlyCreature && this.getFakeHealth() <= 0.0f && ((EntityFriendlyCreature)this.func_70638_az()).getFakeHealth() <= 0.0f && this.isOnSameTeam((EntityLivingBase)((EntityFriendlyCreature)this.func_70638_az()))) {
            this.func_70624_b(null);
        }
        this.currentReadingBook = this.getBookID() != 0 ? new ItemStack(books[this.getBookID()], 1, this.getBookDurability()) : ItemStack.field_190927_a;
        this.basicInventory.func_70299_a(0, this.func_184582_a(EntityEquipmentSlot.HEAD));
        this.basicInventory.func_70299_a(1, this.func_184582_a(EntityEquipmentSlot.CHEST));
        this.basicInventory.func_70299_a(2, this.func_184582_a(EntityEquipmentSlot.LEGS));
        this.basicInventory.func_70299_a(3, this.func_184582_a(EntityEquipmentSlot.FEET));
        this.basicInventory.func_70299_a(4, this.func_184582_a(EntityEquipmentSlot.MAINHAND));
        this.basicInventory.func_70299_a(5, this.func_184582_a(EntityEquipmentSlot.OFFHAND));
        this.basicInventory.func_70299_a(6, this.getCurrentBook());
        if (this.getTier() == EnumTier.TIER6) {
            this.setLevel(300);
            this.setTotalEXP(2.1474836E9f);
            this.setEXP(2.1474836E9f);
            this.setEnergy(100.0f);
        }
        if (this.field_70143_R >= this.func_110143_aJ() * 2.0f && this.func_70089_S() && this.takesFallDamage() && this.field_70163_u <= -45.0) {
            this.func_70097_a(DamageSource.field_76379_h, Float.MAX_VALUE);
        }
        if (this.isABoss()) {
            this.updateBossBar();
        } else {
            this.bossInfo.func_186758_d(false);
        }
        if (!(this.isABoss() || this.func_184218_aH() || this instanceof Flying && this.func_70089_S() || this.field_70122_E || this.field_70737_aN <= 0 && this.func_70089_S())) {
            if (this.func_70090_H() || this.func_180799_ab()) {
                this.field_70181_x -= (double)0.1f;
            } else {
                this.field_70737_aN = 10;
            }
            this.field_70134_J = false;
            this.field_70761_aq = this.field_70177_z = this.field_70759_as;
            this.func_70661_as().func_75499_g();
            this.rotationPitchFalling = (float)(-this.field_70181_x * 114.59155902616465);
            while (this.rotationPitchFalling - this.prevRotationPitchFalling < -180.0f) {
                this.prevRotationPitchFalling -= 360.0f;
            }
            while (this.rotationPitchFalling - this.prevRotationPitchFalling >= 180.0f) {
                this.prevRotationPitchFalling += 360.0f;
            }
            this.rotationPitchFalling = this.prevRotationPitchFalling + (this.rotationPitchFalling - this.prevRotationPitchFalling) * (float)(this.field_70181_x == 0.0 ? 0.01 : (this.field_70181_x < 0.0 ? -this.field_70181_x / 5.0 : this.field_70181_x / 5.0));
            if (this.rotationPitchFalling >= 90.0f) {
                this.rotationPitchFalling = 90.0f;
            }
            if (this.rotationPitchFalling <= -90.0f) {
                this.rotationPitchFalling = -90.0f;
            }
            if (this.rotationPitchFalling < 90.0f && this.rotationPitchFalling > -90.0f && !this.field_70122_E && this.field_70759_as != (float)MathHelper.func_181159_b((double)this.field_70179_y, (double)this.field_70159_w) * 57.295776f - 90.0f) {
                this.field_70177_z = this.field_70759_as = (float)MathHelper.func_181159_b((double)this.field_70179_y, (double)this.field_70159_w) * 57.295776f - 90.0f;
                this.field_70761_aq = this.field_70759_as;
                this.field_70758_at = this.field_70759_as;
                this.field_70126_B = this.field_70759_as;
                this.field_70760_ar = this.field_70759_as;
                float xRatio = MathHelper.func_76126_a((float)(this.field_70759_as * ((float)Math.PI / 180)));
                float zRatio = -MathHelper.func_76134_b((float)(this.field_70759_as * ((float)Math.PI / 180)));
                float f = MathHelper.func_76129_c((float)(xRatio * xRatio + zRatio * zRatio));
                this.field_70159_w -= (double)xRatio / (double)f * (double)((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()) * 0.1;
                this.field_70179_y -= (double)zRatio / (double)f * (double)((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()) * 0.1;
            }
        } else {
            this.rotationPitchFalling = 0.0f;
            this.prevRotationPitchFalling = 0.0f;
        }
        this.prevChasingPosX = this.chasingPosX;
        this.prevChasingPosY = this.chasingPosY;
        this.prevChasingPosZ = this.chasingPosZ;
        double d0 = this.field_70165_t - this.chasingPosX;
        double d1 = this.field_70163_u - this.chasingPosY;
        double d2 = this.field_70161_v - this.chasingPosZ;
        double d3 = 10.0;
        if (d0 > d3) {
            this.prevChasingPosX = this.chasingPosX = this.field_70165_t;
        }
        if (d2 > d3) {
            this.prevChasingPosZ = this.chasingPosZ = this.field_70161_v;
        }
        if (d1 > d3) {
            this.prevChasingPosY = this.chasingPosY = this.field_70163_u;
        }
        if (d0 < -d3) {
            this.prevChasingPosX = this.chasingPosX = this.field_70165_t;
        }
        if (d2 < -d3) {
            this.prevChasingPosZ = this.chasingPosZ = this.field_70161_v;
        }
        if (d1 < -d3) {
            this.prevChasingPosY = this.chasingPosY = this.field_70163_u;
        }
        this.chasingPosX += d0 * 0.25;
        this.chasingPosZ += d2 * 0.25;
        this.chasingPosY += d1 * 0.25;
        if (!this.func_70089_S() && this.field_70163_u <= -200.0) {
            this.func_70106_y();
        }
        if (this.func_184207_aI()) {
            for (Entity entity : this.func_184188_bt()) {
                entity.field_70181_x = this.field_70181_x;
            }
        }
        if (!this.func_70089_S()) {
            this.func_70624_b(null);
            this.func_70604_c(null);
            this.func_184210_p();
        }
        boolean bl = this.field_70160_al = !this.field_70122_E;
        if (this.blockTimer > 0) {
            --this.blockTimer;
        }
        if (this.convertionInt > 0 && !this.isWild()) {
            this.convertionInt = 0;
        }
        if (this.field_70173_aa % 300 == 0 && this.getGuardBlock() == null && !this.func_184218_aH() && !this.func_184207_aI() && this.func_70638_az() == null && !this.func_70661_as().func_75500_f() && this.field_70122_E && this.field_70159_w == 0.0 && this.field_70179_y == 0.0) {
            this.setSitResting(true);
        }
        if (this.isSitResting()) {
            this.func_70661_as().func_75499_g();
        }
        if (this.func_184218_aH() || this.getGuardBlock() != null || this.func_184207_aI() || this.func_70638_az() != null || !this.func_70661_as().func_75500_f() || !this.field_70122_E || this.field_70159_w != 0.0 || this.field_70181_x != 0.0 || this.field_70179_y != 0.0) {
            this.setSitResting(false);
        }
        if (this.field_70173_aa > 20 && this.getCurrentBook().func_190926_b()) {
            this.setBookID(0);
            this.setBookDurability(0);
        }
        if (this.func_70638_az() == null && !this.getCurrentBook().func_190926_b() && this.getCurrentBook().func_77973_b() instanceof ItemLearningBook) {
            this.setSitResting(true);
            this.field_70125_A = this instanceof EntityShulker || this instanceof EntityGuardian ? 0.0f : 30.0f;
            this.field_70759_as = this.field_70177_z = this.field_70761_aq;
            if (this.field_70173_aa % (51 - (int)this.func_110148_a(INTELLIGENCE).func_111125_b() / 2) == 0) {
                this.flipT += 1.0f;
                this.setCurrentStudy(EnumStudy.Mental, 1);
                if (this.getCurrentBook().func_77973_b() == SpawnerItems.learningBookForDummies) {
                    this.setCurrentStudy(EnumStudy.Mental, 2);
                }
                if (this.getCurrentBook().func_77973_b() == SpawnerItems.learningBookJodging) {
                    this.setCurrentStudy(this.field_70146_Z.nextBoolean() ? EnumStudy.Physical : EnumStudy.Mental, 2);
                }
                if (this.getCurrentBook().func_77973_b() == SpawnerItems.learningBookCombat) {
                    this.setCurrentStudy(this.field_70146_Z.nextBoolean() ? EnumStudy.Combative : EnumStudy.Mental, 4);
                }
                if (this.getCurrentBook().func_77973_b() == SpawnerItems.learningBookAdvancedCombat) {
                    this.setCurrentStudy(this.field_70146_Z.nextBoolean() ? EnumStudy.Combative : EnumStudy.Mental, 8);
                }
                this.getCurrentBook().func_77972_a(1, (EntityLivingBase)this);
                if (!this.getCurrentBook().func_190926_b() && !this.func_184582_a(EntityEquipmentSlot.OFFHAND).func_190926_b() && this.func_184582_a(EntityEquipmentSlot.OFFHAND).func_77973_b() instanceof ItemLearningBook) {
                    this.func_184201_a(EntityEquipmentSlot.OFFHAND, ItemStack.field_190927_a);
                }
            }
        }
        if (this.func_70638_az() != null && !this.getCurrentBook().func_190926_b() && this.getCurrentBook().func_77973_b() instanceof ItemLearningBook) {
            this.func_70099_a(new ItemStack(this.getCurrentBook().func_77973_b(), 1, this.getCurrentBook().func_77952_i()), this.func_70047_e());
            this.setCurrentBook(ItemStack.field_190927_a);
            this.setBookID(0);
            this.setBookDurability(0);
            this.func_184185_a(SoundEvents.field_187924_gx, 1.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.4f);
        }
        if (!this.field_70170_p.field_72995_K && !this.func_184614_ca().func_190926_b() && this.func_184614_ca().func_77973_b() == Items.field_151054_z) {
            this.func_70099_a(new ItemStack(Items.field_151054_z), this.func_70047_e());
            this.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
            this.func_184185_a(SoundEvents.field_187924_gx, 1.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.4f);
        }
        if (!this.getCurrentBook().func_190926_b()) {
            this.setBookDurability(this.getCurrentBook().func_77952_i());
        }
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(this.getKnockbackResistance());
        if (!this.isWild() && this.getOwner() instanceof EntityPlayer && this.func_70089_S()) {
            if (this.getTier() != EnumTier.TIER6 && this.getEXP() >= (float)(this.getNextLevelRequirement() * this.getLevel())) {
                this.levelUp();
            }
            ((EntityPlayer)this.getOwner()).func_71029_a((StatBase)EngenderAchievments.creation);
            if (this.getTier() == EnumTier.TIER5) {
                ((EntityPlayer)this.getOwner()).func_71029_a((StatBase)EngenderAchievments.tier5);
            }
        }
        if (this.isABoss() && !this.func_70651_bq().isEmpty()) {
            for (PotionEffect potioneffect : this.func_70651_bq()) {
                if (!potioneffect.func_188419_a().func_76398_f()) continue;
                this.func_184596_c(potioneffect.func_188419_a());
            }
        }
        if (this.getEnergy() > 100.0f) {
            this.func_70691_i(this.getEnergy() - 100.0f);
            this.setEnergy(100.0f);
        }
        if (this.getEnergy() <= 0.0f) {
            this.setEnergy(0.0f);
            if (this.func_184207_aI()) {
                this.func_184210_p();
            }
        }
        if (this.func_70662_br() || this.isABoss() || this.getTier() == EnumTier.TIER6) {
            this.setEnergy(100.0f);
        } else {
            if ((this.func_70644_a(MobEffects.field_76438_s) || this.func_70051_ag()) && this.field_70173_aa % 20 == 0) {
                this.setEnergy(this.getEnergy() - 0.1f);
            }
            if ((this.func_70644_a(MobEffects.field_76428_l) || this.field_70159_w == 0.0 && this.field_70181_x == 0.0 && this.field_70179_y == 0.0) && this.getEnergy() < 100.0f && this.field_70173_aa % 20 == 0) {
                this.setEnergy(this.getEnergy() + 0.1f);
            }
        }
        if (this.func_184613_cA() && this.field_70173_aa % 20 == 0 && !this.field_70170_p.field_72995_K) {
            this.setCurrentStudy(EnumStudy.Physical, 3);
        }
        if (this.func_184207_aI() && this.field_70173_aa % 60 == 0 && !this.field_70170_p.field_72995_K) {
            this.setCurrentStudy(EnumStudy.Physical, 1);
        }
        if (!(this.func_70638_az() == null || this.func_70638_az() != this && this.func_70638_az().func_70089_S())) {
            this.func_70624_b(null);
        }
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (this.holdRoseTick > 0) {
            --this.holdRoseTick;
        }
        if (this.moralRaisedTimer > 0) {
            --this.moralRaisedTimer;
        }
        if (this.exptobeadded > 0) {
            --this.exptobeadded;
            this.setEXP(this.getEXP() + 1.0f);
            this.setTotalEXP(this.getTotalEXP() + 1.0f);
            if (this.exptobeadded >= 100) {
                for (int ex = 1; ex <= this.exptobeadded / (100 * ex); ++ex) {
                    this.exptobeadded -= ex;
                    this.setEXP(this.getEXP() + (float)ex);
                    this.setTotalEXP(this.getTotalEXP() + (float)ex);
                }
            }
        }
        if (this.lastChanceInvul > 0) {
            this.field_70172_ad = this.lastChanceInvul--;
        }
        if (this.getEnergy() <= 5.0f) {
            this.spawnStressParticle();
        }
        if (this.getFakeHealth() <= 0.0f) {
            this.setFakeHealth(0.0f);
        }
        if (this.func_175446_cd()) {
            this.field_184619_aG = 0.0f;
        }
        if (!this.func_70089_S()) {
            this.func_70674_bp();
        }
        if (this.isHero()) {
            this.func_70066_B();
        }
        if (!this.isSitResting() || !this.isWild() || this.isHero() || !this.func_184222_aU() || this.getTier() == EnumTier.TIER6 || this instanceof IEntityMultiPart) {
            this.field_70708_bq = 0;
        }
        if (this.func_184614_ca().func_77973_b() == SpawnerItems.carrier || this.func_184592_cb().func_77973_b() == SpawnerItems.carrier) {
            this.dropEquipmentUndamaged();
        }
        if (this.func_70093_af() || !this.func_70089_S() || this.isWild() || this instanceof EntityWitherStormHead || this instanceof EntityWitherStormTentacle || this instanceof EntityWitherStormTentacleDevourer) {
            this.func_174805_g(false);
        } else {
            this.func_174805_g(this.field_70170_p.func_72890_a((Entity)this, 16.0 * (double)(this.field_70130_N + this.field_70131_O)) != null && this.isOnSameTeam((EntityLivingBase)this.field_70170_p.func_72890_a((Entity)this, 16.0 * (double)(this.field_70130_N + this.field_70131_O))));
        }
        if (this.field_70173_aa > 20 && this.func_184187_bx() != null && this.func_184187_bx() instanceof EntityPlayer && !(this instanceof EntityChagaroth) && !(this instanceof EntitySlime) && !this.func_70631_g_()) {
            this.func_184210_p();
        }
        if (this.getLevel() >= 299 && this.getTier() != EnumTier.TIER6 && this.field_70146_Z.nextInt(5) == 0) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.END_ROD, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f - this.field_70130_N) * 0.6, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f - this.field_70130_N) * 0.6, 0.0, 0.01, 0.0, new int[0]);
        }
        List list = this.field_70170_p.func_175647_a(EntityFriendlyCreature.class, this.func_174813_aQ().func_186662_g(0.1), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_94557_a}));
        if (!this.field_70170_p.field_72995_K && list != null && !list.isEmpty() && this.isAntiMob()) {
            for (int i1 = 0; i1 < list.size(); ++i1) {
                EntityFriendlyCreature entity = (EntityFriendlyCreature)list.get(i1);
                if (entity == null || entity.getClass() != this.getClass() || entity.isAntiMob()) continue;
                EntityFriendlyCreature.createEngenderModExplosionFireless((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 5 + list.size(), this.field_70170_p.func_82736_K().func_82766_b("mobGriefing"));
                entity.func_174812_G();
                this.func_174812_G();
            }
        }
        if (this.func_110143_aJ() > 0.0f) {
            if (this.field_70725_aQ > 0) {
                --this.field_70725_aQ;
            }
            this.field_70729_aU = false;
        }
        this.pageFlipPrev = this.pageFlip;
        this.bookSpreadPrev = this.bookSpread;
        if (this.getBookID() > 0 && this.func_70089_S()) {
            this.bookSpread += 0.05f;
            if (this.bookSpread == 0.1f) {
                this.func_184185_a(SoundEvents.field_187694_dK, 1.0f, 1.3f + this.field_70146_Z.nextFloat() * 0.4f);
            }
        } else {
            this.bookSpread -= 0.1f;
        }
        this.bookSpread = MathHelper.func_76131_a((float)this.bookSpread, (float)0.0f, (float)1.0f);
        this.pageFlipPrev = this.pageFlip;
        float f = (this.flipT - this.pageFlip) * 0.4f;
        float f3 = 0.2f;
        f = MathHelper.func_76131_a((float)f, (float)-0.2f, (float)0.2f);
        this.flipA += (f - this.flipA) * 0.9f;
        this.pageFlip += this.flipA;
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && this.getEnergy() == 100.0f && this.field_70173_aa % 20 == 0) {
            this.func_70691_i(1.0f);
        }
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && this.getEnergy() <= 90.0f && this.getEnergy() > 80.0f && this.func_110143_aJ() < this.func_110138_aP() && this.field_70172_ad <= 10 && this.field_70173_aa % 40 == 0) {
            this.func_70691_i(1.0f);
            this.setEnergy(this.getEnergy() - 0.1f);
        }
        if (!this.field_70170_p.field_72995_K && !this.isABoss() && !this.func_70662_br() && this.func_70089_S() && this.getEnergy() < 100.0f && this.getEnergy() > 90.0f && this.func_110143_aJ() < this.func_110138_aP() && this.field_70172_ad <= 10 && this.field_70173_aa % 10 == 0) {
            this.func_70691_i(2.0f);
            this.setEnergy(this.getEnergy() - 5.0f);
        }
        this.func_70031_b(!this.func_70661_as().func_75500_f() && !this.isWild() && this.getOwner().func_70051_ag() && this.func_70089_S() && this.getEnergy() > 20.0f);
        this.func_70095_a(!this.isWild() && this.func_70089_S() && (this.getOwner().func_70093_af() || this.inLove > 0 && this.field_70173_aa % 5 == 0 && this.func_70068_e((Entity)this.getOwner()) < 2.0));
        if (Loader.isModLoaded((String)"abyssalcraft") && this.isEntityImmuneToAntiMatter() && this.func_70644_a(AbyssalCraftAPI.antimatter_potion)) {
            this.func_184596_c(MobEffects.field_76421_d);
            this.func_184596_c(MobEffects.field_76440_q);
            this.func_184596_c(MobEffects.field_76437_t);
            this.func_184596_c(MobEffects.field_76438_s);
            this.func_184596_c(AbyssalCraftAPI.antimatter_potion);
        }
        if (this.isEntityImmuneToDarkness()) {
            this.func_184596_c(MobEffects.field_76440_q);
        }
        if (this.func_70644_a(MobEffects.field_76426_n) || this.func_70045_F()) {
            this.func_70066_B();
        }
        if (this.func_70644_a(MobEffects.field_76426_n) || this.func_70045_F() || this.getIntelligence() <= 6.0f) {
            this.func_184644_a(PathNodeType.LAVA, 0.0f);
            this.func_184644_a(PathNodeType.DANGER_FIRE, 0.0f);
            this.func_184644_a(PathNodeType.DAMAGE_FIRE, 0.0f);
        } else {
            this.func_184644_a(PathNodeType.LAVA, -1.0f);
            this.func_184644_a(PathNodeType.DANGER_FIRE, 8.0f);
            this.func_184644_a(PathNodeType.DAMAGE_FIRE, 16.0f);
        }
        if (!this.func_70089_S() && this.func_184207_aI()) {
            for (Entity entity : this.func_184188_bt()) {
                if (!entity.func_184218_aH()) continue;
                entity.func_184210_p();
            }
        }
        if (this.func_175446_cd()) {
            this.field_70172_ad = this.field_70771_an;
            if (this.field_70173_aa > 21) {
                --this.field_70173_aa;
            }
        }
        this.func_174810_b(this.func_175446_cd());
        this.func_94061_f(this.field_70725_aQ > 40 || this.isABoss() && !this.func_70089_S() || this.func_184753_b() != null && this.getOwner() == null);
        this.prevRotationPitchFalling = this.rotationPitchFalling;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L && this.func_70089_S() && !this.func_175446_cd();
    }

    public void func_70636_d() {
        List list;
        boolean bl = this.field_70160_al = !this.field_70122_E;
        if (this.isABoss()) {
            this.func_184596_c(MobEffects.field_76436_u);
            this.func_184596_c(MobEffects.field_82731_v);
            this.func_184596_c(MobEffects.field_76421_d);
            this.func_184596_c(MobEffects.field_76437_t);
            this.func_184596_c(MobEffects.field_76440_q);
            this.func_184596_c(MobEffects.field_76431_k);
            this.func_184596_c(MobEffects.field_188424_y);
            this.func_184596_c(MobEffects.field_76438_s);
        }
        if (this.func_70090_H() && !this.func_70648_aU() && this.field_70173_aa % 20 == 0) {
            this.setEnergy(this.getEnergy() - 0.01f);
        }
        if (this.field_70181_x > 0.0) {
            this.field_70143_R = 0.0f;
        }
        if (this.getJukeboxToDanceTo() != null && this.field_70173_aa % 10 == 0 && this.func_70089_S()) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.NOTE, this.field_70165_t, this.field_70163_u + (double)this.field_70131_O, this.field_70161_v, this.field_70146_Z.nextDouble(), this.field_70146_Z.nextDouble(), this.field_70146_Z.nextDouble(), new int[0]);
        }
        if (this.convertionInt > 0 && this.field_70173_aa % 10 == 0) {
            this.spawnConversionParticle();
        }
        if (this.convertionInt > 0) {
            this.func_70661_as().func_75499_g();
        }
        if (this.func_70638_az() != null && this.func_70638_az() instanceof EntityPlayer && ((EntityPlayer)this.func_70638_az()).field_71075_bZ.field_75102_a) {
            this.func_70624_b(null);
        }
        if (Loader.isModLoaded((String)"iceandfire") && !(list = this.field_70170_p.field_72996_f).isEmpty()) {
            for (int i1 = 0; i1 < list.size(); ++i1) {
                Entity entity = (Entity)list.get(i1);
                if (!entity.func_70089_S() || !(entity instanceof EntityMob)) continue;
                EntityMob mob = (EntityMob)entity;
                if (mob.field_70130_N != 0.8f || mob.field_70131_O != 1.99f || mob.func_70638_az() == null) continue;
                mob.func_70624_b((EntityLivingBase)mob);
            }
        }
        if (this.func_184207_aI() && !(this instanceof EntitySquid) && !(this instanceof EntityGuardian)) {
            if (this.func_70090_H() || this.func_180799_ab()) {
                this.field_70181_x += 0.05;
            }
            this.field_70703_bu = false;
        }
        IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
        IAttributeInstance iattributeinstanceattack = this.func_110148_a(SharedMonsterAttributes.field_111264_e);
        if (this.moralRaisedTimer >= 600) {
            this.moralRaisedTimer = 600;
            int b0 = 20;
            this.func_70690_d(new PotionEffect(MobEffects.field_76422_e, 20 * b0));
            this.func_184185_a(ModSoundEvents.battlecry, 10.0f, 1.0f);
            if (this.field_70122_E) {
                this.func_70664_aZ();
            }
            this.func_184185_a(this.func_184639_G(), this.func_70599_aP(), this.func_70647_i() + this.field_70146_Z.nextFloat() * 0.15f);
            this.func_184185_a(this.func_184639_G(), this.func_70599_aP(), this.func_70647_i() + this.field_70146_Z.nextFloat() * 0.25f);
            this.func_184185_a(this.func_184639_G(), this.func_70599_aP(), this.func_70647_i() + this.field_70146_Z.nextFloat() * 0.35f);
            this.func_184185_a(this.func_184601_bQ(), this.func_70599_aP(), this.func_70647_i() + this.field_70146_Z.nextFloat() * 0.35f);
        }
        if (this.moralRaisedTimer <= 0) {
            if (iattributeinstance.func_180374_a(attackingSpeedBoostModifier)) {
                iattributeinstance.func_111124_b(attackingSpeedBoostModifier);
            }
            if (iattributeinstanceattack.func_180374_a(attackingBoostModifier)) {
                iattributeinstanceattack.func_111124_b(attackingBoostModifier);
            }
        } else {
            this.func_70031_b(!this.func_70661_as().func_75500_f());
            if (!iattributeinstance.func_180374_a(attackingSpeedBoostModifier)) {
                iattributeinstance.func_111121_a(attackingSpeedBoostModifier);
            }
            if (!iattributeinstanceattack.func_180374_a(attackingBoostModifier)) {
                iattributeinstanceattack.func_111121_a(attackingBoostModifier);
            }
        }
        if (!this.field_70170_p.field_72995_K && this.func_85035_bI() > 0 && (this.func_70638_az() == null && (this.field_70173_aa + this.func_145782_y()) % 100 == 0 || this.getTier() == EnumTier.TIER5 || this.getTier() == EnumTier.TIER6)) {
            this.func_85034_r(this.func_85035_bI() - 1);
            this.func_70097_a(DamageSource.field_76367_g, 2.0f);
            this.func_184185_a(SoundEvents.field_187903_gc, this.func_70599_aP(), this.func_70647_i());
            EntityTippedArrow entityarrow = new EntityTippedArrow(this.field_70170_p, (EntityLivingBase)this);
            entityarrow.func_82149_j((Entity)this);
            entityarrow.field_70163_u = this.field_70163_u + (double)this.func_70047_e();
            entityarrow.func_184547_a((Entity)this, -30.0f, this.field_70146_Z.nextFloat() * 360.0f, 0.0f, 0.35f, 1.0f);
            entityarrow.field_70251_a = EntityArrow.PickupStatus.ALLOWED;
            this.field_70170_p.func_72838_d((Entity)entityarrow);
        }
        if (!this.field_70170_p.field_72995_K && this.func_85035_bI() > 0 && (this.field_70173_aa + this.func_145782_y()) % 40 == 0) {
            this.func_70097_a(DamageSource.field_76367_g, 1.0f);
        }
        if (this.func_70644_a(MobEffects.field_76440_q) || this.func_70644_a(MobEffects.field_76431_k) && this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) > 16.0) {
            this.func_70624_b(null);
        }
        if (this.func_70644_a(MobEffects.field_76431_k)) {
            this.field_70759_as += MathHelper.func_76126_a((float)((float)this.field_70173_aa * 0.2f)) * 10.0f;
            this.field_70125_A += MathHelper.func_76134_b((float)((float)this.field_70173_aa * 0.1f)) * 10.0f;
            if (this.field_70173_aa % 10 == 0) {
                this.func_70661_as().func_75499_g();
            }
        }
        if (this.inLove > 0) {
            --this.inLove;
            if (this.inLove % 10 == 0) {
                for (int ai = 0; ai < 7; ++ai) {
                    this.spawnHeartParticle();
                }
            }
        }
        if (this.func_184614_ca().func_77973_b() instanceof ItemFood && (this.getEnergy() < 90.0f || this.func_110143_aJ() <= this.func_110138_aP() / 2.0f)) {
            if (this.field_70173_aa > 53) {
                this.field_70173_aa = 20;
            }
            this.func_184609_a(EnumHand.MAIN_HAND);
            this.func_184598_c(EnumHand.MAIN_HAND);
            this.field_70125_A = this.field_70173_aa % 2 == 0 ? 40.0f : 0.0f;
            if (this.field_70173_aa == 50) {
                for (int ai = 0; ai < ((ItemFood)this.func_184614_ca().func_77973_b()).func_150905_g(this.func_184614_ca()); ++ai) {
                    this.spawnHeartParticle();
                }
                this.func_70691_i(((ItemFood)this.func_184614_ca().func_77973_b()).func_150905_g(this.func_184614_ca()));
                this.setEnergy(this.getEnergy() + (float)(((ItemFood)this.func_184614_ca().func_77973_b()).func_150905_g(this.func_184614_ca()) * 5));
                this.func_184185_a(SoundEvents.field_187739_dZ, 0.5f, this.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
        }
        if (this.func_184592_cb().func_77973_b() instanceof ItemFood && (this.getEnergy() < 90.0f || this.func_110143_aJ() <= this.func_110138_aP() / 2.0f)) {
            if (this.field_70173_aa > 53) {
                this.field_70173_aa = 20;
            }
            this.field_70125_A = this.field_70173_aa % 2 == 0 ? 40.0f : 0.0f;
            this.func_184609_a(EnumHand.OFF_HAND);
            this.func_184598_c(EnumHand.OFF_HAND);
            if (this.field_70173_aa == 50) {
                this.spawnHeartParticle();
                this.func_70691_i(((ItemFood)this.func_184592_cb().func_77973_b()).func_150905_g(this.func_184592_cb()));
                this.setEnergy(this.getEnergy() + (float)(((ItemFood)this.func_184592_cb().func_77973_b()).func_150905_g(this.func_184592_cb()) * 5));
                this.func_184185_a(SoundEvents.field_187739_dZ, 0.5f, this.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
        }
        if (this.func_184187_bx() != null && this.func_184187_bx() instanceof EntityBoat && ((EntityBoat)this.func_184187_bx()).func_184179_bs() == this) {
            ((EntityBoat)this.func_184187_bx()).field_70177_z = this.field_70177_z;
            float f1 = 0.0f;
            if (this.field_70701_bs > 0.0f || this.func_70638_az() != null) {
                f1 += 0.04f;
            }
            if (this.field_70701_bs < 0.0f) {
                f1 -= 0.005f;
            }
            ((EntityBoat)this.func_184187_bx()).field_70159_w += (double)(MathHelper.func_76126_a((float)(-((EntityBoat)this.func_184187_bx()).field_70177_z * ((float)Math.PI / 180))) * f1);
            ((EntityBoat)this.func_184187_bx()).field_70179_y += (double)(MathHelper.func_76134_b((float)(((EntityBoat)this.func_184187_bx()).field_70177_z * ((float)Math.PI / 180))) * f1);
        }
        if (this.getJukeboxToDanceTo() != null) {
            if (this.field_70173_aa % 20 == 0 && this instanceof EntityCreeper && ((EntityCreeper)this).getPowered()) {
                this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t - 0.5, this.field_70163_u + 1.9, this.field_70161_v - 0.5, true));
            }
            this.field_70761_aq = this.field_70177_z = this.field_70759_as;
            this.setSitResting(false);
            this.func_70661_as().func_75499_g();
            IBlockState iblockstate = this.field_70170_p.func_180495_p(this.getJukeboxToDanceTo());
            Block block = iblockstate.func_177230_c();
            if (block != Blocks.field_150421_aI || block == Blocks.field_150421_aI && !((Boolean)iblockstate.func_177229_b((IProperty)BlockJukebox.field_176432_a)).booleanValue() || this.func_174831_c(this.jukeBoxToDanceTo) > 10000.0) {
                this.setJukeboxToDanceTo(null);
            }
        }
        if (this.getJukeboxToDanceTo() == null && this.field_70173_aa % 60 == 0) {
            int i11 = MathHelper.func_76128_c((double)this.field_70163_u);
            int l1 = MathHelper.func_76128_c((double)this.field_70165_t);
            int i2 = MathHelper.func_76128_c((double)this.field_70161_v);
            boolean flag = false;
            for (int k2 = -12 - (int)this.field_70130_N; k2 <= 12 + (int)this.field_70130_N; ++k2) {
                for (int l2 = -12 - (int)this.field_70130_N; l2 <= 12 + (int)this.field_70130_N; ++l2) {
                    for (int j = -12 - (int)this.field_70131_O; j <= 12 + (int)this.field_70131_O; ++j) {
                        int i3 = l1 + k2;
                        int k = i11 + j;
                        int l = i2 + l2;
                        BlockPos blockpos = new BlockPos(i3, k, l);
                        IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
                        Block block = iblockstate.func_177230_c();
                        if (block != Blocks.field_150421_aI || !((Boolean)iblockstate.func_177229_b((IProperty)BlockJukebox.field_176432_a)).booleanValue()) continue;
                        this.setJukeboxToDanceTo(blockpos);
                    }
                }
            }
        }
        if (this.func_70631_g_() && this.func_184218_aH() && this.func_184187_bx() instanceof EntityPlayer) {
            if (((EntityPlayer)this.func_184187_bx()).func_184187_bx() != null && ((EntityPlayer)this.func_184187_bx()).func_184187_bx() instanceof EntityLivingBase) {
                this.field_70761_aq = this.field_70177_z = ((EntityLivingBase)((EntityPlayer)this.func_184187_bx()).func_184187_bx()).field_70177_z;
                this.field_70759_as = ((EntityLivingBase)((EntityPlayer)this.func_184187_bx()).func_184187_bx()).field_70759_as;
            } else {
                this.field_70761_aq = this.field_70177_z = ((EntityPlayer)this.func_184187_bx()).field_70177_z;
                this.field_70759_as = ((EntityPlayer)this.func_184187_bx()).field_70759_as;
            }
        }
        if (!this.canBeMatedWith() && this.isInLove()) {
            this.resetInLove();
        }
        if (this.getGrowingAge() < 4000) {
            this.resetInLove();
        }
        EntityPlayer player = this.field_70170_p.func_72890_a((Entity)this, 4.0 + (double)this.field_70131_O + (double)this.field_70130_N);
        if (EngenderMod.useMobTalkerModels && this.func_70631_g_() && !this.func_184218_aH() && this.hasOwner(player)) {
            this.func_70671_ap().func_75651_a((Entity)player, (float)this.func_184649_cE(), (float)this.func_70646_bf());
        }
        this.field_70138_W = this.field_70131_O >= 2.0f ? this.field_70131_O / 2.0f : 1.0f;
        this.func_82168_bl();
        if (this.field_70173_aa < 20) {
            this.field_70143_R *= 0.0f;
        }
        if (this.func_110167_bD() && !this.field_70122_E) {
            this.field_70143_R *= 0.0f;
        }
        if (this.getSpecialAttackTimer() > 0) {
            this.setSpecialAttackTimer(this.getSpecialAttackTimer() - 1);
        }
        if (this.field_70146_Z.nextInt(2) == 0 && !this.isWild() && this.getOwner().func_70643_av() != null && !this.isOnSameTeam(this.getOwner().func_70643_av())) {
            this.func_70624_b(this.getOwner().func_70643_av());
        }
        if (this.isWild() && this.func_184753_b() == null) {
            if (this.field_70170_p.field_72995_K) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                double d3 = 10.0;
                if (this.func_70089_S()) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.TOWN_AURA, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N - d0 * d3, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O) - d1 * d3, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N - d2 * d3, d0, d1, d2, new int[0]);
                }
            }
            if (this.convertionInt > 0 && this.field_70170_p.field_72995_K) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                double d3 = 10.0;
                if (this.func_70089_S()) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.ENCHANTMENT_TABLE, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N - d0 * d3, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O) - d1 * d3, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N - d2 * d3, d0, (double)0.1f, d2, new int[0]);
                }
            }
        } else {
            this.convertionInt = 0;
            if (this.isHero() && this.field_70170_p.field_72995_K) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                double d3 = 10.0;
                if (this.func_70089_S()) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.FIREWORKS_SPARK, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N - d0 * d3, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O) - d1 * d3, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N - d2 * d3, d0, (double)0.1f, d2, new int[0]);
                }
            }
        }
        if (this.field_70173_aa > this.getSpawnTimer()) {
            super.func_70636_d();
        } else {
            if (this.field_70173_aa == 2) {
                this.func_70656_aK();
            }
            this.field_70159_w *= 0.0;
            this.field_70179_y *= 0.0;
            this.field_70761_aq = this.field_70177_z = this.field_70759_as;
        }
        if (this.func_70089_S() && this.field_70122_E && this.func_70638_az() != null && this.func_70638_az().field_70163_u >= this.field_70163_u + 2.0 && this.field_70146_Z.nextInt(100) == 0) {
            this.field_70181_x = (double)this.func_175134_bD() + (double)0.2f;
            this.field_70160_al = true;
            ForgeHooks.onLivingJump((EntityLivingBase)this);
            double d0 = this.func_70638_az().field_70165_t - this.field_70165_t;
            double d1 = this.func_70638_az().field_70161_v - this.field_70161_v;
            float f1 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
            this.field_70159_w += d0 / (double)f1 * 0.5 * 0.5 + this.field_70159_w * 0.5;
            this.field_70179_y += d1 / (double)f1 * 0.5 * 0.5 + this.field_70179_y * 0.5;
        }
    }

    public void func_70031_b(boolean sprinting) {
        if (this.getEnergy() <= 30.0f) {
            sprinting = false;
        }
        super.func_70031_b(sprinting);
    }

    public void updateBossBar() {
        this.bossInfo.func_186739_a(this.func_145748_c_());
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        this.bossInfo.func_186758_d(!this.func_70093_af() && !this.func_82150_aj() && this.func_70089_S());
        this.bossInfo.func_186746_a(this.getTier() == EnumTier.TIER6 ? BossInfo.Overlay.NOTCHED_20 : (this.getTier() == EnumTier.TIER5 ? (this.func_110138_aP() >= 250.0f ? BossInfo.Overlay.NOTCHED_12 : BossInfo.Overlay.NOTCHED_10) : (this.func_110138_aP() >= 50.0f ? BossInfo.Overlay.NOTCHED_6 : BossInfo.Overlay.PROGRESS)));
    }

    public boolean isABoss() {
        return false;
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        if (this.isABoss()) {
            this.bossInfo.func_186760_a(player);
        }
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public int getSpawnTimer() {
        return 20;
    }

    public float getHealthPercent() {
        return this.func_110143_aJ() / this.func_110138_aP();
    }

    public float getEnergyPercent() {
        return this.getEnergy() / 100.0f;
    }

    public float getEXPPercent() {
        return this.getEXP() / (float)(this.getNextLevelRequirement() * this.getLevel());
    }

    public boolean isEntityImmuneToCoralium() {
        return this.isABoss() || this.isHero() || this.isCameo();
    }

    public boolean isEntityImmuneToDread() {
        return this.isABoss() || this.isHero() || this.isCameo();
    }

    public boolean isEntityImmuneToAntiMatter() {
        return this.isABoss() || this.isHero() || this.isCameo() || this.isAntiMob();
    }

    public boolean isEntityImmuneToDarkness() {
        return this.isABoss() || this.isHero() || this.isCameo();
    }

    public boolean passesCoraliumPlague() {
        return false;
    }

    public boolean passesDreadPlague() {
        return false;
    }

    protected SoundEvent getRegularHurtSound() {
        return ModSoundEvents.fleshHit;
    }

    protected SoundEvent getPierceHurtSound() {
        return ModSoundEvents.fleshHitPierce;
    }

    protected SoundEvent getCrushHurtSound() {
        return ModSoundEvents.fleshHitCrush;
    }

    public boolean isWoodLike() {
        return this.getCrushHurtSound() == ModSoundEvents.woodHitCrush;
    }

    public boolean isMetalLike() {
        return this.getCrushHurtSound() == ModSoundEvents.metalHitCrush;
    }

    public static enum EnumStudy {
        Physical,
        Mental,
        Combative;

    }
}

