/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.AgeOfMinecraft.render;

import net.minecraft.AgeOfMinecraft.EngenderMod;
import net.minecraft.AgeOfMinecraft.models.ModelCMMZombie;
import net.minecraft.AgeOfMinecraft.models.ModelZombie;
import net.minecraft.AgeOfMinecraft.models.ModelZombieVillager;
import net.minecraft.AgeOfMinecraft.render.LayerArrowCustomSized;
import net.minecraft.AgeOfMinecraft.render.LayerCustomArmor;
import net.minecraft.AgeOfMinecraft.render.LayerCustomHeadEngender;
import net.minecraft.AgeOfMinecraft.render.LayerLearningBook;
import net.minecraft.AgeOfMinecraft.render.LayerMobCape;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerElytra;
import net.minecraft.client.renderer.entity.layers.LayerHeldItem;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.helpful.tier3.EntityZombie;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderZombie
extends RenderLiving<EntityZombie> {
    private static final ResourceLocation CMM_ZOMBIE_VILLAGER_TEXTURES = new ResourceLocation("ageofminecraft", "textures/entities/yarrscmm/zombiev1.png");
    private static final ResourceLocation CMM_ZOMBIE_VILLAGER_FARMER_LOCATION = new ResourceLocation("ageofminecraft", "textures/entities/yarrscmm/zombiev2.png");
    private static final ResourceLocation CMM_ZOMBIE_VILLAGER_LIBRARIAN_LOC = new ResourceLocation("ageofminecraft", "textures/entities/yarrscmm/zombiev3.png");
    private static final ResourceLocation CMM_ZOMBIE_VILLAGER_PRIEST_LOCATION = new ResourceLocation("ageofminecraft", "textures/entities/yarrscmm/zombiev4.png");
    private static final ResourceLocation CMM_ZOMBIE_VILLAGER_SMITH_LOCATION = new ResourceLocation("ageofminecraft", "textures/entities/yarrscmm/zombiev5.png");
    private static final ResourceLocation CMM_ZOMBIE_VILLAGER_BUTCHER_LOCATION = new ResourceLocation("ageofminecraft", "textures/entities/yarrscmm/zombiev6.png");
    private static final ResourceLocation CMM_ZOMBIE_TEXTURES = new ResourceLocation("ageofminecraft", "textures/entities/yarrscmm/zombie.png");
    private static final ResourceLocation CMM_HUSK_ZOMBIE_TEXTURES = new ResourceLocation("ageofminecraft", "textures/entities/yarrscmm/zombiehusk.png");
    private static final ResourceLocation CMM_PRISON_ZOMBIE_TEXTURES = new ResourceLocation("ageofminecraft", "textures/entities/yarrscmm/zombieprison.png");
    private static final ResourceLocation ZOMBIE_VILLAGER_TEXTURES = new ResourceLocation("textures/entity/zombie_villager/zombie_villager.png");
    private static final ResourceLocation ZOMBIE_VILLAGER_FARMER_LOCATION = new ResourceLocation("textures/entity/zombie_villager/zombie_farmer.png");
    private static final ResourceLocation ZOMBIE_VILLAGER_LIBRARIAN_LOC = new ResourceLocation("textures/entity/zombie_villager/zombie_librarian.png");
    private static final ResourceLocation ZOMBIE_VILLAGER_PRIEST_LOCATION = new ResourceLocation("textures/entity/zombie_villager/zombie_priest.png");
    private static final ResourceLocation ZOMBIE_VILLAGER_SMITH_LOCATION = new ResourceLocation("textures/entity/zombie_villager/zombie_smith.png");
    private static final ResourceLocation ZOMBIE_VILLAGER_BUTCHER_LOCATION = new ResourceLocation("textures/entity/zombie_villager/zombie_butcher.png");
    private static final ResourceLocation ZOMBIE_TEXTURES = new ResourceLocation("textures/entity/zombie/zombie.png");
    private static final ResourceLocation HUSK_ZOMBIE_TEXTURES = new ResourceLocation("textures/entity/zombie/husk.png");
    private static final ResourceLocation PRISON_ZOMBIE_TEXTURES = new ResourceLocation("ageofminecraft", "textures/entities/prisonzombie.png");
    private static final ResourceLocation antiCMM_ZOMBIE_TEXTURES = new ResourceLocation("ageofminecraft", "textures/entities/yarrscmm/anti/zombie.png");
    private static final ResourceLocation antiCMM_HUSK_ZOMBIE_TEXTURES = new ResourceLocation("ageofminecraft", "textures/entities/yarrscmm/anti/zombiehusk.png");
    private static final ResourceLocation antiCMM_PRISON_ZOMBIE_TEXTURES = new ResourceLocation("ageofminecraft", "textures/entities/yarrscmm/anti/zombieprison.png");
    private static final ResourceLocation antiZOMBIE_TEXTURES = new ResourceLocation("ageofminecraft", "textures/entities/anti/zombie.png");
    private static final ResourceLocation antiHUSK_ZOMBIE_TEXTURES = new ResourceLocation("ageofminecraft", "textures/entities/anti/husk.png");
    private static final ResourceLocation antiPRISON_ZOMBIE_TEXTURES = new ResourceLocation("ageofminecraft", "textures/entities/anti/prisonzombie.png");
    private static final ResourceLocation DAVE_ZOMBIE_TEXTURES = new ResourceLocation("ageofminecraft", "textures/entities/dave.png");
    private static final ResourceLocation MARK_ZOMBIE_TEXTURES = new ResourceLocation("ageofminecraft", "textures/entities/mark.png");
    private LayerCustomArmor armor = new LayerCustomArmor((RenderLivingBase<?>)this);
    private static ModelCMMZombie cmmmodel = new ModelCMMZombie();
    private static ModelZombieVillager sregularmodel = new ModelZombieVillager();
    private static ModelZombie regularmodel = new ModelZombie();
    private static ModelCMMZombie cmmleggings = new ModelCMMZombie(0.5f, true);
    private static ModelZombieVillager sregularleggings = new ModelZombieVillager(0.5f, 0.0f, true);
    private static ModelZombie regularleggings = new ModelZombie(0.5f, true);
    private static ModelCMMZombie cmmarmor = new ModelCMMZombie(1.0f, true);
    private static ModelZombieVillager sregulararmor = new ModelZombieVillager(1.0f, 0.0f, true);
    private static ModelZombie regulararmor = new ModelZombie(1.0f, true);

    public RenderZombie(RenderManager renderManagerIn) {
        super(renderManagerIn, (ModelBase)(EngenderMod.useMobTalkerModels ? cmmmodel : regularmodel), 0.5f);
        this.func_177094_a(new LayerArrowCustomSized((RenderLivingBase<?>)this, 1.0f));
        this.func_177094_a(new LayerLearningBook(this));
        this.func_177094_a(new LayerMobCape((RenderLivingBase)this));
        this.armor = new LayerCustomArmor((RenderLivingBase)this){

            @Override
            protected void func_177177_a() {
                this.field_177189_c = EngenderMod.useMobTalkerModels ? cmmleggings : regularleggings;
                this.field_177186_d = EngenderMod.useMobTalkerModels ? cmmarmor : regulararmor;
            }
        };
        this.func_177094_a((LayerRenderer)this.armor);
        this.func_177094_a((LayerRenderer)new LayerElytra((RenderLivingBase)this));
        this.func_177094_a((LayerRenderer)new LayerHeldItem((RenderLivingBase)this));
        this.func_177094_a(new LayerCustomHeadEngender(RenderZombie.regularmodel.field_78116_c, RenderZombie.cmmmodel.Head));
    }

    private void changeModel(final EntityZombie entitylivingbaseIn) {
        this.field_77045_g = EngenderMod.useMobTalkerModels ? cmmmodel : (entitylivingbaseIn.isVillager() ? sregularmodel : regularmodel);
        this.field_177097_h.remove((Object)this.armor);
        this.armor = new LayerCustomArmor((RenderLivingBase)this){

            @Override
            protected void func_177177_a() {
                ModelBiped modelBiped = EngenderMod.useMobTalkerModels ? cmmleggings : (this.field_177189_c = entitylivingbaseIn.isVillager() ? sregularleggings : regularleggings);
                this.field_177186_d = EngenderMod.useMobTalkerModels ? cmmarmor : (entitylivingbaseIn.isVillager() ? sregulararmor : regulararmor);
            }
        };
        this.func_177094_a((LayerRenderer)this.armor);
    }

    public void func_82422_c() {
        GlStateManager.func_179109_b((float)0.0f, (float)0.1875f, (float)0.0f);
    }

    protected void preRenderCallback(EntityZombie entitylivingbaseIn, float partialTickTime) {
        this.changeModel(entitylivingbaseIn);
        if (EngenderMod.useMobTalkerModels) {
            if (entitylivingbaseIn.isSitResting()) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.6f, (float)0.0f);
            }
            if (entitylivingbaseIn.isSitResting() && entitylivingbaseIn.func_70631_g_()) {
                GlStateManager.func_179109_b((float)0.0f, (float)-0.3f, (float)0.0f);
            }
        } else if (entitylivingbaseIn.func_70093_af()) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
        }
        if (entitylivingbaseIn.getZombieType() == 1) {
            GlStateManager.func_179152_a((float)1.0625f, (float)1.0625f, (float)1.0625f);
        }
        float fit = entitylivingbaseIn.getFittness();
        GlStateManager.func_179152_a((float)fit, (float)fit, (float)fit);
        if (entitylivingbaseIn.isHero()) {
            GlStateManager.func_179152_a((float)1.05f, (float)1.05f, (float)1.05f);
        }
        if (!entitylivingbaseIn.field_70122_E) {
            GlStateManager.func_179114_b((float)(entitylivingbaseIn.prevRotationPitchFalling + (entitylivingbaseIn.rotationPitchFalling - entitylivingbaseIn.prevRotationPitchFalling) * 2.0f - 1.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (entitylivingbaseIn.field_70173_aa <= 21 && entitylivingbaseIn.field_70173_aa > 0) {
            float f5 = ((float)entitylivingbaseIn.field_70173_aa + partialTickTime - 1.0f) / 20.0f * 1.6f;
            if ((f5 = MathHelper.func_76129_c((float)f5)) > 1.0f) {
                f5 = 1.0f;
            }
            GlStateManager.func_179152_a((float)f5, (float)f5, (float)f5);
            GlStateManager.func_179114_b((float)(f5 * 90.0f - 90.0f), (float)f5, (float)f5, (float)f5);
        }
    }

    protected ResourceLocation getEntityTexture(EntityZombie entity) {
        String s = TextFormatting.func_110646_a((String)entity.func_70005_c_());
        if (EngenderMod.useMobTalkerModels) {
            switch (entity.getZombieType()) {
                case 1: {
                    return entity.isAntiMob() ? antiCMM_HUSK_ZOMBIE_TEXTURES : CMM_HUSK_ZOMBIE_TEXTURES;
                }
                case 2: {
                    return entity.isAntiMob() ? antiCMM_PRISON_ZOMBIE_TEXTURES : CMM_PRISON_ZOMBIE_TEXTURES;
                }
            }
            if (entity.isVillager()) {
                switch (entity.getVillagerType()) {
                    case 0: {
                        return CMM_ZOMBIE_VILLAGER_FARMER_LOCATION;
                    }
                    case 1: {
                        return CMM_ZOMBIE_VILLAGER_LIBRARIAN_LOC;
                    }
                    case 2: {
                        return CMM_ZOMBIE_VILLAGER_PRIEST_LOCATION;
                    }
                    case 3: {
                        return CMM_ZOMBIE_VILLAGER_SMITH_LOCATION;
                    }
                    case 4: {
                        return CMM_ZOMBIE_VILLAGER_BUTCHER_LOCATION;
                    }
                }
                return CMM_ZOMBIE_VILLAGER_TEXTURES;
            }
            return entity.isAntiMob() ? antiCMM_ZOMBIE_TEXTURES : CMM_ZOMBIE_TEXTURES;
        }
        switch (entity.getZombieType()) {
            case 1: {
                return entity.isAntiMob() ? antiHUSK_ZOMBIE_TEXTURES : HUSK_ZOMBIE_TEXTURES;
            }
            case 2: {
                return entity.isAntiMob() ? antiPRISON_ZOMBIE_TEXTURES : PRISON_ZOMBIE_TEXTURES;
            }
        }
        if (entity.isVillager()) {
            switch (entity.getVillagerType()) {
                case 0: {
                    return ZOMBIE_VILLAGER_FARMER_LOCATION;
                }
                case 1: {
                    return ZOMBIE_VILLAGER_LIBRARIAN_LOC;
                }
                case 2: {
                    return ZOMBIE_VILLAGER_PRIEST_LOCATION;
                }
                case 3: {
                    return ZOMBIE_VILLAGER_SMITH_LOCATION;
                }
                case 4: {
                    return ZOMBIE_VILLAGER_BUTCHER_LOCATION;
                }
            }
            return ZOMBIE_VILLAGER_TEXTURES;
        }
        return entity.isAntiMob() ? antiZOMBIE_TEXTURES : (s != null && s.equals("Dave") ? DAVE_ZOMBIE_TEXTURES : (s != null && s.equals("Mark") ? MARK_ZOMBIE_TEXTURES : ZOMBIE_TEXTURES));
    }

    protected void applyRotations(EntityZombie entityLiving, float p_77043_2_, float p_77043_3_, float partialTicks) {
        if (entityLiving.isConverting()) {
            p_77043_3_ += (float)(Math.cos((double)entityLiving.field_70173_aa * 3.25) * Math.PI);
        }
        if (entityLiving.func_70027_ad()) {
            p_77043_3_ += (float)(Math.cos((double)entityLiving.field_70173_aa * 1.0) * Math.PI);
        }
        if (entityLiving.func_184613_cA()) {
            super.func_77043_a((EntityLivingBase)entityLiving, p_77043_2_, p_77043_3_, partialTicks);
            float f = (float)entityLiving.func_184599_cB() + partialTicks;
            float f1 = MathHelper.func_76131_a((float)(f * f / 100.0f), (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)(f1 * (-90.0f - entityLiving.field_70125_A)), (float)1.0f, (float)0.0f, (float)0.0f);
            Vec3d vec3d = entityLiving.func_70676_i(partialTicks);
            double d0 = entityLiving.field_70159_w * entityLiving.field_70159_w + entityLiving.field_70179_y * entityLiving.field_70179_y;
            double d1 = vec3d.field_72450_a * vec3d.field_72450_a + vec3d.field_72449_c * vec3d.field_72449_c;
            if (d0 > 0.0 && d1 > 0.0) {
                double d2 = (entityLiving.field_70159_w * vec3d.field_72450_a + entityLiving.field_70179_y * vec3d.field_72449_c) / (Math.sqrt(d0) * Math.sqrt(d1));
                double d3 = entityLiving.field_70159_w * vec3d.field_72449_c - entityLiving.field_70179_y * vec3d.field_72450_a;
                GlStateManager.func_179114_b((float)((float)(Math.signum(d3) * Math.acos(d2)) * 180.0f / (float)Math.PI), (float)0.0f, (float)1.0f, (float)0.0f);
            }
        } else {
            GlStateManager.func_179114_b((float)(180.0f - p_77043_3_), (float)0.0f, (float)1.0f, (float)0.0f);
            if (entityLiving.field_70725_aQ > 0) {
                float f = ((float)entityLiving.field_70725_aQ + partialTicks - 1.0f) / 20.0f * 1.6f;
                if ((f = MathHelper.func_76129_c((float)f)) > 1.0f) {
                    f = 1.0f;
                }
                if (EngenderMod.useMobTalkerModels) {
                    GlStateManager.func_179114_b((float)(f * this.func_77037_a((EntityLivingBase)entityLiving)), (float)1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)(-f * 0.1f));
                } else {
                    GlStateManager.func_179114_b((float)(f * this.func_77037_a((EntityLivingBase)entityLiving)), (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_179109_b((float)(f * 0.25f), (float)0.0f, (float)0.0f);
                }
            } else {
                String s = TextFormatting.func_110646_a((String)entityLiving.func_70005_c_());
                if (s != null && ("Dinnerbone".equals(s) || "Grumm".equals(s))) {
                    GlStateManager.func_179109_b((float)0.0f, (float)(entityLiving.field_70131_O + 0.1f), (float)0.0f);
                    GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                }
            }
        }
    }
}

