/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.AgeOfMinecraft.render;

import net.minecraft.AgeOfMinecraft.models.ModelWither;
import net.minecraft.AgeOfMinecraft.render.LayerArrowCustomSized;
import net.minecraft.AgeOfMinecraft.render.LayerCustomHeadEngender;
import net.minecraft.AgeOfMinecraft.render.LayerLearningBook;
import net.minecraft.AgeOfMinecraft.render.LayerMobCape;
import net.minecraft.AgeOfMinecraft.render.LayerWitherAura;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.helpful.tier5.EntityWither;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderWither
extends RenderLiving<EntityWither> {
    private static final ResourceLocation invulnerableWitherTextures = new ResourceLocation("textures/entity/wither/wither_invulnerable.png");
    private static final ResourceLocation witherTextures = new ResourceLocation("textures/entity/wither/wither.png");
    private static ModelWither regularmodel = new ModelWither(0.0f);

    public RenderWither(RenderManager renderManagerIn) {
        super(renderManagerIn, (ModelBase)regularmodel, 1.0f);
        this.func_177094_a(new LayerWitherAura(this));
        this.func_177094_a(new LayerArrowCustomSized((RenderLivingBase<?>)this, 0.5f));
        this.func_177094_a(new LayerCustomHeadEngender(RenderWither.regularmodel.heads[0], RenderWither.regularmodel.heads[0]));
        this.func_177094_a(new LayerLearningBook(this));
        this.func_177094_a(new LayerMobCape((RenderLivingBase)this));
    }

    protected ResourceLocation getEntityTexture(EntityWither entity) {
        int i = entity.getInvulTime();
        return i > 0 && (i > 80 || i / 5 % 2 != 1) ? invulnerableWitherTextures : witherTextures;
    }

    protected void applyRotations(EntityWither entitylivingbaseIn, float p_77043_2_, float p_77043_3_, float partialTicks) {
        if (!(entitylivingbaseIn.field_70122_E || entitylivingbaseIn.func_184207_aI() || entitylivingbaseIn.func_82150_aj())) {
            GlStateManager.func_179109_b((float)0.0f, (float)(MathHelper.func_76134_b((float)(p_77043_2_ * 0.2f)) * 0.2f), (float)0.0f);
        }
        super.func_77043_a((EntityLivingBase)entitylivingbaseIn, p_77043_2_, p_77043_3_, partialTicks);
    }

    protected void preRenderCallback(EntityWither entitylivingbaseIn, float partialTickTime) {
        float fit = entitylivingbaseIn.getFittness();
        GlStateManager.func_179152_a((float)fit, (float)fit, (float)fit);
        float f = 2.0f;
        int i = entitylivingbaseIn.getInvulTime();
        if (i > 0) {
            f -= ((float)i - partialTickTime) / 220.0f * 0.5f;
        }
        GlStateManager.func_179152_a((float)f, (float)f, (float)f);
        GlStateManager.func_179109_b((float)0.0f, (float)0.1f, (float)0.0f);
        if (entitylivingbaseIn.func_70093_af() || entitylivingbaseIn.getRamTime() < 180 && entitylivingbaseIn.getRamTime() > 100) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.5f, (float)0.0f);
        }
        if (entitylivingbaseIn.isHero()) {
            GlStateManager.func_179152_a((float)1.05f, (float)1.05f, (float)1.05f);
        }
        float f1 = entitylivingbaseIn.getCreeperFlashIntensity(partialTickTime);
        float f11 = 1.0f + MathHelper.func_76126_a((float)(f1 * 100.0f)) * f1 * 0.01f;
        f1 = MathHelper.func_76131_a((float)f1, (float)0.0f, (float)1.0f);
        f1 *= f1;
        f1 *= f1;
        float f2 = (1.0f + f1 * 0.8f) * f11;
        float f3 = (1.0f + f1 * 0.4f) / f11;
        GlStateManager.func_179152_a((float)f2, (float)f3, (float)f2);
    }

    protected int getColorMultiplier(EntityWither entitylivingbaseIn, float lightBrightness, float partialTickTime) {
        float f = entitylivingbaseIn.getCreeperFlashIntensity(partialTickTime);
        if ((int)(f * 10.0f) % 2 == 0) {
            return 0;
        }
        int i = (int)(f * 0.2f * 255.0f);
        i = MathHelper.func_76125_a((int)i, (int)0, (int)255);
        return i << 24 | 0x30FFFFFF;
    }
}

