/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.AgeOfMinecraft.render;

import net.minecraft.AgeOfMinecraft.EngenderMod;
import net.minecraft.AgeOfMinecraft.models.ModelCMMVillager;
import net.minecraft.AgeOfMinecraft.render.LayerArrowCustomSized;
import net.minecraft.AgeOfMinecraft.render.LayerCustomHeadEngender;
import net.minecraft.AgeOfMinecraft.render.LayerLearningBook;
import net.minecraft.AgeOfMinecraft.render.LayerMobCape;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelVillager;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.helpful.tier2.EntityVillager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderVillager
extends RenderLiving<EntityVillager> {
    private static final ResourceLocation cmmvillagerTextures = new ResourceLocation("ageofminecraft", "textures/entities/yarrscmm/vill1.png");
    private static final ResourceLocation cmmfarmerVillagerTextures = new ResourceLocation("ageofminecraft", "textures/entities/yarrscmm/vill2.png");
    private static final ResourceLocation cmmlibrarianVillagerTextures = new ResourceLocation("ageofminecraft", "textures/entities/yarrscmm/vill3.png");
    private static final ResourceLocation cmmpriestVillagerTextures = new ResourceLocation("ageofminecraft", "textures/entities/yarrscmm/vill4.png");
    private static final ResourceLocation cmmsmithVillagerTextures = new ResourceLocation("ageofminecraft", "textures/entities/yarrscmm/vill5.png");
    private static final ResourceLocation cmmbutcherVillagerTextures = new ResourceLocation("ageofminecraft", "textures/entities/yarrscmm/vill6.png");
    private static final ResourceLocation villagerTextures = new ResourceLocation("textures/entity/villager/villager.png");
    private static final ResourceLocation farmerVillagerTextures = new ResourceLocation("textures/entity/villager/farmer.png");
    private static final ResourceLocation librarianVillagerTextures = new ResourceLocation("textures/entity/villager/librarian.png");
    private static final ResourceLocation priestVillagerTextures = new ResourceLocation("textures/entity/villager/priest.png");
    private static final ResourceLocation smithVillagerTextures = new ResourceLocation("textures/entity/villager/smith.png");
    private static final ResourceLocation butcherVillagerTextures = new ResourceLocation("textures/entity/villager/butcher.png");
    private static final ResourceLocation anticmmvillagerTextures = new ResourceLocation("ageofminecraft", "textures/entities/yarrscmm/anti/vill1.png");
    private static final ResourceLocation antivillagerTextures = new ResourceLocation("ageofminecraft", "textures/entities/anti/villager.png");
    private static ModelCMMVillager cmmmodel = new ModelCMMVillager();
    private static ModelVillager regularmodel = new ModelVillager(0.0f);

    public RenderVillager(RenderManager renderManagerIn) {
        super(renderManagerIn, (ModelBase)(EngenderMod.useMobTalkerModels ? cmmmodel : regularmodel), 0.5f);
        this.func_177094_a(new LayerArrowCustomSized((RenderLivingBase<?>)this, 1.0f));
        this.func_177094_a(new LayerCustomHeadEngender(RenderVillager.regularmodel.field_78191_a, RenderVillager.cmmmodel.Head));
        this.func_177094_a(new LayerLearningBook(this));
        this.func_177094_a(new LayerMobCape((RenderLivingBase)this));
    }

    protected ResourceLocation getEntityTexture(EntityVillager entity) {
        if (EngenderMod.useMobTalkerModels) {
            if (entity.isAntiMob()) {
                return anticmmvillagerTextures;
            }
            switch (entity.getProfession()) {
                case 0: {
                    return cmmfarmerVillagerTextures;
                }
                case 1: {
                    return cmmlibrarianVillagerTextures;
                }
                case 2: {
                    return cmmpriestVillagerTextures;
                }
                case 3: {
                    return cmmsmithVillagerTextures;
                }
                case 4: {
                    return cmmbutcherVillagerTextures;
                }
            }
            return cmmvillagerTextures;
        }
        if (entity.isAntiMob()) {
            return antivillagerTextures;
        }
        switch (entity.getProfession()) {
            case 0: {
                return farmerVillagerTextures;
            }
            case 1: {
                return librarianVillagerTextures;
            }
            case 2: {
                return priestVillagerTextures;
            }
            case 3: {
                return smithVillagerTextures;
            }
            case 4: {
                return butcherVillagerTextures;
            }
        }
        return villagerTextures;
    }

    protected void applyRotations(EntityVillager entityLiving, float p_77043_2_, float p_77043_3_, float partialTicks) {
        GlStateManager.func_179114_b((float)(180.0f - p_77043_3_), (float)0.0f, (float)1.0f, (float)0.0f);
        if (entityLiving.field_70725_aQ > 0) {
            float f = ((float)entityLiving.field_70725_aQ + partialTicks - 1.0f) / 20.0f * 1.6f;
            if ((f = MathHelper.func_76129_c((float)f)) > 1.0f) {
                f = 1.0f;
            }
            if (EngenderMod.useMobTalkerModels) {
                GlStateManager.func_179114_b((float)(f * this.func_77037_a((EntityLivingBase)entityLiving)), (float)-1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)(f * 0.1f));
            } else {
                GlStateManager.func_179114_b((float)(f * this.func_77037_a((EntityLivingBase)entityLiving)), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179109_b((float)(f * 0.25f), (float)0.0f, (float)0.0f);
            }
        } else {
            String s = TextFormatting.func_110646_a((String)entityLiving.func_70005_c_());
            if (s != null && ("Dinnerbone".equals(s) || "Grumm".equals(s))) {
                GlStateManager.func_179109_b((float)0.0f, (float)(entityLiving.field_70131_O + 0.1f), (float)0.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
        }
    }

    protected void preRenderCallback(EntityVillager entitylivingbaseIn, float partialTickTime) {
        this.field_77045_g = EngenderMod.useMobTalkerModels ? cmmmodel : regularmodel;
        float f = 0.9375f;
        if (!EngenderMod.useMobTalkerModels) {
            GlStateManager.func_179152_a((float)f, (float)f, (float)f);
            if (entitylivingbaseIn.func_70631_g_()) {
                GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
            }
        }
        if (EngenderMod.useMobTalkerModels) {
            if (entitylivingbaseIn.isSitResting()) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.6f, (float)0.0f);
            }
            if (entitylivingbaseIn.isSitResting() && entitylivingbaseIn.func_70631_g_()) {
                GlStateManager.func_179109_b((float)0.0f, (float)-0.3f, (float)0.0f);
            }
            if (entitylivingbaseIn.func_184218_aH() && entitylivingbaseIn.func_70631_g_()) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.6f, (float)0.25f);
            }
        }
        float fit = entitylivingbaseIn.getFittness();
        GlStateManager.func_179152_a((float)fit, (float)fit, (float)fit);
        if (entitylivingbaseIn.isHero()) {
            GlStateManager.func_179152_a((float)1.05f, (float)1.05f, (float)1.05f);
        }
        if (!entitylivingbaseIn.field_70122_E) {
            GlStateManager.func_179114_b((float)(entitylivingbaseIn.prevRotationPitchFalling + (entitylivingbaseIn.rotationPitchFalling - entitylivingbaseIn.prevRotationPitchFalling) * 2.0f - 1.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (entitylivingbaseIn.field_70173_aa <= 21 && entitylivingbaseIn.field_70173_aa > 0) {
            float f5 = ((float)entitylivingbaseIn.field_70173_aa + partialTickTime - 1.0f) / 20.0f * 1.6f;
            if ((f5 = MathHelper.func_76129_c((float)f5)) > 1.0f) {
                f5 = 1.0f;
            }
            GlStateManager.func_179152_a((float)f5, (float)f5, (float)f5);
            GlStateManager.func_179114_b((float)(f5 * 90.0f - 90.0f), (float)f5, (float)f5, (float)f5);
        }
    }
}

