/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.AgeOfMinecraft.render;

import net.minecraft.AgeOfMinecraft.models.ModelVex;
import net.minecraft.AgeOfMinecraft.render.LayerCustomHeadEngender;
import net.minecraft.AgeOfMinecraft.render.LayerLearningBook;
import net.minecraft.AgeOfMinecraft.render.LayerMobCape;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderBiped;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.helpful.tier3.EntityVex;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderVex
extends RenderBiped<EntityVex> {
    private static final ResourceLocation VEX_TEXTURE = new ResourceLocation("textures/entity/illager/vex.png");
    private static final ResourceLocation VEX_CHARGING_TEXTURE = new ResourceLocation("textures/entity/illager/vex_charging.png");
    private static final ResourceLocation antiVEX_TEXTURE = new ResourceLocation("ageofminecraft", "textures/entities/anti/vex.png");
    private static final ResourceLocation antiVEX_CHARGING_TEXTURE = new ResourceLocation("ageofminecraft", "textures/entities/anti/vex_charging.png");
    private int modelVersion;

    public RenderVex(RenderManager p_i47190_1_) {
        super(p_i47190_1_, (ModelBiped)new ModelVex(), 0.3f);
        this.modelVersion = ((ModelVex)this.field_77045_g).getModelVersion();
        this.func_177094_a(new LayerCustomHeadEngender(((ModelVex)this.field_77045_g).field_78116_c, ((ModelVex)this.field_77045_g).field_78116_c));
        this.func_177094_a(new LayerLearningBook((RenderLiving)this));
        this.func_177094_a(new LayerMobCape((RenderLivingBase)this));
    }

    protected ResourceLocation getEntityTexture(EntityVex entity) {
        return entity.isCharging() ? (entity.isAntiMob() ? antiVEX_CHARGING_TEXTURE : VEX_CHARGING_TEXTURE) : (entity.isAntiMob() ? antiVEX_TEXTURE : VEX_TEXTURE);
    }

    public void doRender(EntityVex entity, double x, double y, double z, float entityYaw, float partialTicks) {
        int i = ((ModelVex)this.field_77045_g).getModelVersion();
        if (i != this.modelVersion) {
            this.field_77045_g = new ModelVex();
            this.modelVersion = i;
        }
        super.func_76986_a((EntityLiving)entity, x, y, z, entityYaw, partialTicks);
    }

    protected void preRenderCallback(EntityVex entitylivingbaseIn, float partialTickTime) {
        float fit = entitylivingbaseIn.getFittness();
        GlStateManager.func_179152_a((float)fit, (float)fit, (float)fit);
        GlStateManager.func_179152_a((float)0.4f, (float)0.4f, (float)0.4f);
        if (entitylivingbaseIn.isHero()) {
            GlStateManager.func_179152_a((float)1.05f, (float)1.05f, (float)1.05f);
        }
        if (entitylivingbaseIn.field_70173_aa <= 21 && entitylivingbaseIn.field_70173_aa > 0) {
            float f5 = ((float)entitylivingbaseIn.field_70173_aa + partialTickTime - 1.0f) / 20.0f * 1.6f;
            if ((f5 = MathHelper.func_76129_c((float)f5)) > 1.0f) {
                f5 = 1.0f;
            }
            GlStateManager.func_179152_a((float)f5, (float)f5, (float)f5);
            GlStateManager.func_179114_b((float)(f5 * 90.0f - 90.0f), (float)f5, (float)f5, (float)f5);
        }
    }
}

