/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.AgeOfMinecraft.render;

import net.minecraft.AgeOfMinecraft.render.LayerArrowCustomSized;
import net.minecraft.AgeOfMinecraft.render.LayerLearningBook;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelSquid;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.helpful.tier2.EntitySquid;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderSquid
extends RenderLiving<EntitySquid> {
    private static final ResourceLocation squidTextures = new ResourceLocation("textures/entity/squid.png");
    private static final ResourceLocation antisquidTextures = new ResourceLocation("textures/entity/squid.png");

    public RenderSquid(RenderManager p_i46138_1_) {
        super(p_i46138_1_, (ModelBase)new ModelSquid(), 0.7f);
        this.func_177094_a(new LayerArrowCustomSized((RenderLivingBase<?>)this, 1.0f));
        this.func_177094_a(new LayerLearningBook(this));
    }

    protected ResourceLocation getEntityTexture(EntitySquid entity) {
        return entity.isAntiMob() ? antisquidTextures : squidTextures;
    }

    protected void applyRotations(EntitySquid entityLiving, float p_77043_2_, float p_77043_3_, float partialTicks) {
        float f = entityLiving.prevSquidPitch + (entityLiving.squidPitch - entityLiving.prevSquidPitch) * partialTicks;
        float f1 = entityLiving.prevSquidYaw + (entityLiving.squidYaw - entityLiving.prevSquidYaw) * partialTicks;
        GlStateManager.func_179109_b((float)0.0f, (float)0.5f, (float)0.0f);
        GlStateManager.func_179114_b((float)(180.0f - p_77043_3_), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)f1, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)-1.2f, (float)0.0f);
        if (entityLiving.func_70631_g_()) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.6f, (float)0.0f);
        }
        GlStateManager.func_179114_b((float)(90.0f - p_77043_3_), (float)0.0f, (float)1.0f, (float)0.0f);
        if (entityLiving.field_70725_aQ > 0) {
            float f11 = ((float)entityLiving.field_70725_aQ + partialTicks - 1.0f) / 20.0f * 1.6f;
            if ((f11 = MathHelper.func_76129_c((float)f11)) > 1.0f) {
                f11 = 1.0f;
            }
            GlStateManager.func_179114_b((float)(f11 * 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        } else {
            String s = TextFormatting.func_110646_a((String)entityLiving.func_70005_c_());
            if (s != null && (s.equals("Dinnerbone") || s.equals("Grumm"))) {
                GlStateManager.func_179109_b((float)0.0f, (float)(entityLiving.field_70131_O + 0.1f), (float)0.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
        }
    }

    protected float handleRotationFloat(EntitySquid livingBase, float partialTicks) {
        return livingBase.lastTentacleAngle + (livingBase.tentacleAngle - livingBase.lastTentacleAngle) * partialTicks;
    }

    protected void preRenderCallback(EntitySquid entitylivingbaseIn, float partialTickTime) {
        if (entitylivingbaseIn.func_70631_g_()) {
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        }
        float fit = entitylivingbaseIn.getFittness();
        GlStateManager.func_179152_a((float)fit, (float)fit, (float)fit);
        if (entitylivingbaseIn.isHero()) {
            GlStateManager.func_179152_a((float)1.05f, (float)1.05f, (float)1.05f);
        }
        if (!entitylivingbaseIn.field_70122_E) {
            GlStateManager.func_179114_b((float)(entitylivingbaseIn.prevRotationPitchFalling + (entitylivingbaseIn.rotationPitchFalling - entitylivingbaseIn.prevRotationPitchFalling) * 2.0f - 1.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (entitylivingbaseIn.field_70173_aa <= 21 && entitylivingbaseIn.field_70173_aa > 0) {
            float f5 = ((float)entitylivingbaseIn.field_70173_aa + partialTickTime - 1.0f) / 20.0f * 1.6f;
            if ((f5 = MathHelper.func_76129_c((float)f5)) > 1.0f) {
                f5 = 1.0f;
            }
            GlStateManager.func_179152_a((float)f5, (float)f5, (float)f5);
            GlStateManager.func_179114_b((float)(f5 * 90.0f - 90.0f), (float)f5, (float)f5, (float)f5);
        }
    }
}

