/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.AgeOfMinecraft.render;

import net.minecraft.AgeOfMinecraft.EngenderMod;
import net.minecraft.AgeOfMinecraft.models.ModelCMMCaveSpider;
import net.minecraft.AgeOfMinecraft.models.ModelCMMSpider;
import net.minecraft.AgeOfMinecraft.models.ModelSpider;
import net.minecraft.AgeOfMinecraft.render.LayerArrowCustomSized;
import net.minecraft.AgeOfMinecraft.render.LayerCustomHeadEngender;
import net.minecraft.AgeOfMinecraft.render.LayerLearningBook;
import net.minecraft.AgeOfMinecraft.render.LayerMobCape;
import net.minecraft.AgeOfMinecraft.render.LayerSpiderEyes;
import net.minecraft.AgeOfMinecraft.render.RenderCaveSpider;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.tier3.EntitySpider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderSpider<T extends EntitySpider>
extends RenderLiving<T> {
    private static final ResourceLocation cmmSpiderTextures = new ResourceLocation("ageofminecraft", "textures/entities/yarrscmm/spider.png");
    private static final ResourceLocation spiderTextures = new ResourceLocation("textures/entity/spider/spider.png");
    private static final ResourceLocation stcmmSpiderTextures = new ResourceLocation("ageofminecraft", "textures/entities/yarrscmm/stspider.png");
    private static final ResourceLocation stspiderTextures = new ResourceLocation("ageofminecraft", "textures/entities/survival_test_spider.png");
    private static final ResourceLocation anticmmSpiderTextures = new ResourceLocation("ageofminecraft", "textures/entities/yarrscmm/anti/spider.png");
    private static final ResourceLocation antispiderTextures = new ResourceLocation("ageofminecraft", "textures/entities/anti/spider.png");
    private static ModelCMMCaveSpider scmmmodel = new ModelCMMCaveSpider();
    private static ModelCMMSpider cmmmodel = new ModelCMMSpider();
    private static ModelSpider regularmodel = new ModelSpider();

    public RenderSpider(RenderManager renderManagerIn) {
        super(renderManagerIn, (ModelBase)regularmodel, EngenderMod.useMobTalkerModels ? 0.5f : 1.0f);
        this.func_177094_a(new LayerSpiderEyes(this));
        this.func_177094_a(new LayerArrowCustomSized((RenderLivingBase<?>)this, 1.0f));
        this.func_177094_a(new LayerCustomHeadEngender(RenderSpider.regularmodel.spiderHead, RenderSpider.cmmmodel.Head));
        this.func_177094_a(new LayerLearningBook(this));
        this.func_177094_a(new LayerMobCape((RenderLivingBase)this));
    }

    protected float getDeathMaxRotation(EntitySpider entityLiving) {
        return EngenderMod.useMobTalkerModels ? 90.0f : 180.0f;
    }

    protected void preRenderCallback(EntitySpider entitylivingbaseIn, float partialTickTime) {
        float f = this.field_76989_e = EngenderMod.useMobTalkerModels ? 0.5f : 1.0f;
        Object object = EngenderMod.useMobTalkerModels ? (this instanceof RenderCaveSpider ? scmmmodel : cmmmodel) : (this.field_77045_g = regularmodel);
        if (!EngenderMod.useMobTalkerModels) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.05f, (float)0.0f);
            if (entitylivingbaseIn.func_70631_g_()) {
                GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
            }
        }
        if (entitylivingbaseIn.func_184218_aH()) {
            GlStateManager.func_179109_b((float)0.0f, (float)-0.325f, (float)0.0f);
        }
        if (!EngenderMod.useMobTalkerModels && entitylivingbaseIn.func_70093_af()) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
        }
        if (EngenderMod.useMobTalkerModels) {
            GlStateManager.func_179152_a((float)0.85f, (float)0.85f, (float)0.85f);
            if (entitylivingbaseIn.isSitResting()) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.6f, (float)0.0f);
            }
            if (entitylivingbaseIn.isSitResting() && entitylivingbaseIn.func_70631_g_()) {
                GlStateManager.func_179109_b((float)0.0f, (float)-0.3f, (float)0.0f);
            }
            if (entitylivingbaseIn.func_70617_f_()) {
                GlStateManager.func_179109_b((float)0.0f, (float)-0.5f, (float)0.0f);
            }
            if (entitylivingbaseIn.func_184218_aH()) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.6f, (float)0.25f);
            }
            if (!(entitylivingbaseIn.field_70122_E || entitylivingbaseIn.func_70617_f_() || entitylivingbaseIn.func_184218_aH())) {
                GlStateManager.func_179114_b((float)45.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
            if (entitylivingbaseIn.func_184207_aI() && !entitylivingbaseIn.field_70122_E) {
                if (!entitylivingbaseIn.func_70617_f_()) {
                    GlStateManager.func_179109_b((float)0.0f, (float)-0.5f, (float)1.0f);
                }
                GlStateManager.func_179109_b((float)0.0f, (float)-0.5f, (float)-0.2f);
            }
        }
        float fit = entitylivingbaseIn.getFittness();
        GlStateManager.func_179152_a((float)fit, (float)fit, (float)fit);
        if (entitylivingbaseIn.isHero()) {
            GlStateManager.func_179152_a((float)1.05f, (float)1.05f, (float)1.05f);
        }
        if (!entitylivingbaseIn.field_70122_E) {
            GlStateManager.func_179114_b((float)(entitylivingbaseIn.prevRotationPitchFalling + (entitylivingbaseIn.rotationPitchFalling - entitylivingbaseIn.prevRotationPitchFalling) * 2.0f - 1.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (entitylivingbaseIn.field_70173_aa <= 21 && entitylivingbaseIn.field_70173_aa > 0) {
            float f5 = ((float)entitylivingbaseIn.field_70173_aa + partialTickTime - 1.0f) / 20.0f * 1.6f;
            if ((f5 = MathHelper.func_76129_c((float)f5)) > 1.0f) {
                f5 = 1.0f;
            }
            GlStateManager.func_179152_a((float)f5, (float)f5, (float)f5);
            GlStateManager.func_179114_b((float)(f5 * 90.0f - 90.0f), (float)f5, (float)f5, (float)f5);
        }
    }

    protected void applyRotations(EntitySpider entityLiving, float p_77043_2_, float p_77043_3_, float partialTicks) {
        GlStateManager.func_179114_b((float)(180.0f - p_77043_3_), (float)0.0f, (float)1.0f, (float)0.0f);
        if (entityLiving.field_70725_aQ > 0) {
            float f = ((float)entityLiving.field_70725_aQ + partialTicks - 1.0f) / 20.0f * 1.6f;
            if ((f = MathHelper.func_76129_c((float)f)) > 1.0f) {
                f = 1.0f;
            }
            if (EngenderMod.useMobTalkerModels) {
                GlStateManager.func_179114_b((float)(f * this.getDeathMaxRotation(entityLiving)), (float)-1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)(f * (this instanceof RenderCaveSpider ? 0.05f : 0.1f)));
            } else {
                GlStateManager.func_179114_b((float)(f * this.getDeathMaxRotation(entityLiving)), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)(-f * (this instanceof RenderCaveSpider ? 0.5f : 0.75f)), (float)0.0f);
            }
        } else {
            String s = TextFormatting.func_110646_a((String)entityLiving.func_70005_c_());
            if (s != null && ("Dinnerbone".equals(s) || "Grumm".equals(s))) {
                GlStateManager.func_179109_b((float)0.0f, (float)(entityLiving.field_70131_O + 0.1f), (float)0.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
        }
    }

    protected ResourceLocation getEntityTexture(T entity) {
        return EngenderMod.useMobTalkerModels ? (((EntityFriendlyCreature)entity).isAntiMob() ? anticmmSpiderTextures : (((EntitySpider)entity).isSurvivalTestSkin() ? stcmmSpiderTextures : cmmSpiderTextures)) : (((EntityFriendlyCreature)entity).isAntiMob() ? antispiderTextures : (((EntitySpider)entity).isSurvivalTestSkin() ? stspiderTextures : spiderTextures));
    }
}

