/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.AgeOfMinecraft.render;

import net.minecraft.AgeOfMinecraft.EngenderMod;
import net.minecraft.AgeOfMinecraft.models.ModelCMMSnowGolem;
import net.minecraft.AgeOfMinecraft.models.ModelSnowMan;
import net.minecraft.AgeOfMinecraft.render.LayerArrowCustomSized;
import net.minecraft.AgeOfMinecraft.render.LayerLearningBook;
import net.minecraft.AgeOfMinecraft.render.LayerMobCape;
import net.minecraft.AgeOfMinecraft.render.LayerSnowmanHead;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.helpful.tier2.EntitySnowman;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderSnowMan
extends RenderLiving<EntitySnowman> {
    private static final ResourceLocation cmmSnowManTextures = new ResourceLocation("ageofminecraft", "textures/entities/yarrscmm/sgolem.png");
    private static final ResourceLocation snowManTextures = new ResourceLocation("textures/entity/snowman.png");
    private static final ResourceLocation anticmmSnowManTextures = new ResourceLocation("ageofminecraft", "textures/entities/yarrscmm/anti/sgolem.png");
    private static final ResourceLocation antisnowManTextures = new ResourceLocation("ageofminecraft", "textures/entities/anti/snowman.png");
    private static ModelCMMSnowGolem cmmmodel = new ModelCMMSnowGolem();
    private static ModelSnowMan regularmodel = new ModelSnowMan();

    public RenderSnowMan(RenderManager renderManagerIn) {
        super(renderManagerIn, EngenderMod.useMobTalkerModels ? cmmmodel : regularmodel, 0.5f);
        this.func_177094_a(new LayerArrowCustomSized((RenderLivingBase<?>)this, 1.0f));
        this.func_177094_a(new LayerSnowmanHead(RenderSnowMan.regularmodel.head));
        this.func_177094_a(new LayerLearningBook(this));
        this.func_177094_a(new LayerMobCape((RenderLivingBase)this));
    }

    protected void applyRotations(EntitySnowman entityLiving, float p_77043_2_, float p_77043_3_, float partialTicks) {
        GlStateManager.func_179114_b((float)(180.0f - p_77043_3_), (float)0.0f, (float)1.0f, (float)0.0f);
        if (entityLiving.field_70725_aQ > 0) {
            float f = ((float)entityLiving.field_70725_aQ + partialTicks - 1.0f) / 20.0f * 1.6f;
            if ((f = MathHelper.func_76129_c((float)f)) > 1.0f) {
                f = 1.0f;
            }
            if (EngenderMod.useMobTalkerModels) {
                GlStateManager.func_179114_b((float)(f * this.func_77037_a((EntityLivingBase)entityLiving)), (float)-1.0f, (float)0.0f, (float)0.0f);
            } else {
                GlStateManager.func_179114_b((float)(f * this.func_77037_a((EntityLivingBase)entityLiving)), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179109_b((float)(f * 0.25f), (float)0.0f, (float)0.0f);
            }
        } else {
            String s = TextFormatting.func_110646_a((String)entityLiving.func_70005_c_());
            if (s != null && ("Dinnerbone".equals(s) || "Grumm".equals(s))) {
                GlStateManager.func_179109_b((float)0.0f, (float)(entityLiving.field_70131_O + 0.1f), (float)0.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
        }
    }

    protected ResourceLocation getEntityTexture(EntitySnowman entity) {
        return EngenderMod.useMobTalkerModels ? (entity.isAntiMob() ? anticmmSnowManTextures : cmmSnowManTextures) : (entity.isAntiMob() ? antisnowManTextures : snowManTextures);
    }

    protected void preRenderCallback(EntitySnowman entitylivingbaseIn, float partialTickTime) {
        ModelBase modelBase = this.field_77045_g = EngenderMod.useMobTalkerModels ? cmmmodel : regularmodel;
        if (!EngenderMod.useMobTalkerModels && !entitylivingbaseIn.getCurrentBook().func_190926_b()) {
            RenderSnowMan.regularmodel.rightHand.field_78796_g = entitylivingbaseIn.bookSpread - 1.0f;
            RenderSnowMan.regularmodel.leftHand.field_78796_g = -entitylivingbaseIn.bookSpread + 1.0f;
            RenderSnowMan.regularmodel.rightHand.field_78808_h = 0.0f;
            RenderSnowMan.regularmodel.leftHand.field_78808_h = 0.0f;
            RenderSnowMan.regularmodel.rightHand.field_78795_f = -1.5f + (0.1f + MathHelper.func_76126_a((float)((float)entitylivingbaseIn.field_70173_aa * 0.1f)) * 0.01f);
            RenderSnowMan.regularmodel.leftHand.field_78795_f = -1.5f + (0.1f + MathHelper.func_76126_a((float)((float)entitylivingbaseIn.field_70173_aa * 0.1f)) * 0.01f);
        }
        if (EngenderMod.useMobTalkerModels) {
            GlStateManager.func_179152_a((float)0.9f, (float)0.9f, (float)0.9f);
            if (entitylivingbaseIn.isSitResting()) {
                GlStateManager.func_179109_b((float)0.0f, (float)(entitylivingbaseIn.func_70631_g_() ? 0.25f : 0.5f), (float)0.0f);
            }
            if (entitylivingbaseIn.func_184218_aH() && entitylivingbaseIn.func_70631_g_()) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.5f, (float)0.25f);
            }
        } else {
            if (entitylivingbaseIn.func_70631_g_()) {
                GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
            }
            if (entitylivingbaseIn.func_184218_aH()) {
                GlStateManager.func_179109_b((float)0.0f, (float)-1.0f, (float)0.0f);
            }
        }
        float fit = entitylivingbaseIn.getFittness();
        GlStateManager.func_179152_a((float)fit, (float)fit, (float)fit);
        if (entitylivingbaseIn.isHero()) {
            GlStateManager.func_179152_a((float)1.05f, (float)1.05f, (float)1.05f);
        }
        if (!entitylivingbaseIn.field_70122_E) {
            GlStateManager.func_179114_b((float)(entitylivingbaseIn.prevRotationPitchFalling + (entitylivingbaseIn.rotationPitchFalling - entitylivingbaseIn.prevRotationPitchFalling) * 2.0f - 1.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (entitylivingbaseIn.field_70173_aa <= 21 && entitylivingbaseIn.field_70173_aa > 0) {
            float f5 = ((float)entitylivingbaseIn.field_70173_aa + partialTickTime - 1.0f) / 20.0f * 1.6f;
            if ((f5 = MathHelper.func_76129_c((float)f5)) > 1.0f) {
                f5 = 1.0f;
            }
            GlStateManager.func_179152_a((float)f5, (float)f5, (float)f5);
            GlStateManager.func_179114_b((float)(f5 * 90.0f - 90.0f), (float)f5, (float)f5, (float)f5);
        }
    }
}

