/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.AgeOfMinecraft.render;

import net.minecraft.AgeOfMinecraft.EngenderMod;
import net.minecraft.AgeOfMinecraft.models.ModelCMMSlime;
import net.minecraft.AgeOfMinecraft.models.ModelSlime;
import net.minecraft.AgeOfMinecraft.render.LayerCustomHeadEngender;
import net.minecraft.AgeOfMinecraft.render.LayerLearningBook;
import net.minecraft.AgeOfMinecraft.render.LayerSlimeGel;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.helpful.tier3.EntitySlime;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderSlime
extends RenderLiving<EntitySlime> {
    private static final ResourceLocation cmmSlimeLargeTextures = new ResourceLocation("ageofminecraft", "textures/entities/yarrscmm/slime4.png");
    private static final ResourceLocation cmmSlimeSmallTextures = new ResourceLocation("ageofminecraft", "textures/entities/yarrscmm/slime2.png");
    private static final ResourceLocation cmmSlimeTinyTextures = new ResourceLocation("ageofminecraft", "textures/entities/yarrscmm/slime1.png");
    private static final ResourceLocation slimeTextures = new ResourceLocation("textures/entity/slime/slime.png");
    private static final ResourceLocation anticmmSlimeLargeTextures = new ResourceLocation("ageofminecraft", "textures/entities/yarrscmm/anti/slime4.png");
    private static final ResourceLocation anticmmSlimeSmallTextures = new ResourceLocation("ageofminecraft", "textures/entities/yarrscmm/anti/slime2.png");
    private static final ResourceLocation anticmmSlimeTinyTextures = new ResourceLocation("ageofminecraft", "textures/entities/yarrscmm/anti/slime1.png");
    private static final ResourceLocation antislimeTextures = new ResourceLocation("ageofminecraft", "textures/entities/anti/slime.png");
    private static ModelCMMSlime cmmmodel = new ModelCMMSlime();
    private static ModelSlime regularmodel = new ModelSlime(16);

    public RenderSlime(RenderManager renderManagerIn) {
        super(renderManagerIn, EngenderMod.useMobTalkerModels ? cmmmodel : regularmodel, 0.25f);
        this.func_177094_a(new LayerSlimeGel(this));
        this.func_177094_a(new LayerCustomHeadEngender(RenderSlime.regularmodel.slimeBodies, RenderSlime.cmmmodel.Head));
        this.func_177094_a(new LayerLearningBook(this));
    }

    public void doRender(EntitySlime entity, double x, double y, double z, float entityYaw, float partialTicks) {
        this.field_76989_e = EngenderMod.useMobTalkerModels ? (float)entity.getSlimeSize() * 0.125f : 0.25f * (float)entity.getSlimeSize();
        super.func_76986_a((EntityLiving)entity, x, y, z, entityYaw, partialTicks);
    }

    protected void preRenderCallback(EntitySlime entitylivingbaseIn, float partialTickTime) {
        this.field_77045_g = EngenderMod.useMobTalkerModels ? cmmmodel : regularmodel;
        float f1 = entitylivingbaseIn.getSlimeSize();
        float f2 = (entitylivingbaseIn.prevSquishFactor + (entitylivingbaseIn.squishFactor - entitylivingbaseIn.prevSquishFactor) * partialTickTime) / (f1 * 0.5f + 1.0f);
        float f3 = 1.0f / (f2 + 1.0f);
        if (EngenderMod.useMobTalkerModels) {
            GlStateManager.func_179152_a((float)f3, (float)(1.0f / f3), (float)f3);
        } else {
            GlStateManager.func_179152_a((float)(f3 * f1), (float)(1.0f / f3 * f1), (float)(f3 * f1));
            if (entitylivingbaseIn.func_70093_af()) {
                GlStateManager.func_179152_a((float)1.25f, (float)0.75f, (float)1.25f);
            }
        }
        if (EngenderMod.useMobTalkerModels) {
            if (entitylivingbaseIn.isSitResting()) {
                GlStateManager.func_179109_b((float)0.0f, (float)(0.75f + f1 * 0.05f), (float)0.0f);
                if (f1 <= 4.0f) {
                    GlStateManager.func_179109_b((float)0.0f, (float)-0.45f, (float)0.0f);
                }
                if (entitylivingbaseIn.isSmallSlime()) {
                    GlStateManager.func_179109_b((float)0.0f, (float)-0.1f, (float)0.0f);
                }
            }
            if (entitylivingbaseIn.func_184218_aH() && entitylivingbaseIn.isSmallSlime()) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.6f, (float)0.25f);
            }
            GlStateManager.func_179152_a((float)0.95f, (float)0.95f, (float)0.95f);
            GlStateManager.func_179152_a((float)(f1 * 0.25f), (float)(f1 * 0.25f), (float)(f1 * 0.25f));
            if (f1 == 2.0f) {
                GlStateManager.func_179152_a((float)1.5f, (float)1.5f, (float)1.5f);
            }
            if (f1 <= 1.0f) {
                GlStateManager.func_179152_a((float)1.75f, (float)1.75f, (float)1.75f);
            }
        }
        float fit = entitylivingbaseIn.getFittness();
        GlStateManager.func_179152_a((float)fit, (float)fit, (float)fit);
        if (entitylivingbaseIn.isHero()) {
            GlStateManager.func_179152_a((float)1.05f, (float)1.05f, (float)1.05f);
        }
        if (!entitylivingbaseIn.field_70122_E) {
            GlStateManager.func_179114_b((float)(entitylivingbaseIn.prevRotationPitchFalling + (entitylivingbaseIn.rotationPitchFalling - entitylivingbaseIn.prevRotationPitchFalling) * 2.0f - 1.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (entitylivingbaseIn.field_70173_aa <= 21 && entitylivingbaseIn.field_70173_aa > 0) {
            float f5 = ((float)entitylivingbaseIn.field_70173_aa + partialTickTime - 1.0f) / 20.0f * 1.6f;
            if ((f5 = MathHelper.func_76129_c((float)f5)) > 1.0f) {
                f5 = 1.0f;
            }
            GlStateManager.func_179152_a((float)f5, (float)f5, (float)f5);
            GlStateManager.func_179114_b((float)(f5 * 90.0f - 90.0f), (float)f5, (float)f5, (float)f5);
        }
    }

    protected void applyRotations(EntitySlime entityLiving, float p_77043_2_, float p_77043_3_, float partialTicks) {
        if (entityLiving.getJukeboxToDanceTo() != null) {
            GlStateManager.func_179152_a((float)(1.0f + MathHelper.func_76134_b((float)(p_77043_2_ * 1.0f)) * 0.1f), (float)(1.0f - MathHelper.func_76134_b((float)(p_77043_2_ * 1.0f)) * 0.05f), (float)(1.0f + MathHelper.func_76134_b((float)(p_77043_2_ * 1.0f)) * 0.1f));
        }
        GlStateManager.func_179114_b((float)(180.0f - p_77043_3_), (float)0.0f, (float)1.0f, (float)0.0f);
        if (entityLiving.field_70725_aQ > 0) {
            float f = ((float)entityLiving.field_70725_aQ + partialTicks - 1.0f) / 20.0f * 1.6f;
            if ((f = MathHelper.func_76129_c((float)f)) > 1.0f) {
                f = 1.0f;
            }
            if (EngenderMod.useMobTalkerModels) {
                GlStateManager.func_179114_b((float)(f * this.func_77037_a((EntityLivingBase)entityLiving)), (float)-1.0f, (float)0.0f, (float)0.0f);
            } else {
                GlStateManager.func_179114_b((float)(f * this.func_77037_a((EntityLivingBase)entityLiving)), (float)0.0f, (float)0.0f, (float)1.0f);
            }
        } else {
            String s = TextFormatting.func_110646_a((String)entityLiving.func_70005_c_());
            if (s != null && ("Dinnerbone".equals(s) || "Grumm".equals(s))) {
                GlStateManager.func_179109_b((float)0.0f, (float)(entityLiving.field_70131_O + 0.1f), (float)0.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
        }
    }

    protected ResourceLocation getEntityTexture(EntitySlime entity) {
        return EngenderMod.useMobTalkerModels ? (entity.getSlimeSize() <= 1 ? (entity.isAntiMob() ? anticmmSlimeTinyTextures : cmmSlimeTinyTextures) : (entity.getSlimeSize() == 2 || entity.getSlimeSize() == 3 ? (entity.isAntiMob() ? anticmmSlimeSmallTextures : cmmSlimeSmallTextures) : (entity.isAntiMob() ? anticmmSlimeLargeTextures : cmmSlimeLargeTextures))) : (entity.isAntiMob() ? antislimeTextures : slimeTextures);
    }
}

