/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.AgeOfMinecraft.render;

import net.minecraft.AgeOfMinecraft.EngenderMod;
import net.minecraft.AgeOfMinecraft.models.ModelCMMSkeleton;
import net.minecraft.AgeOfMinecraft.models.ModelSkeleton;
import net.minecraft.AgeOfMinecraft.render.LayerArrowCustomSized;
import net.minecraft.AgeOfMinecraft.render.LayerCustomArmor;
import net.minecraft.AgeOfMinecraft.render.LayerCustomHeadEngender;
import net.minecraft.AgeOfMinecraft.render.LayerLearningBook;
import net.minecraft.AgeOfMinecraft.render.LayerMobCape;
import net.minecraft.AgeOfMinecraft.render.LayerSkeletonType;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerElytra;
import net.minecraft.client.renderer.entity.layers.LayerHeldItem;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.helpful.tier3.EntitySkeleton;
import net.minecraft.entity.helpful.tier3.EntitySpider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderSkeleton
extends RenderLiving<EntitySkeleton> {
    private static final ResourceLocation CMM_SKELETON_TEXTURES = new ResourceLocation("ageofminecraft", "textures/entities/yarrscmm/skeleton.png");
    private static final ResourceLocation CMM_WITHER_SKELETON_TEXTURES = new ResourceLocation("ageofminecraft", "textures/entities/yarrscmm/skeletonw.png");
    private static final ResourceLocation CMM_STRAY_SKELETON_TEXTURES = new ResourceLocation("ageofminecraft", "textures/entities/yarrscmm/skeletons.png");
    private static final ResourceLocation SKELETON_TEXTURES = new ResourceLocation("textures/entity/skeleton/skeleton.png");
    private static final ResourceLocation WITHER_SKELETON_TEXTURES = new ResourceLocation("textures/entity/skeleton/wither_skeleton.png");
    private static final ResourceLocation STRAY_SKELETON_TEXTURES = new ResourceLocation("textures/entity/skeleton/stray.png");
    private static final ResourceLocation antiCMM_SKELETON_TEXTURES = new ResourceLocation("ageofminecraft", "textures/entities/yarrscmm/anti/skeleton.png");
    private static final ResourceLocation antiCMM_WITHER_SKELETON_TEXTURES = new ResourceLocation("ageofminecraft", "textures/entities/yarrscmm/anti/skeletonw.png");
    private static final ResourceLocation antiCMM_STRAY_SKELETON_TEXTURES = new ResourceLocation("ageofminecraft", "textures/entities/yarrscmm/anti/skeletons.png");
    private static final ResourceLocation antiSKELETON_TEXTURES = new ResourceLocation("ageofminecraft", "textures/entities/anti/skeleton.png");
    private static final ResourceLocation antiWITHER_SKELETON_TEXTURES = new ResourceLocation("ageofminecraft", "textures/entities/anti/wither_skeleton.png");
    private static final ResourceLocation antiSTRAY_SKELETON_TEXTURES = new ResourceLocation("ageofminecraft", "textures/entities/anti/stray.png");
    private LayerCustomArmor armor = new LayerCustomArmor((RenderLivingBase<?>)this);
    private static ModelCMMSkeleton cmmmodel = new ModelCMMSkeleton();
    private static ModelSkeleton regularmodel = new ModelSkeleton();
    private static ModelCMMSkeleton cmmleggings = new ModelCMMSkeleton(0.5f, true);
    private static ModelSkeleton regularleggings = new ModelSkeleton(0.5f, true);
    private static ModelCMMSkeleton cmmarmor = new ModelCMMSkeleton(1.0f, true);
    private static ModelSkeleton regulararmor = new ModelSkeleton(1.0f, true);

    public RenderSkeleton(RenderManager renderManagerIn) {
        super(renderManagerIn, (ModelBase)(EngenderMod.useMobTalkerModels ? cmmmodel : regularmodel), 0.5f);
        this.func_177094_a(new LayerArrowCustomSized((RenderLivingBase<?>)this, 0.9f));
        this.func_177094_a(new LayerSkeletonType((RenderLivingBase<?>)this));
        this.func_177094_a(new LayerLearningBook(this));
        this.func_177094_a(new LayerMobCape((RenderLivingBase)this));
        this.armor = new LayerCustomArmor((RenderLivingBase)this){

            @Override
            protected void func_177177_a() {
                this.field_177189_c = EngenderMod.useMobTalkerModels ? cmmleggings : regularleggings;
                this.field_177186_d = EngenderMod.useMobTalkerModels ? cmmarmor : regulararmor;
            }
        };
        this.func_177094_a((LayerRenderer)this.armor);
        this.func_177094_a((LayerRenderer)new LayerElytra((RenderLivingBase)this));
        this.func_177094_a((LayerRenderer)new LayerHeldItem((RenderLivingBase)this));
        this.func_177094_a(new LayerCustomHeadEngender(RenderSkeleton.regularmodel.field_78116_c, RenderSkeleton.cmmmodel.Head));
    }

    protected void applyRotations(EntitySkeleton entityLiving, float p_77043_2_, float p_77043_3_, float partialTicks) {
        if (entityLiving.func_184613_cA()) {
            super.func_77043_a((EntityLivingBase)entityLiving, p_77043_2_, p_77043_3_, partialTicks);
            float f = (float)entityLiving.func_184599_cB() + partialTicks;
            float f1 = MathHelper.func_76131_a((float)(f * f / 100.0f), (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)(f1 * (-90.0f - entityLiving.field_70125_A)), (float)1.0f, (float)0.0f, (float)0.0f);
            Vec3d vec3d = entityLiving.func_70676_i(partialTicks);
            double d0 = entityLiving.field_70159_w * entityLiving.field_70159_w + entityLiving.field_70179_y * entityLiving.field_70179_y;
            double d1 = vec3d.field_72450_a * vec3d.field_72450_a + vec3d.field_72449_c * vec3d.field_72449_c;
            if (d0 > 0.0 && d1 > 0.0) {
                double d2 = (entityLiving.field_70159_w * vec3d.field_72450_a + entityLiving.field_70179_y * vec3d.field_72449_c) / (Math.sqrt(d0) * Math.sqrt(d1));
                double d3 = entityLiving.field_70159_w * vec3d.field_72449_c - entityLiving.field_70179_y * vec3d.field_72450_a;
                GlStateManager.func_179114_b((float)((float)(Math.signum(d3) * Math.acos(d2)) * 180.0f / (float)Math.PI), (float)0.0f, (float)1.0f, (float)0.0f);
            }
        } else {
            GlStateManager.func_179114_b((float)(180.0f - p_77043_3_), (float)0.0f, (float)1.0f, (float)0.0f);
            if (entityLiving.field_70725_aQ > 0) {
                float f = ((float)entityLiving.field_70725_aQ + partialTicks - 1.0f) / 20.0f * 1.6f;
                if ((f = MathHelper.func_76129_c((float)f)) > 1.0f) {
                    f = 1.0f;
                }
                if (EngenderMod.useMobTalkerModels) {
                    GlStateManager.func_179114_b((float)(f * this.func_77037_a((EntityLivingBase)entityLiving)), (float)1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)(-f * 0.1f));
                } else {
                    GlStateManager.func_179114_b((float)(f * this.func_77037_a((EntityLivingBase)entityLiving)), (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_179109_b((float)(f * 0.25f), (float)0.0f, (float)0.0f);
                }
            } else {
                String s = TextFormatting.func_110646_a((String)entityLiving.func_70005_c_());
                if (s != null && ("Dinnerbone".equals(s) || "Grumm".equals(s))) {
                    GlStateManager.func_179109_b((float)0.0f, (float)(entityLiving.field_70131_O + 0.1f), (float)0.0f);
                    GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                }
            }
        }
    }

    private void changeModel() {
        this.field_77045_g = EngenderMod.useMobTalkerModels ? cmmmodel : regularmodel;
        this.field_177097_h.remove((Object)this.armor);
        this.armor = new LayerCustomArmor((RenderLivingBase)this){

            @Override
            protected void func_177177_a() {
                this.field_177189_c = EngenderMod.useMobTalkerModels ? cmmleggings : regularleggings;
                this.field_177186_d = EngenderMod.useMobTalkerModels ? cmmarmor : regulararmor;
            }
        };
        this.func_177094_a((LayerRenderer)this.armor);
    }

    protected void preRenderCallback(EntitySkeleton entitylivingbaseIn, float partialTickTime) {
        this.changeModel();
        if (EngenderMod.useMobTalkerModels) {
            GlStateManager.func_179152_a((float)0.95f, (float)0.95f, (float)0.95f);
            if (entitylivingbaseIn.isSitResting()) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.5f, (float)0.0f);
            }
            if (entitylivingbaseIn.isSitResting() && entitylivingbaseIn.func_70631_g_()) {
                GlStateManager.func_179109_b((float)0.0f, (float)-0.25f, (float)0.0f);
            }
            if (entitylivingbaseIn.func_184218_aH() && entitylivingbaseIn.func_70631_g_()) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.25f);
            }
        } else {
            if (entitylivingbaseIn.func_70093_af()) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
            }
            if (entitylivingbaseIn.func_184218_aH() && entitylivingbaseIn.func_70631_g_() && !(entitylivingbaseIn.func_184187_bx() instanceof EntitySpider)) {
                GlStateManager.func_179109_b((float)0.0f, (float)-0.625f, (float)0.0f);
            } else if (entitylivingbaseIn.func_184218_aH() && !entitylivingbaseIn.func_70631_g_()) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.1f, (float)0.0f);
            }
        }
        if (entitylivingbaseIn.func_184218_aH() && entitylivingbaseIn.func_70631_g_() && entitylivingbaseIn.func_184187_bx() instanceof EntitySpider) {
            GlStateManager.func_179109_b((float)0.0f, (float)-0.1f, (float)0.0f);
        }
        if (entitylivingbaseIn.getSkeletonType() == 1) {
            GlStateManager.func_179152_a((float)1.2f, (float)1.2f, (float)1.2f);
            if (EngenderMod.useMobTalkerModels) {
                GlStateManager.func_179152_a((float)1.05f, (float)1.05f, (float)1.05f);
            }
            if (entitylivingbaseIn.isSitResting()) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.1f, (float)0.0f);
            }
        }
        float fit = entitylivingbaseIn.getFittness();
        GlStateManager.func_179152_a((float)fit, (float)fit, (float)fit);
        if (entitylivingbaseIn.isHero()) {
            GlStateManager.func_179152_a((float)1.05f, (float)1.05f, (float)1.05f);
        }
        if (!entitylivingbaseIn.field_70122_E) {
            GlStateManager.func_179114_b((float)(entitylivingbaseIn.prevRotationPitchFalling + (entitylivingbaseIn.rotationPitchFalling - entitylivingbaseIn.prevRotationPitchFalling) * 2.0f - 1.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (entitylivingbaseIn.field_70173_aa <= 21 && entitylivingbaseIn.field_70173_aa > 0) {
            float f5 = ((float)entitylivingbaseIn.field_70173_aa + partialTickTime - 1.0f) / 20.0f * 1.6f;
            if ((f5 = MathHelper.func_76129_c((float)f5)) > 1.0f) {
                f5 = 1.0f;
            }
            GlStateManager.func_179152_a((float)f5, (float)f5, (float)f5);
            GlStateManager.func_179114_b((float)(f5 * 90.0f - 90.0f), (float)f5, (float)f5, (float)f5);
        }
    }

    public void func_82422_c() {
        GlStateManager.func_179109_b((float)0.09375f, (float)0.1875f, (float)0.0f);
    }

    protected ResourceLocation getEntityTexture(EntitySkeleton entity) {
        if (EngenderMod.useMobTalkerModels) {
            switch (entity.getSkeletonType()) {
                case 1: {
                    return entity.isAntiMob() ? antiCMM_WITHER_SKELETON_TEXTURES : CMM_WITHER_SKELETON_TEXTURES;
                }
                case 2: {
                    return entity.isAntiMob() ? antiCMM_STRAY_SKELETON_TEXTURES : CMM_STRAY_SKELETON_TEXTURES;
                }
            }
            return entity.isAntiMob() ? antiCMM_SKELETON_TEXTURES : CMM_SKELETON_TEXTURES;
        }
        switch (entity.getSkeletonType()) {
            case 1: {
                return entity.isAntiMob() ? antiWITHER_SKELETON_TEXTURES : WITHER_SKELETON_TEXTURES;
            }
            case 2: {
                return entity.isAntiMob() ? antiSTRAY_SKELETON_TEXTURES : STRAY_SKELETON_TEXTURES;
            }
        }
        return entity.isAntiMob() ? antiSKELETON_TEXTURES : SKELETON_TEXTURES;
    }
}

