/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.AgeOfMinecraft.render;

import net.minecraft.AgeOfMinecraft.models.ModelSlime;
import net.minecraft.AgeOfMinecraft.render.LayerCustomHeadEngender;
import net.minecraft.AgeOfMinecraft.render.LayerLearningBook;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.helpful.tier3.EntityPrisonSlime;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderPrisonSlime
extends RenderLiving<EntityPrisonSlime> {
    private static final ResourceLocation slimeTextures = new ResourceLocation("ageofminecraft", "textures/entities/prison_slime.png");
    private static ModelSlime regularmodel = new ModelSlime(16);

    public RenderPrisonSlime(RenderManager renderManagerIn) {
        super(renderManagerIn, (ModelBase)regularmodel, 0.25f);
        this.func_177094_a(new LayerSlimeGel(this));
        this.func_177094_a(new LayerCustomHeadEngender(RenderPrisonSlime.regularmodel.slimeBodies, RenderPrisonSlime.regularmodel.slimeBodies));
        this.func_177094_a(new LayerLearningBook(this));
    }

    public void doRender(EntityPrisonSlime entity, double x, double y, double z, float entityYaw, float partialTicks) {
        this.field_76989_e = 0.25f * (float)entity.getSlimeSize();
        super.func_76986_a((EntityLiving)entity, x, y, z, entityYaw, partialTicks);
    }

    protected void preRenderCallback(EntityPrisonSlime entitylivingbaseIn, float partialTickTime) {
        float f1 = entitylivingbaseIn.getSlimeSize();
        float f2 = (entitylivingbaseIn.prevSquishFactor + (entitylivingbaseIn.squishFactor - entitylivingbaseIn.prevSquishFactor) * partialTickTime) / (f1 * 0.5f + 1.0f);
        float f3 = 1.0f / (f2 + 1.0f);
        GlStateManager.func_179152_a((float)(f3 * f1), (float)(1.0f / f3 * f1), (float)(f3 * f1));
        if (entitylivingbaseIn.func_70093_af()) {
            GlStateManager.func_179152_a((float)1.25f, (float)0.75f, (float)1.25f);
        }
        float fit = entitylivingbaseIn.getFittness();
        GlStateManager.func_179152_a((float)fit, (float)fit, (float)fit);
        if (entitylivingbaseIn.isHero()) {
            GlStateManager.func_179152_a((float)1.05f, (float)1.05f, (float)1.05f);
        }
        if (!entitylivingbaseIn.field_70122_E) {
            GlStateManager.func_179114_b((float)(entitylivingbaseIn.prevRotationPitchFalling + (entitylivingbaseIn.rotationPitchFalling - entitylivingbaseIn.prevRotationPitchFalling) * 2.0f - 1.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (entitylivingbaseIn.field_70173_aa <= 21 && entitylivingbaseIn.field_70173_aa > 0) {
            float f5 = ((float)entitylivingbaseIn.field_70173_aa + partialTickTime - 1.0f) / 20.0f * 1.6f;
            if ((f5 = MathHelper.func_76129_c((float)f5)) > 1.0f) {
                f5 = 1.0f;
            }
            GlStateManager.func_179152_a((float)f5, (float)f5, (float)f5);
            GlStateManager.func_179114_b((float)(f5 * 90.0f - 90.0f), (float)f5, (float)f5, (float)f5);
        }
    }

    protected void applyRotations(EntityPrisonSlime entityLiving, float p_77043_2_, float p_77043_3_, float partialTicks) {
        if (entityLiving.getJukeboxToDanceTo() != null) {
            GlStateManager.func_179152_a((float)(1.0f + MathHelper.func_76134_b((float)(p_77043_2_ * 1.0f)) * 0.1f), (float)(1.0f - MathHelper.func_76134_b((float)(p_77043_2_ * 1.0f)) * 0.05f), (float)(1.0f + MathHelper.func_76134_b((float)(p_77043_2_ * 1.0f)) * 0.1f));
        }
        GlStateManager.func_179114_b((float)(180.0f - p_77043_3_), (float)0.0f, (float)1.0f, (float)0.0f);
        if (entityLiving.field_70725_aQ > 0) {
            float f = ((float)entityLiving.field_70725_aQ + partialTicks - 1.0f) / 20.0f * 1.6f;
            if ((f = MathHelper.func_76129_c((float)f)) > 1.0f) {
                f = 1.0f;
            }
            GlStateManager.func_179114_b((float)(f * this.func_77037_a((EntityLivingBase)entityLiving)), (float)0.0f, (float)0.0f, (float)1.0f);
        } else {
            String s = TextFormatting.func_110646_a((String)entityLiving.func_70005_c_());
            if (s != null && ("Dinnerbone".equals(s) || "Grumm".equals(s))) {
                GlStateManager.func_179109_b((float)0.0f, (float)(entityLiving.field_70131_O + 0.1f), (float)0.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
        }
    }

    protected ResourceLocation getEntityTexture(EntityPrisonSlime entity) {
        return slimeTextures;
    }

    @SideOnly(value=Side.CLIENT)
    public class LayerSlimeGel
    implements LayerRenderer {
        private final ResourceLocation slimeTextures = new ResourceLocation("ageofminecraft", "textures/entities/prison_slime.png");
        private final RenderPrisonSlime slimeRenderer;
        private ModelBase slimeModel = new ModelSlime(0);

        public LayerSlimeGel(RenderPrisonSlime p_i46111_1_) {
            this.slimeRenderer = p_i46111_1_;
        }

        public void doRenderLayer(EntityPrisonSlime p_177159_1_, float p_177159_2_, float p_177159_3_, float p_177159_4_, float p_177159_5_, float p_177159_6_, float p_177159_7_, float p_177159_8_) {
            if (!p_177159_1_.func_82150_aj()) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
                GlStateManager.func_179108_z();
                GlStateManager.func_179147_l();
                GlStateManager.func_179112_b((int)770, (int)771);
                this.slimeRenderer.func_110776_a(this.slimeTextures);
                this.slimeModel.func_178686_a(this.slimeRenderer.func_177087_b());
                this.slimeModel.func_78088_a((Entity)p_177159_1_, p_177159_2_, p_177159_3_, p_177159_5_, p_177159_6_, p_177159_7_, p_177159_8_);
                GlStateManager.func_179084_k();
                GlStateManager.func_179133_A();
            }
        }

        public boolean func_177142_b() {
            return true;
        }

        public void func_177141_a(EntityLivingBase p_177141_1_, float p_177141_2_, float p_177141_3_, float p_177141_4_, float p_177141_5_, float p_177141_6_, float p_177141_7_, float p_177141_8_) {
            this.doRenderLayer((EntityPrisonSlime)p_177141_1_, p_177141_2_, p_177141_3_, p_177141_4_, p_177141_5_, p_177141_6_, p_177141_7_, p_177141_8_);
        }
    }
}

