/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.AgeOfMinecraft.render;

import net.minecraft.AgeOfMinecraft.EngenderMod;
import net.minecraft.AgeOfMinecraft.models.ModelCMMGuardian;
import net.minecraft.AgeOfMinecraft.models.ModelGuardian;
import net.minecraft.AgeOfMinecraft.render.LayerArrowCustomSized;
import net.minecraft.AgeOfMinecraft.render.LayerCustomHeadEngender;
import net.minecraft.AgeOfMinecraft.render.LayerLearningBook;
import net.minecraft.AgeOfMinecraft.render.LayerMobCape;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.helpful.tier4.EntityGuardian;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderGuardian
extends RenderLiving<EntityGuardian> {
    private static final ResourceLocation CMM_GUARDIAN_TEXTURE = new ResourceLocation("ageofminecraft", "textures/entities/yarrscmm/guardian.png");
    private static final ResourceLocation CMM_GUARDIAN_ELDER_TEXTURE = new ResourceLocation("ageofminecraft", "textures/entities/yarrscmm/guardiane.png");
    private static final ResourceLocation GUARDIAN_TEXTURE = new ResourceLocation("textures/entity/guardian.png");
    private static final ResourceLocation GUARDIAN_ELDER_TEXTURE = new ResourceLocation("textures/entity/guardian_elder.png");
    private static final ResourceLocation antiCMM_GUARDIAN_TEXTURE = new ResourceLocation("ageofminecraft", "textures/entities/yarrscmm/anti/guardian.png");
    private static final ResourceLocation antiCMM_GUARDIAN_ELDER_TEXTURE = new ResourceLocation("ageofminecraft", "textures/entities/yarrscmm/anti/guardiane.png");
    private static final ResourceLocation antiGUARDIAN_TEXTURE = new ResourceLocation("ageofminecraft", "textures/entities/anti/guardian.png");
    private static final ResourceLocation antiGUARDIAN_ELDER_TEXTURE = new ResourceLocation("ageofminecraft", "textures/entities/anti/guardian_elder.png");
    private static final ResourceLocation GUARDIAN_BEAM_TEXTURE = new ResourceLocation("textures/entity/guardian_beam.png");
    private float scaledown = 1.0f;
    private static ModelCMMGuardian cmmmodel = new ModelCMMGuardian();
    private static ModelGuardian regularmodel = new ModelGuardian();

    public RenderGuardian(RenderManager renderManagerIn) {
        super(renderManagerIn, EngenderMod.useMobTalkerModels ? cmmmodel : regularmodel, 0.5f);
        this.func_177094_a(new LayerArrowCustomSized((RenderLivingBase<?>)this, 0.5f));
        this.func_177094_a(new LayerCustomHeadEngender(RenderGuardian.regularmodel.guardianBody, RenderGuardian.cmmmodel.Head));
        this.func_177094_a(new LayerLearningBook(this));
        this.func_177094_a(new LayerMobCape((RenderLivingBase)this));
    }

    public boolean shouldRender(EntityGuardian livingEntity, ICamera camera, double camX, double camY, double camZ) {
        EntityLivingBase entitylivingbase;
        if (super.func_177071_a((EntityLiving)livingEntity, camera, camX, camY, camZ)) {
            return true;
        }
        if (livingEntity.hasTargetedEntity() && (entitylivingbase = livingEntity.getTargetedEntity()) != null) {
            Vec3d vec3d = this.getPosition(entitylivingbase, (double)entitylivingbase.field_70131_O * 0.5, 1.0f);
            Vec3d vec3d1 = this.getPosition((EntityLivingBase)livingEntity, livingEntity.func_70047_e(), 1.0f);
            if (camera.func_78546_a(new AxisAlignedBB(vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c, vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c))) {
                return true;
            }
        }
        return false;
    }

    private Vec3d getPosition(EntityLivingBase entityLivingBaseIn, double p_177110_2_, float p_177110_4_) {
        double d0 = entityLivingBaseIn.field_70142_S + (entityLivingBaseIn.field_70165_t - entityLivingBaseIn.field_70142_S) * (double)p_177110_4_;
        double d1 = p_177110_2_ + entityLivingBaseIn.field_70137_T + (entityLivingBaseIn.field_70163_u - entityLivingBaseIn.field_70137_T) * (double)p_177110_4_;
        double d2 = entityLivingBaseIn.field_70136_U + (entityLivingBaseIn.field_70161_v - entityLivingBaseIn.field_70136_U) * (double)p_177110_4_;
        return new Vec3d(d0, d1, d2);
    }

    public void doRender(EntityGuardian entity, double x, double y, double z, float entityYaw, float partialTicks) {
        super.func_76986_a((EntityLiving)entity, x, y, z, entityYaw, partialTicks);
        EntityLivingBase entitylivingbase = entity.getTargetedEntity();
        if (entitylivingbase != null) {
            float f = entity.getAttackAnimationScale(partialTicks);
            Tessellator tessellator = Tessellator.func_178181_a();
            VertexBuffer vertexbuffer = tessellator.func_178180_c();
            this.func_110776_a(GUARDIAN_BEAM_TEXTURE);
            GlStateManager.func_187421_b((int)3553, (int)10242, (int)10497);
            GlStateManager.func_187421_b((int)3553, (int)10243, (int)10497);
            GlStateManager.func_179140_f();
            GlStateManager.func_179129_p();
            GlStateManager.func_179084_k();
            GlStateManager.func_179132_a((boolean)true);
            float f1 = 240.0f;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            float f2 = (float)entity.field_70170_p.func_82737_E() + partialTicks;
            float f3 = f2 * 0.5f % 1.0f;
            float f4 = entity.func_70047_e();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((float)x), (float)((float)y + f4), (float)((float)z));
            Vec3d vec3d = this.getPosition(entitylivingbase, entitylivingbase.func_70047_e(), partialTicks);
            Vec3d vec3d1 = this.getPosition((EntityLivingBase)entity, f4, partialTicks);
            Vec3d vec3d2 = vec3d.func_178788_d(vec3d1);
            double d0 = vec3d2.func_72433_c() + 1.0;
            vec3d2 = vec3d2.func_72432_b();
            float f5 = (float)Math.acos(vec3d2.field_72448_b);
            float f6 = (float)Math.atan2(vec3d2.field_72449_c, vec3d2.field_72450_a);
            GlStateManager.func_179114_b((float)((1.5707964f + -f6) * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(f5 * 57.295776f), (float)1.0f, (float)0.0f, (float)0.0f);
            boolean i = true;
            double d1 = (double)f2 * 0.05 * -1.5;
            vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            float f7 = f * f;
            int j = 64 + (int)(f7 * 191.0f);
            int k = 32 + (int)(f7 * 191.0f);
            int l = 128 - (int)(f7 * 64.0f);
            double d2 = 0.2;
            double d3 = 0.282;
            double d4 = 0.0 + Math.cos(d1 + 2.356194490192345) * 0.282;
            double d5 = 0.0 + Math.sin(d1 + 2.356194490192345) * 0.282;
            double d6 = 0.0 + Math.cos(d1 + 0.7853981633974483) * 0.282;
            double d7 = 0.0 + Math.sin(d1 + 0.7853981633974483) * 0.282;
            double d8 = 0.0 + Math.cos(d1 + 3.9269908169872414) * 0.282;
            double d9 = 0.0 + Math.sin(d1 + 3.9269908169872414) * 0.282;
            double d10 = 0.0 + Math.cos(d1 + 5.497787143782138) * 0.282;
            double d11 = 0.0 + Math.sin(d1 + 5.497787143782138) * 0.282;
            double d12 = 0.0 + Math.cos(d1 + Math.PI) * 0.2;
            double d13 = 0.0 + Math.sin(d1 + Math.PI) * 0.2;
            double d14 = 0.0 + Math.cos(d1 + 0.0) * 0.2;
            double d15 = 0.0 + Math.sin(d1 + 0.0) * 0.2;
            double d16 = 0.0 + Math.cos(d1 + 1.5707963267948966) * 0.2;
            double d17 = 0.0 + Math.sin(d1 + 1.5707963267948966) * 0.2;
            double d18 = 0.0 + Math.cos(d1 + 4.71238898038469) * 0.2;
            double d19 = 0.0 + Math.sin(d1 + 4.71238898038469) * 0.2;
            double d20 = 0.0;
            double d21 = 0.4999;
            double d22 = -1.0f + f3;
            double d23 = d0 * 2.5 + d22;
            vertexbuffer.func_181662_b(d12, d0, d13).func_187315_a(0.4999, d23).func_181669_b(j, k, l, 255).func_181675_d();
            vertexbuffer.func_181662_b(d12, 0.0, d13).func_187315_a(0.4999, d22).func_181669_b(j, k, l, 255).func_181675_d();
            vertexbuffer.func_181662_b(d14, 0.0, d15).func_187315_a(0.0, d22).func_181669_b(j, k, l, 255).func_181675_d();
            vertexbuffer.func_181662_b(d14, d0, d15).func_187315_a(0.0, d23).func_181669_b(j, k, l, 255).func_181675_d();
            vertexbuffer.func_181662_b(d16, d0, d17).func_187315_a(0.4999, d23).func_181669_b(j, k, l, 255).func_181675_d();
            vertexbuffer.func_181662_b(d16, 0.0, d17).func_187315_a(0.4999, d22).func_181669_b(j, k, l, 255).func_181675_d();
            vertexbuffer.func_181662_b(d18, 0.0, d19).func_187315_a(0.0, d22).func_181669_b(j, k, l, 255).func_181675_d();
            vertexbuffer.func_181662_b(d18, d0, d19).func_187315_a(0.0, d23).func_181669_b(j, k, l, 255).func_181675_d();
            double d24 = 0.0;
            if (entity.field_70173_aa % 2 == 0) {
                d24 = 0.5;
            }
            GlStateManager.func_179152_a((float)entity.getFittnessStat(), (float)1.0f, (float)entity.getFittnessStat());
            if (entity.isHero() && entity.getSpecialAttackTimer() <= 0) {
                GlStateManager.func_179152_a((float)4.0f, (float)1.0f, (float)4.0f);
            }
            vertexbuffer.func_181662_b(d4, d0, d5).func_187315_a(0.5, d24 + 0.5).func_181669_b(j, k, l, 255).func_181675_d();
            vertexbuffer.func_181662_b(d6, d0, d7).func_187315_a(1.0, d24 + 0.5).func_181669_b(j, k, l, 255).func_181675_d();
            vertexbuffer.func_181662_b(d10, d0, d11).func_187315_a(1.0, d24).func_181669_b(j, k, l, 255).func_181675_d();
            vertexbuffer.func_181662_b(d8, d0, d9).func_187315_a(0.5, d24).func_181669_b(j, k, l, 255).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
        }
    }

    protected void applyRotations(EntityGuardian entityLiving, float p_77043_2_, float p_77043_3_, float partialTicks) {
        GlStateManager.func_179114_b((float)(180.0f - p_77043_3_), (float)0.0f, (float)1.0f, (float)0.0f);
        if (EngenderMod.useMobTalkerModels && entityLiving.func_70089_S() && (entityLiving.func_70090_H() || entityLiving.func_180799_ab() || entityLiving.isSitResting() || entityLiving.isElder() && !entityLiving.func_70631_g_())) {
            GlStateManager.func_179109_b((float)0.0f, (float)(MathHelper.func_76134_b((float)(p_77043_2_ * 0.2f)) * 0.1f), (float)0.0f);
        }
        if (entityLiving.field_70725_aQ > 0) {
            float f = ((float)entityLiving.field_70725_aQ + partialTicks - 1.0f) / 20.0f * 1.6f;
            if ((f = MathHelper.func_76129_c((float)f)) > 1.0f) {
                f = 1.0f;
            }
            if (EngenderMod.useMobTalkerModels) {
                GlStateManager.func_179114_b((float)(f * this.func_77037_a((EntityLivingBase)entityLiving)), (float)-1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)(f * 0.1f));
            } else {
                GlStateManager.func_179114_b((float)(f * this.func_77037_a((EntityLivingBase)entityLiving)), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179109_b((float)(f * 0.5f), (float)(-f * 0.5f), (float)0.0f);
            }
        } else {
            String s = TextFormatting.func_110646_a((String)entityLiving.func_70005_c_());
            if (s != null && ("Dinnerbone".equals(s) || "Grumm".equals(s))) {
                GlStateManager.func_179109_b((float)0.0f, (float)(entityLiving.field_70131_O + 0.1f), (float)0.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
        }
    }

    protected void preRenderCallback(EntityGuardian entitylivingbaseIn, float partialTickTime) {
        ModelBase modelBase = this.field_77045_g = EngenderMod.useMobTalkerModels ? cmmmodel : regularmodel;
        if (EngenderMod.useMobTalkerModels) {
            GlStateManager.func_179152_a((float)0.85f, (float)0.85f, (float)0.85f);
            if (entitylivingbaseIn.isElder()) {
                GlStateManager.func_179152_a((float)1.4f, (float)1.4f, (float)1.4f);
                if (entitylivingbaseIn.func_184218_aH() && entitylivingbaseIn.func_70631_g_()) {
                    GlStateManager.func_179109_b((float)0.0f, (float)0.05f, (float)-0.05f);
                }
            }
            if (entitylivingbaseIn.func_184218_aH() && entitylivingbaseIn.func_70631_g_()) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.6f, (float)0.25f);
            }
        } else {
            if (entitylivingbaseIn.func_184218_aH()) {
                GlStateManager.func_179109_b((float)0.0f, (float)-0.5f, (float)0.0f);
            }
            if (entitylivingbaseIn.func_70631_g_()) {
                GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
            }
            GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)0.0f);
            if (entitylivingbaseIn.isElder()) {
                GlStateManager.func_179152_a((float)2.35f, (float)2.35f, (float)2.35f);
                this.scaledown = 0.425f;
                if (entitylivingbaseIn.func_70089_S() && !entitylivingbaseIn.field_70160_al && entitylivingbaseIn.field_70122_E && !entitylivingbaseIn.func_70093_af() && !entitylivingbaseIn.func_70090_H() && !entitylivingbaseIn.func_180799_ab()) {
                    GlStateManager.func_179109_b((float)0.0f, (float)0.3f, (float)0.0f);
                } else {
                    GlStateManager.func_179109_b((float)0.0f, (float)0.6f, (float)0.0f);
                }
            }
        }
        float fit = entitylivingbaseIn.getFittness();
        GlStateManager.func_179152_a((float)fit, (float)fit, (float)fit);
        if (entitylivingbaseIn.isHero()) {
            GlStateManager.func_179152_a((float)1.05f, (float)1.05f, (float)1.05f);
        }
        if (!entitylivingbaseIn.field_70122_E) {
            GlStateManager.func_179114_b((float)(entitylivingbaseIn.prevRotationPitchFalling + (entitylivingbaseIn.rotationPitchFalling - entitylivingbaseIn.prevRotationPitchFalling) * 2.0f - 1.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (entitylivingbaseIn.field_70173_aa <= 21 && entitylivingbaseIn.field_70173_aa > 0) {
            float f5 = ((float)entitylivingbaseIn.field_70173_aa + partialTickTime - 1.0f) / 20.0f * 1.6f;
            if ((f5 = MathHelper.func_76129_c((float)f5)) > 1.0f) {
                f5 = 1.0f;
            }
            GlStateManager.func_179152_a((float)f5, (float)f5, (float)f5);
            GlStateManager.func_179114_b((float)(f5 * 90.0f - 90.0f), (float)f5, (float)f5, (float)f5);
        }
    }

    protected ResourceLocation getEntityTexture(EntityGuardian entity) {
        return EngenderMod.useMobTalkerModels ? (entity.isElder() ? (entity.isAntiMob() ? antiCMM_GUARDIAN_ELDER_TEXTURE : CMM_GUARDIAN_ELDER_TEXTURE) : (entity.isAntiMob() ? antiCMM_GUARDIAN_TEXTURE : CMM_GUARDIAN_TEXTURE)) : (entity.isElder() ? (entity.isAntiMob() ? antiGUARDIAN_ELDER_TEXTURE : GUARDIAN_ELDER_TEXTURE) : (entity.isAntiMob() ? antiGUARDIAN_TEXTURE : GUARDIAN_TEXTURE));
    }
}

