/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.AgeOfMinecraft.render;

import net.minecraft.AgeOfMinecraft.EngenderMod;
import net.minecraft.AgeOfMinecraft.models.ModelCMMGiant;
import net.minecraft.AgeOfMinecraft.models.ModelGiant;
import net.minecraft.AgeOfMinecraft.render.LayerArrowCustomSized;
import net.minecraft.AgeOfMinecraft.render.LayerCustomHeadEngender;
import net.minecraft.AgeOfMinecraft.render.LayerLearningBook;
import net.minecraft.AgeOfMinecraft.render.LayerMobCape;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerBipedArmor;
import net.minecraft.client.renderer.entity.layers.LayerHeldItem;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.helpful.tier5.EntityGiant;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderGiant
extends RenderLiving<EntityGiant> {
    private static final ResourceLocation CMM_ZOMBIE_TEXTURES = new ResourceLocation("ageofminecraft", "textures/entities/yarrscmm/zombie.png");
    private static final ResourceLocation ZOMBIE_ZOMBIE_TEXTURES = new ResourceLocation("textures/entity/zombie/zombie.png");
    private static final ResourceLocation antiCMM_ZOMBIE_TEXTURES = new ResourceLocation("ageofminecraft", "textures/entities/yarrscmm/anti/zombie.png");
    private static final ResourceLocation antiZOMBIE_ZOMBIE_TEXTURES = new ResourceLocation("ageofminecraft", "textures/entities/anti/zombie.png");
    private static ModelCMMGiant cmmmodel = new ModelCMMGiant();
    private static ModelGiant regularmodel = new ModelGiant();
    private float scale;

    public RenderGiant(RenderManager renderManagerIn) {
        super(renderManagerIn, (ModelBase)(EngenderMod.useMobTalkerModels ? cmmmodel : regularmodel), 3.0f);
        this.func_177094_a(new LayerArrowCustomSized((RenderLivingBase<?>)this, 0.1675f));
        this.func_177094_a((LayerRenderer)new LayerHeldItem((RenderLivingBase)this));
        this.func_177094_a(new LayerCustomHeadEngender(RenderGiant.regularmodel.field_78116_c, RenderGiant.cmmmodel.Head));
        this.func_177094_a(new LayerLearningBook(this));
        this.func_177094_a(new LayerMobCape((RenderLivingBase)this));
        this.func_177094_a((LayerRenderer)new LayerBipedArmor((RenderLivingBase)this){

            protected void func_177177_a() {
                this.field_177189_c = EngenderMod.useMobTalkerModels ? new ModelCMMGiant(0.5f, true) : new ModelGiant(0.5f, true);
                this.field_177186_d = EngenderMod.useMobTalkerModels ? new ModelCMMGiant(1.0f, true) : new ModelGiant(1.0f, true);
            }
        });
    }

    public void func_82422_c() {
        GlStateManager.func_179109_b((float)0.0f, (float)0.1875f, (float)0.0f);
    }

    protected void applyRotations(EntityGiant entityLiving, float p_77043_2_, float p_77043_3_, float partialTicks) {
        if (entityLiving.func_184613_cA()) {
            super.func_77043_a((EntityLivingBase)entityLiving, p_77043_2_, p_77043_3_, partialTicks);
            float f = (float)entityLiving.func_184599_cB() + partialTicks;
            float f1 = MathHelper.func_76131_a((float)(f * f / 100.0f), (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)(f1 * (-90.0f - entityLiving.field_70125_A)), (float)1.0f, (float)0.0f, (float)0.0f);
            Vec3d vec3d = entityLiving.func_70676_i(partialTicks);
            double d0 = entityLiving.field_70159_w * entityLiving.field_70159_w + entityLiving.field_70179_y * entityLiving.field_70179_y;
            double d1 = vec3d.field_72450_a * vec3d.field_72450_a + vec3d.field_72449_c * vec3d.field_72449_c;
            if (d0 > 0.0 && d1 > 0.0) {
                double d2 = (entityLiving.field_70159_w * vec3d.field_72450_a + entityLiving.field_70179_y * vec3d.field_72449_c) / (Math.sqrt(d0) * Math.sqrt(d1));
                double d3 = entityLiving.field_70159_w * vec3d.field_72449_c - entityLiving.field_70179_y * vec3d.field_72450_a;
                GlStateManager.func_179114_b((float)((float)(Math.signum(d3) * Math.acos(d2)) * 180.0f / (float)Math.PI), (float)0.0f, (float)1.0f, (float)0.0f);
            }
        } else {
            GlStateManager.func_179114_b((float)(180.0f - p_77043_3_), (float)0.0f, (float)1.0f, (float)0.0f);
            if (entityLiving.field_70725_aQ > 0) {
                float f = ((float)entityLiving.field_70725_aQ + partialTicks - 1.0f) / 20.0f * 1.6f;
                if ((f = MathHelper.func_76129_c((float)f)) > 1.0f) {
                    f = 1.0f;
                }
                if (EngenderMod.useMobTalkerModels) {
                    GlStateManager.func_179114_b((float)(f * this.func_77037_a((EntityLivingBase)entityLiving)), (float)1.0f, (float)0.0f, (float)0.0f);
                } else {
                    GlStateManager.func_179114_b((float)(f * this.func_77037_a((EntityLivingBase)entityLiving)), (float)0.0f, (float)0.0f, (float)1.0f);
                }
            } else {
                String s = TextFormatting.func_110646_a((String)entityLiving.func_70005_c_());
                if (s != null && ("Dinnerbone".equals(s) || "Grumm".equals(s))) {
                    GlStateManager.func_179109_b((float)0.0f, (float)(entityLiving.field_70131_O + 0.1f), (float)0.0f);
                    GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                }
            }
        }
    }

    protected void preRenderCallback(EntityGiant entitylivingbaseIn, float partialTickTime) {
        this.field_77045_g = EngenderMod.useMobTalkerModels ? cmmmodel : regularmodel;
        GlStateManager.func_179152_a((float)6.0f, (float)6.0f, (float)6.0f);
        if (EngenderMod.useMobTalkerModels) {
            if (entitylivingbaseIn.isSitResting()) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.65f, (float)0.0f);
            }
            if (entitylivingbaseIn.isSitResting() && entitylivingbaseIn.func_70631_g_()) {
                GlStateManager.func_179109_b((float)0.0f, (float)-0.3f, (float)0.0f);
            }
            if (entitylivingbaseIn.func_184218_aH() && entitylivingbaseIn.func_70631_g_()) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.55f, (float)0.1f);
            }
        }
        float fit = entitylivingbaseIn.getFittness();
        GlStateManager.func_179152_a((float)fit, (float)fit, (float)fit);
        if (entitylivingbaseIn.isHero()) {
            GlStateManager.func_179152_a((float)1.05f, (float)1.05f, (float)1.05f);
        }
        if (!entitylivingbaseIn.field_70122_E) {
            GlStateManager.func_179114_b((float)(entitylivingbaseIn.prevRotationPitchFalling + (entitylivingbaseIn.rotationPitchFalling - entitylivingbaseIn.prevRotationPitchFalling) * 2.0f - 1.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (entitylivingbaseIn.field_70173_aa <= 21 && entitylivingbaseIn.field_70173_aa > 0) {
            float f5 = ((float)entitylivingbaseIn.field_70173_aa + partialTickTime - 1.0f) / 20.0f * 1.6f;
            if ((f5 = MathHelper.func_76129_c((float)f5)) > 1.0f) {
                f5 = 1.0f;
            }
            GlStateManager.func_179152_a((float)f5, (float)f5, (float)f5);
            GlStateManager.func_179114_b((float)(f5 * 90.0f - 90.0f), (float)f5, (float)f5, (float)f5);
        }
    }

    protected ResourceLocation getEntityTexture(EntityGiant entity) {
        return EngenderMod.useMobTalkerModels ? (entity.isAntiMob() ? antiCMM_ZOMBIE_TEXTURES : CMM_ZOMBIE_TEXTURES) : (entity.isAntiMob() ? antiZOMBIE_ZOMBIE_TEXTURES : ZOMBIE_ZOMBIE_TEXTURES);
    }
}

