/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.AgeOfMinecraft.render;

import java.util.Random;
import net.minecraft.AgeOfMinecraft.EngenderMod;
import net.minecraft.AgeOfMinecraft.models.ICappedModel;
import net.minecraft.AgeOfMinecraft.models.ModelCMMEnderman;
import net.minecraft.AgeOfMinecraft.models.ModelEnderman;
import net.minecraft.AgeOfMinecraft.render.LayerCustomHeadEngender;
import net.minecraft.AgeOfMinecraft.render.LayerEndermanEyes;
import net.minecraft.AgeOfMinecraft.render.LayerHeldBlock;
import net.minecraft.AgeOfMinecraft.render.LayerLearningBook;
import net.minecraft.AgeOfMinecraft.render.LayerMobCape;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.helpful.tier4.EntityEnderman;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderEnderman
extends RenderLiving<EntityEnderman> {
    private static final ResourceLocation cmmNerrasTextures = new ResourceLocation("ageofminecraft", "textures/entities/yarrscmm/nerras.png");
    private static final ResourceLocation cmmEndermanTextures = new ResourceLocation("ageofminecraft", "textures/entities/yarrscmm/enderman.png");
    private static final ResourceLocation endermanTextures = new ResourceLocation("textures/entity/enderman/enderman.png");
    private static final ResourceLocation anticmmNerrasTextures = new ResourceLocation("ageofminecraft", "textures/entities/yarrscmm/anti/nerras.png");
    private static final ResourceLocation anticmmEndermanTextures = new ResourceLocation("ageofminecraft", "textures/entities/yarrscmm/anti/enderman.png");
    private static final ResourceLocation antiendermanTextures = new ResourceLocation("ageofminecraft", "textures/entities/anti/enderman.png");
    private static final ResourceLocation bartTextures = new ResourceLocation("ageofminecraft", "textures/entities/bart.png");
    private static ModelCMMEnderman cmmmodel = new ModelCMMEnderman();
    private static ModelEnderman regularmodel = new ModelEnderman();
    private Random rnd = new Random();

    public RenderEnderman(RenderManager renderManagerIn) {
        super(renderManagerIn, (ModelBase)(EngenderMod.useMobTalkerModels ? cmmmodel : regularmodel), 0.5f);
        this.func_177094_a(new LayerEndermanEyes(this));
        this.func_177094_a(new LayerHeldBlock(this));
        this.func_177094_a(new LayerCustomHeadEngender(RenderEnderman.regularmodel.field_78116_c, RenderEnderman.cmmmodel.Head));
        this.func_177094_a(new LayerLearningBook(this));
        this.func_177094_a(new LayerMobCape((RenderLivingBase)this));
    }

    public void doRender(EntityEnderman entity, double x, double y, double z, float entityYaw, float partialTicks) {
        if (entity.isArmsRaised()) {
            double d0 = 0.02;
            x += this.rnd.nextGaussian() * d0;
            z += this.rnd.nextGaussian() * d0;
        }
        super.func_76986_a((EntityLiving)entity, x, y, z, entityYaw, partialTicks);
    }

    protected void preRenderCallback(EntityEnderman entitylivingbaseIn, float partialTickTime) {
        ICappedModel iCappedModel = this.field_77045_g = EngenderMod.useMobTalkerModels ? cmmmodel : regularmodel;
        if (entitylivingbaseIn.func_70093_af() && !EngenderMod.useMobTalkerModels) {
            GlStateManager.func_179109_b((float)0.0f, (float)-0.2f, (float)-0.75f);
            if (entitylivingbaseIn.func_70631_g_()) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.375f);
            }
        }
        if (EngenderMod.useMobTalkerModels) {
            GlStateManager.func_179152_a((float)1.33f, (float)1.33f, (float)1.33f);
            if (entitylivingbaseIn.isSitResting()) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.75f, (float)0.0f);
            }
            if (entitylivingbaseIn.isSitResting() && entitylivingbaseIn.func_70631_g_()) {
                GlStateManager.func_179109_b((float)0.0f, (float)-0.4f, (float)0.0f);
            }
            if (entitylivingbaseIn.func_184218_aH() && entitylivingbaseIn.func_70631_g_()) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.7f, (float)0.15f);
            }
        } else {
            if (entitylivingbaseIn.func_184218_aH()) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.25f, (float)0.0f);
            }
            if (entitylivingbaseIn.func_70631_g_()) {
                GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
            }
        }
        float fit = entitylivingbaseIn.getFittness();
        GlStateManager.func_179152_a((float)fit, (float)fit, (float)fit);
        if (entitylivingbaseIn.isHero()) {
            GlStateManager.func_179152_a((float)1.05f, (float)1.05f, (float)1.05f);
        }
        if (!entitylivingbaseIn.field_70122_E) {
            GlStateManager.func_179114_b((float)(entitylivingbaseIn.prevRotationPitchFalling + (entitylivingbaseIn.rotationPitchFalling - entitylivingbaseIn.prevRotationPitchFalling) * 2.0f - 1.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (entitylivingbaseIn.field_70173_aa <= 21 && entitylivingbaseIn.field_70173_aa > 0) {
            float f5 = ((float)entitylivingbaseIn.field_70173_aa + partialTickTime - 1.0f) / 20.0f * 1.6f;
            if ((f5 = MathHelper.func_76129_c((float)f5)) > 1.0f) {
                f5 = 1.0f;
            }
            GlStateManager.func_179152_a((float)f5, (float)f5, (float)f5);
            GlStateManager.func_179114_b((float)(f5 * 90.0f - 90.0f), (float)f5, (float)f5, (float)f5);
        }
    }

    protected void applyRotations(EntityEnderman entityLiving, float p_77043_2_, float p_77043_3_, float partialTicks) {
        GlStateManager.func_179114_b((float)(180.0f - p_77043_3_), (float)0.0f, (float)1.0f, (float)0.0f);
        if (entityLiving.field_70725_aQ > 0) {
            float f = ((float)entityLiving.field_70725_aQ + partialTicks - 1.0f) / 20.0f * 1.6f;
            if ((f = MathHelper.func_76129_c((float)f)) > 1.0f) {
                f = 1.0f;
            }
            if (EngenderMod.useMobTalkerModels) {
                GlStateManager.func_179114_b((float)(f * this.func_77037_a((EntityLivingBase)entityLiving)), (float)-1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)(f * 0.125f));
            } else {
                GlStateManager.func_179114_b((float)(f * this.func_77037_a((EntityLivingBase)entityLiving)), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179109_b((float)(f * 0.25f), (float)0.0f, (float)0.0f);
            }
        } else {
            String s = TextFormatting.func_110646_a((String)entityLiving.func_70005_c_());
            if (s != null && ("Dinnerbone".equals(s) || "Grumm".equals(s))) {
                GlStateManager.func_179109_b((float)0.0f, (float)(entityLiving.field_70131_O + 0.1f), (float)0.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
        }
    }

    protected ResourceLocation getEntityTexture(EntityEnderman entity) {
        String s = TextFormatting.func_110646_a((String)entity.func_70005_c_());
        return EngenderMod.useMobTalkerModels ? (s != null && "Nerras".equals(s) ? (entity.isAntiMob() ? anticmmNerrasTextures : cmmNerrasTextures) : (entity.isAntiMob() ? anticmmEndermanTextures : cmmEndermanTextures)) : (entity.isAntiMob() ? antiendermanTextures : (s != null && "Bart".equals(s) ? bartTextures : endermanTextures));
    }
}

