/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.AgeOfMinecraft.render;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.minecraft.AgeOfMinecraft.EngenderMod;
import net.minecraft.AgeOfMinecraft.models.ModelBlaze;
import net.minecraft.AgeOfMinecraft.models.ModelCMMBlaze;
import net.minecraft.AgeOfMinecraft.render.LayerArrowCustomSized;
import net.minecraft.AgeOfMinecraft.render.LayerCustomHeadEngender;
import net.minecraft.AgeOfMinecraft.render.LayerHeldItemCMM;
import net.minecraft.AgeOfMinecraft.render.LayerLearningBook;
import net.minecraft.AgeOfMinecraft.render.LayerMobCape;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySkullRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.helpful.tier2.EntityVillager;
import net.minecraft.entity.helpful.tier3.EntityZombie;
import net.minecraft.entity.helpful.tier4.EntityBlaze;
import net.minecraft.entity.helpful.tier4.EntityVindicator;
import net.minecraft.entity.helpful.tier4.EntityWitch;
import net.minecraft.entity.helpful.tier5.EntityEvoker;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;

@SideOnly(value=Side.CLIENT)
public class RenderBlaze
extends RenderLiving<EntityBlaze> {
    private static final ResourceLocation cmmTextures = new ResourceLocation("ageofminecraft", "textures/entities/yarrscmm/blaze.png");
    private static final ResourceLocation textures = new ResourceLocation("textures/entity/blaze.png");
    private static final ResourceLocation anticmmTextures = new ResourceLocation("ageofminecraft", "textures/entities/yarrscmm/anti/blaze.png");
    private static final ResourceLocation antiTextures = new ResourceLocation("ageofminecraft", "textures/entities/anti/blaze.png");
    private static ModelCMMBlaze cmmmodel = new ModelCMMBlaze();
    private static ModelBlaze regularmodel = new ModelBlaze();
    private LayerHeldItemCMM helditems;

    public RenderBlaze(RenderManager renderManagerIn) {
        super(renderManagerIn, EngenderMod.useMobTalkerModels ? cmmmodel : regularmodel, 0.5f);
        this.helditems = new LayerHeldItemCMM(EngenderMod.useMobTalkerModels ? RenderBlaze.cmmmodel.RArm : RenderBlaze.regularmodel.blazeSticks[0], EngenderMod.useMobTalkerModels ? RenderBlaze.cmmmodel.LArm : RenderBlaze.regularmodel.blazeSticks[3]);
        this.func_177094_a(new LayerArrowCustomSized((RenderLivingBase<?>)this, 1.0f));
        this.func_177094_a(new LayerCustomHeadEngender(RenderBlaze.regularmodel.blazeHead, RenderBlaze.cmmmodel.Head));
        this.func_177094_a(this.helditems);
        this.func_177094_a(new LayerLearningBook(this));
        this.func_177094_a(new LayerMobCape((RenderLivingBase)this));
    }

    protected void preRenderCallback(EntityBlaze entitylivingbaseIn, float partialTickTime) {
        this.field_77045_g = EngenderMod.useMobTalkerModels ? cmmmodel : regularmodel;
        this.field_177097_h.remove(this.helditems);
        this.helditems.modelRenderer1 = EngenderMod.useMobTalkerModels ? RenderBlaze.cmmmodel.RArm : RenderBlaze.regularmodel.blazeSticks[0];
        this.helditems.modelRenderer2 = EngenderMod.useMobTalkerModels ? RenderBlaze.cmmmodel.LArm : RenderBlaze.regularmodel.blazeSticks[3];
        this.func_177094_a(this.helditems);
        if (EngenderMod.useMobTalkerModels) {
            if (entitylivingbaseIn.func_184218_aH() && entitylivingbaseIn.func_70631_g_()) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.6f, (float)0.25f);
            } else if (entitylivingbaseIn.func_184218_aH()) {
                GlStateManager.func_179109_b((float)0.0f, (float)-0.5f, (float)0.0f);
            }
        }
        float fit = entitylivingbaseIn.getFittness();
        GlStateManager.func_179152_a((float)fit, (float)fit, (float)fit);
        if (entitylivingbaseIn.isHero()) {
            GlStateManager.func_179152_a((float)1.05f, (float)1.05f, (float)1.05f);
        }
        if (!entitylivingbaseIn.field_70122_E) {
            GlStateManager.func_179114_b((float)(entitylivingbaseIn.prevRotationPitchFalling + (entitylivingbaseIn.rotationPitchFalling - entitylivingbaseIn.prevRotationPitchFalling) * 2.0f - 1.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (entitylivingbaseIn.field_70173_aa <= 21 && entitylivingbaseIn.field_70173_aa > 0) {
            float f5 = ((float)entitylivingbaseIn.field_70173_aa + partialTickTime - 1.0f) / 20.0f * 1.6f;
            if ((f5 = MathHelper.func_76129_c((float)f5)) > 1.0f) {
                f5 = 1.0f;
            }
            GlStateManager.func_179152_a((float)f5, (float)f5, (float)f5);
            GlStateManager.func_179114_b((float)(f5 * 90.0f - 90.0f), (float)f5, (float)f5, (float)f5);
        }
    }

    protected void applyRotations(EntityBlaze entityLiving, float p_77043_2_, float p_77043_3_, float partialTicks) {
        GlStateManager.func_179114_b((float)(180.0f - p_77043_3_), (float)0.0f, (float)1.0f, (float)0.0f);
        if (EngenderMod.useMobTalkerModels && entityLiving.isSitResting()) {
            GlStateManager.func_179109_b((float)0.0f, (float)(MathHelper.func_76134_b((float)(p_77043_2_ * 0.2f)) * 0.1f), (float)0.0f);
        }
        if (entityLiving.field_70725_aQ > 0) {
            float f = ((float)entityLiving.field_70725_aQ + partialTicks - 1.0f) / 20.0f * 1.6f;
            if ((f = MathHelper.func_76129_c((float)f)) > 1.0f) {
                f = 1.0f;
            }
            if (EngenderMod.useMobTalkerModels) {
                GlStateManager.func_179114_b((float)(f * this.func_77037_a((EntityLivingBase)entityLiving)), (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)(-f * 0.125f));
            } else {
                GlStateManager.func_179114_b((float)(f * this.func_77037_a((EntityLivingBase)entityLiving)), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179109_b((float)(f * 0.25f), (float)0.0f, (float)0.0f);
            }
        } else {
            String s = TextFormatting.func_110646_a((String)entityLiving.func_70005_c_());
            if (s != null && ("Dinnerbone".equals(s) || "Grumm".equals(s))) {
                GlStateManager.func_179109_b((float)0.0f, (float)(entityLiving.field_70131_O + 0.1f), (float)0.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
        }
    }

    protected ResourceLocation getEntityTexture(EntityBlaze entity) {
        return EngenderMod.useMobTalkerModels ? (entity.isAntiMob() ? anticmmTextures : cmmTextures) : (entity.isAntiMob() ? antiTextures : textures);
    }

    private ModelRenderer getHead() {
        return EngenderMod.useMobTalkerModels ? ((ModelCMMBlaze)this.func_177087_b()).Head : ((ModelBlaze)this.func_177087_b()).blazeHead;
    }

    private ModelRenderer getRightArm() {
        return EngenderMod.useMobTalkerModels ? ((ModelCMMBlaze)this.func_177087_b()).RArm : ((ModelBlaze)this.func_177087_b()).blazeSticks[0];
    }

    private ModelRenderer getLeftArm() {
        return EngenderMod.useMobTalkerModels ? ((ModelCMMBlaze)this.func_177087_b()).LArm : ((ModelBlaze)this.func_177087_b()).blazeSticks[3];
    }

    @SideOnly(value=Side.CLIENT)
    public class LayerHead
    implements LayerRenderer<EntityLivingBase> {
        private RenderLiving renderer;

        public LayerHead(RenderLiving p_i46120_1_) {
            this.renderer = p_i46120_1_;
        }

        public void func_177141_a(EntityLivingBase entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            if (this.renderer != null && !entitylivingbaseIn.func_70631_g_()) {
                GlStateManager.func_179094_E();
                ItemStack itemstack = entitylivingbaseIn.func_184582_a(EntityEquipmentSlot.HEAD);
                if (!itemstack.func_190926_b()) {
                    boolean flag;
                    Item item = itemstack.func_77973_b();
                    Minecraft minecraft = Minecraft.func_71410_x();
                    boolean bl = flag = entitylivingbaseIn instanceof EntityWitch || entitylivingbaseIn instanceof EntityEvoker || entitylivingbaseIn instanceof EntityVindicator || entitylivingbaseIn instanceof EntityVillager || !EngenderMod.useMobTalkerModels && entitylivingbaseIn instanceof EntityZombie && ((EntityZombie)entitylivingbaseIn).isVillager();
                    if (entitylivingbaseIn.func_70631_g_() && !flag) {
                        float f = 2.0f;
                        float f1 = 1.4f;
                        GlStateManager.func_179109_b((float)0.0f, (float)(0.5f * scale), (float)0.0f);
                        GlStateManager.func_179109_b((float)0.0f, (float)(16.0f * scale), (float)0.0f);
                    }
                    ((RenderBlaze)this.renderer).getHead().func_78794_c(0.0625f);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    if (item == Items.field_151144_bL) {
                        float f2 = 1.1875f;
                        GlStateManager.func_179152_a((float)1.1875f, (float)-1.1875f, (float)-1.1875f);
                        if (flag) {
                            GlStateManager.func_179109_b((float)0.0f, (float)0.0625f, (float)0.0f);
                        }
                        GameProfile gameprofile = null;
                        if (itemstack.func_77942_o()) {
                            String s;
                            NBTTagCompound nbttagcompound = itemstack.func_77978_p();
                            if (nbttagcompound.func_150297_b("SkullOwner", 10)) {
                                gameprofile = NBTUtil.func_152459_a((NBTTagCompound)nbttagcompound.func_74775_l("SkullOwner"));
                            } else if (nbttagcompound.func_150297_b("SkullOwner", 8) && !StringUtils.isBlank((CharSequence)(s = nbttagcompound.func_74779_i("SkullOwner")))) {
                                gameprofile = TileEntitySkull.func_174884_b((GameProfile)new GameProfile((UUID)null, s));
                                nbttagcompound.func_74782_a("SkullOwner", (NBTBase)NBTUtil.func_180708_a((NBTTagCompound)new NBTTagCompound(), (GameProfile)gameprofile));
                            }
                        }
                        TileEntitySkullRenderer.field_147536_b.func_188190_a(-0.5f, 0.0f, -0.5f, EnumFacing.UP, 180.0f, itemstack.func_77960_j(), gameprofile, -1, limbSwing);
                    } else if (!(item instanceof ItemArmor) || ((ItemArmor)item).func_185083_B_() != EntityEquipmentSlot.HEAD) {
                        float f3 = 0.625f;
                        GlStateManager.func_179109_b((float)0.0f, (float)-0.25f, (float)0.0f);
                        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        GlStateManager.func_179152_a((float)0.625f, (float)-0.625f, (float)-0.625f);
                        if (flag) {
                            GlStateManager.func_179109_b((float)0.0f, (float)0.1875f, (float)0.0f);
                        }
                        minecraft.func_175597_ag().func_178099_a(entitylivingbaseIn, itemstack, ItemCameraTransforms.TransformType.HEAD);
                    }
                }
                GlStateManager.func_179121_F();
            }
        }

        public boolean func_177142_b() {
            return false;
        }
    }
}

