/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.AgeOfMinecraft.render;

import net.minecraft.AgeOfMinecraft.models.ModelIceGolem;
import net.minecraft.AgeOfMinecraft.render.LayerArrowCustomSized;
import net.minecraft.AgeOfMinecraft.render.LayerLearningBook;
import net.minecraft.AgeOfMinecraft.render.LayerMobCape;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.helpful.tier5.EntityAbomniableSnowman;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderAbomniableSnowman
extends RenderLiving<EntityAbomniableSnowman> {
    private static final ResourceLocation iceGolemTextures = new ResourceLocation("ageofminecraft", "textures/entities/abominable_snowman.png");
    private static ModelIceGolem regularmodel = new ModelIceGolem();

    public RenderAbomniableSnowman(RenderManager p_i46133_1_) {
        super(p_i46133_1_, (ModelBase)regularmodel, 1.75f);
        this.func_177094_a(new LayerArrowCustomSized((RenderLivingBase<?>)this, 1.0f));
        this.func_177094_a(new LayerSnowmanHead(RenderAbomniableSnowman.regularmodel.ironGolemHead));
        this.func_177094_a(new LayerLearningBook(this));
        this.func_177094_a(new LayerMobCape((RenderLivingBase)this));
    }

    protected ResourceLocation getEntityTexture(EntityAbomniableSnowman entity) {
        return iceGolemTextures;
    }

    protected void preRenderCallback(EntityAbomniableSnowman entitylivingbaseIn, float partialTickTime) {
        GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
        float fit = entitylivingbaseIn.getFittness();
        GlStateManager.func_179152_a((float)fit, (float)fit, (float)fit);
        if (entitylivingbaseIn.isHero()) {
            GlStateManager.func_179152_a((float)1.05f, (float)1.05f, (float)1.05f);
        }
        if (entitylivingbaseIn.func_70631_g_()) {
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        }
        if (entitylivingbaseIn.field_70173_aa <= 21 && entitylivingbaseIn.field_70173_aa > 0) {
            float f5 = ((float)entitylivingbaseIn.field_70173_aa + partialTickTime - 1.0f) / 20.0f * 1.6f;
            if ((f5 = MathHelper.func_76129_c((float)f5)) > 1.0f) {
                f5 = 1.0f;
            }
            GlStateManager.func_179152_a((float)f5, (float)f5, (float)f5);
            GlStateManager.func_179114_b((float)(f5 * 90.0f - 90.0f), (float)f5, (float)f5, (float)f5);
        }
    }

    protected void applyRotations(EntityAbomniableSnowman entityLiving, float p_77043_2_, float p_77043_3_, float partialTicks) {
        GlStateManager.func_179114_b((float)(180.0f - p_77043_3_), (float)0.0f, (float)1.0f, (float)0.0f);
        if (entityLiving.field_70725_aQ > 0) {
            float f = ((float)entityLiving.field_70725_aQ + partialTicks - 1.0f) / 20.0f * 1.6f;
            if ((f = MathHelper.func_76129_c((float)f)) > 1.0f) {
                f = 1.0f;
            }
            GlStateManager.func_179114_b((float)(f * this.func_77037_a((EntityLivingBase)entityLiving)), (float)0.0f, (float)0.0f, (float)1.0f);
        } else {
            String s = TextFormatting.func_110646_a((String)entityLiving.func_70005_c_());
            if (s != null && ("Dinnerbone".equals(s) || "Grumm".equals(s))) {
                GlStateManager.func_179109_b((float)0.0f, (float)(entityLiving.field_70131_O + 0.1f), (float)0.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
        }
        if ((double)entityLiving.field_70721_aZ >= 0.01) {
            float f3 = 13.0f;
            float f4 = entityLiving.field_184619_aG - entityLiving.field_70721_aZ * (1.0f - partialTicks) + 6.0f;
            float f5 = (Math.abs(f4 % f3 - f3 * 0.5f) - f3 * 0.25f) / (f3 * 0.25f);
            GlStateManager.func_179114_b((float)(7.0f * f5), (float)0.0f, (float)0.0f, (float)1.0f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class LayerSnowmanHead
    implements LayerRenderer<EntityAbomniableSnowman> {
        private final ModelRenderer snowManRenderer;

        public LayerSnowmanHead(ModelRenderer snowManRendererIn) {
            this.snowManRenderer = snowManRendererIn;
        }

        public void doRenderLayer(EntityAbomniableSnowman entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            if (!entitylivingbaseIn.func_82150_aj()) {
                GlStateManager.func_179094_E();
                this.snowManRenderer.func_78794_c(0.0625f);
                float f = 0.55f;
                GlStateManager.func_179109_b((float)0.0f, (float)-0.25f, (float)0.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)f, (float)(-f), (float)(-f));
                Minecraft.func_71410_x().func_175597_ag().func_178099_a((EntityLivingBase)entitylivingbaseIn, new ItemStack(Blocks.field_150423_aK, 1), ItemCameraTransforms.TransformType.HEAD);
                GlStateManager.func_179121_F();
            }
        }

        public boolean func_177142_b() {
            return true;
        }
    }
}

