/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.AgeOfMinecraft.models;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.helpful.tier2.EntitySilverfish;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelSilverfish
extends ModelBase {
    public final ModelRenderer[] silverfishBodyParts = new ModelRenderer[7];
    private final ModelRenderer[] silverfishWings;
    private final float[] zPlacement = new float[7];
    private static final int[][] SILVERFISH_BOX_LENGTH = new int[][]{{3, 2, 2}, {4, 3, 2}, {6, 4, 3}, {3, 3, 3}, {2, 2, 3}, {2, 1, 2}, {1, 1, 2}};
    private static final int[][] SILVERFISH_TEXTURE_POSITIONS = new int[][]{{0, 0}, {0, 4}, {0, 9}, {0, 16}, {0, 22}, {11, 0}, {13, 4}};

    public ModelSilverfish() {
        float f = -3.5f;
        for (int i = 0; i < this.silverfishBodyParts.length; ++i) {
            this.silverfishBodyParts[i] = new ModelRenderer((ModelBase)this, SILVERFISH_TEXTURE_POSITIONS[i][0], SILVERFISH_TEXTURE_POSITIONS[i][1]);
            this.silverfishBodyParts[i].func_78789_a((float)SILVERFISH_BOX_LENGTH[i][0] * -0.5f, 0.0f, (float)SILVERFISH_BOX_LENGTH[i][2] * -0.5f, SILVERFISH_BOX_LENGTH[i][0], SILVERFISH_BOX_LENGTH[i][1], SILVERFISH_BOX_LENGTH[i][2]);
            this.silverfishBodyParts[i].func_78793_a(0.0f, (float)(24 - SILVERFISH_BOX_LENGTH[i][1]), f);
            this.zPlacement[i] = f;
            if (i >= this.silverfishBodyParts.length - 1) continue;
            f += (float)(SILVERFISH_BOX_LENGTH[i][2] + SILVERFISH_BOX_LENGTH[i + 1][2]) * 0.5f;
        }
        this.silverfishWings = new ModelRenderer[3];
        this.silverfishWings[0] = new ModelRenderer((ModelBase)this, 20, 0);
        this.silverfishWings[0].func_78789_a(-5.0f, 0.0f, (float)SILVERFISH_BOX_LENGTH[2][2] * -0.5f, 10, 8, SILVERFISH_BOX_LENGTH[2][2]);
        this.silverfishWings[0].func_78793_a(0.0f, 16.0f, this.zPlacement[2]);
        this.silverfishWings[1] = new ModelRenderer((ModelBase)this, 20, 11);
        this.silverfishWings[1].func_78789_a(-3.0f, 0.0f, (float)SILVERFISH_BOX_LENGTH[4][2] * -0.5f, 6, 4, SILVERFISH_BOX_LENGTH[4][2]);
        this.silverfishWings[1].func_78793_a(0.0f, 20.0f, this.zPlacement[4]);
        this.silverfishWings[2] = new ModelRenderer((ModelBase)this, 20, 18);
        this.silverfishWings[2].func_78789_a(-3.0f, 0.0f, (float)SILVERFISH_BOX_LENGTH[4][2] * -0.5f, 6, 5, SILVERFISH_BOX_LENGTH[1][2]);
        this.silverfishWings[2].func_78793_a(0.0f, 19.0f, this.zPlacement[1]);
    }

    public void func_78088_a(Entity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        this.func_78087_a(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale, entityIn);
        for (ModelRenderer modelrenderer : this.silverfishBodyParts) {
            modelrenderer.func_78785_a(scale);
        }
        for (ModelRenderer modelrenderer1 : this.silverfishWings) {
            modelrenderer1.func_78785_a(scale);
        }
    }

    public void func_78087_a(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, Entity entity) {
        int i;
        EntitySilverfish silverfish = (EntitySilverfish)entity;
        for (i = 0; i < this.silverfishBodyParts.length; ++i) {
            this.silverfishBodyParts[i].field_78796_g = MathHelper.func_76134_b((float)((silverfish.func_175446_cd() ? 1.0f : ageInTicks) * 0.9f + (float)i * 0.15f * (float)Math.PI)) * (float)Math.PI * (silverfish.func_70093_af() ? 0.0125f : 0.05f) * (float)(1 + Math.abs(i - 2));
            this.silverfishBodyParts[i].field_78800_c = MathHelper.func_76126_a((float)((silverfish.func_175446_cd() ? 1.0f : ageInTicks) * 0.9f + (float)i * 0.15f * (float)Math.PI)) * (float)Math.PI * (silverfish.func_70093_af() ? 0.05f : 0.2f) * (float)Math.abs(i - 2);
        }
        if (silverfish.getJukeboxToDanceTo() != null) {
            for (i = 0; i < this.silverfishBodyParts.length; ++i) {
                this.silverfishBodyParts[i].field_78796_g = MathHelper.func_76134_b((float)((silverfish.func_175446_cd() ? 1.0f : ageInTicks) * 0.45f + (float)i * 0.125f * (float)Math.PI)) * (float)Math.PI * 0.1f * (float)(1 + Math.abs(i - 2));
                this.silverfishBodyParts[i].field_78800_c = MathHelper.func_76126_a((float)((silverfish.func_175446_cd() ? 1.0f : ageInTicks) * 0.45f + (float)i * 0.125f * (float)Math.PI)) * (float)Math.PI * 0.2f * (float)Math.abs(i - 2);
            }
        }
        this.silverfishBodyParts[0].field_78796_g += netHeadYaw / 57.295776f;
        this.silverfishBodyParts[0].field_78795_f = headPitch / 57.295776f;
        this.silverfishWings[0].field_78796_g = this.silverfishBodyParts[2].field_78796_g;
        this.silverfishWings[1].field_78796_g = this.silverfishBodyParts[4].field_78796_g;
        this.silverfishWings[1].field_78800_c = this.silverfishBodyParts[4].field_78800_c;
        this.silverfishWings[2].field_78796_g = this.silverfishBodyParts[1].field_78796_g;
        this.silverfishWings[2].field_78800_c = this.silverfishBodyParts[1].field_78800_c;
    }
}

