/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.AgeOfMinecraft.items;

import java.util.List;
import net.minecraft.AgeOfMinecraft.EngenderMod;
import net.minecraft.AgeOfMinecraft.ModSoundEvents;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.helpful.EntityPortal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPortalStaff
extends Item {
    public ItemPortalStaff() {
        this.setRegistryName("portalstaff");
        this.func_77655_b("portalstaff");
        this.func_77625_d(1);
        this.func_77637_a(EngenderMod.aomTab);
        this.func_77627_a(true);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean B) {
        list.add("Summons a portal to help aid the user of the staff. Staff is held inside the portal until it's destroyed or unbuilt by being right clicked by it's owner. Portals summon mobs from Bats to Withers. Higher upgrades improve the portal itself.");
        list.add(TextFormatting.YELLOW + "Hold back and stand on ground to use." + TextFormatting.WHITE);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 1: {
                return EnumRarity.UNCOMMON;
            }
            case 2: {
                return EnumRarity.RARE;
            }
            case 3: {
                return EnumRarity.EPIC;
            }
            case 4: {
                return EngenderMod.SUPEREPIC;
            }
        }
        return EnumRarity.COMMON;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return super.func_77636_d(stack) || stack.func_77960_j() > 3;
    }

    public int func_77626_a(ItemStack stack) {
        return 30;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        boolean flag;
        ItemStack itemStackIn = playerIn.func_184586_b(hand);
        ActionResult ret = ForgeEventFactory.onArrowNock((ItemStack)itemStackIn, (World)worldIn, (EntityPlayer)playerIn, (EnumHand)hand, (boolean)(flag = this.func_185060_a(playerIn) != null));
        if (ret != null) {
            return ret;
        }
        if (!playerIn.field_71075_bZ.field_75098_d && !flag) {
            return !flag ? new ActionResult(EnumActionResult.FAIL, (Object)itemStackIn) : new ActionResult(EnumActionResult.PASS, (Object)itemStackIn);
        }
        playerIn.func_184598_c(hand);
        playerIn.field_70170_p.func_184133_a(playerIn, new BlockPos((Entity)playerIn), SoundEvents.field_187680_c, SoundCategory.PLAYERS, 100.0f, 0.5f);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
    }

    private ItemStack func_185060_a(EntityPlayer player) {
        return player.func_184586_b(EnumHand.MAIN_HAND);
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        return this.onItemUseFinish(stack, worldIn, (EntityPlayer)entityLiving);
    }

    public ItemStack onItemUseFinish(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        playerIn.func_71020_j(10.0f);
        playerIn.func_184811_cZ().func_185145_a((Item)this, 600);
        EntityPortal portal = new EntityPortal(worldIn);
        portal.func_70012_b((int)playerIn.field_70165_t, (int)playerIn.field_70163_u, (int)playerIn.field_70161_v, 0.0f, 0.0f);
        portal.setOwnerId(playerIn.func_110124_au());
        portal.func_184185_a(ModSoundEvents.portalMake, 100.0f, 1.0f);
        portal.func_184185_a(ModSoundEvents.portalAmbient, 5.0f, 1.0f);
        if (!worldIn.field_72995_K) {
            worldIn.func_72838_d((Entity)portal);
            portal.setMetaData(stack.func_77960_j());
            portal.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(1000.0 + (double)portal.getMetaData() * 500.0);
            portal.func_70691_i(portal.func_110138_aP());
            stack.func_190918_g(1);
        }
        return stack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item itemIn, CreativeTabs tab, NonNullList<ItemStack> subItems) {
        subItems.add((Object)new ItemStack(itemIn));
        subItems.add((Object)new ItemStack(itemIn, 1, 1));
        subItems.add((Object)new ItemStack(itemIn, 1, 2));
        subItems.add((Object)new ItemStack(itemIn, 1, 3));
        subItems.add((Object)new ItemStack(itemIn, 1, 4));
    }
}

