/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.AgeOfMinecraft.items;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import net.minecraft.AgeOfMinecraft.EngenderMod;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.EnumTier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemConvertingStaff
extends Item {
    public ItemConvertingStaff() {
        this.setRegistryName("convertingstaff");
        this.func_77655_b("convertingstaff");
        this.func_77625_d(1);
        this.func_77637_a(EngenderMod.aomTab);
        this.func_77627_a(true);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean B) {
        list.add("Converts wild Engender mobs to your side. You must hold right click until it tells you in chat that the mob has converted. Mobs will take longer to convert depending on tier. Is the cheapest method to convert, but also the most time costing.");
        list.add(TextFormatting.YELLOW + "Hold back to use." + TextFormatting.WHITE);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 1: {
                return EnumRarity.UNCOMMON;
            }
            case 2: {
                return EnumRarity.RARE;
            }
            case 3: {
                return EnumRarity.EPIC;
            }
            case 4: {
                return EngenderMod.SUPEREPIC;
            }
        }
        return EnumRarity.COMMON;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return super.func_77636_d(stack) || stack.func_77960_j() > 3;
    }

    public int func_77626_a(ItemStack stack) {
        return 20;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        boolean flag;
        ItemStack itemStackIn = playerIn.func_184586_b(hand);
        ActionResult ret = ForgeEventFactory.onArrowNock((ItemStack)itemStackIn, (World)worldIn, (EntityPlayer)playerIn, (EnumHand)hand, (boolean)(flag = this.func_185060_a(playerIn) != null));
        if (ret != null) {
            return ret;
        }
        if (!playerIn.field_71075_bZ.field_75098_d && !flag) {
            return !flag ? new ActionResult(EnumActionResult.FAIL, (Object)itemStackIn) : new ActionResult(EnumActionResult.PASS, (Object)itemStackIn);
        }
        playerIn.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
    }

    private ItemStack func_185060_a(EntityPlayer player) {
        return player.func_184586_b(EnumHand.MAIN_HAND);
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        return this.onItemUseFinish(stack, worldIn, (EntityPlayer)entityLiving);
    }

    public ItemStack onItemUseFinish(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        List list = playerIn.field_70170_p.func_175647_a(EntityFriendlyCreature.class, playerIn.func_174813_aQ().func_72314_b(24.0, 24.0, 24.0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d}));
        if (list != null) {
            if (!list.isEmpty()) {
                for (int i1 = 0; i1 < list.size(); ++i1) {
                    EntityFriendlyCreature entity = (EntityFriendlyCreature)list.get(i1);
                    if (entity != null && entity.func_70089_S() && entity.isWild() && entity.func_184753_b() == null && !entity.isABoss() && entity.getTier() != EnumTier.TIER6) {
                        if (entity.convertionInt <= 0 && !playerIn.field_70170_p.field_72995_K) {
                            playerIn.func_145747_a((ITextComponent)new TextComponentTranslation(entity.func_70005_c_() + " is wild. Starting conversion...", new Object[0]));
                        }
                        playerIn.func_184811_cZ().func_185145_a((Item)this, 20);
                        for (int times = 0; times <= stack.func_77960_j(); ++times) {
                            entity.incrementConversion(playerIn);
                        }
                        continue;
                    }
                    if (entity == null || !entity.func_70089_S() || entity.isWild() && entity.func_184753_b() == null || entity.getTier() == EnumTier.TIER6 || playerIn.field_70170_p.field_72995_K) continue;
                    playerIn.func_145747_a((ITextComponent)new TextComponentTranslation(entity.func_70005_c_() + " isn't wild.", new Object[0]));
                }
            } else if (!playerIn.field_70170_p.field_72995_K) {
                playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("No engender mobs are in your vicinity.", new Object[0]));
            }
        }
        return stack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item itemIn, CreativeTabs tab, NonNullList<ItemStack> subItems) {
        subItems.add((Object)new ItemStack(itemIn));
        subItems.add((Object)new ItemStack(itemIn, 1, 1));
        subItems.add((Object)new ItemStack(itemIn, 1, 2));
        subItems.add((Object)new ItemStack(itemIn, 1, 3));
        subItems.add((Object)new ItemStack(itemIn, 1, 4));
    }
}

