/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.AgeOfMinecraft.draconicevolution;

import com.brandon3055.brandonscore.utils.Utils;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import net.minecraft.AgeOfMinecraft.MobChunkLoader;
import net.minecraft.AgeOfMinecraft.ModSoundEvents;
import net.minecraft.AgeOfMinecraft.draconicevolution.EntityGuardianProjectile;
import net.minecraft.block.Block;
import net.minecraft.block.BlockJukebox;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.EnumTier;
import net.minecraft.entity.helpful.tier5.EntityEnderDragon;
import net.minecraft.entity.helpful.tier5.dragonphases.EntityDragonFireballOther;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.BossInfo;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;

public class EntityChaosGuardian
extends EntityEnderDragon {
    public int homeX = 0;
    public int homeY = -1;
    public int homeZ = 0;
    public boolean homeSet = false;
    public double targetX;
    public double targetY;
    public double targetZ;
    public boolean forceNewTarget;
    private int nextAttackTimer = 100;
    private int attackInProgress = -1;
    private int attackTimer = 0;
    private EnumBehaviour previousBehaviour = EnumBehaviour.ROAMING;
    private int ignitionChargeTimer = 0;
    private static final int ATTACK_FIREBALL_CHARGE = 0;
    private static final int ATTACK_FIREBALL_CHASER = 1;
    private static final int ATTACK_ENERGY_CHASER = 2;
    private static final int ATTACK_CHAOS_CHASER = 3;
    private static final int ATTACK_TELEPORT = 4;
    private static final int ATTACK_LIGHTNING_BOLT = 5;
    private static final int ATTACK_ENDER_CHARGE = 6;
    private static final int ATTACK_WILD_CARD = 7;
    private static final int ATTACK_HEAVY_WIND = 8;
    public float circlePosition = 0.0f;
    public float circleDirection = 1.0f;
    public EnumBehaviour behaviour = EnumBehaviour.ROAMING;
    private static final List<WeightedAttack> weightedAttacks = Lists.newArrayList((Object[])new WeightedAttack[]{new WeightedAttack(16, 0), new WeightedAttack(14, 1), new WeightedAttack(12, 2), new WeightedAttack(10, 3), new WeightedAttack(5, 5), new WeightedAttack(10, 6)});
    private static final List<WeightedAttack> weightedLowHealthAttaxks = Lists.newArrayList((Object[])new WeightedAttack[]{new WeightedAttack(5, 1), new WeightedAttack(5, 4), new WeightedAttack(10, 2), new WeightedAttack(15, 3), new WeightedAttack(15, 5), new WeightedAttack(105, 6)});
    private static final List<WeightedBehaviour> weightedBehaviours = Lists.newArrayList((Object[])new WeightedBehaviour[]{new WeightedBehaviour(1, EnumBehaviour.LOW_HEALTH_STRATEGY), new WeightedBehaviour(10, EnumBehaviour.GUARDING), new WeightedBehaviour(20, EnumBehaviour.CHARGING), new WeightedBehaviour(12, EnumBehaviour.FIREBOMB), new WeightedBehaviour(20, EnumBehaviour.CIRCLE_PLAYER)});

    public EntityChaosGuardian(World par1World) {
        super(par1World);
        this.bossInfo.func_186745_a(BossInfo.Color.RED);
        this.bossInfo.func_186741_a(true);
        this.bossInfo.func_186746_a(BossInfo.Overlay.NOTCHED_20);
        this.setLevel(300);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(2000.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(50.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111128_a(20.0);
    }

    @Override
    public float getDefaultStrengthStat() {
        return 100.0f;
    }

    @Override
    public float getDefaultStaminaStat() {
        return 100.0f;
    }

    @Override
    public float getDefaultIntelligenceStat() {
        return 100.0f;
    }

    @Override
    public float getDefaultDexterityStat() {
        return 100.0f;
    }

    @Override
    public float getDefaultAgilityStat() {
        return 100.0f;
    }

    @Override
    public float getDefaultFittnessStat() {
        return 1.0f;
    }

    @Override
    public EnumTier getTier() {
        return EnumTier.TIER6;
    }

    @Override
    public void func_70636_d() {
        if (this.field_70173_aa % 5 == 0) {
            this.func_70691_i(2.0f);
        }
        if (this.field_70181_x >= 2.0 || this.field_70181_x <= -2.0) {
            this.field_70181_x = 0.0;
        }
        if (this.func_70089_S() && this.isCarryingCrystal()) {
            this.func_70606_j(this.func_110143_aJ() + 0.1f);
        }
        if (this.innerRotation > 500) {
            this.innerRotation = 0;
        }
        if (this.func_70638_az() != null && this.getJukeboxToDanceTo() == null) {
            this.func_70625_a((Entity)this.func_70638_az(), 10.0f, 90.0f);
        }
        if (this.func_70638_az() != null && (!this.func_70638_az().func_70089_S() || this.isOnSameTeam(this.func_70638_az()))) {
            this.func_70624_b(null);
        }
        if (this.func_70638_az() == null) {
            this.behaviour = EnumBehaviour.GO_HOME;
        }
        if (this.moralRaisedTimer <= 0) {
            this.moralRaisedTimer = 0;
        }
        if (this.moralRaisedTimer > 0) {
            --this.moralRaisedTimer;
        }
        if (this.func_175446_cd()) {
            this.func_94061_f(this.func_175446_cd());
            this.field_70172_ad = this.field_70771_an;
            if (this.field_70173_aa > 21) {
                --this.field_70173_aa;
            }
        } else {
            if (this.func_110143_aJ() > this.func_110138_aP() / 5.0f) {
                this.field_70715_bh.func_75774_a();
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.func_70089_S() && this.func_70638_az() != null && this.func_70638_az().func_70089_S() && this.isOffensive && !this.func_70631_g_() && !this.isOnSameTeam(this.func_70638_az())) {
                    double d = this.func_70068_e((Entity)this.func_70638_az());
                    float f = this.func_70638_az() instanceof EntityFriendlyCreature ? ((EntityFriendlyCreature)this.func_70638_az()).reachWidth : this.func_70638_az().field_70130_N;
                    float f2 = this.func_70638_az() instanceof EntityFriendlyCreature ? ((EntityFriendlyCreature)this.func_70638_az()).reachWidth : this.func_70638_az().field_70130_N;
                    if (d < (double)(this.reachWidth * this.reachWidth + f * f2) + 9.0 && (this.field_70173_aa + this.func_145782_y()) % 10 == 0) {
                        this.func_70652_k((Entity)this.func_70638_az());
                    }
                }
                if (this.func_70089_S()) {
                    MobChunkLoader.updateLoaded((Entity)this);
                } else {
                    MobChunkLoader.stopLoading((Entity)this);
                }
            }
        }
        this.func_174810_b(this.func_175446_cd());
        this.field_70703_bu = false;
        this.field_70160_al = false;
        this.field_70122_E = true;
        if (this.getJukeboxToDanceTo() != null) {
            this.func_70661_as().func_75499_g();
            IBlockState iblockstate = this.field_70170_p.func_180495_p(this.getJukeboxToDanceTo());
            Block block = iblockstate.func_177230_c();
            if (this.field_70173_aa > 100) {
                this.field_70173_aa = 20;
            }
            if (this.innerRotation > 500) {
                this.innerRotation = 0;
            }
            this.sitting = true;
            this.field_70181_x = this.field_70179_y *= 0.0;
            this.field_70159_w = this.field_70179_y;
            this.func_70634_a(this.getJukeboxToDanceTo().func_177958_n(), (double)this.getJukeboxToDanceTo().func_177956_o() + 12.0, this.getJukeboxToDanceTo().func_177952_p());
            if (block != Blocks.field_150421_aI || block == Blocks.field_150421_aI && !((Boolean)iblockstate.func_177229_b((IProperty)BlockJukebox.field_176432_a)).booleanValue() || this.func_174831_c(this.jukeBoxToDanceTo) > 10000.0) {
                this.setJukeboxToDanceTo(null);
                this.sitting = false;
            }
        }
        if (this.getJukeboxToDanceTo() == null && this.field_70173_aa % 60 == 0) {
            int i11 = MathHelper.func_76128_c((double)this.field_70163_u);
            int l1 = MathHelper.func_76128_c((double)this.field_70165_t);
            int i2 = MathHelper.func_76128_c((double)this.field_70161_v);
            boolean flag = false;
            for (int k2 = -12 - (int)this.field_70130_N; k2 <= 12 + (int)this.field_70130_N; ++k2) {
                for (int l2 = -12 - (int)this.field_70130_N; l2 <= 12 + (int)this.field_70130_N; ++l2) {
                    for (int j = -18 - (int)this.field_70131_O; j <= 18 + (int)this.field_70131_O; ++j) {
                        int i3 = l1 + k2;
                        int k = i11 + j;
                        int l = i2 + l2;
                        BlockPos blockpos = new BlockPos(i3, k, l);
                        IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
                        Block block = iblockstate.func_177230_c();
                        if (block != Blocks.field_150421_aI || !((Boolean)iblockstate.func_177229_b((IProperty)BlockJukebox.field_176432_a)).booleanValue()) continue;
                        this.setJukeboxToDanceTo(blockpos);
                        if (this.field_70173_aa > 100) {
                            this.field_70173_aa = 20;
                        }
                        if (this.innerRotation <= 500) continue;
                        this.innerRotation = 0;
                    }
                }
            }
        }
        if (!this.isWild()) {
            this.homeX = (int)this.getOwner().field_70165_t;
            this.homeY = (int)this.getOwner().field_70163_u + 5;
            this.homeZ = (int)this.getOwner().field_70161_v;
        } else {
            this.homeX = (int)this.field_70165_t;
            this.homeY = (int)this.field_70163_u;
            this.homeZ = (int)this.field_70161_v;
        }
        if (!this.homeSet) {
            this.homeX = (int)this.field_70165_t;
            this.homeY = (int)this.field_70163_u;
            this.homeZ = (int)this.field_70161_v;
            this.targetX = this.homeX;
            this.targetY = this.homeY;
            this.targetZ = this.homeZ;
            this.homeSet = true;
        }
        float moveSpeedMultiplier = this.behaviour.dragonSpeed;
        if (this.field_70170_p.field_72995_K) {
            float f = MathHelper.func_76134_b((float)(this.animTime * (float)Math.PI * 2.0f));
            float f1 = MathHelper.func_76134_b((float)(this.prevAnimTime * (float)Math.PI * 2.0f));
            if (f1 <= -0.3f && f >= -0.3f && this.deathTicks <= 0) {
                if (this.func_70093_af()) {
                    this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187524_aN, this.func_184176_by(), 1.0f, 0.6f + this.field_70146_Z.nextFloat() * 0.3f, false);
                } else {
                    this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187524_aN, SoundCategory.HOSTILE, 5.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.3f, false);
                }
            }
        }
        this.prevAnimTime = this.animTime;
        if (!this.field_70170_p.field_72995_K) {
            this.updateTarget();
            this.customAIUpdate();
            if (this.behaviour == EnumBehaviour.FIREBOMB && Utils.getDistanceAtoB((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)this.homeX, (double)(this.homeY + 30), (double)this.homeZ) <= 3.0) {
                moveSpeedMultiplier = 0.0f;
            }
        }
        if (this.func_110143_aJ() <= 0.0f) {
            this.behaviour = EnumBehaviour.DEAD;
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 4.0f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.field_70165_t + (double)f, this.field_70163_u + 2.0 + (double)f1, this.field_70161_v + (double)f2, 0.0, 0.0, 0.0, new int[0]);
        }
        this.field_70177_z = MathHelper.func_76142_g((float)this.field_70177_z);
        if (this.func_175446_cd()) {
            this.animTime = 0.0f;
        } else if (this.func_70089_S()) {
            if (this.ringBufferIndex < 0) {
                for (int i = 0; i < this.ringBuffer.length; ++i) {
                    this.ringBuffer[i][0] = this.field_70177_z;
                    this.ringBuffer[i][1] = this.field_70163_u;
                }
            }
            if (++this.ringBufferIndex == this.ringBuffer.length) {
                this.ringBufferIndex = 0;
            }
            this.ringBuffer[this.ringBufferIndex][0] = this.field_70177_z;
            this.ringBuffer[this.ringBufferIndex][1] = this.field_70163_u;
            float f = 0.2f / (MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y)) * 10.0f + 1.0f);
            f *= moveSpeedMultiplier == 0.0f ? 1.0f : moveSpeedMultiplier;
            this.animTime = this.func_184207_aI() || this.getJukeboxToDanceTo() != null ? (this.animTime += 0.1f) : (this.slowed ? (this.animTime += f * 0.5f) : (this.animTime += (f *= (float)Math.pow(2.0, this.field_70181_x))));
            if (this.field_70170_p.field_72995_K) {
                if (this.field_70716_bi > 0) {
                    double d10 = this.field_70165_t + (this.field_184623_bh - this.field_70165_t) / (double)this.field_70716_bi;
                    double d0 = this.field_70163_u + (this.field_184624_bi - this.field_70163_u) / (double)this.field_70716_bi;
                    double d1 = this.field_70161_v + (this.field_184625_bj - this.field_70161_v) / (double)this.field_70716_bi;
                    double d2 = MathHelper.func_76138_g((double)(this.field_184626_bk - (double)this.field_70177_z));
                    this.field_70177_z = (float)((double)this.field_70177_z + d2 / (double)this.field_70716_bi);
                    this.field_70125_A = (float)((double)this.field_70125_A + (this.field_70709_bj - (double)this.field_70125_A) / (double)this.field_70716_bi);
                    --this.field_70716_bi;
                    this.func_70107_b(d10, d0, d1);
                    this.func_70101_b(this.field_70177_z, this.field_70125_A);
                }
            } else {
                float f12;
                double d10 = this.targetX - this.field_70165_t;
                double d0 = this.targetY - this.field_70163_u;
                double d1 = this.targetZ - this.field_70161_v;
                double d2 = d10 * d10 + d0 * d0 + d1 * d1;
                if (this.func_70093_af() && this.func_70638_az() == null) {
                    this.targetX = this.homeX;
                    this.targetY = this.homeY;
                    this.targetZ = this.homeZ;
                }
                if (this.func_70638_az() != null) {
                    if (this.behaviour == EnumBehaviour.CIRCLE_PLAYER) {
                        this.targetX = this.func_70638_az().field_70165_t + (double)((int)(Math.cos(this.circlePosition) * 60.0));
                        this.targetZ = this.func_70638_az().field_70161_v + (double)((int)(Math.sin(this.circlePosition) * 60.0));
                        moveSpeedMultiplier = 1.0f + Math.min((float)Utils.getDistanceAtoB((double)this.targetX, (double)this.targetZ, (double)this.field_70165_t, (double)this.field_70161_v) / 50.0f * 3.0f, 3.0f);
                    } else {
                        this.targetX = this.func_70638_az().field_70165_t;
                        this.targetZ = this.func_70638_az().field_70161_v;
                    }
                    double d3 = this.targetX - this.field_70165_t;
                    double d5 = this.targetZ - this.field_70161_v;
                    double d7 = Math.sqrt(d3 * d3 + d5 * d5);
                    double d8 = (double)0.4f + d7 / 80.0 - 1.0;
                    if (d8 > 10.0) {
                        d8 = 10.0;
                    }
                    this.targetY = this.func_70638_az().func_174813_aQ().field_72338_b + d8 + (double)(this.behaviour == EnumBehaviour.CIRCLE_PLAYER ? 50 : 10);
                } else if (this.behaviour != EnumBehaviour.FIREBOMB) {
                    this.targetX += this.field_70146_Z.nextGaussian() * 2.0;
                    this.targetZ += this.field_70146_Z.nextGaussian() * 2.0;
                }
                if (this.forceNewTarget || d2 < 100.0 || d2 > 22500.0 || this.field_70123_F || this.field_70124_G) {
                    this.setNewTarget();
                }
                if ((d0 /= (double)MathHelper.func_76133_a((double)(d10 * d10 + d1 * d1))) < (double)(-(f12 = 0.6f))) {
                    d0 = -f12;
                }
                if (d0 > (double)f12) {
                    d0 = f12;
                }
                this.field_70181_x += d0 * (double)0.1f;
                this.field_70177_z = MathHelper.func_76142_g((float)this.field_70177_z);
                double d4 = 180.0 - Math.atan2(d10, d1) * 180.0 / Math.PI;
                double d6 = MathHelper.func_76138_g((double)(d4 - (double)this.field_70177_z));
                if (d6 > 50.0) {
                    d6 = 50.0;
                }
                if (d6 < -50.0) {
                    d6 = -50.0;
                }
                Vec3d vec3 = new Vec3d(this.targetX - this.field_70165_t, this.targetY - this.field_70163_u, this.targetZ - this.field_70161_v).func_72432_b();
                Vec3d vec32 = new Vec3d((double)MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)), this.field_70181_x, (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)))).func_72432_b();
                float f5 = (float)(vec32.func_72430_b(vec3) + 0.5) / 1.5f;
                if (f5 < 0.0f) {
                    f5 = 0.0f;
                }
                this.field_70704_bt *= 0.8f;
                float f6 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y)) * 1.0f + 1.0f;
                double d9 = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y) * 1.0 + 1.0;
                if (d9 > 40.0) {
                    d9 = 40.0;
                }
                this.field_70704_bt = (float)((double)this.field_70704_bt + d6 * ((double)0.7f / d9 / (double)f6));
                this.field_70177_z += this.field_70704_bt * 0.1f;
                float f7 = (float)(2.0 / (d9 + 1.0));
                float f8 = 0.06f;
                this.func_70060_a(0.0f, -1.0f, 0.06f * (f7 * f8 + (1.0f - f8)));
                if (this.func_70093_af()) {
                    this.func_70091_d(MoverType.SELF, this.field_70159_w * (this.func_184207_aI() ? 0.375 : 0.25), this.field_70181_x * (this.func_184207_aI() ? 0.375 : 0.25), this.field_70179_y * (this.func_184207_aI() ? 0.375 : 0.25));
                } else if (this.slowed) {
                    this.func_70091_d(MoverType.SELF, this.field_70159_w * (double)0.8f * (double)moveSpeedMultiplier, this.field_70181_x * (double)0.8f * (double)moveSpeedMultiplier, this.field_70179_y * (double)0.8f * (double)moveSpeedMultiplier);
                } else if (this.moralRaisedTimer > 200) {
                    this.func_70091_d(MoverType.SELF, this.field_70159_w * (this.func_184207_aI() ? 3.0 : 2.0), this.field_70181_x * (this.func_184207_aI() ? 3.0 : 2.0), this.field_70179_y * (this.func_184207_aI() ? 3.0 : 2.0));
                } else {
                    this.func_70091_d(MoverType.SELF, this.field_70159_w * (this.func_184207_aI() ? 1.5 : 1.0), this.field_70181_x * (this.func_184207_aI() ? 1.5 : 1.0), this.field_70179_y * (this.func_184207_aI() ? 1.5 : 1.0));
                }
                Vec3d vec31 = new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72432_b();
                float f9 = (float)(vec31.func_72430_b(vec32) + 1.0) / 2.0f;
                f9 = 0.8f + 0.15f * f9;
                this.field_70159_w *= (double)f9;
                this.field_70179_y *= (double)f9;
                this.field_70181_x *= (double)0.91f;
            }
        }
        this.dragonPartHead.field_70131_O = 2.5f;
        this.dragonPartHead.field_70130_N = 2.5f;
        this.dragonPartNeck.field_70131_O = 2.5f;
        this.dragonPartNeck.field_70130_N = 2.5f;
        this.dragonPartTail1.field_70131_O = 2.0f;
        this.dragonPartTail1.field_70130_N = 2.0f;
        this.dragonPartTail2.field_70131_O = 2.0f;
        this.dragonPartTail2.field_70130_N = 2.0f;
        this.dragonPartTail3.field_70131_O = 2.0f;
        this.dragonPartTail3.field_70130_N = 2.0f;
        this.dragonPartBody.field_70131_O = 3.5f;
        this.dragonPartBody.field_70130_N = 5.0f;
        this.dragonPartWing1.field_70131_O = 3.0f;
        this.dragonPartWing1.field_70130_N = 4.0f;
        this.dragonPartWing2.field_70131_O = 3.0f;
        this.dragonPartWing2.field_70130_N = 4.0f;
        Vec3d[] avec3d = new Vec3d[this.dragonPartArray.length];
        for (int j = 0; j < this.dragonPartArray.length; ++j) {
            avec3d[j] = new Vec3d(this.dragonPartArray[j].field_70165_t, this.dragonPartArray[j].field_70163_u, this.dragonPartArray[j].field_70161_v);
        }
        float f14 = (float)(this.getMovementOffsets(5, 1.0f)[1] - this.getMovementOffsets(10, 1.0f)[1]) * 10.0f * ((float)Math.PI / 180);
        float f16 = MathHelper.func_76134_b((float)f14);
        float f18 = MathHelper.func_76126_a((float)f14);
        float f7 = this.field_70177_z * ((float)Math.PI / 180);
        float f19 = MathHelper.func_76126_a((float)f7);
        float f3 = MathHelper.func_76134_b((float)f7);
        double[] adouble = this.getMovementOffsets(5, 1.0f);
        double[] adouble1 = this.getMovementOffsets(14, 1.0f);
        double[] adouble2 = this.getMovementOffsets(16, 1.0f);
        this.dragonPartBody.func_70071_h_();
        this.dragonPartBody.func_70012_b(this.field_70165_t, this.field_70163_u - (double)(MathHelper.func_76126_a((float)(this.animTime * ((float)Math.PI * 2) - 0.5f)) * 0.1f), this.field_70161_v, 0.0f, 0.0f);
        this.dragonPartWing1.func_70071_h_();
        this.dragonPartWing1.func_70012_b(this.field_70165_t + (double)(f3 * 4.5f), this.field_70163_u + 1.0 + (double)(MathHelper.func_76126_a((float)(this.animTime * ((float)Math.PI * 2))) * 3.0f), this.field_70161_v + (double)(f19 * 4.5f), 0.0f, 0.0f);
        this.dragonPartWing2.func_70071_h_();
        this.dragonPartWing2.func_70012_b(this.field_70165_t - (double)(f3 * 4.5f), this.field_70163_u + 1.0 + (double)(MathHelper.func_76126_a((float)(this.animTime * ((float)Math.PI * 2))) * 3.0f), this.field_70161_v - (double)(f19 * 4.5f), 0.0f, 0.0f);
        this.dragonPartNeck.func_70071_h_();
        this.dragonPartNeck.func_70012_b(this.field_70165_t + (double)(f19 * 3.5f), this.field_70163_u + 1.0 - (double)(MathHelper.func_76126_a((float)(this.animTime * ((float)Math.PI * 2) + 1.0f)) * 0.1f) + (double)(f18 * 2.0f) - (double)(this.field_70125_A / 90.0f) * Math.PI * 0.25, this.field_70161_v - (double)(f3 * 3.5f), 0.0f, 0.0f);
        this.dragonPartHead.func_70071_h_();
        this.dragonPartHead.func_70012_b(this.field_70165_t + (double)(f19 * 6.0f), this.field_70163_u + 1.0 - (double)(MathHelper.func_76126_a((float)(this.animTime * ((float)Math.PI * 2))) * 0.1f) + (double)(f18 * 4.0f) - (double)(this.field_70125_A / 90.0f) * Math.PI * 1.0, this.field_70161_v - (double)(f3 * 6.0f), 0.0f, 0.0f);
        for (int j = 0; j < 3; ++j) {
            EntityDragonPart entitydragonpart = null;
            if (j == 0) {
                entitydragonpart = this.dragonPartTail1;
            }
            if (j == 1) {
                entitydragonpart = this.dragonPartTail2;
            }
            if (j == 2) {
                entitydragonpart = this.dragonPartTail3;
            }
            adouble1 = this.getMovementOffsets(12 + j * 2, 1.0f);
            float f21 = this.field_70177_z * ((float)Math.PI / 180) + this.simplifyAngle(adouble1[0] - adouble[0]) * ((float)Math.PI / 180);
            float f22 = MathHelper.func_76126_a((float)f21);
            float f71 = MathHelper.func_76134_b((float)f21);
            float f23 = 1.5f;
            float f24 = (float)(j + 1) * 2.0f;
            entitydragonpart.func_70071_h_();
            entitydragonpart.func_70012_b(this.field_70165_t - (double)((f19 * f23 + f22 * f24) * f16), this.field_70163_u - (double)(MathHelper.func_76126_a((float)(this.animTime * ((float)Math.PI * 2) + (float)j)) * (0.2f * (float)(j + 1))) - (double)(f18 * (2.0f + (float)(1 * j))) + (double)f23, this.field_70161_v + (double)((f3 * f23 + f71 * f24) * f16), 0.0f, 0.0f);
        }
        for (int l = 0; l < this.dragonPartArray.length; ++l) {
            this.dragonPartArray[l].field_70169_q = avec3d[l].field_72450_a;
            this.dragonPartArray[l].field_70167_r = avec3d[l].field_72448_b;
            this.dragonPartArray[l].field_70166_s = avec3d[l].field_72449_c;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.collideWithEntities(this.dragonPartHead, this.field_70170_p.func_72839_b((Entity)this, this.dragonPartHead.func_174813_aQ().func_186662_g(1.0)));
            this.collideWithEntities(this.dragonPartNeck, this.field_70170_p.func_72839_b((Entity)this, this.dragonPartNeck.func_174813_aQ().func_186662_g(1.0)));
            this.collideWithEntities(this.dragonPartBody, this.field_70170_p.func_72839_b((Entity)this, this.dragonPartBody.func_174813_aQ().func_186662_g(1.0)));
            this.flingEntities(this.dragonPartWing1, this.field_70170_p.func_72839_b((Entity)this, this.dragonPartWing1.func_174813_aQ().func_186662_g(4.0).func_72317_d(0.0, -2.0, 0.0)));
            this.flingEntities(this.dragonPartWing2, this.field_70170_p.func_72839_b((Entity)this, this.dragonPartWing2.func_174813_aQ().func_186662_g(4.0).func_72317_d(0.0, -2.0, 0.0)));
            this.collideWithEntities(this.dragonPartTail1, this.field_70170_p.func_72839_b((Entity)this, this.dragonPartTail1.func_174813_aQ().func_186662_g(1.0)));
            this.collideWithEntities(this.dragonPartTail2, this.field_70170_p.func_72839_b((Entity)this, this.dragonPartTail2.func_174813_aQ().func_186662_g(1.0)));
            this.collideWithEntities(this.dragonPartTail3, this.field_70170_p.func_72839_b((Entity)this, this.dragonPartTail3.func_174813_aQ().func_186662_g(1.0)));
            this.attackEntitiesInList(this.field_70170_p.func_72839_b((Entity)this, this.dragonPartHead.func_174813_aQ().func_186662_g(3.0)));
            this.attackEntitiesInList(this.field_70170_p.func_72839_b((Entity)this, this.dragonPartNeck.func_174813_aQ().func_186662_g(2.0)));
        }
        this.destroyBlocksInAABB(this.dragonPartHead.func_174813_aQ());
        this.destroyBlocksInAABB(this.dragonPartNeck.func_174813_aQ());
        this.destroyBlocksInAABB(this.dragonPartBody.func_174813_aQ());
        this.destroyBlocksInAABB(this.dragonPartWing1.func_174813_aQ());
        this.destroyBlocksInAABB(this.dragonPartWing2.func_174813_aQ());
        this.destroyBlocksInAABB(this.dragonPartTail1.func_174813_aQ());
        this.destroyBlocksInAABB(this.dragonPartTail2.func_174813_aQ());
        this.destroyBlocksInAABB(this.dragonPartTail3.func_174813_aQ());
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && this.func_110143_aJ() < this.func_110138_aP() && this.field_70737_aN <= 5) {
            this.func_70691_i(this.func_70638_az() != null || this.func_70644_a(MobEffects.field_76438_s) ? 0.02f : 0.1f);
        }
        if (!this.isWild() && this.func_70068_e((Entity)this.getOwner()) >= 48400.0) {
            this.behaviour = EnumBehaviour.GUARDING;
            this.func_70012_b(this.getOwner().field_70165_t, this.getOwner().field_70163_u, this.getOwner().field_70161_v, this.field_70177_z, this.field_70125_A);
        }
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null && this.func_70638_az().func_70089_S() && this.func_70638_az().func_70685_l((Entity)this) && this.field_70146_Z.nextInt(40) == 0) {
            List entities = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_70638_az().func_174813_aQ().func_186662_g(3.0));
            for (EntityLivingBase entityLivingBase : entities) {
                if (this.isOnSameTeam(entityLivingBase)) continue;
                this.fireLightning((Entity)entityLivingBase, this.dragonPartHead.field_70165_t, this.dragonPartHead.field_70163_u + 0.25, this.dragonPartHead.field_70161_v);
            }
        }
        if (this.func_184207_aI() && this.func_184179_bs() != null && this.func_184179_bs() instanceof EntityPlayer) {
            EntityPlayer passenger = (EntityPlayer)this.func_184179_bs();
            passenger.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 40, 4));
            this.field_70761_aq = this.field_70177_z = passenger.field_70759_as + 180.0f;
            this.field_70125_A = 0.0f;
            for (int i = 0; i < 256; ++i) {
                double d1 = 0.0075;
                if (this.moralRaisedTimer > 200) {
                    d1 *= 2.0;
                }
                if (this.func_70051_ag()) {
                    d1 *= 2.0;
                }
                Vec3d vec3 = passenger.func_70676_i(1.0f);
                if (passenger.field_70701_bs > 0.0f) {
                    this.func_70107_b(this.field_70165_t + vec3.field_72450_a * d1, this.field_70163_u + vec3.field_72448_b * d1, this.field_70161_v + vec3.field_72449_c * d1);
                    Entity[] aentity = this.func_70021_al();
                    if (aentity != null) {
                        for (Entity entity : aentity) {
                            entity.func_70012_b(entity.field_70165_t + vec3.field_72450_a * d1, entity.field_70163_u + vec3.field_72448_b * d1, entity.field_70161_v + vec3.field_72449_c * d1, 0.0f, 0.0f);
                        }
                    }
                }
                if (!(passenger.field_70701_bs < 0.0f)) continue;
                this.func_70107_b(this.field_70165_t - vec3.field_72450_a * d1, this.field_70163_u - vec3.field_72448_b * d1, this.field_70161_v - vec3.field_72449_c * d1);
            }
        }
        if (!this.isWild() && this.getOwner().func_70051_ag()) {
            this.func_70031_b(true);
        } else {
            this.func_70031_b(false);
        }
        if (!this.isWild() && this.getOwner().func_70093_af()) {
            this.func_70095_a(true);
        } else {
            this.func_70095_a(false);
        }
        this.bossInfo.func_186739_a(this.func_145748_c_());
        if (this.func_70093_af()) {
            this.bossInfo.func_186758_d(false);
        } else if (this.func_70089_S()) {
            this.bossInfo.func_186758_d(true);
        }
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        if ((double)this.func_110143_aJ() > (double)this.func_110138_aP() * 0.75 && this.bossInfo.func_186736_g() != BossInfo.Color.RED) {
            this.bossInfo.func_186745_a(BossInfo.Color.RED);
        }
        if ((double)this.func_110143_aJ() < (double)this.func_110138_aP() * 0.75 && this.func_110143_aJ() > this.func_110138_aP() / 2.0f && this.bossInfo.func_186736_g() != BossInfo.Color.PURPLE) {
            this.bossInfo.func_186745_a(BossInfo.Color.PURPLE);
        }
        if (this.func_110143_aJ() < this.func_110138_aP() / 2.0f && this.func_110143_aJ() > this.func_110138_aP() / 4.0f && this.bossInfo.func_186736_g() != BossInfo.Color.PINK) {
            this.bossInfo.func_186745_a(BossInfo.Color.PINK);
        }
        if (this.func_110143_aJ() < this.func_110138_aP() / 4.0f && this.func_110143_aJ() > 0.0f && this.bossInfo.func_186736_g() != BossInfo.Color.WHITE) {
            this.bossInfo.func_186745_a(BossInfo.Color.WHITE);
        }
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null && this.func_70638_az().func_70089_S() && this.func_70638_az().func_70685_l((Entity)this) && this.field_70146_Z.nextInt(120) == 0) {
            switch (this.field_70146_Z.nextInt(4)) {
                case 0: {
                    EntityGuardianProjectile projectile = new EntityGuardianProjectile(this.field_70170_p, 1, this.func_70638_az(), 5.0f + this.field_70146_Z.nextFloat() * 8.0f, (Entity)this);
                    projectile.func_70107_b(this.dragonPartHead.field_70165_t, this.dragonPartHead.field_70163_u, this.dragonPartHead.field_70161_v);
                    projectile.shooter = this;
                    projectile.target = this.func_70638_az();
                    this.field_70170_p.func_72838_d((Entity)projectile);
                    double distance = Utils.getDistanceAtoB((double)this.func_70638_az().field_70165_t, (double)this.func_70638_az().field_70161_v, (double)this.dragonPartHead.field_70165_t, (double)this.dragonPartHead.field_70161_v);
                    this.field_70125_A = (float)Math.toDegrees(Math.atan2(this.func_70638_az().field_70163_u - this.dragonPartHead.field_70163_u, distance)) * -1.0f;
                    break;
                }
                case 1: {
                    EntityGuardianProjectile projectile = new EntityGuardianProjectile(this.field_70170_p, 3, this.func_70638_az(), 5.0f + this.field_70146_Z.nextFloat() * 2.0f, (Entity)this);
                    projectile.func_70107_b(this.dragonPartHead.field_70165_t, this.dragonPartHead.field_70163_u, this.dragonPartHead.field_70161_v);
                    projectile.shooter = this;
                    projectile.target = this.func_70638_az();
                    this.field_70170_p.func_72838_d((Entity)projectile);
                    break;
                }
                case 2: {
                    EntityGuardianProjectile projectile = new EntityGuardianProjectile(this.field_70170_p, 4, this.func_70638_az(), 5.0f + this.field_70146_Z.nextFloat() * 10.0f, (Entity)this);
                    projectile.func_70107_b(this.dragonPartHead.field_70165_t, this.dragonPartHead.field_70163_u, this.dragonPartHead.field_70161_v);
                    projectile.shooter = this;
                    projectile.target = this.func_70638_az();
                    this.field_70170_p.func_72838_d((Entity)projectile);
                    break;
                }
                case 3: {
                    EntityGuardianProjectile projectile = new EntityGuardianProjectile(this.field_70170_p, 5, this.func_70638_az(), 5.0f + this.field_70146_Z.nextFloat() * 10.0f, (Entity)this);
                    projectile.func_70107_b(this.dragonPartHead.field_70165_t, this.dragonPartHead.field_70163_u, this.dragonPartHead.field_70161_v);
                    projectile.shooter = this;
                    projectile.target = this.func_70638_az();
                    this.field_70170_p.func_72838_d((Entity)projectile);
                    break;
                }
            }
        }
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null && this.func_70638_az().func_70089_S() && this.field_70146_Z.nextInt(200) == 0 && (double)this.func_70032_d((Entity)this.func_70638_az()) >= 100.0) {
            this.behaviour = EnumBehaviour.CHARGING;
            this.targetX = this.func_70638_az().field_70165_t;
            this.targetY = this.func_70638_az().field_70163_u;
            this.targetZ = this.func_70638_az().field_70161_v;
        }
        if (this.attackInProgress != -1 && this.nextAttackTimer <= 0) {
            this.attackInProgress = -1;
        }
    }

    private void customAIUpdate() {
        if (this.func_110143_aJ() > 0.0f && this.func_110143_aJ() < this.func_110138_aP() * 0.2f) {
            this.behaviour = EnumBehaviour.LOW_HEALTH_STRATEGY;
        }
        switch (this.behaviour) {
            case ROAMING: {
                if (!(Utils.getDistanceAtoB((double)this.field_70165_t, (double)this.field_70161_v, (double)this.homeX, (double)this.homeZ) < 200.0)) break;
                this.selectNewBehaviour();
                break;
            }
            case GO_HOME: {
                if (!(Utils.getDistanceAtoB((double)this.field_70165_t, (double)this.field_70161_v, (double)this.homeX, (double)this.homeZ) < 70.0)) break;
                this.selectNewBehaviour();
                break;
            }
            case GUARDING: {
                break;
            }
            case CHARGING: {
                if (!(Utils.getDistanceAtoB((double)this.field_70165_t, (double)this.field_70161_v, (double)this.homeX, (double)this.homeZ) > 300.0)) break;
                this.behaviour = EnumBehaviour.GO_HOME;
                break;
            }
            case CIRCLE_PLAYER: {
                this.circlePosition += 0.02f * this.circleDirection;
                if (!(Utils.getDistanceAtoB((double)this.field_70165_t, (double)this.field_70161_v, (double)this.homeX, (double)this.homeZ) > 300.0) && !(this.field_70163_u > 250.0)) break;
                this.behaviour = EnumBehaviour.GO_HOME;
                break;
            }
            case LOW_HEALTH_STRATEGY: {
                if (this.func_70638_az() == null || !(this.func_70068_e((Entity)this.func_70638_az()) < 60.0) || this.attackInProgress == 4) break;
                for (int escape = 0; escape < 50; ++escape) {
                    this.targetX = (double)this.homeX + (this.field_70146_Z.nextDouble() - 0.5) * 220.0;
                    this.targetY = (double)(this.homeY + 30) + this.field_70146_Z.nextDouble() * 20.0;
                    this.targetZ = (double)this.homeZ + (this.field_70146_Z.nextDouble() - 0.5) * 220.0;
                }
                this.func_70624_b(null);
                break;
            }
            default: {
                this.func_70624_b(null);
                this.targetX = this.homeX;
                this.targetY = this.homeY;
                this.targetZ = this.homeZ;
            }
        }
        if (this.behaviour == EnumBehaviour.DEAD) {
            return;
        }
        if (this.field_70173_aa % 1000 == 0 && this.field_70146_Z.nextBoolean()) {
            this.ignitionChargeTimer = 0;
        }
        if (this.field_70173_aa % (this.behaviour == EnumBehaviour.LOW_HEALTH_STRATEGY ? 1000 : 2000) == 0) {
            this.selectNewBehaviour();
        }
        if (this.ignitionChargeTimer > 1 || this.ignitionChargeTimer == 1 && this.field_70173_aa % 20 == 0) {
            --this.ignitionChargeTimer;
        }
        if (this.ignitionChargeTimer <= 0 && !this.field_70170_p.field_72995_K && (this.field_70173_aa - 19) % 20 == 0) {
            this.ignitionChargeTimer = (this.behaviour == EnumBehaviour.LOW_HEALTH_STRATEGY ? 1000 : 2000) + this.field_70146_Z.nextInt(600);
        }
        this.updateAttack();
    }

    private void updateAttack() {
        if (this.field_70170_p.field_72995_K || this.behaviour == EnumBehaviour.DEAD) {
            return;
        }
        if (this.behaviour == EnumBehaviour.FIREBOMB && Utils.getDistanceAtoB((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)this.homeX, (double)(this.homeY + 30), (double)this.homeZ) <= 3.0) {
            if (this.func_70638_az() == null || this.field_70173_aa % 100 == 0) {
                this.setNewTarget();
            }
            if (this.func_70638_az() != null) {
                double distance = Utils.getDistanceAtoB((double)this.func_70638_az().field_70165_t, (double)this.func_70638_az().field_70161_v, (double)this.dragonPartHead.field_70165_t, (double)this.dragonPartHead.field_70161_v);
                if (Utils.getDistanceAtoB((double)this.func_70638_az().field_70165_t, (double)this.func_70638_az().field_70161_v, (double)this.field_70165_t, (double)this.field_70161_v) < 5.0) {
                    distance *= -1.0;
                }
                float anglePitch = (float)Math.toDegrees(Math.atan2(this.func_70638_az().field_70163_u - this.dragonPartHead.field_70163_u, distance)) * -1.0f;
                float angleYaw = (float)Math.toDegrees(Math.atan2(this.func_70638_az().field_70165_t - this.dragonPartHead.field_70165_t, this.func_70638_az().field_70161_v - this.field_70161_v)) * -1.0f;
                this.field_70125_A = anglePitch;
                if (Utils.getDistanceAtoB((double)this.func_70638_az().field_70165_t, (double)this.func_70638_az().field_70161_v, (double)this.field_70165_t, (double)this.field_70161_v) > 8.0) {
                    this.field_70177_z = angleYaw + 180.0f;
                }
                if (this.field_70173_aa % 2 == 0) {
                    EntityGuardianProjectile projectile = new EntityGuardianProjectile(this.field_70170_p, 1, this.func_70638_az(), 5.0f + this.field_70146_Z.nextFloat() * 8.0f, (Entity)this);
                    projectile.func_70107_b(this.dragonPartHead.field_70165_t + Math.cos((this.field_70177_z - 90.0f) / 180.0f * (float)Math.PI) * 2.0, this.dragonPartHead.field_70163_u + 1.5, this.dragonPartHead.field_70161_v + Math.sin((this.field_70177_z - 90.0f) / 180.0f * (float)Math.PI) * 2.0);
                    this.field_70170_p.func_72838_d((Entity)projectile);
                }
            }
        } else if (this.nextAttackTimer > 0 && this.func_70638_az() != null) {
            --this.nextAttackTimer;
        } else if (this.nextAttackTimer == 0) {
            if (this.attackInProgress == -1) {
                this.selectNewAttack();
                switch (this.attackInProgress) {
                    case 0: {
                        this.attackTimer = 100 + this.field_70146_Z.nextInt(100);
                        this.previousBehaviour = this.behaviour;
                        this.behaviour = EnumBehaviour.CHARGING;
                        break;
                    }
                    case 1: {
                        this.attackTimer = 60 + this.field_70146_Z.nextInt(60);
                        break;
                    }
                    case 2: {
                        this.attackTimer = 60 + this.field_70146_Z.nextInt(60);
                        break;
                    }
                    case 3: {
                        this.attackTimer = 60 + this.field_70146_Z.nextInt(60);
                        break;
                    }
                    case 4: {
                        this.attackTimer = 10 + this.field_70146_Z.nextInt(10);
                        break;
                    }
                    case 5: {
                        this.attackTimer = 120 + this.field_70146_Z.nextInt(60);
                        break;
                    }
                    case 6: {
                        this.attackTimer = 120 + this.field_70146_Z.nextInt(60);
                        break;
                    }
                    case 7: {
                        this.attackTimer = 80 + this.field_70146_Z.nextInt(40);
                        break;
                    }
                    case 8: {
                        this.attackTimer = 80;
                        this.previousBehaviour = this.behaviour;
                        this.behaviour = EnumBehaviour.CHARGING;
                    }
                }
            }
            switch (this.attackInProgress) {
                case 0: {
                    if (this.func_70638_az() != null && Utils.getDistanceAtoB((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)this.func_70638_az().field_70165_t, (double)this.func_70638_az().field_70163_u, (double)this.func_70638_az().field_70161_v) > 10.0) {
                        if (this.attackTimer % 2 == 0) {
                            EntityGuardianProjectile projectile = new EntityGuardianProjectile(this.field_70170_p, 1, this.func_70638_az(), 5.0f + this.field_70146_Z.nextFloat() * 8.0f, (Entity)this);
                            projectile.func_70107_b(this.dragonPartHead.field_70165_t, this.dragonPartHead.field_70163_u, this.dragonPartHead.field_70161_v);
                            projectile.shooter = this;
                            projectile.target = this.func_70638_az();
                            this.field_70170_p.func_72838_d((Entity)projectile);
                        }
                        double distance = Utils.getDistanceAtoB((double)this.func_70638_az().field_70165_t, (double)this.func_70638_az().field_70161_v, (double)this.dragonPartHead.field_70165_t, (double)this.dragonPartHead.field_70161_v);
                        this.field_70125_A = (float)Math.toDegrees(Math.atan2(this.func_70638_az().field_70163_u - this.dragonPartHead.field_70163_u, distance)) * -1.0f;
                        break;
                    }
                    this.attackTimer = 0;
                    break;
                }
                case 1: {
                    if (this.func_70638_az() == null || this.attackTimer % 10 != 0) break;
                    EntityGuardianProjectile projectile = new EntityGuardianProjectile(this.field_70170_p, 3, this.func_70638_az(), 5.0f + this.field_70146_Z.nextFloat() * 2.0f, (Entity)this);
                    projectile.func_70107_b(this.dragonPartHead.field_70165_t, this.dragonPartHead.field_70163_u, this.dragonPartHead.field_70161_v);
                    projectile.shooter = this;
                    projectile.target = this.func_70638_az();
                    this.field_70170_p.func_72838_d((Entity)projectile);
                    break;
                }
                case 2: {
                    if (this.func_70638_az() == null || this.attackTimer % 10 != 0) break;
                    EntityGuardianProjectile projectile = new EntityGuardianProjectile(this.field_70170_p, 4, this.func_70638_az(), 5.0f + this.field_70146_Z.nextFloat() * 10.0f, (Entity)this);
                    projectile.func_70107_b(this.dragonPartHead.field_70165_t, this.dragonPartHead.field_70163_u, this.dragonPartHead.field_70161_v);
                    projectile.shooter = this;
                    projectile.target = this.func_70638_az();
                    this.field_70170_p.func_72838_d((Entity)projectile);
                    break;
                }
                case 3: {
                    if (this.func_70638_az() == null || this.attackTimer % 10 != 0) break;
                    EntityGuardianProjectile projectile = new EntityGuardianProjectile(this.field_70170_p, 5, this.func_70638_az(), 5.0f + this.field_70146_Z.nextFloat() * 10.0f, (Entity)this);
                    projectile.func_70107_b(this.dragonPartHead.field_70165_t, this.dragonPartHead.field_70163_u, this.dragonPartHead.field_70161_v);
                    projectile.shooter = this;
                    projectile.target = this.func_70638_az();
                    this.field_70170_p.func_72838_d((Entity)projectile);
                    break;
                }
                case 4: {
                    if (this.func_70638_az() == null) {
                        this.attackInProgress = -1;
                        return;
                    }
                    if (this.func_70638_az() != null && Utils.getDistanceAtoB((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)this.func_70638_az().field_70165_t, (double)this.func_70638_az().field_70163_u, (double)this.func_70638_az().field_70161_v) > 15.0) {
                        if (this.attackTimer % 2 == 0) {
                            EntityGuardianProjectile projectile = new EntityGuardianProjectile(this.field_70170_p, 2, this.func_70638_az(), 5.0f + this.field_70146_Z.nextFloat() * 8.0f, (Entity)this);
                            projectile.func_70107_b(this.dragonPartHead.field_70165_t, this.dragonPartHead.field_70163_u, this.dragonPartHead.field_70161_v);
                            projectile.shooter = this;
                            projectile.target = this.func_70638_az();
                            this.field_70170_p.func_72838_d((Entity)projectile);
                        }
                        double distance = Utils.getDistanceAtoB((double)this.func_70638_az().field_70165_t, (double)this.func_70638_az().field_70161_v, (double)this.dragonPartHead.field_70165_t, (double)this.dragonPartHead.field_70161_v);
                        this.field_70125_A = (float)Math.toDegrees(Math.atan2(this.func_70638_az().field_70163_u - this.dragonPartHead.field_70163_u, distance)) * -1.0f;
                        break;
                    }
                    this.attackTimer = 0;
                    break;
                }
                case 5: {
                    if (this.func_70638_az() == null || this.attackTimer % 20 != 0) break;
                    List entities = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_70638_az().func_174813_aQ().func_186662_g(3.0));
                    for (EntityLivingBase entityLivingBase : entities) {
                        if (this.isOnSameTeam(entityLivingBase)) continue;
                        this.fireLightning((Entity)entityLivingBase, this.dragonPartHead.field_70165_t, this.dragonPartHead.field_70163_u + 0.25, this.dragonPartHead.field_70161_v);
                    }
                    break;
                }
                case 6: {
                    if (this.func_70638_az() == null || !(Utils.getDistanceAtoB((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)this.func_70638_az().field_70165_t, (double)this.func_70638_az().field_70163_u, (double)this.func_70638_az().field_70161_v) > 15.0) || this.attackTimer % 5 != 0) break;
                    double d6 = this.dragonPartHead.field_70165_t;
                    double d7 = this.dragonPartHead.field_70163_u + 0.5;
                    double d8 = this.dragonPartHead.field_70161_v;
                    double d9 = this.func_70638_az().field_70165_t - d6;
                    double d10 = this.func_70638_az().field_70163_u + 1.0 - d7;
                    double d11 = this.func_70638_az().field_70161_v - d8;
                    this.field_70170_p.func_180498_a((EntityPlayer)null, 1016, new BlockPos((Entity)this), 0);
                    EntityDragonFireballOther entitydragonfireball = new EntityDragonFireballOther(this.field_70170_p, (EntityLivingBase)this, d9, d10, d11);
                    entitydragonfireball.field_70165_t = d6;
                    entitydragonfireball.field_70163_u = d7;
                    entitydragonfireball.field_70161_v = d8;
                    this.field_70170_p.func_72838_d((Entity)entitydragonfireball);
                    break;
                }
                case 7: {
                    if (this.func_70638_az() == null || this.attackTimer % 2 != 0) break;
                    EntityGuardianProjectile projectile = new EntityGuardianProjectile(this.field_70170_p, 1 + this.field_70146_Z.nextInt(5), this.func_70638_az(), 5.0f + this.field_70146_Z.nextFloat() * 10.0f, (Entity)this);
                    projectile.func_70107_b(this.dragonPartHead.field_70165_t, this.dragonPartHead.field_70163_u, this.dragonPartHead.field_70161_v);
                    projectile.shooter = this;
                    projectile.target = this.func_70638_az();
                    this.field_70170_p.func_72838_d((Entity)projectile);
                    break;
                }
                case 8: {
                    if (this.func_70638_az() == null || !(Utils.getDistanceAtoB((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)this.func_70638_az().field_70165_t, (double)this.func_70638_az().field_70163_u, (double)this.func_70638_az().field_70161_v) > 10.0)) break;
                    this.animTime += 0.25f;
                    if (this.attackTimer % 20 == 0) {
                        this.func_184185_a(SoundEvents.field_187524_aN, this.func_70599_aP(), this.func_70647_i() - 0.25f);
                        List entities = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ().func_186662_g(16.0));
                        for (EntityLivingBase entityLivingBase : entities) {
                            if (this.isOnSameTeam(entityLivingBase)) continue;
                            double d0 = entityLivingBase.field_70165_t - this.field_70165_t;
                            double d1 = entityLivingBase.field_70161_v - this.field_70161_v;
                            double d2 = MathHelper.func_76132_a((double)d0, (double)d1);
                            d2 = MathHelper.func_76133_a((double)d2);
                            d0 /= d2;
                            d1 /= d2;
                            double d3 = 1.0 / d2;
                            if (d3 > 1.0) {
                                d3 = 1.0;
                            }
                            d0 *= d3;
                            d1 *= d3;
                            d0 *= 1.750000000745058;
                            d1 *= 1.750000000745058;
                            if (entityLivingBase.func_184207_aI()) continue;
                            entityLivingBase.func_70024_g(d0, 1.0, d1);
                        }
                    }
                    double distance = Utils.getDistanceAtoB((double)this.func_70638_az().field_70165_t, (double)this.func_70638_az().field_70161_v, (double)this.dragonPartHead.field_70165_t, (double)this.dragonPartHead.field_70161_v);
                    this.field_70125_A = (float)Math.toDegrees(Math.atan2(this.func_70638_az().field_70163_u - this.dragonPartHead.field_70163_u, distance)) * -1.0f;
                }
            }
            --this.attackTimer;
            if (this.attackTimer <= -1) {
                if (this.attackInProgress == 0) {
                    this.behaviour = this.previousBehaviour;
                }
                this.attackInProgress = -1;
                this.nextAttackTimer = -1;
            }
        } else {
            this.nextAttackTimer = this.behaviour == EnumBehaviour.LOW_HEALTH_STRATEGY ? 10 + this.field_70146_Z.nextInt(50) : 200 + this.field_70146_Z.nextInt(400);
        }
    }

    private void selectNewAttack() {
        if (this.behaviour == EnumBehaviour.DEAD) {
            return;
        }
        this.attackInProgress = this.behaviour == EnumBehaviour.LOW_HEALTH_STRATEGY ? ((WeightedAttack)WeightedRandom.func_76271_a((Random)this.field_70146_Z, EntityChaosGuardian.weightedLowHealthAttaxks)).attack : (this.behaviour != EnumBehaviour.FIREBOMB ? ((WeightedAttack)WeightedRandom.func_76271_a((Random)this.field_70146_Z, EntityChaosGuardian.weightedAttacks)).attack : 2);
    }

    private void selectNewBehaviour() {
        if (this.field_70170_p.field_72995_K || this.behaviour == EnumBehaviour.DEAD) {
            return;
        }
        EnumBehaviour newBehaviour = this.behaviour;
        while (newBehaviour == this.behaviour) {
            newBehaviour = ((WeightedBehaviour)WeightedRandom.func_76271_a((Random)this.field_70146_Z, EntityChaosGuardian.weightedBehaviours)).randomBehaviour;
        }
        this.previousBehaviour = this.behaviour = newBehaviour;
    }

    private void updateTarget() {
        switch (this.behaviour) {
            case ROAMING: {
                break;
            }
            case GO_HOME: {
                break;
            }
            case GUARDING: {
                break;
            }
            case CHARGING: {
                break;
            }
            case FIREBOMB: {
                if (!(Utils.getDistanceAtoB((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)this.homeX, (double)(this.homeY + 30), (double)this.homeZ) > 3.0)) break;
                this.targetX = this.homeX;
                this.targetY = this.homeY + 30;
                this.targetZ = this.homeZ;
                break;
            }
            case CIRCLE_PLAYER: {
                break;
            }
            case LOW_HEALTH_STRATEGY: {
                break;
            }
            case DEAD: {
                this.targetX = this.homeX;
                this.targetY = this.homeY;
                this.targetZ = this.homeZ;
                this.func_70624_b(null);
            }
        }
    }

    private void setNewTarget() {
        if (this.behaviour == EnumBehaviour.DEAD) {
            return;
        }
        this.forceNewTarget = false;
        switch (this.behaviour) {
            case ROAMING: {
                this.targetX = (float)this.homeX + this.field_70146_Z.nextFloat() * 120.0f - 60.0f;
                this.targetY = (double)(this.homeY + 60) + this.field_70146_Z.nextDouble() * 40.0;
                this.targetZ = (float)this.homeZ + this.field_70146_Z.nextFloat() * 120.0f - 60.0f;
                break;
            }
            case GO_HOME: {
                this.targetX = this.homeX;
                this.targetY = (double)(this.homeY + 30) + this.field_70146_Z.nextDouble() * 30.0;
                this.targetZ = this.homeZ;
            }
            case GUARDING: {
                this.targetX = this.homeX;
                this.targetY = (double)(this.homeY + 5) + this.field_70146_Z.nextDouble() * 5.0;
                this.targetZ = this.homeZ;
                this.func_70624_b(null);
                break;
            }
            case CHARGING: {
                if (this.func_70638_az() != null) {
                    this.targetX = this.func_70638_az().field_70165_t + (double)(this.field_70146_Z.nextFloat() * 60.0f) - 30.0;
                    this.targetY = this.func_70638_az().field_70163_u + 10.0 + this.field_70146_Z.nextDouble() * 10.0;
                    this.targetZ = this.func_70638_az().field_70161_v + (double)(this.field_70146_Z.nextFloat() * 60.0f) - 30.0;
                }
            }
            case CIRCLE_PLAYER: {
                if (this.func_70638_az() == null) break;
                this.targetX = this.func_70638_az().field_70165_t + (double)(this.field_70146_Z.nextFloat() * 120.0f) - 60.0;
                this.targetY = this.func_70638_az().field_70163_u + 30.0 + this.field_70146_Z.nextDouble() * 30.0;
                this.targetZ = this.func_70638_az().field_70161_v + (double)(this.field_70146_Z.nextFloat() * 120.0f) - 60.0;
                break;
            }
            case LOW_HEALTH_STRATEGY: {
                this.targetX = (float)this.homeX + this.field_70146_Z.nextFloat() * 60.0f - 30.0f;
                this.targetY = (double)(this.homeY + 30) + this.field_70146_Z.nextDouble() * 20.0;
                this.targetZ = (float)this.homeZ + this.field_70146_Z.nextFloat() * 60.0f - 30.0f;
                break;
            }
            case FIREBOMB: {
                if (this.func_70638_az() == null) break;
                this.targetX = this.func_70638_az().field_70165_t + (double)(this.field_70146_Z.nextFloat() * 120.0f) - 60.0;
                this.targetY = this.func_70638_az().field_70163_u + 20.0 + this.field_70146_Z.nextDouble() * 20.0;
                this.targetZ = this.func_70638_az().field_70161_v + (double)(this.field_70146_Z.nextFloat() * 120.0f) - 60.0;
                break;
            }
            case DEAD: {
                this.targetX = this.homeX;
                this.targetY = this.homeY;
                this.targetZ = this.homeZ;
            }
        }
    }

    @Override
    public boolean func_70965_a(EntityDragonPart part, DamageSource damageSource, float dmg) {
        if (this.behaviour == EnumBehaviour.DEAD) {
            return false;
        }
        if (damageSource.func_76355_l() == "chaosImplosion" || damageSource.func_76355_l() == "de.GuardianFireball" || damageSource.func_76355_l() == "de.GuardianEnergyBall" || damageSource.func_76355_l() == "de.GuardianChaosBall") {
            dmg *= 0.15f;
        }
        switch (this.behaviour) {
            case ROAMING: {
                break;
            }
            case GO_HOME: {
                break;
            }
            case GUARDING: {
                if (this.field_70146_Z.nextInt(5) != 0) break;
                this.selectNewBehaviour();
                break;
            }
            case CHARGING: {
                if (this.field_70146_Z.nextInt(6) != 0) break;
                this.selectNewBehaviour();
                break;
            }
            case CIRCLE_PLAYER: {
                if (this.field_70146_Z.nextInt(6) == 0) {
                    this.selectNewBehaviour();
                    break;
                }
                if (this.field_70146_Z.nextInt(4) != 0) break;
                this.circleDirection *= -1.0f;
                break;
            }
            case LOW_HEALTH_STRATEGY: {
                if (this.field_70146_Z.nextInt(6) == 0 && this.func_110143_aJ() >= this.func_110138_aP() * 0.2f) {
                    this.selectNewBehaviour();
                }
                if (this.attackInProgress == 4) break;
                boolean flag = false;
                for (int escape = 0; escape < 50; ++escape) {
                    this.targetX = (double)this.homeX + (this.field_70146_Z.nextDouble() - 0.5) * 260.0;
                    this.targetY = (double)(this.homeY + 20) + (this.field_70146_Z.nextDouble() - 0.5) * 50.0;
                    this.targetZ = (double)this.homeZ + (this.field_70146_Z.nextDouble() - 0.5) * 260.0;
                }
                this.func_70624_b(null);
                break;
            }
            case FIREBOMB: {
                if (this.func_70638_az() == null && Utils.getDistanceAtoB((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)this.homeX, (double)(this.homeY + 30), (double)this.homeZ) <= 3.0 || this.field_70146_Z.nextInt(5) == 0) {
                    this.selectNewBehaviour();
                }
                if (!(damageSource.func_76346_g() instanceof EntityLivingBase) || damageSource.func_76346_g() == this.func_70638_az() || this.field_70170_p.func_72933_a(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v), new Vec3d(damageSource.func_76346_g().field_70165_t, damageSource.func_76346_g().field_70163_u, damageSource.func_76346_g().field_70161_v)) != null) break;
                this.func_70624_b((EntityLivingBase)damageSource.func_76346_g());
                break;
            }
        }
        return super.func_70965_a(part, damageSource, dmg);
    }

    public void setToGuard() {
        this.behaviour = EnumBehaviour.GUARDING;
    }

    @Override
    protected void func_70609_aI() {
        if (!this.isWild()) {
            this.homeX = (int)this.getOwner().field_70165_t;
            this.homeY = (int)this.getOwner().field_70163_u + 5;
            this.homeZ = (int)this.getOwner().field_70161_v;
        }
        double d0 = (double)this.homeX - this.field_70165_t;
        double d1 = (double)this.homeY - this.field_70163_u;
        double d2 = (double)this.homeZ - this.field_70161_v;
        double d3 = d0 * d0 + d2 * d2;
        if (this.field_70173_aa > 20) {
            if (d3 > 1.0 && this.deathTicks < 1) {
                double d5 = MathHelper.func_76133_a((double)d3);
                this.field_70177_z = this.field_70759_as = (float)Math.atan2(this.field_70179_y, this.field_70159_w) * 57.295776f - 90.0f + 180.0f;
                this.field_70761_aq = this.field_70759_as;
                this.field_70159_w += d0 / d5 * 0.75 - this.field_70159_w;
                this.field_70181_x += d1 / d5 * 0.75 - this.field_70181_x;
                this.field_70179_y += d2 / d5 * 0.75 - this.field_70179_y;
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            } else {
                this.func_70091_d(MoverType.SELF, 0.0, 0.1f, 0.0);
                this.field_70759_as = this.field_70177_z += 10.0f;
                this.field_70761_aq = this.field_70177_z;
                ++this.deathTicks;
            }
        }
        if (this.deathTicks >= 180 && this.deathTicks <= 200) {
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 4.0f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, this.field_70165_t + (double)f, this.field_70163_u + 2.0 + (double)f1, this.field_70161_v + (double)f2, 0.0, 0.0, 0.0, new int[0]);
        }
        if (!this.field_70170_p.field_72995_K && this.deathTicks == 1) {
            if (Loader.isModLoaded((String)"draconicevolution")) {
                Entity var8 = EntityList.func_188429_b((ResourceLocation)new ResourceLocation("draconicevolution:dragonheartitem"), (World)this.field_70170_p);
                this.field_70170_p.func_72838_d(var8);
            }
            if (Loader.isModLoaded((String)"draconicevolution")) {
                Entity var8 = EntityList.func_188429_b((ResourceLocation)new ResourceLocation("draconicevolution:dragonheartitem"), (World)this.field_70170_p);
                this.field_70170_p.func_72838_d(var8);
            }
            this.field_70170_p.func_175669_a(1028, new BlockPos((Entity)this), 0);
            if (this.getOwner() != null) {
                for (EntityPlayer entityplayer : this.field_70170_p.field_73010_i) {
                    this.field_70170_p.func_184133_a(null, entityplayer.func_180425_c(), SoundEvents.field_187522_aL, this.func_184176_by(), this.func_70599_aP(), 1.0f);
                    entityplayer.func_146105_b((ITextComponent)new TextComponentTranslation("\u00a74" + this.getOwner().func_70005_c_() + "'s " + this.func_70005_c_() + " has been killed!!!", new Object[0]), true);
                }
                ((EntityPlayerMP)this.getOwner()).func_145747_a((ITextComponent)new TextComponentTranslation("Your Chaos Guardian has fallen in battle.", new Object[0]));
            }
        }
        if (this.deathTicks >= 180 && this.deathTicks <= 200) {
            EntityLightningBolt bolt = new EntityLightningBolt(this.field_70170_p, (double)this.homeX, (double)(this.homeY + 1), (double)this.homeZ, true);
            bolt.field_70158_ak = true;
            this.field_70170_p.func_72942_c((Entity)bolt);
        }
        if (this.deathTicks == 200 && !this.field_70170_p.field_72995_K) {
            int j;
            for (int i = 200000; i > 0; i -= j) {
                j = EntityXPOrb.func_70527_a((int)i);
                this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
            }
            this.func_184185_a(ModSoundEvents.blast, 100.0f, 0.75f);
            this.func_70106_y();
            List entities = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ().func_186662_g(200.0));
            for (EntityLivingBase entity : entities) {
                if (entity.func_180427_aV() || this.isOnSameTeam(entity)) continue;
                entity.func_70097_a(new EntityDamageSource("explosion.player", (Entity)this).func_94540_d().func_76348_h().func_151518_m(), 10000.0f);
            }
        }
    }

    private float simplifyAngle(double par1) {
        return (float)MathHelper.func_76138_g((double)par1);
    }

    public NBTTagCompound func_189511_e(NBTTagCompound compound) {
        super.func_189511_e(compound);
        compound.func_74768_a("HomeXCoord", this.homeX);
        compound.func_74768_a("HomeYCoord", this.homeY);
        compound.func_74768_a("HomeZCoord", this.homeZ);
        compound.func_74778_a("Behaviour", this.behaviour.name());
        compound.func_74757_a("HomeSet", this.homeSet);
        int chunkX = MathHelper.func_76128_c((double)(this.field_70165_t / 16.0));
        int chunkZ = MathHelper.func_76128_c((double)(this.field_70161_v / 16.0));
        return compound;
    }

    public void func_70020_e(NBTTagCompound compound) {
        super.func_70020_e(compound);
        this.homeX = compound.func_74762_e("HomeXCoord");
        this.homeY = compound.func_74762_e("HomeYCoord");
        this.homeZ = compound.func_74762_e("HomeZCoord");
        if (compound.func_74764_b("Behaviour")) {
            this.behaviour = EnumBehaviour.valueOf(compound.func_74779_i("Behaviour"));
        }
        this.homeSet = compound.func_74767_n("HomeSet");
        this.targetX = this.homeX;
        this.targetZ = this.homeZ;
        int chunkX = MathHelper.func_76128_c((double)(this.field_70165_t / 16.0));
        int chunkZ = MathHelper.func_76128_c((double)(this.field_70161_v / 16.0));
    }

    private static class WeightedBehaviour
    extends WeightedRandom.Item {
        public EnumBehaviour randomBehaviour;

        public WeightedBehaviour(int weight, EnumBehaviour randomBehaviour) {
            super(weight);
            this.randomBehaviour = randomBehaviour;
        }
    }

    private static class WeightedAttack
    extends WeightedRandom.Item {
        public int attack;

        public WeightedAttack(int weight, int attack) {
            super(weight);
            this.attack = attack;
        }
    }

    private static enum EnumBehaviour {
        ROAMING(1.0f),
        GO_HOME(1.3f),
        GUARDING(0.8f),
        CHARGING(2.0f),
        FIREBOMB(1.5f),
        CIRCLE_PLAYER(1.2f),
        LOW_HEALTH_STRATEGY(2.0f),
        DEAD(0.5f);

        public float dragonSpeed;

        private EnumBehaviour(float dragonSpeed) {
            this.dragonSpeed = dragonSpeed;
        }
    }
}

