/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.AgeOfMinecraft.blocks;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.AgeOfMinecraft.SpawnerItems;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;

public class MobSpawnerRecipes {
    private static final MobSpawnerRecipes smeltingBase = new MobSpawnerRecipes();
    private Map smeltingList = Maps.newHashMap();
    private Map experienceList = Maps.newHashMap();

    public static MobSpawnerRecipes instance() {
        return smeltingBase;
    }

    private MobSpawnerRecipes() {
        this.addSmelting(SpawnerItems.fusionItemBat, new ItemStack((Item)SpawnerItems.batItem), 5.0f);
        this.addSmelting(SpawnerItems.fusionItemChicken, new ItemStack((Item)SpawnerItems.chickenItem), 5.0f);
        this.addSmelting(SpawnerItems.fusionItemCow, new ItemStack((Item)SpawnerItems.cowItem), 5.0f);
        this.addSmelting(SpawnerItems.fusionItemMooshroom, new ItemStack((Item)SpawnerItems.mooshroomItem), 5.0f);
        this.addSmelting(SpawnerItems.fusionItemPig, new ItemStack((Item)SpawnerItems.pigItem), 5.0f);
        this.addSmelting(SpawnerItems.fusionItemRabbit, new ItemStack((Item)SpawnerItems.rabbitItem), 5.0f);
        this.addSmelting(SpawnerItems.fusionItemSheep, new ItemStack((Item)SpawnerItems.sheepItem), 5.0f);
        this.addSmelting(SpawnerItems.fusionItemOzelot, new ItemStack((Item)SpawnerItems.ozelotItem), 5.0f);
        this.addSmelting(SpawnerItems.fusionItemSquid, new ItemStack((Item)SpawnerItems.squidItem), 5.0f);
        this.addSmelting(SpawnerItems.fusionItemVillager, new ItemStack((Item)SpawnerItems.villagerItem), 5.0f);
        this.addSmelting(SpawnerItems.fusionItemSnowman, new ItemStack((Item)SpawnerItems.snowmanItem), 5.0f);
        this.addSmelting(SpawnerItems.fusionItemSilverfish, new ItemStack((Item)SpawnerItems.silverfishItem), 15.0f);
        this.addSmelting(SpawnerItems.fusionItemEndermite, new ItemStack((Item)SpawnerItems.endermiteItem), 18.0f);
        this.addSmelting(SpawnerItems.fusionItemWolf, new ItemStack((Item)SpawnerItems.wolfItem), 18.0f);
        this.addSmelting(SpawnerItems.fusionItemSpider, new ItemStack((Item)SpawnerItems.spiderItem), 20.0f);
        this.addSmelting(SpawnerItems.fusionItemZombie, new ItemStack((Item)SpawnerItems.zombieItem), 22.0f);
        this.addSmelting(SpawnerItems.fusionItemSkeleton, new ItemStack((Item)SpawnerItems.skeletonItem), 30.0f);
        this.addSmelting(SpawnerItems.fusionItemCreeper, new ItemStack((Item)SpawnerItems.creeperItem), 50.0f);
        this.addSmelting(SpawnerItems.fusionItemSlime, new ItemStack((Item)SpawnerItems.slimeItem), 50.0f);
        this.addSmelting(SpawnerItems.fusionItemMagmaCube, new ItemStack((Item)SpawnerItems.magmacubeItem), 50.0f);
        this.addSmelting(SpawnerItems.fusionItemSpiderJockey, new ItemStack((Item)SpawnerItems.spiderjockeyItem), 50.0f);
        this.addSmelting(SpawnerItems.fusionItemChickenJockey, new ItemStack((Item)SpawnerItems.chickenjockeyItem), 50.0f);
        this.addSmelting(SpawnerItems.fusionItemBlaze, new ItemStack((Item)SpawnerItems.blazeItem), 500.0f);
        this.addSmelting(SpawnerItems.fusionItemEnderman, new ItemStack((Item)SpawnerItems.endermanItem), 400.0f);
        this.addSmelting(SpawnerItems.fusionItemCaveSpider, new ItemStack((Item)SpawnerItems.cavespiderItem), 100.0f);
        this.addSmelting(SpawnerItems.fusionItemPigZombie, new ItemStack((Item)SpawnerItems.pigzombieItem), 200.0f);
        this.addSmelting(SpawnerItems.fusionItemGuardian, new ItemStack((Item)SpawnerItems.guardianItem), 50.0f);
        this.addSmelting(SpawnerItems.fusionItemGhast, new ItemStack((Item)SpawnerItems.ghastItem), 700.0f);
        this.addSmelting(SpawnerItems.fusionItemWitch, new ItemStack((Item)SpawnerItems.witchItem), 600.0f);
        this.addSmelting(SpawnerItems.fusionItemWitherSkeleton, new ItemStack((Item)SpawnerItems.witherskeletonItem), 180.0f);
        this.addSmelting(SpawnerItems.fusionItemKillerRabbit, new ItemStack((Item)SpawnerItems.killerrabbitItem), 50.0f);
        this.addSmelting(SpawnerItems.fusionItemElderGuardian, new ItemStack((Item)SpawnerItems.elderguardianItem), 10000.0f);
        this.addSmelting(SpawnerItems.fusionItemGiant, new ItemStack((Item)SpawnerItems.giantItem), 8000.0f);
        this.addSmelting(SpawnerItems.fusionItemVillagerGolem, new ItemStack((Item)SpawnerItems.villagergolemItem), 8000.0f);
        this.addSmelting(SpawnerItems.fusionItemEnderDragon, new ItemStack((Item)SpawnerItems.enderdragonItem), 160000.0f);
        this.addSmelting(SpawnerItems.fusionItemWither, new ItemStack((Item)SpawnerItems.witherItem), 160000.0f);
        this.addSmelting(SpawnerItems.fusionItemShulker, new ItemStack((Item)SpawnerItems.shulkerItem), 300.0f);
        this.addSmelting(SpawnerItems.fusionItemSkeletonTrap, new ItemStack((Item)SpawnerItems.the4horsemenItem), 12000.0f);
        this.addSmelting(SpawnerItems.fusionItemStray, new ItemStack((Item)SpawnerItems.strayItem), 150.0f);
        this.addSmelting(SpawnerItems.fusionItemHusk, new ItemStack((Item)SpawnerItems.huskItem), 150.0f);
        this.addSmelting(SpawnerItems.fusionItemPolarBear, new ItemStack((Item)SpawnerItems.polarBearItem), 75.0f);
        this.addSmelting(SpawnerItems.fusionItemVex, new ItemStack((Item)SpawnerItems.vexItem), 45.0f);
        this.addSmelting(SpawnerItems.fusionItemVindicator, new ItemStack((Item)SpawnerItems.vindicatorItem), 300.0f);
        this.addSmelting(SpawnerItems.fusionItemLlama, new ItemStack((Item)SpawnerItems.llamaItem), 10.0f);
        this.addSmelting(SpawnerItems.fusionItemEvoker, new ItemStack((Item)SpawnerItems.evokerItem), 18000.0f);
        this.addSmelting(SpawnerItems.fusionItemEversource, new ItemStack((Item)SpawnerItems.eversourceItem), 18000.0f);
        this.addSmelting(SpawnerItems.fusionItemIceSpider, new ItemStack((Item)SpawnerItems.iceSpiderItem), 50.0f);
        this.addSmelting(SpawnerItems.fusionItemPrisonSlime, new ItemStack((Item)SpawnerItems.prisonSlimeItem), 50.0f);
        this.addSmelting(SpawnerItems.fusionItemPrisonZombie, new ItemStack((Item)SpawnerItems.prisonZombieItem), 50.0f);
        this.addSmelting(SpawnerItems.fusionItemPrisonSpider, new ItemStack((Item)SpawnerItems.prisonSpiderItem), 50.0f);
        this.addSmelting(SpawnerItems.fusionItemCreeder, new ItemStack((Item)SpawnerItems.creederItem), 100.0f);
        this.addSmelting(SpawnerItems.fusionItemIcyEnderCreeper, new ItemStack((Item)SpawnerItems.icyEnderCreeperItem), 400.0f);
        this.addSmelting(SpawnerItems.fusionItemIceGolem, new ItemStack((Item)SpawnerItems.iceGolemItem), 8000.0f);
        this.addSmelting(SpawnerItems.fusionItemMagmaGolem, new ItemStack((Item)SpawnerItems.magmaGolemItem), 8000.0f);
        this.addSmelting(SpawnerItems.fusionItemPrisonGolem, new ItemStack((Item)SpawnerItems.prisonGolemItem), 8000.0f);
        this.addSmelting(SpawnerItems.fusionItemGhasther, new ItemStack((Item)SpawnerItems.ghastherItem), 160000.0f);
        this.addSmelting(SpawnerItems.fusionItemAbomniableSnowman, new ItemStack((Item)SpawnerItems.abomniableSnowmanItem), 160000.0f);
        this.addSmelting(SpawnerItems.fusionItemWitherStorm, new ItemStack((Item)SpawnerItems.witherStormItem), 6000000.0f);
        if (Loader.isModLoaded((String)"abyssalcraft")) {
            this.addSmelting(SpawnerItems.fusionItemAbyssalZombie, new ItemStack((Item)SpawnerItems.abyssalZombieItem), 22.0f);
            this.addSmelting(SpawnerItems.fusionItemAbyssalniteGolem, new ItemStack((Item)SpawnerItems.abyssalniteGolemItem), 22.0f);
            this.addSmelting(SpawnerItems.fusionItemChagarothSpawn, new ItemStack((Item)SpawnerItems.chagarothSpawnItem), 22.0f);
            this.addSmelting(SpawnerItems.fusionItemChagarothFist, new ItemStack((Item)SpawnerItems.chagarothFistItem), 22.0f);
            this.addSmelting(SpawnerItems.fusionItemCoraliumSquid, new ItemStack((Item)SpawnerItems.coraliumSquidItem), 22.0f);
            this.addSmelting(SpawnerItems.fusionItemDreadAbyssalniteGolem, new ItemStack((Item)SpawnerItems.dreadAbyssalniteGolemItem), 22.0f);
            this.addSmelting(SpawnerItems.fusionItemDreadling, new ItemStack((Item)SpawnerItems.dreadlingItem), 22.0f);
            this.addSmelting(SpawnerItems.fusionItemDreadSpawn, new ItemStack((Item)SpawnerItems.dreadSpawnItem), 22.0f);
            this.addSmelting(SpawnerItems.fusionItemDepthsGhoul, new ItemStack((Item)SpawnerItems.depthsGhoulItem), 22.0f);
            this.addSmelting(SpawnerItems.fusionItemShadowCreature, new ItemStack((Item)SpawnerItems.shadowCreatureItem), 50.0f);
            this.addSmelting(SpawnerItems.fusionItemGreaterDreadSpawn, new ItemStack((Item)SpawnerItems.greaterDreadSpawnItem), 50.0f);
            this.addSmelting(SpawnerItems.fusionItemOmotholGhoul, new ItemStack((Item)SpawnerItems.omotholGhoulItem), 150.0f);
            this.addSmelting(SpawnerItems.fusionItemShadowMonster, new ItemStack((Item)SpawnerItems.shadowMonsterItem), 150.0f);
            this.addSmelting(SpawnerItems.fusionItemShoggoth, new ItemStack((Item)SpawnerItems.shoggothItem), 300.0f);
            this.addSmelting(SpawnerItems.fusionItemRemnant, new ItemStack((Item)SpawnerItems.remnantItem), 600.0f);
            this.addSmelting(SpawnerItems.fusionItemSpectralDragon, new ItemStack((Item)SpawnerItems.spectralDragonItem), 700.0f);
            this.addSmelting(SpawnerItems.fusionItemAsorah, new ItemStack((Item)SpawnerItems.asorahItem), 160000.0f);
            this.addSmelting(SpawnerItems.fusionItemChagaroth, new ItemStack((Item)SpawnerItems.chagarothItem), 160000.0f);
            this.addSmelting(SpawnerItems.fusionItemDreadguard, new ItemStack((Item)SpawnerItems.dreadguardItem), 8000.0f);
            this.addSmelting(SpawnerItems.fusionItemGatekeeperMinion, new ItemStack((Item)SpawnerItems.gatekeeperminionItem), 8000.0f);
            this.addSmelting(SpawnerItems.fusionItemLesserDreadbeast, new ItemStack((Item)SpawnerItems.lesserDreadbeastItem), 8000.0f);
            this.addSmelting(SpawnerItems.fusionItemShadowBeast, new ItemStack((Item)SpawnerItems.shadowBeastItem), 8000.0f);
            this.addSmelting(SpawnerItems.fusionItemSkeletonGoliath, new ItemStack((Item)SpawnerItems.skeletonGoliathItem), 500.0f);
            this.addSmelting(SpawnerItems.fusionItemSacthoth, new ItemStack((Item)SpawnerItems.sacthothItem), 160000.0f);
            this.addSmelting(SpawnerItems.fusionItemJzahar, new ItemStack((Item)SpawnerItems.jzaharItem), 6000000.0f);
        }
        if (Loader.isModLoaded((String)"draconicevolution")) {
            this.addSmelting(SpawnerItems.fusionItemChaosGuardian, new ItemStack((Item)SpawnerItems.chaosGuardianItem), 6000000.0f);
        }
    }

    public void addSmeltingRecipeForBlock(Block input, ItemStack stack, float experience) {
        this.addSmelting(Item.func_150898_a((Block)input), stack, experience);
    }

    public void addSmelting(Item input, ItemStack stack, float experience) {
        this.addSmeltingRecipe(new ItemStack(input, 1, Short.MAX_VALUE), stack, experience);
    }

    public void addSmeltingRecipe(ItemStack input, ItemStack stack, float experience) {
        this.smeltingList.put(input, stack);
        this.experienceList.put(stack, Float.valueOf(experience));
    }

    public ItemStack getSmeltingResult(ItemStack stack) {
        Map.Entry entry;
        Iterator iterator = this.smeltingList.entrySet().iterator();
        do {
            if (iterator.hasNext()) continue;
            return null;
        } while (!this.compareItemStacks(stack, (ItemStack)(entry = iterator.next()).getKey()));
        return (ItemStack)entry.getValue();
    }

    private boolean compareItemStacks(ItemStack stack1, ItemStack stack2) {
        return stack2.func_77973_b() == stack1.func_77973_b() && (stack2.func_77960_j() == Short.MAX_VALUE || stack2.func_77960_j() == stack1.func_77960_j());
    }

    public Map getSmeltingList() {
        return this.smeltingList;
    }

    public float getSmeltingExperience(ItemStack stack) {
        Map.Entry entry;
        float ret = stack.func_77973_b().getSmeltingExperience(stack);
        if (ret != -1.0f) {
            return ret;
        }
        Iterator iterator = this.experienceList.entrySet().iterator();
        do {
            if (iterator.hasNext()) continue;
            return 0.0f;
        } while (!this.compareItemStacks(stack, (ItemStack)(entry = iterator.next()).getKey()));
        return ((Float)entry.getValue()).floatValue();
    }
}

