/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.AgeOfMinecraft.abyssalcraft.render.entity;

import net.minecraft.AgeOfMinecraft.abyssalcraft.entity.EntityRemnant;
import net.minecraft.AgeOfMinecraft.abyssalcraft.model.ModelRemnant;
import net.minecraft.AgeOfMinecraft.render.LayerLearningBook;
import net.minecraft.AgeOfMinecraft.render.LayerMobCape;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerCustomHead;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderRemnant
extends RenderLiving<EntityRemnant> {
    private static ResourceLocation defaultTexture = new ResourceLocation("abyssalcraft:textures/model/remnant/remnant.png");
    private static final ResourceLocation remnantTexture = new ResourceLocation("abyssalcraft:textures/model/remnant/remnant.png");
    private static final ResourceLocation librarianTexture = new ResourceLocation("abyssalcraft:textures/model/remnant/remnant_librarian.png");
    private static final ResourceLocation priestTexture = new ResourceLocation("abyssalcraft:textures/model/remnant/remnant_priest.png");
    private static final ResourceLocation blacksmithTexture = new ResourceLocation("abyssalcraft:textures/model/remnant/remnant_blacksmith.png");
    private static final ResourceLocation butcherTexture = new ResourceLocation("abyssalcraft:textures/model/remnant/remnant_butcher.png");
    private static final ResourceLocation bankerTexture = new ResourceLocation("abyssalcraft:textures/model/remnant/remnant_banker.png");
    private static final ResourceLocation masterBlacksmithTexture = new ResourceLocation("abyssalcraft:textures/model/remnant/remnant_master_blacksmith.png");

    public RenderRemnant(RenderManager manager) {
        this(manager, new ModelRemnant());
    }

    public RenderRemnant(RenderManager manager, ModelRemnant model) {
        super(manager, (ModelBase)model, 0.5f);
        this.func_177094_a((LayerRenderer)new LayerCustomHead(model.head));
        this.func_177094_a(new LayerLearningBook(this));
        this.func_177094_a(new LayerMobCape((RenderLivingBase)this));
    }

    protected ResourceLocation getEntityTexture(EntityRemnant entity) {
        switch (entity.getProfession()) {
            case 0: {
                defaultTexture = remnantTexture;
                break;
            }
            case 1: {
                defaultTexture = librarianTexture;
                break;
            }
            case 2: {
                defaultTexture = priestTexture;
                break;
            }
            case 3: {
                defaultTexture = blacksmithTexture;
                break;
            }
            case 4: {
                defaultTexture = butcherTexture;
                break;
            }
            case 5: {
                defaultTexture = bankerTexture;
                break;
            }
            case 6: {
                defaultTexture = masterBlacksmithTexture;
            }
        }
        return defaultTexture;
    }

    protected void preRenderCallback(EntityRemnant entitylivingbaseIn, float partialTickTime) {
        if (entitylivingbaseIn.func_70631_g_()) {
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        }
        float fit = entitylivingbaseIn.getFittness();
        GlStateManager.func_179152_a((float)fit, (float)fit, (float)fit);
        if (entitylivingbaseIn.isHero()) {
            GlStateManager.func_179152_a((float)1.05f, (float)1.05f, (float)1.05f);
        }
        if (!entitylivingbaseIn.field_70122_E) {
            GlStateManager.func_179114_b((float)(entitylivingbaseIn.prevRotationPitchFalling + (entitylivingbaseIn.rotationPitchFalling - entitylivingbaseIn.prevRotationPitchFalling) * 2.0f - 1.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (entitylivingbaseIn.field_70173_aa <= 21 && entitylivingbaseIn.field_70173_aa > 0) {
            float f5 = ((float)entitylivingbaseIn.field_70173_aa + partialTickTime - 1.0f) / 20.0f * 1.6f;
            if ((f5 = MathHelper.func_76129_c((float)f5)) > 1.0f) {
                f5 = 1.0f;
            }
            GlStateManager.func_179152_a((float)f5, (float)f5, (float)f5);
            GlStateManager.func_179114_b((float)(f5 * 90.0f - 90.0f), (float)f5, (float)f5, (float)f5);
        }
    }
}

