/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.AgeOfMinecraft.abyssalcraft.render.entity;

import com.shinoow.abyssalcraft.api.AbyssalCraftAPI;
import net.minecraft.AgeOfMinecraft.abyssalcraft.entity.EntityOmotholGhoul;
import net.minecraft.AgeOfMinecraft.abyssalcraft.model.ModelDG;
import net.minecraft.AgeOfMinecraft.abyssalcraft.model.ModelDGArmor;
import net.minecraft.AgeOfMinecraft.render.LayerArrowCustomSized;
import net.minecraft.AgeOfMinecraft.render.LayerLearningBook;
import net.minecraft.AgeOfMinecraft.render.LayerMobCape;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerArmorBase;
import net.minecraft.client.renderer.entity.layers.LayerCustomHead;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderOmotholGhoul
extends RenderLiving<EntityOmotholGhoul> {
    private float scale = 1.2f;
    private static final ResourceLocation ghoulResource = new ResourceLocation("abyssalcraft:textures/model/omothol_ghoul.png");

    public RenderOmotholGhoul(RenderManager manager) {
        this(manager, new ModelDG());
    }

    public RenderOmotholGhoul(RenderManager manager, ModelDG model) {
        super(manager, (ModelBase)model, 0.8f);
        this.func_177094_a(new LayerGhoulHeldItem((RenderLivingBase<?>)this));
        this.func_177094_a((LayerRenderer)new LayerGhoulArmor((RenderLivingBase<?>)this));
        this.func_177094_a((LayerRenderer)new LayerCustomHead(model.Head));
        this.func_177094_a(new LayerArrowCustomSized((RenderLivingBase<?>)this, 0.8f));
        this.func_177094_a(new LayerLearningBook(this));
        this.func_177094_a(new LayerMobCape((RenderLivingBase)this));
    }

    protected void preRenderCallback(EntityOmotholGhoul entitylivingbaseIn, float partialTickTime) {
        ((ModelDG)this.func_177087_b()).isSneak = entitylivingbaseIn.func_70093_af();
        if (entitylivingbaseIn.func_70093_af()) {
            GlStateManager.func_179114_b((float)30.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)0.25f, (float)0.5f);
        }
        GlStateManager.func_179152_a((float)this.scale, (float)this.scale, (float)this.scale);
        float fit = entitylivingbaseIn.getFittness();
        GlStateManager.func_179152_a((float)fit, (float)fit, (float)fit);
        if (entitylivingbaseIn.isHero()) {
            GlStateManager.func_179152_a((float)1.05f, (float)1.05f, (float)1.05f);
        }
        if (!entitylivingbaseIn.field_70122_E) {
            GlStateManager.func_179114_b((float)(entitylivingbaseIn.prevRotationPitchFalling + (entitylivingbaseIn.rotationPitchFalling - entitylivingbaseIn.prevRotationPitchFalling) * 2.0f - 1.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (entitylivingbaseIn.field_70173_aa <= 21 && entitylivingbaseIn.field_70173_aa > 0) {
            float f5 = ((float)entitylivingbaseIn.field_70173_aa + partialTickTime - 1.0f) / 20.0f * 1.6f;
            if ((f5 = MathHelper.func_76129_c((float)f5)) > 1.0f) {
                f5 = 1.0f;
            }
            GlStateManager.func_179152_a((float)f5, (float)f5, (float)f5);
            GlStateManager.func_179114_b((float)(f5 * 90.0f - 90.0f), (float)f5, (float)f5, (float)f5);
        }
    }

    protected ResourceLocation getEntityTexture(EntityOmotholGhoul par1EntityLiving) {
        return ghoulResource;
    }

    @SideOnly(value=Side.CLIENT)
    public class LayerGhoulArmor
    extends LayerArmorBase<ModelDGArmor> {
        private final ResourceLocation MISSING_ARMOR;
        private final ResourceLocation MISSING_LEGGINGS;

        public LayerGhoulArmor(RenderLivingBase<?> rendererIn) {
            super(rendererIn);
            this.MISSING_ARMOR = new ResourceLocation("abyssalcraft:textures/armor/ghoul/missing_1.png");
            this.MISSING_LEGGINGS = new ResourceLocation("abyssalcraft:textures/armor/ghoul/missing_2.png");
        }

        protected void func_177177_a() {
            this.field_177189_c = new ModelDGArmor(0.5f);
            this.field_177186_d = new ModelDGArmor(1.0f);
        }

        protected void setModelSlotVisible(ModelDGArmor model, EntityEquipmentSlot slot) {
            this.setModelVisible(model);
            switch (slot) {
                case FEET: {
                    model.rleg.field_78806_j = true;
                    model.lleg.field_78806_j = true;
                    break;
                }
                case LEGS: {
                    model.chestplate.field_78806_j = true;
                    model.pelvis.field_78806_j = true;
                    model.rleg.field_78806_j = true;
                    model.lleg.field_78806_j = true;
                    break;
                }
                case CHEST: {
                    model.chestplate.field_78806_j = true;
                    model.Spine3.field_78806_j = true;
                    model.rarm1.field_78806_j = true;
                    model.larm1.field_78806_j = true;
                    break;
                }
                case HEAD: {
                    model.Head.field_78806_j = true;
                    model.jaw.field_78806_j = true;
                    break;
                }
            }
        }

        protected void setModelVisible(ModelDGArmor model) {
            model.setInvisible(false);
        }

        protected ModelDGArmor getArmorModelHook(EntityLivingBase entity, ItemStack itemStack, EntityEquipmentSlot slot, ModelDGArmor model) {
            return model;
        }

        public ResourceLocation getArmorResource(Entity entity, ItemStack stack, EntityEquipmentSlot slot, String type) {
            ResourceLocation res = null;
            switch (slot) {
                case HEAD: {
                    res = AbyssalCraftAPI.getGhoulHelmetTexture((Item)stack.func_77973_b());
                    if (type != null && type.equals("overlay") && res != null) {
                        String domain = res.func_110624_b();
                        String path = res.func_110623_a();
                        res = new ResourceLocation(domain, path.substring(0, path.length() - 4).concat("_overlay.png"));
                    }
                    if (res != null) break;
                    res = this.MISSING_ARMOR;
                    break;
                }
                case CHEST: {
                    res = AbyssalCraftAPI.getGhoulChestplateTexture((Item)stack.func_77973_b());
                    if (type != null && type.equals("overlay") && res != null) {
                        String domain = res.func_110624_b();
                        String path = res.func_110623_a();
                        res = new ResourceLocation(domain, path.substring(0, path.length() - 4).concat("_overlay.png"));
                    }
                    if (res != null) break;
                    res = this.MISSING_ARMOR;
                    break;
                }
                case LEGS: {
                    res = AbyssalCraftAPI.getGhoulLeggingsTexture((Item)stack.func_77973_b());
                    if (type != null && type.equals("overlay") && res != null) {
                        String domain = res.func_110624_b();
                        String path = res.func_110623_a();
                        res = new ResourceLocation(domain, path.substring(0, path.length() - 4).concat("_overlay.png"));
                    }
                    if (res != null) break;
                    res = this.MISSING_LEGGINGS;
                    break;
                }
                case FEET: {
                    res = AbyssalCraftAPI.getGhoulBootsTexture((Item)stack.func_77973_b());
                    if (type != null && type.equals("overlay") && res != null) {
                        String domain = res.func_110624_b();
                        String path = res.func_110623_a();
                        res = new ResourceLocation(domain, path.substring(0, path.length() - 4).concat("_overlay.png"));
                    }
                    if (res != null) break;
                    res = this.MISSING_ARMOR;
                    break;
                }
                default: {
                    res = this.MISSING_ARMOR;
                }
            }
            return res;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class LayerGhoulHeldItem
    implements LayerRenderer<EntityLivingBase> {
        private final RenderLivingBase<?> livingEntityRenderer;

        public LayerGhoulHeldItem(RenderLivingBase<?> livingEntityRendererIn) {
            this.livingEntityRenderer = livingEntityRendererIn;
        }

        public void func_177141_a(EntityLivingBase entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            ItemStack itemstack1;
            boolean flag = entitylivingbaseIn.func_184591_cq() == EnumHandSide.RIGHT;
            ItemStack itemstack = flag ? entitylivingbaseIn.func_184592_cb() : entitylivingbaseIn.func_184614_ca();
            ItemStack itemStack = itemstack1 = flag ? entitylivingbaseIn.func_184614_ca() : entitylivingbaseIn.func_184592_cb();
            if (itemstack != null || itemstack1 != null) {
                GlStateManager.func_179094_E();
                if (this.livingEntityRenderer.func_177087_b().field_78091_s) {
                    float f = 0.5f;
                    GlStateManager.func_179109_b((float)0.0f, (float)0.625f, (float)0.0f);
                    GlStateManager.func_179114_b((float)-20.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.func_179152_a((float)f, (float)f, (float)f);
                }
                this.renderHeldItem(entitylivingbaseIn, itemstack1, ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, EnumHandSide.RIGHT);
                this.renderHeldItem(entitylivingbaseIn, itemstack, ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, EnumHandSide.LEFT);
                GlStateManager.func_179121_F();
            }
        }

        private void renderHeldItem(EntityLivingBase p_188358_1_, ItemStack p_188358_2_, ItemCameraTransforms.TransformType p_188358_3_, EnumHandSide handSide) {
            if (p_188358_2_ != null) {
                GlStateManager.func_179094_E();
                ((ModelDG)this.livingEntityRenderer.func_177087_b()).postRenderArm(0.0625f, handSide);
                if (!this.livingEntityRenderer.func_177087_b().field_78091_s) {
                    GlStateManager.func_179109_b((float)-0.08f, (float)0.55f, (float)-0.16f);
                    GlStateManager.func_179114_b((float)-45.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                } else {
                    GlStateManager.func_179109_b((float)-0.05f, (float)0.65f, (float)0.0f);
                    GlStateManager.func_179114_b((float)-70.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                }
                GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                boolean flag = handSide == EnumHandSide.LEFT;
                GlStateManager.func_179109_b((float)(flag ? -0.0625f : 0.0625f), (float)0.125f, (float)-0.625f);
                Minecraft.func_71410_x().func_175597_ag().func_187462_a(p_188358_1_, p_188358_2_, p_188358_3_, flag);
                GlStateManager.func_179121_F();
            }
        }

        public boolean func_177142_b() {
            return false;
        }
    }
}

