/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.AgeOfMinecraft.abyssalcraft.entity.asorahphases;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import net.minecraft.AgeOfMinecraft.abyssalcraft.entity.EntityDragonBoss;
import net.minecraft.AgeOfMinecraft.abyssalcraft.entity.asorahphases.IPhaseAsorah;
import net.minecraft.AgeOfMinecraft.abyssalcraft.entity.asorahphases.PhaseApproachOwner;
import net.minecraft.AgeOfMinecraft.abyssalcraft.entity.asorahphases.PhaseBreathing;
import net.minecraft.AgeOfMinecraft.abyssalcraft.entity.asorahphases.PhaseCircle;
import net.minecraft.AgeOfMinecraft.abyssalcraft.entity.asorahphases.PhaseDeath;
import net.minecraft.AgeOfMinecraft.abyssalcraft.entity.asorahphases.PhaseFaceNearestEnemy;
import net.minecraft.AgeOfMinecraft.abyssalcraft.entity.asorahphases.PhaseFireballAndStrafe;
import net.minecraft.AgeOfMinecraft.abyssalcraft.entity.asorahphases.PhaseHoveringOverOwner;
import net.minecraft.AgeOfMinecraft.abyssalcraft.entity.asorahphases.PhaseIdleHover;
import net.minecraft.AgeOfMinecraft.abyssalcraft.entity.asorahphases.PhaseLightningAndStrafe;
import net.minecraft.AgeOfMinecraft.abyssalcraft.entity.asorahphases.PhasePreBreathing;
import net.minecraft.AgeOfMinecraft.abyssalcraft.entity.asorahphases.PhaseRamAttack;

public class PhaseListAsorah<T extends IPhaseAsorah> {
    private static PhaseListAsorah<?>[] phases = new PhaseListAsorah[0];
    public static final PhaseListAsorah<PhaseCircle> HOLDING_PATTERN = PhaseListAsorah.create(PhaseCircle.class, "Circle");
    public static final PhaseListAsorah<PhaseFireballAndStrafe> STRAFE_PLAYER = PhaseListAsorah.create(PhaseFireballAndStrafe.class, "FireballAndStrafe");
    public static final PhaseListAsorah<PhaseApproachOwner> LANDING_APPROACH = PhaseListAsorah.create(PhaseApproachOwner.class, "ApproachOwner");
    public static final PhaseListAsorah<PhaseHoveringOverOwner> LANDING = PhaseListAsorah.create(PhaseHoveringOverOwner.class, "HoverOverOwner");
    public static final PhaseListAsorah<PhaseLightningAndStrafe> TAKEOFF = PhaseListAsorah.create(PhaseLightningAndStrafe.class, "LightningAndStrafe");
    public static final PhaseListAsorah<PhaseBreathing> SITTING_FLAMING = PhaseListAsorah.create(PhaseBreathing.class, "Breathe");
    public static final PhaseListAsorah<PhaseFaceNearestEnemy> SITTING_SCANNING = PhaseListAsorah.create(PhaseFaceNearestEnemy.class, "Search");
    public static final PhaseListAsorah<PhasePreBreathing> SITTING_ATTACKING = PhaseListAsorah.create(PhasePreBreathing.class, "Roar");
    public static final PhaseListAsorah<PhaseRamAttack> CHARGING_PLAYER = PhaseListAsorah.create(PhaseRamAttack.class, "MeleeAttack");
    public static final PhaseListAsorah<PhaseDeath> DYING = PhaseListAsorah.create(PhaseDeath.class, "Dying");
    public static final PhaseListAsorah<PhaseIdleHover> HOVER = PhaseListAsorah.create(PhaseIdleHover.class, "Hover");
    private final Class<? extends IPhaseAsorah> clazz;
    private final int id;
    private final String name;

    private PhaseListAsorah(int idIn, Class<? extends IPhaseAsorah> clazzIn, String nameIn) {
        this.id = idIn;
        this.clazz = clazzIn;
        this.name = nameIn;
    }

    public IPhaseAsorah createPhase(EntityDragonBoss dragon) {
        try {
            Constructor<IPhaseAsorah> constructor = this.getConstructor();
            return constructor.newInstance(dragon);
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }

    protected Constructor<? extends IPhaseAsorah> getConstructor() throws NoSuchMethodException {
        return this.clazz.getConstructor(EntityDragonBoss.class);
    }

    public int getId() {
        return this.id;
    }

    public String toString() {
        return this.name + " (#" + this.id + ")";
    }

    public static PhaseListAsorah<?> getById(int p_188738_0_) {
        return p_188738_0_ >= 0 && p_188738_0_ < phases.length ? phases[p_188738_0_] : HOLDING_PATTERN;
    }

    public static int getTotalPhases() {
        return phases.length;
    }

    private static <T extends IPhaseAsorah> PhaseListAsorah<T> create(Class<T> phaseIn, String nameIn) {
        PhaseListAsorah<T> phaselist = new PhaseListAsorah<T>(phases.length, phaseIn, nameIn);
        phases = Arrays.copyOf(phases, phases.length + 1);
        PhaseListAsorah.phases[phaselist.getId()] = phaselist;
        return phaselist;
    }
}

