/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.AgeOfMinecraft.abyssalcraft.entity;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.shinoow.abyssalcraft.api.item.ACItems;
import com.shinoow.abyssalcraft.lib.ACConfig;
import com.shinoow.abyssalcraft.lib.ACLib;
import com.shinoow.abyssalcraft.lib.ACLoot;
import com.shinoow.abyssalcraft.lib.ACSounds;
import java.util.Calendar;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFleeSun;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.helpful.Armored;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.EnumTier;
import net.minecraft.entity.helpful.Undead;
import net.minecraft.entity.helpful.ai.EntityAIFollowLeader;
import net.minecraft.entity.helpful.ai.EntityAIFriendlyAttackMelee;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityShadowBeast
extends EntityFriendlyCreature
implements Armored,
Undead {
    private int shadowFlameShootTimer;

    public EntityShadowBeast(World par1World) {
        super(par1World);
        this.func_70105_a(0.8f, 2.9f);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFollowLeader(this, 1.2, 48.0f, 12.0f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFriendlyAttackMelee(this, 1.2, true));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFleeSun((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.isOffensive = true;
    }

    @Override
    public int getNextLevelRequirement() {
        return 1500;
    }

    @Override
    public float getBonusVSArmored() {
        return 1.25f;
    }

    @Override
    public float getBonusVSMassive() {
        return 0.75f;
    }

    @Override
    public EntityFriendlyCreature spawnBaby(EntityFriendlyCreature par1EntityAgeable) {
        return new EntityShadowBeast(this.field_70170_p);
    }

    @Override
    public boolean isEntityImmuneToCoralium() {
        return true;
    }

    @Override
    public boolean isEntityImmuneToDread() {
        return true;
    }

    @Override
    public boolean isEntityImmuneToAntiMatter() {
        return true;
    }

    @Override
    public boolean canBeMatedWith() {
        return false;
    }

    @Override
    public boolean canBeMarried() {
        return false;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111128_a(10.0);
        if (ACConfig.hardcoreMode) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(200.0);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(20.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(10.0);
        }
    }

    @Override
    public double getKnockbackResistance() {
        return 1.0;
    }

    @Override
    public boolean func_70652_k(Entity par1Entity) {
        this.func_184609_a(EnumHand.MAIN_HAND);
        this.func_184609_a(EnumHand.OFF_HAND);
        boolean flag = super.func_70652_k(par1Entity);
        if (flag && par1Entity instanceof EntityLivingBase) {
            ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(MobEffects.field_76440_q, 15));
            ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(MobEffects.field_76421_d, 60));
        }
        if (ACConfig.hardcoreMode && par1Entity instanceof EntityPlayer) {
            par1Entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this).func_76348_h().func_151518_m(), 3.0f * (float)(ACConfig.damageAmpl > 1.0 ? ACConfig.damageAmpl : 1.0));
        }
        return flag;
    }

    @Override
    public EnumTier getTier() {
        return EnumTier.TIER5;
    }

    protected float func_70647_i() {
        return super.func_70647_i() - 0.3f;
    }

    protected SoundEvent func_184601_bQ() {
        return ACSounds.shadow_hurt;
    }

    protected SoundEvent func_184615_bR() {
        return ACSounds.shadow_death;
    }

    protected Item func_146068_u() {
        return ACItems.shadow_gem;
    }

    protected ResourceLocation func_184647_J() {
        return ACLoot.ENTITY_SHADOW_BEAST;
    }

    @Override
    public void func_70636_d() {
        this.func_70105_a(0.8f, 2.9f);
        for (int i = 0; i < 2 && ACConfig.particleEntity && this.field_70170_p.field_73011_w.getDimension() != ACLib.dark_realm_id; ++i) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
        }
        if (this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) <= 64.0 && this.shadowFlameShootTimer <= (this.isHero() ? -100 : -300)) {
            this.shadowFlameShootTimer = 100;
        }
        if (this.shadowFlameShootTimer > 0) {
            Entity target;
            this.field_70159_w *= 0.05;
            this.field_70179_y *= 0.05;
            this.field_70170_p.func_72960_a((Entity)this, (byte)23);
            if (this.field_70173_aa % 5 == 0) {
                this.field_70170_p.func_184133_a(null, new BlockPos(this.field_70165_t + 0.5, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v + 0.5), SoundEvents.field_187557_bK, this.func_184176_by(), 0.5f + this.func_70681_au().nextFloat(), this.func_70681_au().nextFloat() * 0.7f + 0.3f);
            }
            if ((target = this.getHeadLookTarget()) != null) {
                List list = this.field_70170_p.func_175647_a(EntityLivingBase.class, target.func_174813_aQ().func_72314_b(2.0, 2.0, 2.0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_94557_a}));
                if (list != null && !list.isEmpty()) {
                    for (int i1 = 0; i1 < list.size(); ++i1) {
                        EntityLivingBase entity = (EntityLivingBase)list.get(i1);
                        if (entity == null || this.isOnSameTeam(entity) || this.field_70146_Z.nextInt(3) != 0) continue;
                        if (entity.func_70097_a(new DamageSource("shadow").func_76348_h().func_151518_m().func_82726_p(), (float)(15.0 - (double)this.func_70032_d((Entity)entity)))) {
                            entity.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 100));
                            entity.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 100, 1));
                            continue;
                        }
                        this.func_70652_k((Entity)entity);
                        entity.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 100));
                        entity.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 100, 1));
                    }
                }
                if (target.func_70097_a(new DamageSource("shadow").func_76348_h().func_151518_m().func_82726_p(), (float)(15.0 - (double)this.func_70032_d(target)))) {
                    if (target instanceof EntityLivingBase) {
                        ((EntityLivingBase)target).func_70690_d(new PotionEffect(MobEffects.field_76440_q, 200));
                        ((EntityLivingBase)target).func_70690_d(new PotionEffect(MobEffects.field_76421_d, 200, 1));
                    }
                } else {
                    this.func_70652_k(target);
                    if (target instanceof EntityLivingBase) {
                        ((EntityLivingBase)target).func_70690_d(new PotionEffect(MobEffects.field_76440_q, 200));
                        ((EntityLivingBase)target).func_70690_d(new PotionEffect(MobEffects.field_76421_d, 200, 1));
                    }
                }
            }
        }
        --this.shadowFlameShootTimer;
        super.func_70636_d();
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData par1EntityLivingData) {
        Calendar calendar;
        par1EntityLivingData = super.func_180482_a(difficulty, par1EntityLivingData);
        if (this.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b() && (calendar = this.field_70170_p.func_83015_S()).get(2) + 1 == 10 && calendar.get(5) == 31 && this.field_70146_Z.nextFloat() < 0.25f) {
            this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(this.field_70146_Z.nextFloat() < 0.1f ? Blocks.field_150428_aP : Blocks.field_150423_aK));
            this.field_184655_bs[EntityEquipmentSlot.HEAD.func_188454_b()] = 0.0f;
        }
        return par1EntityLivingData;
    }

    private Entity getHeadLookTarget() {
        Entity pointedEntity = null;
        double range = 4.0 + this.field_70146_Z.nextDouble() * 8.0;
        Vec3d srcVec = new Vec3d(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v);
        Vec3d lookVec = this.func_70676_i(1.0f);
        RayTraceResult raytrace = this.field_70170_p.func_72933_a(srcVec, srcVec.func_72441_c(lookVec.field_72450_a * range, lookVec.field_72448_b * range, lookVec.field_72449_c * range));
        BlockPos hitpos = raytrace != null ? raytrace.func_178782_a() : null;
        double rx = hitpos == null ? range : Math.min(range, Math.abs(this.field_70165_t - (double)hitpos.func_177958_n()));
        double ry = hitpos == null ? range : Math.min(range, Math.abs(this.field_70163_u - (double)hitpos.func_177956_o()));
        double rz = hitpos == null ? range : Math.min(range, Math.abs(this.field_70161_v - (double)hitpos.func_177952_p()));
        Vec3d destVec = srcVec.func_72441_c(lookVec.field_72450_a * range, lookVec.field_72448_b * range, lookVec.field_72449_c * range);
        float var9 = 4.0f;
        List possibleList = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72317_d(lookVec.field_72450_a * rx, lookVec.field_72448_b * ry, lookVec.field_72449_c * rz).func_72314_b((double)var9, (double)var9, (double)var9));
        double hitDist = 0.0;
        for (Entity possibleEntity : possibleList) {
            double possibleDist;
            if (possibleEntity == this || !(possibleEntity instanceof EntityLivingBase) || this.isOnSameTeam((EntityLivingBase)possibleEntity)) continue;
            float borderSize = possibleEntity.func_70111_Y();
            AxisAlignedBB collisionBB = possibleEntity.func_174813_aQ().func_72314_b((double)borderSize, (double)borderSize, (double)borderSize);
            RayTraceResult interceptPos = collisionBB.func_72327_a(srcVec, destVec);
            if (collisionBB.func_72318_a(srcVec)) {
                if (!(0.0 < hitDist) && hitDist != 0.0) continue;
                pointedEntity = possibleEntity;
                hitDist = 0.0;
                continue;
            }
            if (interceptPos == null || !((possibleDist = srcVec.func_72438_d(interceptPos.field_72307_f)) < hitDist) && hitDist != 0.0) continue;
            pointedEntity = possibleEntity;
            hitDist = possibleDist;
        }
        return pointedEntity;
    }

    protected void addMouthParticles() {
        if (this.field_70170_p.field_72995_K) {
            Vec3d vector = this.func_70040_Z();
            double px = this.field_70165_t;
            double py = this.field_70163_u + (double)this.func_70047_e();
            double pz = this.field_70161_v;
            for (int i = 0; i < 15; ++i) {
                double dx = vector.field_72450_a;
                double dy = vector.field_72448_b;
                double dz = vector.field_72449_c;
                double spread = 5.0 + this.func_70681_au().nextDouble() * 2.5;
                double velocity = 0.5 + this.func_70681_au().nextDouble() * 0.5;
                dx += this.func_70681_au().nextGaussian() * (double)0.0075f * spread;
                dy += this.func_70681_au().nextGaussian() * (double)0.0075f * spread;
                dz += this.func_70681_au().nextGaussian() * (double)0.0075f * spread;
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, px + this.func_70681_au().nextDouble() - 0.5, py + this.func_70681_au().nextDouble() - 0.5, pz + this.func_70681_au().nextDouble() - 0.5, dx *= velocity, dy *= velocity, dz *= velocity, new int[0]);
            }
        } else {
            this.field_70170_p.func_72960_a((Entity)this, (byte)23);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 23) {
            this.addMouthParticles();
        } else {
            super.func_70103_a(id);
        }
    }

    @Override
    public boolean interact(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        ItemStack heldItem = new ItemStack(stack.func_77973_b());
        if (this.func_70631_g_()) {
            if (this.hasOwner(player)) {
                player.func_184609_a(EnumHand.MAIN_HAND);
                if (this.func_184187_bx() == null) {
                    this.func_184205_a((Entity)player, true);
                } else {
                    this.func_184210_p();
                }
            }
            return true;
        }
        if (stack.func_190926_b() && this.func_184187_bx() == null) {
            if (!this.isWild() && this.isOnSameTeam((EntityLivingBase)player) && !this.func_70631_g_() && !this.field_70170_p.field_72995_K) {
                player.func_184220_m((Entity)this);
            }
            return true;
        }
        return false;
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * 0.9;
    }

    public void func_70612_e(float strafe, float forward) {
        if (this.func_184207_aI()) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)this.func_184179_bs();
            this.field_70126_B = this.field_70177_z = entitylivingbase.field_70177_z;
            this.field_70125_A = entitylivingbase.field_70125_A;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            strafe = entitylivingbase.field_70702_br;
            forward = entitylivingbase.field_70701_bs;
            if (this.func_70090_H() || this.func_180799_ab()) {
                this.field_70181_x += 0.05;
            }
            if (this.func_184186_bw()) {
                this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * (this.func_70090_H() || this.func_180799_ab() ? 5.0f : 1.0f));
                super.func_70612_e(strafe, forward);
            } else if (entitylivingbase instanceof EntityPlayer) {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            this.field_184618_aE = this.field_70721_aZ;
            double d5 = this.field_70165_t - this.field_70169_q;
            double d7 = this.field_70161_v - this.field_70166_s;
            float f10 = MathHelper.func_76133_a((double)(d5 * d5 + d7 * d7)) * 4.0f;
            if (f10 > 1.0f) {
                f10 = 1.0f;
            }
            this.field_70721_aZ += (f10 - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
        } else {
            super.func_70612_e(strafe, forward);
        }
    }
}

