/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.AgeOfMinecraft.abyssalcraft.entity;

import com.shinoow.abyssalcraft.api.AbyssalCraftAPI;
import com.shinoow.abyssalcraft.api.block.ACBlocks;
import com.shinoow.abyssalcraft.api.entity.EntityUtil;
import com.shinoow.abyssalcraft.api.item.ACItems;
import com.shinoow.abyssalcraft.common.blocks.BlockShoggothOoze;
import com.shinoow.abyssalcraft.common.world.gen.WorldGenShoggothMonolith;
import com.shinoow.abyssalcraft.lib.ACConfig;
import com.shinoow.abyssalcraft.lib.ACLib;
import com.shinoow.abyssalcraft.lib.ACLoot;
import com.shinoow.abyssalcraft.lib.ACSounds;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFleeSun;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.helpful.Armored;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.EnumTier;
import net.minecraft.entity.helpful.Undead;
import net.minecraft.entity.helpful.ai.EntityAIFollowLeader;
import net.minecraft.entity.helpful.ai.EntityAIFriendlyAttackMelee;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateClimber;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeModContainer;

public class EntityLesserShoggoth
extends EntityFriendlyCreature
implements Armored,
Undead {
    private static final DataParameter<Byte> CLIMBING = EntityDataManager.func_187226_a(EntityLesserShoggoth.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Integer> TYPE = EntityDataManager.func_187226_a(EntityLesserShoggoth.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> FOOD = EntityDataManager.func_187226_a(EntityLesserShoggoth.class, (DataSerializer)DataSerializers.field_187192_b);
    private int monolithTimer;
    private float shoggothWidth = -1.0f;
    private float shoggothHeight;

    public EntityLesserShoggoth(World par1World) {
        super(par1World);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFollowLeader(this, 1.2, 32.0f, 6.0f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFriendlyAttackMelee(this, 1.2, true));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFleeSun((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.func_70105_a(1.9f, 2.35f);
        this.isOffensive = true;
    }

    @Override
    public int getNextLevelRequirement() {
        return 400;
    }

    @Override
    public float getBonusVSLight() {
        return 2.0f;
    }

    @Override
    public float getBonusVSArmored() {
        return 0.75f;
    }

    @Override
    public boolean isASwarmingMob() {
        return true;
    }

    @Override
    public EntityFriendlyCreature spawnBaby(EntityFriendlyCreature par1EntityAgeable) {
        return new EntityLesserShoggoth(this.field_70170_p);
    }

    @Override
    public EnumTier getTier() {
        return EnumTier.TIER4;
    }

    @Override
    public boolean canBeMatedWith() {
        return false;
    }

    @Override
    public boolean canBeMarried() {
        return false;
    }

    @Override
    public boolean isEntityImmuneToCoralium() {
        return this.getShoggothType() == 1 ? true : super.isEntityImmuneToCoralium();
    }

    @Override
    public boolean isEntityImmuneToDread() {
        return this.getShoggothType() == 2 ? true : super.isEntityImmuneToDread();
    }

    @Override
    public boolean passesCoraliumPlague() {
        return this.getShoggothType() == 1;
    }

    @Override
    public boolean passesDreadPlague() {
        return this.getShoggothType() == 2;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        if (ACConfig.hardcoreMode) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(200.0);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(16.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(8.0);
        }
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new PathNavigateClimber((EntityLiving)this, worldIn);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TYPE, (Object)0);
        this.field_70180_af.func_187214_a(FOOD, (Object)0);
        this.field_70180_af.func_187214_a(CLIMBING, (Object)0);
    }

    public boolean func_70648_aU() {
        return true;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.setBesideClimbableBlock(this.field_70123_F);
        }
    }

    public int getShoggothType() {
        return (Integer)this.field_70180_af.func_187225_a(TYPE);
    }

    public void setShoggothType(int par1) {
        this.field_70180_af.func_187227_b(TYPE, (Object)par1);
    }

    public void setFoodLevel(int par1) {
        this.field_70180_af.func_187227_b(FOOD, (Object)par1);
    }

    public int getFoodLevel() {
        return (Integer)this.field_70180_af.func_187225_a(FOOD);
    }

    public void feed() {
        int food = this.getFoodLevel() + 1;
        this.field_70180_af.func_187227_b(FOOD, (Object)food);
        this.setGrowingAge(this.getGrowingAge() + 4000);
        if (this.getFittness() < 1.5f && this.field_70146_Z.nextInt(10) == 0) {
            this.setFittness(this.getFittness() + 0.05f);
        }
        if (this.getStrength() < 100.0f && this.field_70146_Z.nextInt(10) == 0) {
            this.setStrength(this.getStrength() + 0.05f);
        }
        if (this.getStamina() < 100.0f && this.field_70146_Z.nextInt(10) == 0) {
            this.setStamina(this.getStamina() + 0.05f);
        }
        if (this.getAgility() < 100.0f && this.field_70146_Z.nextInt(10) == 0) {
            this.setAgility(this.getAgility() + 0.05f);
        }
        if (this.getDexterity() < 100.0f && this.field_70146_Z.nextInt(10) == 0) {
            this.setDexterity(this.getDexterity() + 0.05f);
        }
    }

    public boolean func_70617_f_() {
        return this.isBesideClimbableBlock();
    }

    public void reduceMonolithTimer() {
        this.monolithTimer = this.monolithTimer - 100 >= 100 ? (this.monolithTimer -= 100) : 0;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        this.func_70105_a(1.9f, 2.35f);
        ++this.monolithTimer;
        if (this.getFoodLevel() == 3 && !this.field_70170_p.field_72995_K) {
            this.setFoodLevel(0);
            if (!this.func_70631_g_()) {
                EntityLesserShoggoth shoggoth = (EntityLesserShoggoth)this.spawnBaby(this);
                shoggoth.func_82149_j((Entity)this);
                shoggoth.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v)), null);
                shoggoth.setGrowingAge(-24000);
                shoggoth.setOwnerId(this.func_184753_b());
                shoggoth.setShoggothType(this.getShoggothType());
                this.field_70170_p.func_72838_d((Entity)shoggoth);
                this.func_184185_a(SoundEvents.field_187665_Y, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            }
        }
        if (!this.field_70170_p.field_72995_K && !this.func_82150_aj()) {
            for (int l = 0; l < 1; ++l) {
                int x = MathHelper.func_76128_c((double)(this.field_70165_t + (double)((float)(l % 2 * 2 - 1) * 0.25f)));
                int y = MathHelper.func_76128_c((double)this.field_70163_u);
                int z = MathHelper.func_76128_c((double)(this.field_70161_v + (double)((float)(l / 2 % 2 * 2 - 1) * 0.25f)));
                this.spawnOoze(x, y, z);
                if (this.func_70631_g_()) continue;
                this.spawnOoze(x - 1, y, z);
                this.spawnOoze(x, y, z - 1);
                this.spawnOoze(x - 1, y, z - 1);
            }
        }
        if (this.monolithTimer >= 200 && !this.func_82150_aj()) {
            this.monolithTimer = 0;
            if (this.field_70170_p.func_72872_a(this.getClass(), this.func_174813_aQ().func_186662_g(32.0)).size() > 5 && !this.func_70631_g_()) {
                for (EntityLesserShoggoth shoggoth : this.field_70170_p.func_72872_a(this.getClass(), this.func_174813_aQ().func_186662_g(16.0))) {
                    shoggoth.reduceMonolithTimer();
                }
                if (!this.field_70170_p.field_72995_K) {
                    new WorldGenShoggothMonolith().func_180709_b(this.field_70170_p, this.field_70146_Z, new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t) + 3, MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v) + 3));
                }
            }
        }
        for (int i = 0; i < 2 && this.getShoggothType() == 4 && !this.func_82150_aj() && ACConfig.particleEntity && this.field_70170_p.field_73011_w.getDimension() != ACLib.dark_realm_id; ++i) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    private void spawnOoze(int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        if (ACConfig.shoggothOoze) {
            if ((this.field_70170_p.func_180495_p(pos).func_185904_a() == Material.field_151579_a || this.field_70170_p.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)this.field_70170_p, pos)) && ACBlocks.shoggoth_ooze.func_176196_c(this.field_70170_p, pos) && this.field_70170_p.func_180495_p(pos).func_177230_c() != ACBlocks.shoggoth_ooze && !this.field_70170_p.func_180495_p(pos).func_185904_a().func_76224_d()) {
                this.field_70170_p.func_175656_a(pos, ACBlocks.shoggoth_ooze.func_176223_P());
            } else if (this.field_70170_p.func_180495_p(pos).func_177230_c() == ACBlocks.shoggoth_ooze && (Integer)this.field_70170_p.func_180495_p(pos).func_177229_b((IProperty)BlockShoggothOoze.LAYERS) < 8 && this.field_70173_aa % 10 == 0 && this.field_70146_Z.nextInt(5) == 0) {
                IBlockState state = this.field_70170_p.func_180495_p(pos);
                this.field_70170_p.func_175656_a(pos, state.func_177226_a((IProperty)BlockShoggothOoze.LAYERS, (Comparable)Integer.valueOf((Integer)state.func_177229_b((IProperty)BlockShoggothOoze.LAYERS) + 1)));
            }
        }
    }

    public boolean isBesideClimbableBlock() {
        return ((Byte)this.field_70180_af.func_187225_a(CLIMBING) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean par1) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CLIMBING);
        b0 = par1 ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(CLIMBING, (Object)b0);
    }

    @Override
    public boolean func_70652_k(Entity par1Entity) {
        boolean flag = super.func_70652_k(par1Entity);
        if (flag && par1Entity instanceof EntityLivingBase) {
            this.func_184581_c(null);
        }
        switch (this.getShoggothType()) {
            case 1: {
                if (EntityUtil.isEntityCoralium((EntityLivingBase)((EntityLivingBase)par1Entity))) break;
                ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(AbyssalCraftAPI.coralium_plague, 100));
                break;
            }
            case 2: {
                if (EntityUtil.isEntityDread((EntityLivingBase)((EntityLivingBase)par1Entity))) break;
                ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(AbyssalCraftAPI.dread_plague, 100));
                break;
            }
            case 3: {
                ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(MobEffects.field_76421_d, 100));
                break;
            }
            case 4: {
                ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(MobEffects.field_76440_q, 100));
                if (!this.func_82150_aj() && this.field_70146_Z.nextInt(5) == 0) {
                    this.func_184185_a(ACSounds.shadow_death, 1.0f, this.func_70647_i());
                    this.func_70690_d(new PotionEffect(MobEffects.field_76441_p, 800));
                }
                if (!this.func_82150_aj()) break;
                ((EntityLivingBase)par1Entity).field_70172_ad = 0;
            }
        }
        if (ACConfig.hardcoreMode && par1Entity instanceof EntityPlayer) {
            par1Entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this).func_76348_h().func_151518_m(), 3.0f * (float)(ACConfig.damageAmpl > 1.0 ? ACConfig.damageAmpl : 1.0));
        }
        return flag;
    }

    @Override
    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (par1DamageSource.func_76352_a()) {
            this.func_184185_a(SoundEvents.field_189110_fE, this.func_70599_aP(), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) / 0.8f);
            return false;
        }
        if (par1DamageSource == DamageSource.field_76367_g) {
            return false;
        }
        return super.func_70097_a(par1DamageSource, par2);
    }

    @Override
    public boolean takesFallDamage() {
        return false;
    }

    protected SoundEvent func_184639_G() {
        return ACSounds.shoggoth_ambient;
    }

    protected SoundEvent func_184601_bQ() {
        return ACSounds.shoggoth_hurt;
    }

    protected SoundEvent func_184615_bR() {
        return ACSounds.shoggoth_death;
    }

    protected void func_180429_a(BlockPos pos, Block par4) {
        if (!this.func_82150_aj()) {
            this.func_184185_a(SoundEvents.field_187823_fN, 0.15f, 1.0f);
        }
    }

    protected void func_70628_a(boolean par1, int par2) {
        ItemStack item = new ItemStack(ACItems.shoggoth_flesh, 1, this.getShoggothType());
        if (item != null) {
            int i = this.field_70146_Z.nextInt(3);
            if (par2 > 0) {
                i += this.field_70146_Z.nextInt(par2 + 1);
            }
            for (int j = 0; j < i; ++j) {
                this.func_70099_a(item, 0.0f);
            }
        }
    }

    protected ResourceLocation func_184647_J() {
        switch (this.getShoggothType()) {
            case 0: {
                return ACLoot.ENTITY_LESSER_SHOGGOTH;
            }
            case 1: {
                return ACLoot.ENTITY_LESSER_ABYSSAL_SHOGGOTH;
            }
            case 2: {
                return ACLoot.ENTITY_LESSER_DREADED_SHOGGOTH;
            }
            case 3: {
                return ACLoot.ENTITY_LESSER_OMOTHOL_SHOGGOTH;
            }
            case 4: {
                return ACLoot.ENTITY_LESSER_SHADOW_SHOGGOTH;
            }
        }
        return null;
    }

    @Override
    public boolean interact(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        ItemStack heldItem = new ItemStack(stack.func_77973_b());
        if (this.func_70631_g_()) {
            if (this.hasOwner(player)) {
                player.func_184609_a(EnumHand.MAIN_HAND);
                if (this.func_184187_bx() == null) {
                    this.func_184205_a((Entity)player, true);
                } else {
                    this.func_184210_p();
                }
            }
            return true;
        }
        if (!stack.func_190926_b() && stack.func_77973_b() == ACItems.shoggoth_flesh && this.hasOwner(player)) {
            if (this.getShoggothType() != stack.func_77960_j()) {
                this.func_184185_a(this.func_184639_G(), this.func_70599_aP(), this.func_70647_i());
                player.func_184609_a(hand);
                if (!this.field_70170_p.field_72995_K) {
                    this.func_70099_a(new ItemStack(ACItems.shoggoth_flesh, 1, this.getShoggothType()), 1.0f);
                    this.setShoggothType(stack.func_77960_j());
                    stack.func_190918_g(1);
                }
            }
            return true;
        }
        if (stack.func_190926_b() && this.func_184187_bx() == null) {
            if (!this.isWild() && this.isOnSameTeam((EntityLivingBase)player) && !this.func_70631_g_() && !this.field_70170_p.field_72995_K) {
                player.func_184220_m((Entity)this);
            }
            return true;
        }
        return false;
    }

    public void func_70612_e(float strafe, float forward) {
        if (this.func_184207_aI()) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)this.func_184179_bs();
            this.field_70126_B = this.field_70177_z = entitylivingbase.field_70177_z;
            this.field_70125_A = entitylivingbase.field_70125_A;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            strafe = entitylivingbase.field_70702_br;
            forward = entitylivingbase.field_70701_bs;
            if (this.func_70090_H() || this.func_180799_ab()) {
                this.field_70181_x += 0.05;
            }
            if (this.func_184186_bw()) {
                this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * (this.func_70090_H() || this.func_180799_ab() ? 5.0f : 1.0f));
                super.func_70612_e(strafe, forward);
                this.setBesideClimbableBlock(this.field_70123_F);
            } else if (entitylivingbase instanceof EntityPlayer) {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            if (entitylivingbase.field_70701_bs > 0.0f && this.field_70173_aa % 7 == 0) {
                this.func_180429_a(new BlockPos((Entity)this), this.field_70170_p.func_180495_p(new BlockPos((Entity)this)).func_177230_c());
            }
            this.field_184618_aE = this.field_70721_aZ;
            double d5 = this.field_70165_t - this.field_70169_q;
            double d7 = this.field_70161_v - this.field_70166_s;
            float f10 = MathHelper.func_76133_a((double)(d5 * d5 + d7 * d7)) * 4.0f;
            if (f10 > 1.0f) {
                f10 = 1.0f;
            }
            this.field_70721_aZ += (f10 - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
        } else {
            super.func_70612_e(strafe, forward);
        }
    }

    public boolean func_70662_br() {
        return true;
    }

    @Override
    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        byte var2;
        super.func_70037_a(par1NBTTagCompound);
        if (par1NBTTagCompound.func_74767_n("IsBaby")) {
            this.setChild(true);
        }
        if (par1NBTTagCompound.func_74764_b("ShoggothType")) {
            var2 = par1NBTTagCompound.func_74771_c("ShoggothType");
            this.setShoggothType(var2);
        }
        if (par1NBTTagCompound.func_74764_b("FoodLevel")) {
            var2 = par1NBTTagCompound.func_74771_c("FoodLevel");
            this.setFoodLevel(var2);
        }
        this.monolithTimer = par1NBTTagCompound.func_74762_e("MonolithTimer");
    }

    @Override
    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
        if (this.func_70631_g_()) {
            par1NBTTagCompound.func_74757_a("IsBaby", true);
        }
        par1NBTTagCompound.func_74774_a("ShoggothType", (byte)this.getShoggothType());
        par1NBTTagCompound.func_74774_a("FoodLevel", (byte)this.getFoodLevel());
        par1NBTTagCompound.func_74768_a("MonolithTimer", this.monolithTimer);
    }

    @Override
    public void func_70074_a(EntityLivingBase par1EntityLivingBase) {
        super.func_70074_a(par1EntityLivingBase);
        if (EntityUtil.isShoggothFood((EntityLivingBase)par1EntityLivingBase)) {
            this.feed();
        }
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData par1EntityLivingData) {
        IEntityLivingData data = super.func_180482_a(difficulty, par1EntityLivingData);
        this.setShoggothType(0);
        if (this.field_70170_p.field_73011_w.getDimension() == ACLib.abyssal_wasteland_id) {
            this.setShoggothType(1);
        }
        if (this.field_70170_p.field_73011_w.getDimension() == ACLib.dreadlands_id) {
            this.setShoggothType(2);
        }
        if (this.field_70170_p.field_73011_w.getDimension() == ACLib.omothol_id) {
            this.setShoggothType(3);
        }
        if (this.field_70170_p.field_73011_w.getDimension() == ACLib.dark_realm_id) {
            this.setShoggothType(4);
        }
        if (data == null) {
            data = new GroupData(this.field_70170_p.field_73012_v.nextFloat() < ForgeModContainer.zombieBabyChance, null);
        }
        if (data instanceof GroupData) {
            GroupData groupdata = (GroupData)data;
            if (groupdata.isBaby) {
                this.setGrowingAge(-24000);
            }
        }
        return data;
    }

    class GroupData
    implements IEntityLivingData {
        public boolean isBaby = false;

        private GroupData(boolean par2) {
            this.isBaby = par2;
        }

        GroupData(boolean par2, Object par4EntityLesserShoggothINNER1) {
            this(par2);
        }
    }
}

