/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.AgeOfMinecraft.abyssalcraft.entity;

import com.shinoow.abyssalcraft.api.AbyssalCraftAPI;
import com.shinoow.abyssalcraft.api.item.ACItems;
import com.shinoow.abyssalcraft.lib.ACConfig;
import com.shinoow.abyssalcraft.lib.ACLoot;
import com.shinoow.abyssalcraft.lib.ACSounds;
import java.util.List;
import net.minecraft.AgeOfMinecraft.ModSoundEvents;
import net.minecraft.AgeOfMinecraft.abyssalcraft.entity.EntityDreadSlugOther;
import net.minecraft.AgeOfMinecraft.abyssalcraft.entity.EntityGreaterDreadSpawn;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.EnumTier;
import net.minecraft.entity.helpful.Light;
import net.minecraft.entity.helpful.ai.EntityAIFollowLeader;
import net.minecraft.entity.helpful.ai.EntityAIFriendlyAttackMelee;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateClimber;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityDreadSpawn
extends EntityFriendlyCreature
implements Light {
    private static final DataParameter<Byte> CLIMBING = EntityDataManager.func_187226_a(EntityDreadSpawn.class, (DataSerializer)DataSerializers.field_187191_a);
    private static boolean hasMerged;

    public EntityDreadSpawn(World par1World) {
        super(par1World);
        this.func_70105_a(0.425f, 0.425f);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFollowLeader(this, 1.1, 32.0f, 9.0f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFriendlyAttackMelee(this, 1.0, true));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70178_ae = true;
        this.isOffensive = true;
    }

    @Override
    public int getNextLevelRequirement() {
        return 25;
    }

    @Override
    public boolean isASwarmingMob() {
        return true;
    }

    @Override
    public EntityFriendlyCreature spawnBaby(EntityFriendlyCreature par1EntityAgeable) {
        return new EntityDreadSpawn(this.field_70170_p);
    }

    @Override
    public EnumTier getTier() {
        return EnumTier.TIER3;
    }

    @Override
    public boolean passesDreadPlague() {
        return true;
    }

    @Override
    public float getBonusVSLight() {
        return 1.1f;
    }

    @Override
    public float getBonusVSMassive() {
        return 0.1f;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        if (ACConfig.hardcoreMode) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(12.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
        }
    }

    @Override
    public boolean canBeMatedWith() {
        return false;
    }

    @Override
    public boolean canBeMarried() {
        return false;
    }

    public boolean func_70648_aU() {
        return true;
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new PathNavigateClimber((EntityLiving)this, worldIn);
    }

    @Override
    public boolean func_70652_k(Entity par1Entity) {
        boolean flag = super.func_70652_k(par1Entity);
        if (flag && par1Entity instanceof EntityLivingBase) {
            ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(AbyssalCraftAPI.dread_plague, 100));
        }
        if (ACConfig.hardcoreMode && par1Entity instanceof EntityPlayer) {
            par1Entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this).func_76348_h().func_151518_m(), 1.5f * (float)(ACConfig.damageAmpl > 1.0 ? ACConfig.damageAmpl : 1.0));
        }
        return flag;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CLIMBING, (Object)0);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.setBesideClimbableBlock(this.field_70123_F);
        }
    }

    protected SoundEvent func_184639_G() {
        return ACSounds.dread_spawn_ambient;
    }

    protected SoundEvent func_184601_bQ() {
        return ACSounds.dread_spawn_hurt;
    }

    protected SoundEvent func_184615_bR() {
        return ACSounds.dread_spawn_death;
    }

    protected void func_180429_a(BlockPos pos, Block par4) {
        this.func_184185_a(SoundEvents.field_187939_hm, 0.15f, 1.0f);
    }

    @Override
    public boolean isEntityImmuneToDread() {
        return true;
    }

    public boolean func_70617_f_() {
        return this.isBesideClimbableBlock();
    }

    public boolean isBesideClimbableBlock() {
        return ((Byte)this.field_70180_af.func_187225_a(CLIMBING) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean par1) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CLIMBING);
        b0 = par1 ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(CLIMBING, (Object)b0);
    }

    @Override
    public boolean takesFallDamage() {
        return false;
    }

    protected Item func_146068_u() {
        return ACItems.dread_fragment;
    }

    protected ResourceLocation func_184647_J() {
        return ACLoot.ENTITY_DREAD_SPAWN;
    }

    public boolean func_70662_br() {
        return true;
    }

    @Override
    public void func_70636_d() {
        List list;
        super.func_70636_d();
        if (this.func_184187_bx() != null && this.func_184187_bx() instanceof EntityDreadSlugOther) {
            this.field_70177_z = this.field_70759_as = this.func_184187_bx().field_70177_z + 180.0f;
            this.field_70761_aq = this.field_70759_as;
            this.field_70125_A = -this.func_184187_bx().field_70125_A;
        }
        this.func_70105_a(0.425f, 0.425f);
        if (this.field_70173_aa == 1) {
            this.func_184185_a(ModSoundEvents.amalgamate, 1.0f, 1.0f);
        }
        List dreadspawns = this.field_70170_p.func_72872_a(this.getClass(), this.func_174813_aQ().func_186662_g(0.5));
        if (!(this.field_70170_p.field_72995_K || dreadspawns.isEmpty() || dreadspawns.size() < 5 || hasMerged)) {
            hasMerged = true;
            for (int i = 0; i < 5 && this.isOnSameTeam((EntityLivingBase)dreadspawns.get(i)); ++i) {
                this.field_70170_p.func_72900_e((Entity)dreadspawns.get(i));
            }
            EntityGreaterDreadSpawn greaterspawn = new EntityGreaterDreadSpawn(this.field_70170_p);
            greaterspawn.func_82149_j((Entity)this);
            greaterspawn.setOwnerId(this.func_184753_b());
            this.field_70170_p.func_72900_e((Entity)this);
            this.field_70170_p.func_72838_d((Entity)greaterspawn);
            hasMerged = false;
        }
        if (!(list = this.field_70170_p.func_72872_a(this.getClass(), this.func_174813_aQ().func_186662_g(8.0))).isEmpty() && list.size() >= 5 && (this.field_70173_aa + this.func_145782_y()) % 20 == 0) {
            for (int i1 = 0; i1 < list.size(); ++i1) {
                EntityDreadSpawn mob;
                Entity entity = (Entity)list.get(i1);
                if (!entity.func_70089_S() || !(entity instanceof EntityDreadSpawn) || !this.isOnSameTeam((EntityLivingBase)(mob = (EntityDreadSpawn)entity))) continue;
                this.func_70661_as().func_75497_a((Entity)mob, 1.2);
            }
        }
    }
}

