/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.AgeOfMinecraft.abyssalcraft.entity;

import com.shinoow.abyssalcraft.api.AbyssalCraftAPI;
import com.shinoow.abyssalcraft.api.entity.EntityUtil;
import com.shinoow.abyssalcraft.api.item.ACItems;
import com.shinoow.abyssalcraft.lib.ACAchievements;
import com.shinoow.abyssalcraft.lib.ACConfig;
import com.shinoow.abyssalcraft.lib.ACLoot;
import java.util.List;
import net.minecraft.AgeOfMinecraft.ModSoundEvents;
import net.minecraft.AgeOfMinecraft.abyssalcraft.entity.EntityDragonBoss;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.EnumTier;
import net.minecraft.entity.helpful.Flying;
import net.minecraft.entity.helpful.Light;
import net.minecraft.entity.helpful.Undead;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class EntityDragonMinion
extends EntityFriendlyCreature
implements IEntityMultiPart,
Light,
Flying,
Undead {
    public static final float innerRotation = 0.0f;
    public double targetX;
    public double targetY;
    public double targetZ;
    public double[][] ringBuffer = new double[64][3];
    public int ringBufferIndex = -1;
    public EntityDragonPart[] dragonPartArray;
    public EntityDragonPart dragonPartHead = new EntityDragonPart((IEntityMultiPart)this, "head", 3.0f, 3.0f);
    public EntityDragonPart dragonPartNeck = new EntityDragonPart((IEntityMultiPart)this, "neck", 3.0f, 3.0f);
    public EntityDragonPart dragonPartBody = new EntityDragonPart((IEntityMultiPart)this, "body", 4.0f, 4.0f);
    public EntityDragonPart dragonPartTail1 = new EntityDragonPart((IEntityMultiPart)this, "tail", 2.0f, 2.0f);
    public EntityDragonPart dragonPartTail2 = new EntityDragonPart((IEntityMultiPart)this, "tail", 2.0f, 2.0f);
    public EntityDragonPart dragonPartTail3 = new EntityDragonPart((IEntityMultiPart)this, "tail", 2.0f, 2.0f);
    public EntityDragonPart dragonPartWing1 = new EntityDragonPart((IEntityMultiPart)this, "wing", 2.0f, 2.0f);
    public EntityDragonPart dragonPartWing2 = new EntityDragonPart((IEntityMultiPart)this, "wing", 2.0f, 2.0f);
    public float prevAnimTime;
    public float animTime;
    public boolean forceNewTarget;
    public Entity target;
    public EntityDragonBoss healingcircle;

    public EntityDragonMinion(World par1World) {
        super(par1World);
        this.dragonPartArray = new EntityDragonPart[]{this.dragonPartHead, this.dragonPartNeck, this.dragonPartBody, this.dragonPartTail1, this.dragonPartTail2, this.dragonPartTail3, this.dragonPartWing1, this.dragonPartWing2};
        this.func_70606_j(this.func_110138_aP());
        this.func_70105_a(8.0f, 3.0f);
        this.field_70145_X = true;
        this.targetY = 100.0;
        this.field_70178_ae = true;
        this.isOffensive = true;
    }

    @Override
    public EntityFriendlyCreature spawnBaby(EntityFriendlyCreature par1EntityAgeable) {
        return new EntityDragonMinion(this.field_70170_p);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        if (ACConfig.hardcoreMode) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(60.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        }
    }

    @Override
    public int getNextLevelRequirement() {
        return 300;
    }

    @Override
    public float getBonusVSArmored() {
        return 1.5f;
    }

    @Override
    public float getBonusVSFlying() {
        return 2.0f;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
    }

    public double[] getMovementOffsets(int par1, float par2) {
        if (this.func_110143_aJ() <= 0.0f) {
            par2 = 0.0f;
        }
        par2 = 1.0f - par2;
        int j = this.ringBufferIndex - par1 * 1 & 0x3F;
        int k = this.ringBufferIndex - par1 * 1 - 1 & 0x3F;
        double[] adouble = new double[3];
        double d0 = this.ringBuffer[j][0];
        double d1 = MathHelper.func_76138_g((double)(this.ringBuffer[k][0] - d0));
        adouble[0] = d0 + d1 * (double)par2;
        d0 = this.ringBuffer[j][1];
        d1 = this.ringBuffer[k][1] - d0;
        adouble[1] = d0 + d1 * (double)par2;
        adouble[2] = this.ringBuffer[j][2] + (this.ringBuffer[k][2] - this.ringBuffer[j][2]) * (double)par2;
        return adouble;
    }

    protected Item func_146068_u() {
        return ACItems.coralium_plagued_flesh;
    }

    @Override
    public EnumTier getTier() {
        return EnumTier.TIER4;
    }

    protected ResourceLocation func_184647_J() {
        return ACLoot.ENTITY_SPECTRAL_DRAGON;
    }

    @Override
    public void func_70645_a(DamageSource par1DamageSource) {
        super.func_70645_a(par1DamageSource);
        if (par1DamageSource.func_76346_g() instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)par1DamageSource.func_76346_g();
            entityplayer.func_71064_a((StatBase)ACAchievements.kill_spectral_dragon, 1);
        }
    }

    @Override
    protected float func_70599_aP() {
        return this.func_70093_af() ? 0.2f : 2.0f;
    }

    @Override
    public void func_70636_d() {
        double d2;
        double d1;
        double d0;
        double d3;
        float f1;
        float f;
        if (this.func_70093_af() || this.isWild()) {
            this.func_174805_g(false);
        } else {
            this.func_174805_g(true);
        }
        if (this.field_70173_aa <= 20) {
            if (this.field_70173_aa == 3) {
                this.func_70656_aK();
            }
            this.field_70159_w *= 0.0;
            this.field_70179_y *= 0.0;
            this.field_70761_aq = this.field_70177_z = this.field_70759_as;
        }
        this.func_70105_a(4.0f, 1.8f);
        if (this.moralRaisedTimer <= 0) {
            this.moralRaisedTimer = 0;
        }
        if (this.moralRaisedTimer > 0) {
            --this.moralRaisedTimer;
        }
        if (this.func_175446_cd()) {
            this.func_94061_f(this.func_175446_cd());
            this.field_70172_ad = this.field_70771_an;
            if (this.field_70173_aa > 21) {
                --this.field_70173_aa;
            }
        } else {
            if (this.func_110143_aJ() > this.func_110138_aP() / 5.0f) {
                this.field_70715_bh.func_75774_a();
            }
            if (this.func_70089_S() && this.func_70638_az() != null && this.func_70638_az().func_70089_S() && this.isOffensive && !this.func_70631_g_() && !this.isOnSameTeam(this.func_70638_az())) {
                double d = this.func_70068_e((Entity)this.func_70638_az());
                float f2 = this.func_70638_az() instanceof EntityFriendlyCreature ? ((EntityFriendlyCreature)this.func_70638_az()).reachWidth : this.func_70638_az().field_70130_N;
                float f3 = this.func_70638_az() instanceof EntityFriendlyCreature ? ((EntityFriendlyCreature)this.func_70638_az()).reachWidth : this.func_70638_az().field_70130_N;
                if (d < (double)(this.reachWidth * this.reachWidth + f2 * f3) + 9.0 && (this.field_70173_aa + this.func_145782_y()) % 10 == 0) {
                    this.func_70652_k((Entity)this.func_70638_az());
                }
            }
        }
        this.func_174810_b(this.func_175446_cd());
        if (this.field_70170_p.field_72995_K) {
            f = MathHelper.func_76134_b((float)(this.animTime * (float)Math.PI * 2.0f));
            f1 = MathHelper.func_76134_b((float)(this.prevAnimTime * (float)Math.PI * 2.0f));
            if (f1 <= -0.3f && f >= -0.3f) {
                this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187524_aN, this.func_184176_by(), this.func_70599_aP(), this.func_70647_i() + 0.1f, false);
            }
        }
        this.prevAnimTime = this.animTime;
        if (this.func_110143_aJ() <= 0.0f) {
            f = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 4.0f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            if (ACConfig.particleEntity) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.field_70165_t + (double)f, this.field_70163_u + 2.0 + (double)f1, this.field_70161_v + (double)f2, 0.0, 0.0, 0.0, new int[0]);
            }
        } else if (!this.func_175446_cd()) {
            if (!this.isWild() && this.func_70068_e((Entity)this.getOwner()) > 4069.0) {
                this.target = this.getOwner();
                this.func_70624_b(null);
            }
            if (this.func_70638_az() != null && this.target == null && this.field_70173_aa + this.func_145782_y() % 40 == 0) {
                this.target = this.func_70638_az();
            }
            this.updateHealingCircle();
            f = 0.2f / (MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y)) * 10.0f + 1.0f);
            f *= (float)Math.pow(2.0, this.field_70181_x);
            if (this.field_70173_aa > 20) {
                this.animTime += f;
            }
            if (this.func_70631_g_()) {
                this.animTime += f;
                this.animTime += f;
            }
            if (this.func_184207_aI() && ((EntityLivingBase)this.func_184179_bs()).field_70701_bs == 0.0f) {
                this.animTime += 0.1f;
            }
            this.field_70177_z = MathHelper.func_76142_g((float)this.field_70177_z);
            if (this.ringBufferIndex < 0) {
                for (int i = 0; i < this.ringBuffer.length; ++i) {
                    this.ringBuffer[i][0] = this.field_70177_z;
                    this.ringBuffer[i][1] = this.field_70163_u;
                }
            }
            if (++this.ringBufferIndex == this.ringBuffer.length) {
                this.ringBufferIndex = 0;
            }
            this.ringBuffer[this.ringBufferIndex][0] = this.field_70177_z;
            this.ringBuffer[this.ringBufferIndex][1] = this.field_70163_u;
            this.field_70761_aq = this.field_70177_z;
            this.dragonPartHead.field_70131_O = 1.5f;
            this.dragonPartHead.field_70130_N = 1.5f;
            this.dragonPartNeck.field_70131_O = 1.5f;
            this.dragonPartNeck.field_70130_N = 1.5f;
            this.dragonPartTail1.field_70131_O = 1.0f;
            this.dragonPartTail1.field_70130_N = 1.0f;
            this.dragonPartTail2.field_70131_O = 1.0f;
            this.dragonPartTail2.field_70130_N = 1.0f;
            this.dragonPartTail3.field_70131_O = 1.0f;
            this.dragonPartTail3.field_70130_N = 1.0f;
            this.dragonPartBody.field_70131_O = 1.5f;
            this.dragonPartBody.field_70130_N = 2.5f;
            this.dragonPartWing1.field_70131_O = 1.5f;
            this.dragonPartWing1.field_70130_N = 2.0f;
            this.dragonPartWing2.field_70131_O = 1.5f;
            this.dragonPartWing2.field_70130_N = 1.5f;
            float f14 = (float)(this.getMovementOffsets(5, 1.0f)[1] - this.getMovementOffsets(10, 1.0f)[1]) * 10.0f / 180.0f * (float)Math.PI;
            float f16 = MathHelper.func_76134_b((float)f14);
            float f18 = MathHelper.func_76126_a((float)f14);
            float f21 = this.field_70177_z * ((float)Math.PI / 180);
            float f19 = MathHelper.func_76126_a((float)f21);
            float f31 = MathHelper.func_76134_b((float)f21);
            double[] adouble = this.getMovementOffsets(5, 1.0f);
            double[] adouble1 = this.getMovementOffsets(14, 1.0f);
            double[] adouble2 = this.getMovementOffsets(16, 1.0f);
            this.dragonPartBody.func_70071_h_();
            this.dragonPartBody.func_70012_b(this.field_70165_t + (double)(f19 * 0.25f), this.field_70163_u, this.field_70161_v - (double)(f31 * 0.25f), 0.0f, 0.0f);
            this.dragonPartWing1.func_70071_h_();
            this.dragonPartWing1.func_70012_b(this.field_70165_t + (double)(f31 * 2.25f), this.field_70163_u + (double)(MathHelper.func_76126_a((float)(this.animTime * 3.0f)) * 1.5f), this.field_70161_v + (double)(f19 * 2.25f), 0.0f, 0.0f);
            this.dragonPartWing2.func_70071_h_();
            this.dragonPartWing2.func_70012_b(this.field_70165_t - (double)(f31 * 2.25f), this.field_70163_u + (double)(MathHelper.func_76126_a((float)(this.animTime * 3.0f)) * 1.5f), this.field_70161_v - (double)(f19 * 2.25f), 0.0f, 0.0f);
            this.dragonPartNeck.func_70071_h_();
            this.dragonPartNeck.func_70012_b(this.field_70165_t + (double)(f19 * 2.0f), this.field_70163_u, this.field_70161_v - (double)(f31 * 2.0f), 0.0f, 0.0f);
            this.dragonPartHead.func_70071_h_();
            this.dragonPartHead.func_70012_b(this.field_70165_t + (double)(f19 * 3.5f), this.field_70163_u, this.field_70161_v - (double)(f31 * 3.5f), 0.0f, 0.0f);
            for (int j = 0; j < 3; ++j) {
                EntityDragonPart entitydragonpart = null;
                if (j == 0) {
                    entitydragonpart = this.dragonPartTail1;
                }
                if (j == 1) {
                    entitydragonpart = this.dragonPartTail2;
                }
                if (j == 2) {
                    entitydragonpart = this.dragonPartTail3;
                }
                adouble1 = this.getMovementOffsets(12 + j * 2, 1.0f);
                float f211 = this.field_70177_z * (float)Math.PI / 180.0f + this.simplifyAngle(adouble2[0] - adouble[0]) * (float)Math.PI / 180.0f * 1.0f;
                float f22 = MathHelper.func_76126_a((float)f211);
                float f7 = MathHelper.func_76134_b((float)f211);
                float f23 = 0.75f;
                float f24 = (float)(j + 1) * 1.0f;
                entitydragonpart.func_70071_h_();
                entitydragonpart.func_70012_b(this.field_70165_t - (double)((f19 * f23 + f22 * f24) * f16), this.field_70163_u + (adouble1[1] - adouble[1]) - (double)((f24 + f23) * f18) + 0.75, this.field_70161_v + (double)((f31 * f23 + f7 * f24) * f16), 0.0f, 0.0f);
            }
            if (!this.field_70170_p.field_72995_K) {
                this.collideWithEntities(this.field_70170_p.func_72839_b((Entity)this, this.dragonPartBody.func_174813_aQ().func_186662_g(1.0)));
                this.collideWithEntities(this.field_70170_p.func_72839_b((Entity)this, this.dragonPartWing1.func_174813_aQ().func_186662_g(1.0).func_72317_d(0.0, -1.0, 0.0)));
                this.collideWithEntities(this.field_70170_p.func_72839_b((Entity)this, this.dragonPartWing2.func_174813_aQ().func_186662_g(1.0).func_72317_d(0.0, -1.0, 0.0)));
                this.collideWithEntities(this.field_70170_p.func_72839_b((Entity)this, this.dragonPartTail1.func_174813_aQ().func_186662_g(1.0)));
                this.collideWithEntities(this.field_70170_p.func_72839_b((Entity)this, this.dragonPartTail2.func_174813_aQ().func_186662_g(1.0)));
                this.collideWithEntities(this.field_70170_p.func_72839_b((Entity)this, this.dragonPartTail3.func_174813_aQ().func_186662_g(1.0)));
                this.attackEntitiesInList(this.field_70170_p.func_72839_b((Entity)this, this.dragonPartHead.func_174813_aQ().func_186662_g(3.0).func_72317_d(0.0, -1.0, 0.0)));
                this.attackEntitiesInList(this.field_70170_p.func_72839_b((Entity)this, this.dragonPartNeck.func_174813_aQ().func_186662_g(3.0).func_72317_d(0.0, -1.0, 0.0)));
            }
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.field_70716_bi > 0) {
                d3 = this.field_70165_t + (this.field_184623_bh - this.field_70165_t) / (double)this.field_70716_bi;
                d0 = this.field_70163_u + (this.field_184624_bi - this.field_70163_u) / (double)this.field_70716_bi;
                d1 = this.field_70161_v + (this.field_184625_bj - this.field_70161_v) / (double)this.field_70716_bi;
                d2 = MathHelper.func_76138_g((double)(this.field_184626_bk - (double)this.field_70177_z));
                this.field_70177_z = (float)((double)this.field_70177_z + d2 / (double)this.field_70716_bi);
                this.field_70125_A = (float)((double)this.field_70125_A + (this.field_70709_bj - (double)this.field_70125_A) / (double)this.field_70716_bi);
                --this.field_70716_bi;
                this.func_70107_b(d3, d0, d1);
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
            }
        } else {
            float f3;
            d3 = this.targetX - this.field_70165_t;
            d0 = this.targetY - this.field_70163_u;
            d1 = this.targetZ - this.field_70161_v;
            d2 = d3 * d3 + d0 * d0 + d1 * d1;
            if (this.target != null && this.func_70089_S()) {
                this.targetX = this.target.field_70165_t;
                this.targetZ = this.target.field_70161_v;
                double d4 = this.targetX - this.field_70165_t;
                double d5 = this.targetZ - this.field_70161_v;
                double d6 = Math.sqrt(d4 * d4 + d5 * d5);
                double d7 = (double)0.4f + d6 / 80.0 - 1.0;
                if (d7 > 10.0) {
                    d7 = 10.0;
                }
                this.targetY = this.target.func_174813_aQ().field_72338_b + d7;
            } else {
                this.targetX += this.field_70146_Z.nextGaussian() * 2.0;
                this.targetZ += this.field_70146_Z.nextGaussian() * 2.0;
            }
            if (this.forceNewTarget || d2 < 25.0 || d2 > 40000.0 || this.field_70123_F || this.field_70124_G) {
                this.setNewTarget();
            }
            if ((d0 /= (double)MathHelper.func_76133_a((double)(d3 * d3 + d1 * d1))) < (double)(-(f3 = 0.6f))) {
                d0 = -f3;
            }
            if (d0 > (double)f3) {
                d0 = f3;
            }
            this.field_70181_x += d0 * (double)0.1f;
            this.field_70177_z = MathHelper.func_76142_g((float)this.field_70177_z);
            double d8 = 180.0 - Math.atan2(d3, d1) * 180.0 / Math.PI;
            double d9 = MathHelper.func_76138_g((double)(d8 - (double)this.field_70177_z));
            if (d9 > 50.0) {
                d9 = 50.0;
            }
            if (d9 < -50.0) {
                d9 = -50.0;
            }
            Vec3d vec3 = new Vec3d(this.targetX - this.field_70165_t, this.targetY - this.field_70163_u, this.targetZ - this.field_70161_v).func_72432_b();
            Vec3d vec31 = new Vec3d((double)MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)), this.field_70181_x, (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)))).func_72432_b();
            float f4 = (float)(vec31.func_72430_b(vec3) + 0.5) / 1.5f;
            if (f4 < 0.0f) {
                f4 = 0.0f;
            }
            this.field_70704_bt *= 0.8f;
            float f5 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y)) * 1.0f + 1.0f;
            double d10 = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y) * 1.0 + 1.0;
            if (d10 > 40.0) {
                d10 = 40.0;
            }
            this.field_70704_bt = (float)((double)this.field_70704_bt + d9 * ((double)0.7f / d10 / (double)f5));
            this.field_70177_z += this.field_70704_bt * 0.1f;
            float f6 = (float)(2.0 / (d10 + 1.0));
            float f7 = 0.06f;
            if (this.field_70173_aa > 20) {
                this.func_70060_a(0.0f, -1.0f, f7 * (f4 * f6 + (1.0f - f6)));
            }
            if (this.field_70173_aa > 20) {
                this.func_70091_d(MoverType.SELF, this.field_70159_w * (double)this.getFittness() * (this.func_70631_g_() ? 1.5 : 1.0), this.field_70181_x * (double)this.getFittness() * (this.func_70631_g_() ? 1.5 : 1.0), this.field_70179_y * (double)this.getFittness() * (this.func_70631_g_() ? 1.5 : 1.0));
            }
            Vec3d vec32 = new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72432_b();
            float f8 = (float)(vec32.func_72430_b(vec31) + 1.0) / 2.5f;
            f8 = 0.8f + 0.15f * f8;
            this.field_70159_w *= (double)f8;
            this.field_70179_y *= (double)f8;
            this.field_70181_x *= (double)0.91f;
        }
        if (this.func_184207_aI() && this.func_184179_bs() != null && this.func_184179_bs() instanceof EntityPlayer) {
            EntityPlayer passenger = (EntityPlayer)this.func_184179_bs();
            passenger.field_70143_R *= 0.0f;
            passenger.field_70172_ad = 40;
            passenger.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 40, 4));
            this.field_70761_aq = this.field_70177_z = passenger.field_70759_as + 180.0f;
            this.field_70125_A = 0.0f;
            for (int i = 0; i < 256; ++i) {
                double g = 0.005;
                if (this.moralRaisedTimer > 200) {
                    g *= 2.0;
                }
                if (this.func_70051_ag()) {
                    g *= 2.0;
                }
                Vec3d vec3 = passenger.func_70676_i(1.0f);
                if (passenger.field_70701_bs > 0.0f) {
                    this.func_70107_b(this.field_70165_t + vec3.field_72450_a * g, this.field_70163_u + vec3.field_72448_b * g, this.field_70161_v + vec3.field_72449_c * g);
                    Entity[] aentity = this.func_70021_al();
                    if (aentity != null) {
                        for (Entity entity : aentity) {
                            entity.func_70012_b(entity.field_70165_t + vec3.field_72450_a * g, entity.field_70163_u + vec3.field_72448_b * g, entity.field_70161_v + vec3.field_72449_c * g, 0.0f, 0.0f);
                        }
                    }
                }
                if (!(passenger.field_70701_bs < 0.0f)) continue;
                this.func_70107_b(this.field_70165_t - vec3.field_72450_a * g, this.field_70163_u - vec3.field_72448_b * g, this.field_70161_v - vec3.field_72449_c * g);
            }
        }
    }

    @Override
    public boolean interact(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_190926_b() && this.func_184187_bx() == null) {
            if (!this.isWild() && this.isOnSameTeam((EntityLivingBase)player) && !this.func_70631_g_() && !this.field_70170_p.field_72995_K) {
                player.func_184220_m((Entity)this);
            }
            return true;
        }
        return false;
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
        this.func_174826_a(this.func_174813_aQ().func_72317_d(x, y, z));
        this.func_174829_m();
        try {
            this.func_145775_I();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Checking entity block collision");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Entity being checked for collision");
            this.func_85029_a(crashreportcategory);
            throw new ReportedException(crashreport);
        }
    }

    protected void func_145775_I() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185345_c((double)(axisalignedbb.field_72340_a + 0.001), (double)(axisalignedbb.field_72338_b + 0.001), (double)(axisalignedbb.field_72339_c + 0.001));
        BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos1 = BlockPos.PooledMutableBlockPos.func_185345_c((double)(axisalignedbb.field_72336_d - 0.001), (double)(axisalignedbb.field_72337_e - 0.001), (double)(axisalignedbb.field_72334_f - 0.001));
        BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos2 = BlockPos.PooledMutableBlockPos.func_185346_s();
        if (this.field_70170_p.func_175707_a((BlockPos)blockpos$pooledmutableblockpos, (BlockPos)blockpos$pooledmutableblockpos1)) {
            for (int i = blockpos$pooledmutableblockpos.func_177958_n(); i <= blockpos$pooledmutableblockpos1.func_177958_n(); ++i) {
                for (int j = blockpos$pooledmutableblockpos.func_177956_o(); j <= blockpos$pooledmutableblockpos1.func_177956_o(); ++j) {
                    for (int k = blockpos$pooledmutableblockpos.func_177952_p(); k <= blockpos$pooledmutableblockpos1.func_177952_p(); ++k) {
                        blockpos$pooledmutableblockpos2.func_181079_c(i, j, k);
                        IBlockState iblockstate = this.field_70170_p.func_180495_p((BlockPos)blockpos$pooledmutableblockpos2);
                        if (iblockstate.func_185904_a() != Material.field_151567_E) continue;
                        this.func_70024_g(this.field_70159_w > 0.0 ? -3.0 : 3.0, this.field_70181_x > 0.0 ? -3.0 : 3.0, this.field_70179_y > 0.0 ? -3.0 : 3.0);
                    }
                }
            }
        }
        blockpos$pooledmutableblockpos.func_185344_t();
        blockpos$pooledmutableblockpos1.func_185344_t();
        blockpos$pooledmutableblockpos2.func_185344_t();
    }

    private void updateHealingCircle() {
        if (this.healingcircle != null) {
            if (this.healingcircle.field_70128_L) {
                if (!this.field_70170_p.field_72995_K) {
                    this.func_70965_a(this.dragonPartHead, DamageSource.func_94539_a((Explosion)null), 1000.0f);
                }
                this.healingcircle = null;
            } else if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 10 == 0 && this.func_110143_aJ() <= this.func_110138_aP() && this.healingcircle.func_110143_aJ() < this.healingcircle.func_110138_aP()) {
                this.func_70965_a(this.dragonPartHead, new DamageSource("starve").func_76348_h().func_151518_m(), 2.0f);
                this.healingcircle.func_70691_i(4.0f);
            }
        }
        if (this.field_70146_Z.nextInt(10) == 0) {
            float f = 64.0f;
            List list = this.field_70170_p.func_72872_a(EntityDragonBoss.class, this.func_174813_aQ().func_72314_b((double)f, (double)f, (double)f));
            EntityDragonBoss entitydragonboss = null;
            double d0 = Double.MAX_VALUE;
            for (EntityDragonBoss entitydragonboss1 : list) {
                double d1 = entitydragonboss1.func_70068_e((Entity)this);
                if (!(d1 < d0)) continue;
                d0 = d1;
                entitydragonboss = entitydragonboss1;
            }
            this.healingcircle = entitydragonboss;
        }
    }

    private void collideWithEntities(List<?> par1List) {
        double d0 = (this.dragonPartBody.func_174813_aQ().field_72340_a + this.dragonPartBody.func_174813_aQ().field_72336_d) / 2.0;
        double d1 = (this.dragonPartBody.func_174813_aQ().field_72339_c + this.dragonPartBody.func_174813_aQ().field_72334_f) / 2.0;
        for (Entity entity : par1List) {
            if (!(entity instanceof EntityLivingBase) || this.isOnSameTeam((EntityLivingBase)entity)) continue;
            double d2 = entity.field_70165_t - d0;
            double d3 = entity.field_70161_v - d1;
            double d4 = d2 * d2 + d3 * d3;
            entity.func_70024_g(d2 / d4 * 1.25, 0.1, d3 / d4 * 1.25);
            entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 1.0f);
            if (!(entity instanceof EntityLivingBase) || EntityUtil.isEntityCoralium((EntityLivingBase)((EntityLivingBase)entity))) continue;
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(AbyssalCraftAPI.coralium_plague, 100));
        }
    }

    private void attackEntitiesInList(List<?> par1List) {
        for (int i = 0; i < par1List.size(); ++i) {
            Entity entity = (Entity)par1List.get(i);
            if (entity.field_70173_aa + entity.func_145782_y() % 10 != 0 || this.field_70170_p.field_72995_K || !(entity instanceof EntityLivingBase) || this.isOnSameTeam((EntityLivingBase)entity)) continue;
            this.func_70652_k(entity);
            this.func_184185_a(SoundEvents.field_187685_dH, 5.0f, 0.75f);
            if (entity instanceof EntityLivingBase && !EntityUtil.isEntityCoralium((EntityLivingBase)((EntityLivingBase)entity))) {
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(AbyssalCraftAPI.coralium_plague, 400));
            }
            if (!ACConfig.hardcoreMode || !(entity instanceof EntityPlayer)) continue;
            entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this).func_76348_h().func_151518_m(), 1.0f);
        }
    }

    private void setNewTarget() {
        this.forceNewTarget = false;
        if (this.field_70146_Z.nextBoolean() && this.func_70638_az() != null) {
            this.target = this.func_70638_az();
        } else {
            boolean flag = false;
            do {
                double d2;
                double d1;
                double d0;
                if (this.func_70638_az() != null) {
                    this.targetX = this.func_70638_az().field_70165_t;
                    this.targetY = this.func_70638_az().field_70163_u + 20.0 + (double)(this.field_70146_Z.nextFloat() * 20.0f);
                    this.targetZ = this.func_70638_az().field_70161_v;
                    this.targetX += (double)(this.field_70146_Z.nextFloat() * 40.0f - 20.0f);
                    this.targetZ += (double)(this.field_70146_Z.nextFloat() * 40.0f - 20.0f);
                    d0 = this.field_70165_t - this.targetX;
                    d1 = this.field_70163_u - this.targetY;
                    d2 = this.field_70161_v - this.targetZ;
                    flag = d0 * d0 + d1 * d1 + d2 * d2 > 100.0;
                    continue;
                }
                if (!this.isWild()) {
                    this.targetX = this.getOwner().field_70165_t;
                    this.targetY = this.getOwner().field_70163_u + 20.0 + (double)(this.field_70146_Z.nextFloat() * 20.0f);
                    this.targetZ = this.getOwner().field_70161_v;
                    this.targetX += (double)(this.field_70146_Z.nextFloat() * 60.0f - 30.0f);
                    this.targetZ += (double)(this.field_70146_Z.nextFloat() * 60.0f - 30.0f);
                    d0 = this.field_70165_t - this.targetX;
                    d1 = this.field_70163_u - this.targetY;
                    d2 = this.field_70161_v - this.targetZ;
                    flag = d0 * d0 + d1 * d1 + d2 * d2 > 100.0;
                    continue;
                }
                this.targetX = 0.0;
                this.targetY = 70.0f + this.field_70146_Z.nextFloat() * 50.0f;
                this.targetZ = 0.0;
                this.targetX += (double)(this.field_70146_Z.nextFloat() * 120.0f - 60.0f);
                this.targetZ += (double)(this.field_70146_Z.nextFloat() * 120.0f - 60.0f);
                d0 = this.field_70165_t - this.targetX;
                d1 = this.field_70163_u - this.targetY;
                d2 = this.field_70161_v - this.targetZ;
                boolean bl = flag = d0 * d0 + d1 * d1 + d2 * d2 > 100.0;
            } while (!flag);
            this.target = null;
        }
    }

    private float simplifyAngle(double par1) {
        return (float)MathHelper.func_76138_g((double)par1);
    }

    public boolean func_70965_a(EntityDragonPart par1EntityDragonPart, DamageSource source, float damage) {
        if (par1EntityDragonPart != this.dragonPartHead) {
            damage = damage / 2.0f + 1.0f;
        }
        if (damage < 0.01f || source.func_76352_a() || source == DamageSource.field_82727_n || source == DamageSource.field_76368_d || source == DamageSource.field_76369_e || source == DamageSource.field_191291_g || source == DamageSource.field_76367_g) {
            return false;
        }
        float f = this.func_110143_aJ();
        if (source.func_76352_a()) {
            this.func_184185_a(this.getPierceHurtSound(), 3.0f, 1.0f);
        } else if (damage >= 7.0f || source.func_94541_c() || source == DamageSource.field_82728_o || source.func_76357_e() || source.func_151517_h() || source.func_82725_o() || source == DamageSource.field_76379_h || source == DamageSource.field_76371_c) {
            this.func_184185_a(this.getCrushHurtSound(), 3.0f, 1.0f);
        } else {
            this.func_184185_a(this.getRegularHurtSound(), 3.0f, 1.0f);
        }
        this.func_70097_a(source, damage);
        return true;
    }

    @Override
    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        return super.func_70097_a(par1DamageSource, par2);
    }

    @Override
    public boolean takesFallDamage() {
        return false;
    }

    @Override
    public boolean isEntityImmuneToCoralium() {
        return true;
    }

    @Override
    public boolean isEntityImmuneToDread() {
        return true;
    }

    @Override
    public boolean isEntityImmuneToAntiMatter() {
        return true;
    }

    @Override
    public boolean passesCoraliumPlague() {
        return true;
    }

    @Override
    public boolean canBeMatedWith() {
        return false;
    }

    public Entity[] func_70021_al() {
        return this.dragonPartArray;
    }

    @Override
    public boolean func_70067_L() {
        return this.field_70170_p.func_72890_a((Entity)this, (double)this.field_70130_N) != null && this.func_70089_S();
    }

    public World func_82194_d() {
        return this.field_70170_p;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187521_aK;
    }

    protected SoundEvent func_184601_bQ() {
        return SoundEvents.field_187526_aP;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_191266_he;
    }

    @Override
    protected SoundEvent getRegularHurtSound() {
        return ModSoundEvents.woodHit;
    }

    @Override
    protected SoundEvent getPierceHurtSound() {
        return ModSoundEvents.woodHitPierce;
    }

    @Override
    protected SoundEvent getCrushHurtSound() {
        return ModSoundEvents.woodHitCrush;
    }
}

