/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.AgeOfMinecraft.abyssalcraft.entity;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.shinoow.abyssalcraft.api.AbyssalCraftAPI;
import com.shinoow.abyssalcraft.api.entity.EntityUtil;
import com.shinoow.abyssalcraft.api.item.ACItems;
import com.shinoow.abyssalcraft.init.InitHandler;
import com.shinoow.abyssalcraft.lib.ACConfig;
import com.shinoow.abyssalcraft.lib.ACLoot;
import com.shinoow.abyssalcraft.lib.ACSounds;
import java.util.Calendar;
import java.util.List;
import java.util.UUID;
import net.minecraft.AgeOfMinecraft.EngenderMod;
import net.minecraft.AgeOfMinecraft.ModSoundEvents;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFleeSun;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.EnumTier;
import net.minecraft.entity.helpful.Undead;
import net.minecraft.entity.helpful.ai.EntityAIFollowLeader;
import net.minecraft.entity.helpful.ai.EntityAIFriendlyAttackMelee;
import net.minecraft.entity.helpful.tier1.EntityChicken;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAppleGold;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderEnd;
import net.minecraftforge.common.ForgeModContainer;

public class EntityAbyssalZombie
extends EntityFriendlyCreature
implements Undead {
    private static final DataParameter<Integer> TYPE = EntityDataManager.func_187226_a(EntityAbyssalZombie.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Byte> CHILD = EntityDataManager.func_187226_a(EntityAbyssalZombie.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final UUID attackDamageBoostUUID = UUID.fromString("648D7064-6A60-4F59-8ABE-C2C23A6DD7A9");
    private static final AttributeModifier attackDamageBoost = new AttributeModifier(attackDamageBoostUUID, "Halloween Attack Damage Boost", 3.0, 0);
    private int helmetCount = 1;

    public EntityAbyssalZombie(World par1World) {
        super(par1World);
        this.func_70105_a(0.5f, 1.95f);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFollowLeader(this, 1.1, 32.0f, 9.0f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFriendlyAttackMelee(this, 1.0, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFleeSun((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.isOffensive = true;
    }

    @Override
    public int getNextLevelRequirement() {
        return 50;
    }

    @Override
    public boolean isASwarmingMob() {
        return true;
    }

    @Override
    public EntityFriendlyCreature spawnBaby(EntityFriendlyCreature par1EntityAgeable) {
        return new EntityAbyssalZombie(this.field_70170_p);
    }

    @Override
    public EnumTier getTier() {
        return EnumTier.TIER3;
    }

    @Override
    public boolean isEntityImmuneToCoralium() {
        return true;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(42.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.23f);
        if (ACConfig.hardcoreMode) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(12.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(25.0);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
        }
    }

    @Override
    public void func_70645_a(DamageSource par1DamageSource) {
        super.func_70645_a(par1DamageSource);
        if (!this.field_70170_p.field_72995_K && this.helmetCount > 0) {
            this.func_145779_a((Item)Items.field_151024_Q, this.helmetCount);
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CHILD, (Object)0);
        this.field_70180_af.func_187214_a(TYPE, (Object)0);
    }

    public boolean func_70648_aU() {
        return true;
    }

    public int getZombieType() {
        return (Integer)this.field_70180_af.func_187225_a(TYPE);
    }

    public void setZombieType(int par1) {
        this.field_70180_af.func_187227_b(TYPE, (Object)par1);
    }

    @Override
    public void performSpecialAttack() {
        this.setSpecialAttackTimer(700);
    }

    @Override
    protected boolean func_70610_aX() {
        return this.getSpecialAttackTimer() > 600 || super.func_70610_aX();
    }

    @Override
    public void func_70636_d() {
        float f;
        Object entity;
        int i1;
        List list;
        this.func_70105_a(0.5f, 1.95f);
        if (this.isHero() && this.getSpecialAttackTimer() > 600) {
            this.field_70159_w = 0.0;
            this.field_70179_y = 0.0;
            list = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(32.0, 32.0, 32.0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_94557_a}));
            if (list != null && !list.isEmpty()) {
                for (i1 = 0; i1 < list.size(); ++i1) {
                    entity = (EntityLivingBase)list.get(i1);
                    if (entity == null || this.isOnSameTeam((EntityLivingBase)entity)) continue;
                    entity.field_70172_ad = 0;
                    entity.func_70097_a(DamageSource.field_82727_n, 0.05f);
                    if (!EngenderMod.enableMessages || entity.func_70089_S() || this.isWild()) continue;
                    this.getOwner().func_145747_a((ITextComponent)new TextComponentTranslation(entity.func_70005_c_() + " was yelled at to death by " + this.func_70005_c_() + " (" + this.getOwner().func_70005_c_() + ")", new Object[0]));
                }
            }
        }
        if (this.isHero() && this.getSpecialAttackTimer() > 600 && this.getSpecialAttackTimer() < 660) {
            this.field_70125_A = -50.0f;
        }
        if (this.isHero() && this.getSpecialAttackTimer() == 600 && (list = this.field_70170_p.func_175647_a(EntityFriendlyCreature.class, this.func_174813_aQ().func_72314_b(32.0, 32.0, 32.0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_94557_a}))) != null && !list.isEmpty()) {
            for (i1 = 0; i1 < list.size(); ++i1) {
                entity = (EntityFriendlyCreature)list.get(i1);
                if (entity == null || !this.isOnSameTeam((EntityLivingBase)entity)) continue;
                this.moralRaisedTimer = 600;
                entity.moralRaisedTimer = 600;
            }
        }
        if (this.isHero() && this.getSpecialAttackTimer() == 660) {
            if (this.func_70631_g_()) {
                this.func_184185_a(ModSoundEvents.zombieSpecial, 10.0f, 1.25f);
            } else {
                this.func_184185_a(ModSoundEvents.zombieSpecial, 10.0f, 0.75f);
            }
        }
        if (this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) < 128.0 && this.getSpecialAttackTimer() <= 0 && this.isHero()) {
            this.performSpecialAttack();
        }
        if (this.helmetCount < 0) {
            this.helmetCount = 0;
        }
        if ((this.func_70631_g_() || this.isHero()) && this.helmetCount != 0) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_145779_a((Item)Items.field_151024_Q, 1);
            }
            --this.helmetCount;
        }
        if (this.field_70170_p.func_72935_r() && !this.field_70170_p.field_72995_K && !this.func_70631_g_() && !this.func_70045_F() && !this.isHero() && (f = this.func_70013_c(1.0f)) > 0.5f && this.field_70173_aa % (!this.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b() ? 80 : 10) == 0 && this.field_70170_p.func_175678_i(new BlockPos(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v))) {
            boolean flag = true;
            ItemStack itemstack = this.func_184582_a(EntityEquipmentSlot.HEAD);
            if (!itemstack.func_190926_b()) {
                if (itemstack.func_77984_f()) {
                    itemstack.func_77964_b(itemstack.func_77952_i() + this.field_70146_Z.nextInt(2));
                    if (itemstack.func_77952_i() >= itemstack.func_77958_k()) {
                        this.func_70669_a(itemstack);
                        this.func_184201_a(EntityEquipmentSlot.HEAD, ItemStack.field_190927_a);
                    }
                }
                flag = false;
            }
            if (flag) {
                if (this.helmetCount > 0) {
                    this.func_184609_a(EnumHand.MAIN_HAND);
                    this.func_184609_a(EnumHand.OFF_HAND);
                    --this.helmetCount;
                    this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack((Item)Items.field_151024_Q));
                    this.func_184185_a(SoundEvents.field_187728_s, 1.0f, 1.0f);
                } else {
                    this.func_70015_d(8);
                }
            }
        }
        super.func_70636_d();
    }

    @Override
    public boolean func_70652_k(Entity par1Entity) {
        boolean flag = super.func_70652_k(par1Entity);
        if (flag) {
            float f = this.field_70170_p.func_175649_E(new BlockPos((Entity)this)).func_180168_b();
            if (this.func_184582_a(EntityEquipmentSlot.MAINHAND) != null && (this.func_184582_a(EntityEquipmentSlot.MAINHAND).func_77973_b() == Items.field_151033_d || this.func_184582_a(EntityEquipmentSlot.MAINHAND).func_77973_b() == Items.field_151059_bz)) {
                par1Entity.func_70015_d(12);
            }
            if (this.func_70027_ad() && this.field_70146_Z.nextFloat() < f * 0.5f) {
                par1Entity.func_70015_d(5 * (int)f);
            }
            if (flag && par1Entity instanceof EntityLivingBase && !EntityUtil.isEntityCoralium((EntityLivingBase)((EntityLivingBase)par1Entity))) {
                ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(AbyssalCraftAPI.coralium_plague, 100));
            }
        }
        if (ACConfig.hardcoreMode && par1Entity instanceof EntityPlayer) {
            par1Entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this).func_76348_h().func_151518_m(), 1.5f * (float)(ACConfig.damageAmpl > 1.0 ? ACConfig.damageAmpl : 1.0));
        }
        return flag;
    }

    protected SoundEvent func_184639_G() {
        return ACSounds.abyssal_zombie_ambient;
    }

    protected SoundEvent func_184601_bQ() {
        return ACSounds.abyssal_zombie_hurt;
    }

    protected SoundEvent func_184615_bR() {
        return ACSounds.abyssal_zombie_death;
    }

    protected void func_180429_a(BlockPos pos, Block par4) {
        this.func_184185_a(SoundEvents.field_187939_hm, 0.15f, 1.0f);
    }

    protected Item func_146068_u() {
        return ACItems.coralium_plagued_flesh;
    }

    protected ResourceLocation func_184647_J() {
        return ACLoot.ENTITY_ABYSSAL_ZOMBIE;
    }

    public boolean func_70662_br() {
        return true;
    }

    @Override
    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70037_a(par1NBTTagCompound);
        if (par1NBTTagCompound.func_74767_n("IsBaby")) {
            this.setChild(true);
        }
        if (par1NBTTagCompound.func_74764_b("ZombieType")) {
            byte var2 = par1NBTTagCompound.func_74771_c("ZombieType");
            this.setZombieType(var2);
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
        if (this.func_70631_g_()) {
            par1NBTTagCompound.func_74757_a("IsBaby", true);
        }
        par1NBTTagCompound.func_74774_a("ZombieType", (byte)this.getZombieType());
    }

    protected void func_175445_a(EntityItem itemEntity) {
        if (!InitHandler.INSTANCE.isItemBlacklisted((Entity)this, itemEntity.func_92059_d())) {
            super.func_175445_a(itemEntity);
        }
    }

    @Override
    public boolean passesCoraliumPlague() {
        return true;
    }

    @Override
    public boolean canBeMatedWith() {
        return false;
    }

    @Override
    public boolean canBeMarried() {
        return false;
    }

    @Override
    public boolean interact(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        ItemStack heldItem = new ItemStack(stack.func_77973_b());
        if (this.isOnSameTeam((EntityLivingBase)player) && this.func_70631_g_() && stack.func_190926_b() && player.func_70093_af() && this.func_184187_bx() == null) {
            List list = this.field_70170_p.func_175647_a(EntityChicken.class, this.func_174813_aQ().func_72314_b(16.0, 16.0, 16.0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_94557_a}));
            if (list != null && !list.isEmpty() && !this.func_184207_aI()) {
                for (int i1 = 0; i1 < list.size(); ++i1) {
                    EntityChicken entity = (EntityChicken)list.get(i1);
                    if (entity == null || entity.func_184207_aI() || !this.isOnSameTeam((EntityLivingBase)entity) || !this.func_70631_g_() || this.field_70170_p.field_72995_K) continue;
                    entity.field_70173_aa = 0;
                    this.func_184220_m((Entity)entity);
                    this.func_184185_a(SoundEvents.field_187728_s, 1.0f, 1.0f);
                    break;
                }
            }
            return true;
        }
        if (!stack.func_190926_b() && stack.func_77973_b() == Items.field_151024_Q) {
            ++this.helmetCount;
            this.func_184185_a(SoundEvents.field_187728_s, 1.0f, 1.0f);
            player.func_184609_a(hand);
            if (!this.field_70170_p.field_72995_K) {
                stack.func_190918_g(1);
            }
            return true;
        }
        if (this.isOnSameTeam((EntityLivingBase)player) && !stack.func_190926_b() && this.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b() && (EntityAbyssalZombie.func_184640_d((ItemStack)stack) == EntityEquipmentSlot.HEAD || stack.func_77973_b() == Items.field_151103_aS || stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_185764_cQ) || stack.func_77973_b() == Items.field_151008_G) && stack.func_77973_b() != Items.field_151024_Q) {
            this.func_184201_a(EntityEquipmentSlot.HEAD, stack);
            this.func_184606_a_(stack);
            player.func_184609_a(hand);
            if (!this.field_70170_p.field_72995_K) {
                heldItem.func_77982_d(stack.func_77978_p());
                heldItem.func_77964_b(stack.func_77952_i());
                this.func_184201_a(EntityEquipmentSlot.HEAD, heldItem);
                stack.func_190918_g(1);
            }
            return true;
        }
        if (this.isOnSameTeam((EntityLivingBase)player) && !stack.func_190926_b() && this.func_184582_a(EntityEquipmentSlot.CHEST).func_190926_b() && EntityAbyssalZombie.func_184640_d((ItemStack)stack) == EntityEquipmentSlot.CHEST) {
            this.func_184201_a(EntityEquipmentSlot.CHEST, stack);
            this.func_184606_a_(stack);
            player.func_184609_a(hand);
            if (!this.field_70170_p.field_72995_K) {
                heldItem.func_77982_d(stack.func_77978_p());
                heldItem.func_77964_b(stack.func_77952_i());
                this.func_184201_a(EntityEquipmentSlot.CHEST, heldItem);
                stack.func_190918_g(1);
            }
            return true;
        }
        if (this.isOnSameTeam((EntityLivingBase)player) && !stack.func_190926_b() && this.func_184582_a(EntityEquipmentSlot.LEGS).func_190926_b() && EntityAbyssalZombie.func_184640_d((ItemStack)stack) == EntityEquipmentSlot.LEGS) {
            this.func_184201_a(EntityEquipmentSlot.LEGS, stack);
            this.func_184606_a_(stack);
            player.func_184609_a(hand);
            if (!this.field_70170_p.field_72995_K) {
                heldItem.func_77982_d(stack.func_77978_p());
                heldItem.func_77964_b(stack.func_77952_i());
                this.func_184201_a(EntityEquipmentSlot.LEGS, heldItem);
                stack.func_190918_g(1);
            }
            return true;
        }
        if (this.isOnSameTeam((EntityLivingBase)player) && !stack.func_190926_b() && this.func_184582_a(EntityEquipmentSlot.FEET).func_190926_b() && EntityAbyssalZombie.func_184640_d((ItemStack)stack) == EntityEquipmentSlot.FEET) {
            this.func_184201_a(EntityEquipmentSlot.FEET, stack);
            this.func_184606_a_(stack);
            player.func_184609_a(hand);
            if (!this.field_70170_p.field_72995_K) {
                heldItem.func_77982_d(stack.func_77978_p());
                heldItem.func_77964_b(stack.func_77952_i());
                this.func_184201_a(EntityEquipmentSlot.FEET, heldItem);
                stack.func_190918_g(1);
            }
            return true;
        }
        if (this.isOnSameTeam((EntityLivingBase)player) && !stack.func_190926_b() && this.func_184582_a(EntityEquipmentSlot.MAINHAND).func_190926_b() && (EntityAbyssalZombie.func_184640_d((ItemStack)stack) == EntityEquipmentSlot.MAINHAND || stack.func_77973_b() instanceof ItemSword || stack.func_77973_b() instanceof ItemTool || stack.func_77973_b() == Items.field_151031_f)) {
            this.func_184185_a(SoundEvents.field_187727_dV, 1.0f, 2.0f);
            player.func_184609_a(hand);
            if (!this.field_70170_p.field_72995_K) {
                heldItem.func_77982_d(stack.func_77978_p());
                heldItem.func_77964_b(stack.func_77952_i());
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, heldItem);
                stack.func_190918_g(1);
            }
            return true;
        }
        if (this.isOnSameTeam((EntityLivingBase)player) && !stack.func_190926_b() && this.func_184582_a(EntityEquipmentSlot.OFFHAND).func_190926_b() && (EntityAbyssalZombie.func_184640_d((ItemStack)stack) == EntityEquipmentSlot.OFFHAND || stack.func_77973_b() instanceof ItemSword || stack.func_77973_b() instanceof ItemTool || stack.func_77973_b() instanceof ItemFood && !(stack.func_77973_b() instanceof ItemAppleGold) || stack.func_77973_b() == Items.field_185167_i || stack.func_77973_b() == Items.field_185159_cQ)) {
            this.func_184185_a(SoundEvents.field_187727_dV, 1.0f, 2.0f);
            player.func_184609_a(hand);
            if (!this.field_70170_p.field_72995_K) {
                heldItem.func_77982_d(stack.func_77978_p());
                heldItem.func_77964_b(stack.func_77952_i());
                this.func_184201_a(EntityEquipmentSlot.OFFHAND, heldItem);
                stack.func_190918_g(1);
            }
            return true;
        }
        if (this.isOnSameTeam((EntityLivingBase)player) && stack.func_190926_b()) {
            this.dropEquipmentUndamaged();
            player.func_184609_a(hand);
            return true;
        }
        return false;
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData par1EntityLivingData) {
        Calendar calendar;
        IEntityLivingData data = super.func_180482_a(difficulty, par1EntityLivingData);
        if (this.field_70170_p.field_73011_w instanceof WorldProviderEnd) {
            this.setZombieType(2);
        }
        float f = difficulty.func_180170_c();
        if (data == null) {
            data = new GroupData(this.field_70170_p.field_73012_v.nextFloat() < ForgeModContainer.zombieBabyChance, null);
        }
        if (data instanceof GroupData) {
            GroupData groupdata = (GroupData)data;
            if (groupdata.isBaby) {
                this.setGrowingAge(-60000);
            }
        }
        this.func_180481_a(difficulty);
        this.func_180483_b(difficulty);
        if (this.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b() && (calendar = this.field_70170_p.func_83015_S()).get(2) + 1 == 10 && calendar.get(5) == 31 && this.field_70146_Z.nextFloat() < 0.25f) {
            this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(this.field_70146_Z.nextFloat() < 0.1f ? Blocks.field_150428_aP : Blocks.field_150423_aK));
            this.field_184655_bs[EntityEquipmentSlot.HEAD.func_188454_b()] = 0.0f;
        }
        IAttributeInstance attribute = this.func_110148_a(SharedMonsterAttributes.field_111264_e);
        Calendar calendar2 = this.field_70170_p.func_83015_S();
        attribute.func_111124_b(attackDamageBoost);
        if (calendar2.get(2) + 1 == 10 && calendar2.get(5) == 31) {
            attribute.func_111121_a(attackDamageBoost);
        }
        return data;
    }

    class GroupData
    implements IEntityLivingData {
        public boolean isBaby = false;

        private GroupData(boolean par2) {
            this.isBaby = par2;
        }

        GroupData(boolean par2, Object par4EntityZombieINNER1) {
            this(par2);
        }
    }
}

