/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.AgeOfMinecraft;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.AgeOfMinecraft.EngenderMod;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;

public class MobChunkLoader
implements ForgeChunkManager.LoadingCallback {
    public static MobChunkLoader instance;
    public static Map<Entity, ForgeChunkManager.Ticket> ticketList;
    public static Map<Entity, ArrayList<ChunkPos>> chunkList;
    public static boolean hasReportedIssue;

    public static void init() {
        instance = new MobChunkLoader();
        MinecraftForge.EVENT_BUS.register((Object)instance);
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)EngenderMod.instance, (ForgeChunkManager.LoadingCallback)instance);
    }

    public static void updateLoaded(Entity mob) {
        ForgeChunkManager.Ticket ticket;
        ArrayList<ChunkPos> dragonChunks = new ArrayList<ChunkPos>();
        for (int xx = (int)mob.field_70165_t / 16 - 2; xx <= (int)mob.field_70165_t / 16 + 2; ++xx) {
            for (int zz = (int)mob.field_70161_v / 16 - 2; zz <= (int)mob.field_70161_v / 16 + 2; ++zz) {
                dragonChunks.add(new ChunkPos(xx, zz));
            }
        }
        if (chunkList.containsKey(mob) && dragonChunks.hashCode() == chunkList.get(mob).hashCode()) {
            return;
        }
        if (ticketList.containsKey(mob)) {
            ticket = ticketList.get(mob);
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
        }
        if ((ticket = ForgeChunkManager.requestTicket((Object)EngenderMod.instance, (World)mob.field_70170_p, (ForgeChunkManager.Type)ForgeChunkManager.Type.ENTITY)) != null) {
            ticket.bindEntity(mob);
            ticket.setChunkListDepth(25);
            ticketList.put(mob, ticket);
        }
        for (ChunkPos pos : dragonChunks) {
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)pos);
        }
        chunkList.put(mob, dragonChunks);
    }

    public static void stopLoading(Entity guardian) {
        if (!ticketList.containsKey(guardian)) {
            return;
        }
        ForgeChunkManager.Ticket ticket = ticketList.get(guardian);
        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
        ticketList.remove(guardian);
    }

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        if (!tickets.isEmpty()) {
            for (ForgeChunkManager.Ticket ticket : tickets) {
                ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
            }
        }
    }

    static {
        ticketList = new HashMap<Entity, ForgeChunkManager.Ticket>();
        chunkList = new HashMap<Entity, ArrayList<ChunkPos>>();
        hasReportedIssue = false;
    }
}

