/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.AgeOfMinecraft;

import java.util.Random;
import net.minecraft.AgeOfMinecraft.ModSoundEvents;
import net.minecraft.AgeOfMinecraft.abyssalcraft.entity.EntityJzahar;
import net.minecraft.AgeOfMinecraft.draconicevolution.EntityChaosGuardian;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.MusicTicker;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.helpful.tier5.EntityEnderDragon;
import net.minecraft.entity.helpful.tier5.EntityGhasther;
import net.minecraft.entity.helpful.tier5.EntityWither;
import net.minecraft.entity.helpful.tier6.EntityCommandBlockWither;
import net.minecraft.entity.helpful.tier6.EntityWitherStorm;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class EngenderMusicTicker
extends MusicTicker {
    private final Random RNG = new Random();
    private final Minecraft mc;
    private ISound currentMusic;

    public EngenderMusicTicker(Minecraft minecraft) {
        super(minecraft);
        this.mc = minecraft;
    }

    public MusicTypeExtra getBossMusicType(EntityPlayerSP player) {
        for (Entity entity : player.field_70170_p.field_72996_f) {
            if (entity instanceof EntityChaosGuardian) {
                return MusicTypeExtra.CHAOS_GUARDIAN;
            }
            if (entity instanceof EntityWitherStorm && !((EntityWitherStorm)entity).doesntContainACommandBlock()) {
                return ((EntityWitherStorm)entity).getSize() >= 250000 ? MusicTypeExtra.WITHER_STORM_THUNDERSTORM : (((EntityWitherStorm)entity).getSize() >= 50000 && ((EntityWitherStorm)entity).getSize() < 250000 ? MusicTypeExtra.WITHER_STORM_DEVOURER : MusicTypeExtra.WITHER_STORM);
            }
            if (entity instanceof EntityJzahar) {
                return MusicTypeExtra.JZAHAR;
            }
            if (entity instanceof EntityCommandBlockWither) {
                return MusicTypeExtra.WITHER_STORM_PRE;
            }
            if (entity instanceof EntityGhasther) {
                return MusicTypeExtra.GHASTHER;
            }
            if (entity instanceof EntityWither) {
                return MusicTypeExtra.WITHER;
            }
            if (!(entity instanceof EntityEnderDragon)) continue;
            return MusicTypeExtra.ENDER_DRAGON;
        }
        return null;
    }

    public void func_73660_a() {
        MusicTypeExtra musicticker$musictype = this.getBossMusicType(this.mc.field_71439_g);
        if (musicticker$musictype != null) {
            if (this.currentMusic != null) {
                if (!musicticker$musictype.getMusicLocation().func_187503_a().equals((Object)this.currentMusic.func_147650_b())) {
                    this.func_181557_a();
                }
                if (!this.mc.func_147118_V().func_147692_c(this.currentMusic)) {
                    this.func_181557_a();
                }
            } else {
                this.playMusic(musicticker$musictype);
            }
        }
    }

    public void playMusic(MusicTypeExtra requestedMusicType) {
        this.currentMusic = PositionedSoundRecord.func_184370_a((SoundEvent)requestedMusicType.getMusicLocation());
        this.mc.func_147118_V().func_147682_a(this.currentMusic);
    }

    public void func_181557_a() {
        if (this.currentMusic != null) {
            this.mc.func_147118_V().func_147683_b(this.currentMusic);
            this.currentMusic = null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static enum MusicTypeExtra {
        ENDER_DRAGON(SoundEvents.field_187796_dz),
        WITHER(ModSoundEvents.withertheme),
        GIANT_MAGMA_GOLEM(ModSoundEvents.giantmagmagolemtheme),
        GHASTHER(ModSoundEvents.ghasthertheme),
        WITHER_STORM_PRE(ModSoundEvents.commandBlockWitherTheme),
        WITHER_STORM(ModSoundEvents.witherStormTheme),
        WITHER_STORM_DEVOURER(ModSoundEvents.witherStormTheme2),
        WITHER_STORM_THUNDERSTORM(ModSoundEvents.witherStormTheme3),
        JZAHAR(ModSoundEvents.jzahartheme),
        CHAOS_GUARDIAN(ModSoundEvents.chaosguardiantheme),
        SANS(ModSoundEvents.sans),
        NYEHHEHHEH(ModSoundEvents.nyehhehheh),
        BONETOUSLE(ModSoundEvents.bonetrousle),
        TSTMPWYFSANS(ModSoundEvents.tstmpwyfSans),
        BTERTD(ModSoundEvents.btertd),
        MEGALOVANIA(ModSoundEvents.megalovania),
        DUNKS_AND_JUDGEMENT(ModSoundEvents.dunksandjudgement),
        THE_TWINS(ModSoundEvents.terrariathetwins),
        SOVNGARDE(ModSoundEvents.sovngarde),
        ALDUIN(ModSoundEvents.alduintheme);

        private final SoundEvent musicLocation;

        private MusicTypeExtra(SoundEvent musicLocationIn) {
            this.musicLocation = musicLocationIn;
        }

        public SoundEvent getMusicLocation() {
            return this.musicLocation;
        }
    }
}

