/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.AgeOfMinecraft;

import com.brandon3055.draconicevolution.entity.EntityGuardianCrystal;
import com.github.alexthe666.iceandfire.entity.EntityGorgon;
import com.shinoow.abyssalcraft.common.entity.EntityAbygolem;
import com.shinoow.abyssalcraft.common.entity.EntityDragonBoss;
import com.shinoow.abyssalcraft.common.entity.EntityDragonMinion;
import com.shinoow.abyssalcraft.common.entity.EntityDreadgolem;
import com.shinoow.abyssalcraft.common.entity.EntityDreadguard;
import com.shinoow.abyssalcraft.common.entity.EntitySacthoth;
import com.shinoow.abyssalcraft.common.entity.EntitySkeletonGoliath;
import com.shinoow.abyssalcraft.common.entity.anti.EntityAntiSkeleton;
import java.util.List;
import net.minecraft.AgeOfMinecraft.CommonProxy;
import net.minecraft.AgeOfMinecraft.EnchantmentConviction;
import net.minecraft.AgeOfMinecraft.EnchantmentCrusher;
import net.minecraft.AgeOfMinecraft.EnchantmentDisintigration;
import net.minecraft.AgeOfMinecraft.EnchantmentDisruption;
import net.minecraft.AgeOfMinecraft.EnchantmentNeglection;
import net.minecraft.AgeOfMinecraft.EnchantmentObliteration;
import net.minecraft.AgeOfMinecraft.EnchantmentWitherStormKiller;
import net.minecraft.AgeOfMinecraft.EngenderAchievments;
import net.minecraft.AgeOfMinecraft.EngenderEventHandler;
import net.minecraft.AgeOfMinecraft.HealthHelper;
import net.minecraft.AgeOfMinecraft.LootTableListEngender;
import net.minecraft.AgeOfMinecraft.ModSoundEvents;
import net.minecraft.AgeOfMinecraft.SpawnerItems;
import net.minecraft.AgeOfMinecraft.abyssalcraft.entity.EntityAbyssalZombie;
import net.minecraft.AgeOfMinecraft.abyssalcraft.entity.EntityCoraliumSquid;
import net.minecraft.AgeOfMinecraft.abyssalcraft.entity.EntityDreadling;
import net.minecraft.AgeOfMinecraft.abyssalcraft.entity.EntityJzahar;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.helpful.tier3.EntityCreeper;
import net.minecraft.entity.helpful.tier3.EntitySkeleton;
import net.minecraft.entity.monster.AbstractSkeleton;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityShulker;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.DungeonHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import org.apache.logging.log4j.Logger;

@Mod(modid="ageofminecraft", name="The Engender Mod", version="0.5", acceptedMinecraftVersions="[1.11.2]", guiFactory="net.minecraft.AgeOfMinecraft.EngenderGuiFactory")
public class EngenderMod {
    public static final String MODNAME = "The Engender Mod";
    public static final String MODID = "ageofminecraft";
    public static final String VERSION = "0.5";
    public static final String CLIENT = "net.minecraft.AgeOfMinecraft.ClientProxy";
    public static final String SERVER = "net.minecraft.AgeOfMinecraft.CommonProxy";
    @SidedProxy(clientSide="net.minecraft.AgeOfMinecraft.ClientProxy", serverSide="net.minecraft.AgeOfMinecraft.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance
    public static EngenderMod instance;
    public static final EnumCreatureAttribute ENDER;
    public static final EnumCreatureAttribute CONSTRUCT;
    public static final EnumRarity SUPEREPIC;
    public static final EnumRarity UBEREPIC;
    public static final CreativeTabs aomTab;
    public static boolean useMobTalkerModels;
    public static boolean enableBreeding;
    public static boolean enableMessages;
    public static boolean dragonEggRenewable;
    public static boolean engenderMobSpawns;
    public static final Enchantment crusher;
    public static final Enchantment disruption;
    public static final Enchantment conviction;
    public static final Enchantment neglection;
    public static final Enchantment obliteration;
    public static final Enchantment disintigration;
    public static final Enchantment stormkiller;
    public static Configuration cfg;
    public static Logger logger;
    public static final int statCheckerGUIID = 100;

    public void registerConfig(Configuration config) {
        engenderMobSpawns = config.get("general", "Engender mob replacement spawns", false, "If on, there's a chance for regular mobs to be replaced with Engender versions. False by default.").getBoolean(engenderMobSpawns);
        dragonEggRenewable = config.get("general", "Renewable dragon eggs", false, "Makes the dragon egg renewable, allowing for renewable Ender Dragons and Wither Storms. False by default.").getBoolean(dragonEggRenewable);
        enableMessages = config.get("general", "Enable mob death messages", true, "Shows mob death messages in Engender. True by default.").getBoolean(enableMessages);
        useMobTalkerModels = config.get("general", "Enable CMM Mode", false, "Turns a large portion of the hostile mobs into mob girls. False by default.").getBoolean(useMobTalkerModels);
        enableBreeding = config.get("general", "Enable breeding with your mob girls", true, "Allows you to have sexual intercourse with adult mob girls using golden apples. True by default. Requires CMM Mode").getBoolean(enableBreeding);
        if (config.hasChanged()) {
            config.save();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID() == MODID) {
            this.registerConfig(cfg);
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        logger = e.getModLog();
        logger.info("Loading The Engender Mod...");
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new CommonProxy());
        HealthHelper.setPrivateFinalValue(RangedAttribute.class, (RangedAttribute)SharedMonsterAttributes.field_111267_a, Integer.MAX_VALUE, "maximumValue", "field_111118_b");
        HealthHelper.setPrivateFinalValue(RangedAttribute.class, (RangedAttribute)SharedMonsterAttributes.field_111264_e, Integer.MAX_VALUE, "maximumValue", "field_111118_b");
        LootTableListEngender.registerAllModdedLootTables();
        proxy.preInit(e);
        Blocks.field_150483_bI.func_149647_a(CreativeTabs.field_78028_d);
        Blocks.field_185777_dd.func_149647_a(CreativeTabs.field_78028_d);
        Blocks.field_185776_dc.func_149647_a(CreativeTabs.field_78028_d);
        Blocks.field_185779_df.func_149647_a(CreativeTabs.field_78028_d);
        Blocks.field_180401_cv.func_149647_a(CreativeTabs.field_78026_f);
        ModSoundEvents.registerSounds();
        this.addDungeonHooks();
        cfg = new Configuration(e.getSuggestedConfigurationFile());
        this.registerConfig(cfg);
        logger.debug("Pre Initialization started!");
        logger.debug("Finished pre-init for The Engender Mod!");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        proxy.init(e);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new EngenderEventHandler());
        logger.debug("Initialization started!");
        proxy.registerRenders();
        Enchantment.field_185264_b.func_177775_a(243, (Object)new ResourceLocation("crusher"), (Object)crusher);
        Enchantment.field_185264_b.func_177775_a(244, (Object)new ResourceLocation("disruption"), (Object)disruption);
        Enchantment.field_185264_b.func_177775_a(245, (Object)new ResourceLocation("conviction"), (Object)conviction);
        Enchantment.field_185264_b.func_177775_a(246, (Object)new ResourceLocation("disintigration"), (Object)disintigration);
        Enchantment.field_185264_b.func_177775_a(247, (Object)new ResourceLocation("obliteration"), (Object)obliteration);
        Enchantment.field_185264_b.func_177775_a(248, (Object)new ResourceLocation("neglection"), (Object)neglection);
        Enchantment.field_185264_b.func_177775_a(249, (Object)new ResourceLocation("superweapon"), (Object)stormkiller);
        EngenderAchievments.addAchievments();
        logger.debug("Finished init for The Engender Mod!");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        proxy.postInit(e);
        logger.debug("Post Initialization started!");
        proxy.renderEntities();
        logger.debug("Finished post-init for The Engender Mod!");
        logger.info("Finished The Engender Mod!");
    }

    public static boolean isWoodLikeMob(Entity entity) {
        return entity instanceof EntityWither || entity instanceof AbstractSkeleton || entity instanceof EntityShulker || entity instanceof EntityFriendlyCreature && ((EntityFriendlyCreature)entity).isWoodLike() || Loader.isModLoaded((String)"abyssalcraft") && (entity instanceof EntitySkeletonGoliath || entity instanceof EntityAbygolem || entity instanceof EntityDragonBoss || entity instanceof EntityDragonMinion || entity instanceof EntityDreadgolem || entity instanceof EntityAntiSkeleton || entity instanceof com.shinoow.abyssalcraft.common.entity.EntityCoraliumSquid) || Loader.isModLoaded((String)"iceandfire") && entity instanceof EntityLivingBase && EntityGorgon.isStoneMob((EntityLivingBase)((EntityLivingBase)entity)) || Loader.isModLoaded((String)"draconicevolution") && entity instanceof EntityGuardianCrystal;
    }

    public static boolean sensorsShowJzahars(World world) {
        List list;
        if (Loader.isModLoaded((String)"abyssalcraft") && !(list = world.field_72996_f).isEmpty()) {
            for (int i1 = 0; i1 < list.size(); ++i1) {
                Entity entity = (Entity)list.get(i1);
                if (entity instanceof com.shinoow.abyssalcraft.common.entity.EntityJzahar) {
                    return true;
                }
                if (!(entity instanceof EntityJzahar)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isMetalLikeMob(Entity entity) {
        return entity instanceof EntityBlaze || entity instanceof EntityIronGolem || entity instanceof EntityFriendlyCreature && ((EntityFriendlyCreature)entity).isMetalLike() || Loader.isModLoaded((String)"abyssalcraft") && (entity instanceof EntityDreadguard || entity instanceof EntitySacthoth);
    }

    public static boolean canBeTurned(Entity entity) {
        return entity instanceof EntityPlayer || entity instanceof net.minecraft.entity.helpful.tier3.EntityZombie || entity instanceof net.minecraft.entity.helpful.tier2.EntitySquid || entity instanceof EntityZombie || entity instanceof EntitySquid || entity instanceof EntitySkeleton || entity instanceof AbstractSkeleton || entity instanceof EntityCreeper || entity instanceof net.minecraft.entity.monster.EntityCreeper || entity instanceof net.minecraft.entity.helpful.tier2.EntityVillager || entity instanceof EntityVillager || entity instanceof EntityDreadling || entity instanceof EntityAbyssalZombie || entity instanceof EntityCoraliumSquid || Loader.isModLoaded((String)"abyssalcraft") && (entity instanceof com.shinoow.abyssalcraft.common.entity.EntityDreadling || entity instanceof com.shinoow.abyssalcraft.common.entity.EntityAbyssalZombie || entity instanceof com.shinoow.abyssalcraft.common.entity.EntityCoraliumSquid);
    }

    private void addDungeonHooks() {
        DungeonHooks.addDungeonMob((ResourceLocation)new ResourceLocation("creeper"), (int)25);
        DungeonHooks.addDungeonMob((ResourceLocation)new ResourceLocation("cave_spider"), (int)50);
        DungeonHooks.addDungeonMob((ResourceLocation)new ResourceLocation("silverfish"), (int)50);
        DungeonHooks.addDungeonMob((ResourceLocation)new ResourceLocation("enderman"), (int)10);
        DungeonHooks.addDungeonMob((ResourceLocation)new ResourceLocation("wither_skeleton"), (int)1);
        DungeonHooks.addDungeonMob((ResourceLocation)new ResourceLocation("endermite"), (int)1);
        DungeonHooks.addDungeonMob((ResourceLocation)new ResourceLocation("blaze"), (int)1);
        DungeonHooks.addDungeonMob((ResourceLocation)new ResourceLocation(MODID, "zombiehelpful"), (int)50);
        DungeonHooks.addDungeonMob((ResourceLocation)new ResourceLocation(MODID, "skeletonhelpful"), (int)25);
        DungeonHooks.addDungeonMob((ResourceLocation)new ResourceLocation(MODID, "spiderhelpful"), (int)25);
        DungeonHooks.addDungeonMob((ResourceLocation)new ResourceLocation(MODID, "creeperhelpful"), (int)10);
        DungeonHooks.addDungeonMob((ResourceLocation)new ResourceLocation(MODID, "silverfishhelpful"), (int)10);
        DungeonHooks.addDungeonMob((ResourceLocation)new ResourceLocation(MODID, "endermanhelpful"), (int)1);
        DungeonHooks.addDungeonMob((ResourceLocation)new ResourceLocation(MODID, "blazehelpful"), (int)10);
    }

    static {
        ENDER = EnumHelper.addCreatureAttribute((String)"ENDER");
        CONSTRUCT = EnumHelper.addCreatureAttribute((String)"CONSTRUCT");
        SUPEREPIC = EnumHelper.addRarity((String)"SUPEREPIC", (TextFormatting)TextFormatting.DARK_PURPLE, (String)"SuperEpic");
        UBEREPIC = EnumHelper.addRarity((String)"UBEREPIC", (TextFormatting)TextFormatting.GOLD, (String)"UberEpic");
        aomTab = new CreativeTabs(MODID){

            public ItemStack func_78016_d() {
                return new ItemStack((Item)SpawnerItems.witherStormItem);
            }
        };
        crusher = new EnchantmentCrusher();
        disruption = new EnchantmentDisruption();
        conviction = new EnchantmentConviction();
        neglection = new EnchantmentNeglection(Enchantment.Rarity.VERY_RARE, EntityEquipmentSlot.MAINHAND);
        obliteration = new EnchantmentObliteration(Enchantment.Rarity.RARE, EntityEquipmentSlot.MAINHAND);
        disintigration = new EnchantmentDisintigration(Enchantment.Rarity.RARE, EntityEquipmentSlot.MAINHAND);
        stormkiller = new EnchantmentWitherStormKiller(Enchantment.Rarity.VERY_RARE, EntityEquipmentSlot.MAINHAND);
    }
}

