/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.AgeOfMinecraft;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.AgeOfMinecraft.abyssalcraft.entity.EntityJzahar;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentProtection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.helpful.EntityFriendlyCreature;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.init.Blocks;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EngenderExplosion
extends Explosion {
    private final boolean isFlaming;
    private final boolean isSmoking;
    private final Random explosionRNG = new Random();
    private final World world;
    private final double explosionX;
    private final double explosionY;
    private final double explosionZ;
    private final EntityFriendlyCreature exploder;
    private final float explosionSize;
    private final List<BlockPos> affectedBlockPositions = Lists.newArrayList();
    private final Map<EntityPlayer, Vec3d> playerKnockbackMap = Maps.newHashMap();
    private final Vec3d position;

    @SideOnly(value=Side.CLIENT)
    public EngenderExplosion(World worldIn, Entity entityIn, double x, double y, double z, float size, List<BlockPos> affectedPositions) {
        this(worldIn, entityIn, x, y, z, size, false, true, affectedPositions);
    }

    @SideOnly(value=Side.CLIENT)
    public EngenderExplosion(World worldIn, Entity entityIn, double x, double y, double z, float size, boolean flaming, boolean smoking, List<BlockPos> affectedPositions) {
        this(worldIn, entityIn, x, y, z, size, flaming, smoking);
        this.affectedBlockPositions.addAll(affectedPositions);
    }

    public EngenderExplosion(World worldIn, Entity entityIn, double x, double y, double z, float size, boolean flaming, boolean smoking) {
        super(worldIn, entityIn, x, y, z, size, flaming, smoking);
        this.world = worldIn;
        this.exploder = (EntityFriendlyCreature)entityIn;
        this.explosionSize = size;
        this.explosionX = x;
        this.explosionY = y;
        this.explosionZ = z;
        this.isFlaming = flaming;
        this.isSmoking = smoking;
        this.position = new Vec3d(this.explosionX, this.explosionY, this.explosionZ);
    }

    public void func_77278_a() {
        if (this.explosionSize > 0.0f) {
            HashSet set = Sets.newHashSet();
            int i = 16;
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 16; ++k) {
                    for (int l = 0; l < 16; ++l) {
                        if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                        double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                        double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                        double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                        double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                        d0 /= d3;
                        d1 /= d3;
                        d2 /= d3;
                        double d4 = this.explosionX;
                        double d6 = this.explosionY;
                        double d8 = this.explosionZ;
                        float f1 = 0.3f;
                        for (float f = this.explosionSize * (0.7f + this.world.field_73012_v.nextFloat() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                            BlockPos blockpos = new BlockPos(d4, d6, d8);
                            IBlockState iblockstate = this.world.func_180495_p(blockpos);
                            if (iblockstate.func_185904_a() != Material.field_151579_a) {
                                float f2 = this.exploder != null ? this.exploder.func_180428_a(this, this.world, blockpos, iblockstate) : iblockstate.func_177230_c().getExplosionResistance(this.world, blockpos, (Entity)null, (Explosion)this);
                                f -= (f2 + 0.3f) * 0.3f;
                            }
                            if (f > 0.0f && (this.exploder == null || this.exploder.func_174816_a(this, this.world, blockpos, iblockstate, f))) {
                                set.add(blockpos);
                            }
                            d4 += d0 * (double)0.3f;
                            d6 += d1 * (double)0.3f;
                            d8 += d2 * (double)0.3f;
                        }
                    }
                }
            }
            this.affectedBlockPositions.addAll(set);
            float f3 = this.explosionSize;
            int k1 = MathHelper.func_76128_c((double)(this.explosionX - (double)f3 - 1.0));
            int l1 = MathHelper.func_76128_c((double)(this.explosionX + (double)f3 + 1.0));
            int i2 = MathHelper.func_76128_c((double)(this.explosionY - (double)f3 - 1.0));
            int i1 = MathHelper.func_76128_c((double)(this.explosionY + (double)f3 + 1.0));
            int j2 = MathHelper.func_76128_c((double)(this.explosionZ - (double)f3 - 1.0));
            int j1 = MathHelper.func_76128_c((double)(this.explosionZ + (double)f3 + 1.0));
            List list = this.world.func_72839_b((Entity)this.exploder, new AxisAlignedBB((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1));
            ForgeEventFactory.onExplosionDetonate((World)this.world, (Explosion)this, (List)list, (double)f3);
            Vec3d vec3d = new Vec3d(this.explosionX, this.explosionY, this.explosionZ);
            for (int k2 = 0; k2 < list.size(); ++k2) {
                EntityPlayer entityplayer;
                double d13;
                double d12;
                Entity entity = (Entity)list.get(k2);
                if (entity == null || entity.func_180427_aV() || entity instanceof EntityJzahar || entity instanceof EntityFireball || !((d12 = entity.func_70011_f(this.explosionX, this.explosionY, this.explosionZ) / ((double)f3 * 4.0)) <= 1.0)) continue;
                double d5 = entity.field_70165_t - this.explosionX;
                double d7 = entity.field_70163_u - this.explosionY;
                double d9 = entity.field_70161_v - this.explosionZ;
                if (entity.func_70011_f(this.explosionX, this.explosionY, this.explosionZ) <= 3.0) {
                    d7 = entity.field_70163_u;
                }
                if ((d13 = (double)MathHelper.func_76133_a((double)(d5 * d5 + d7 * d7 + d9 * d9))) == 0.0) continue;
                d5 /= d13;
                d7 /= d13;
                d9 /= d13;
                double d14 = this.world.func_72842_a(vec3d, entity.func_174813_aQ());
                double d10 = (1.0 - d12) * d14;
                if (entity instanceof EntityLivingBase && !this.exploder.isOnSameTeam((EntityLivingBase)entity)) {
                    this.exploder.inflictEngenderMobDamage((EntityLivingBase)entity, " was blown up by ", DamageSource.func_94539_a((Explosion)this), (int)((d10 * d10 + d10) / 2.0 * 7.0 * (double)f3 + 1.0));
                }
                double d11 = d10 * (double)f3;
                if (entity instanceof EntityLivingBase) {
                    d11 = EnchantmentProtection.func_92092_a((EntityLivingBase)((EntityLivingBase)entity), (double)d10);
                }
                if (!(entity instanceof IEntityMultiPart) && entity instanceof EntityLivingBase && !this.exploder.isOnSameTeam((EntityLivingBase)entity)) {
                    entity.field_70159_w += d5 * d11;
                    entity.field_70181_x += d7 * d11 + 1.0;
                    entity.field_70179_y += d9 * d11;
                    if (entity instanceof EntityLivingBase) {
                        ((EntityLivingBase)entity).field_70177_z = ((EntityLivingBase)entity).field_70759_as = (float)MathHelper.func_181159_b((double)entity.field_70179_y, (double)entity.field_70159_w) * 57.295776f - 90.0f;
                        ((EntityLivingBase)entity).field_70761_aq = ((EntityLivingBase)entity).field_70759_as;
                        ((EntityLivingBase)entity).func_70604_c(null);
                        if (entity instanceof EntityLiving) {
                            ((EntityLiving)entity).func_70624_b(null);
                        }
                    }
                }
                if (!(entity instanceof EntityPlayer) || (entityplayer = (EntityPlayer)entity).func_175149_v() || entityplayer.func_184812_l_() && entityplayer.field_71075_bZ.field_75100_b) continue;
                this.playerKnockbackMap.put(entityplayer, new Vec3d(d5 * d10, d7 * d10, d9 * d10));
            }
        }
    }

    public void func_77279_a(boolean spawnParticles) {
        this.world.func_180498_a((EntityPlayer)null, 3000, new BlockPos(this.explosionX, this.explosionY, this.explosionZ), 0);
        if (this.isSmoking && this.explosionSize > 0.0f) {
            for (BlockPos blockpos : this.affectedBlockPositions) {
                IBlockState iblockstate = this.world.func_180495_p(blockpos);
                Block block = iblockstate.func_177230_c();
                double d0 = (float)blockpos.func_177958_n() + this.world.field_73012_v.nextFloat();
                double d1 = (float)blockpos.func_177956_o() + this.world.field_73012_v.nextFloat();
                double d2 = (float)blockpos.func_177952_p() + this.world.field_73012_v.nextFloat();
                double d3 = d0 - this.explosionX;
                double d4 = d1 - this.explosionY;
                double d5 = d2 - this.explosionZ;
                double d6 = MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
                d3 /= d6;
                d4 /= d6;
                d5 /= d6;
                double d7 = 0.5 / (d6 / (double)this.explosionSize + 0.1);
                d3 *= (d7 *= (double)(this.world.field_73012_v.nextFloat() * this.world.field_73012_v.nextFloat() + 0.3f));
                d4 *= d7;
                d5 *= d7;
                if (this.world instanceof WorldServer) {
                    ((WorldServer)this.world).func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, (d0 + this.explosionX) / 2.0, (d1 + this.explosionY) / 2.0, (d2 + this.explosionZ) / 2.0, d3, d4, d5, new int[0]);
                    ((WorldServer)this.world).func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0, d1, d2, d3, d4, d5, new int[0]);
                }
                if (iblockstate.func_185904_a() == Material.field_151579_a) continue;
                if (block.func_149659_a((Explosion)this)) {
                    block.func_180653_a(this.world, blockpos, this.world.func_180495_p(blockpos), 1.0f / this.explosionSize, 0);
                }
                block.onBlockExploded(this.world, blockpos, (Explosion)this);
            }
        }
        if (this.isFlaming) {
            for (BlockPos blockpos1 : this.affectedBlockPositions) {
                if (this.world.func_180495_p(blockpos1).func_185904_a() != Material.field_151579_a || !this.world.func_180495_p(blockpos1.func_177977_b()).func_185913_b() || this.explosionRNG.nextInt(3) != 0) continue;
                this.world.func_175656_a(blockpos1, Blocks.field_150480_ab.func_176223_P());
            }
        }
    }

    public Map<EntityPlayer, Vec3d> func_77277_b() {
        return this.playerKnockbackMap;
    }

    @Nullable
    public EntityLivingBase func_94613_c() {
        return this.exploder == null ? null : (this.exploder instanceof EntityLivingBase ? this.exploder : null);
    }

    public void func_180342_d() {
        this.affectedBlockPositions.clear();
    }

    public List<BlockPos> func_180343_e() {
        return this.affectedBlockPositions;
    }

    public Vec3d getPosition() {
        return this.position;
    }
}

