/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.glacidus.world.biome;

import com.google.common.collect.Lists;
import com.legacy.glacidus.blocks.BlocksGlacidus;
import com.legacy.glacidus.entities.hostile.EntityDropSpider;
import com.legacy.glacidus.entities.hostile.EntityMorprous;
import com.legacy.glacidus.entities.neutral.EntityPorcali;
import com.legacy.glacidus.entities.passive.EntityMerialces;
import com.legacy.glacidus.util.ModInfo;
import com.legacy.glacidus.world.biome.BiomeGlacidusDecorator;
import com.legacy.glacidus.world.features.WorldGenCoreTallGrass;
import com.legacy.glacidus.world.features.WorldGenCoreVines;
import com.legacy.glacidus.world.features.WorldGenUndergroundTree;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class BiomeGlacidus
extends Biome {
    public BiomeGlacidus() {
        super(new Biome.BiomeProperties("Glacidus").func_185396_a().func_185402_a(0xFFFFFF));
        this.setRegistryName(ModInfo.locate("glacidus"));
        this.addSpawnableCreatureList();
        this.addSpawnableMonsterList();
    }

    public void addSpawnableCreatureList() {
        ArrayList<Biome.SpawnListEntry> entityList = new ArrayList<Biome.SpawnListEntry>();
        entityList.add(new Biome.SpawnListEntry(EntityPorcali.class, 22, 2, 3));
        entityList.add(new Biome.SpawnListEntry(EntityMerialces.class, 20, 2, 3));
        this.modSpawnableLists.put(EnumCreatureType.CREATURE, entityList);
    }

    public void addSpawnableMonsterList() {
        ArrayList<Biome.SpawnListEntry> entityList = new ArrayList<Biome.SpawnListEntry>();
        entityList.add(new Biome.SpawnListEntry(EntityDropSpider.class, 10, 1, 1));
        entityList.add(new Biome.SpawnListEntry(EntityMorprous.class, 10, 1, 3));
        this.modSpawnableLists.put(EnumCreatureType.MONSTER, entityList);
    }

    public int getWaterColorMultiplier() {
        return 0xFF5555;
    }

    public void func_180624_a(World worldIn, Random rand, BlockPos pos) {
        super.func_180624_a(worldIn, rand, pos);
        WorldGenCoreVines worldgenvines = new WorldGenCoreVines(rand.nextInt(10) == 0 ? BlocksGlacidus.lumicia_grape_vine : BlocksGlacidus.lumicia_vine);
        if (TerrainGen.decorate((World)worldIn, (Random)rand, (BlockPos)pos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.GRASS)) {
            for (int j1 = 0; j1 < 30; ++j1) {
                int k = rand.nextInt(16) + 8;
                int i1 = rand.nextInt(16) + 8;
                worldgenvines.func_180709_b(worldIn, rand, pos.func_177982_a(k, 50, i1));
            }
        }
    }

    public List<Biome.SpawnListEntry> func_76747_a(EnumCreatureType creatureType) {
        if (!this.modSpawnableLists.containsKey(creatureType)) {
            this.modSpawnableLists.put(creatureType, Lists.newArrayList());
        }
        return (List)this.modSpawnableLists.get(creatureType);
    }

    public WorldGenAbstractTree func_150567_a(Random rand) {
        return new WorldGenUndergroundTree();
    }

    public WorldGenerator func_76730_b(Random rand) {
        return new WorldGenCoreTallGrass();
    }

    public BiomeDecorator func_76729_a() {
        return new BiomeGlacidusDecorator();
    }

    public Class<? extends Biome> func_150562_l() {
        return BiomeGlacidus.class;
    }
}

