/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.glacidus.world;

import com.legacy.glacidus.blocks.BlocksGlacidus;
import com.legacy.glacidus.world.WorldGenCoreCrysiumOre;
import com.legacy.glacidus.world.features.GlacidusEntitySpawner;
import com.legacy.glacidus.world.features.MapGenGlacidusCaves;
import com.legacy.glacidus.world.features.MapGenGlacidusRavine;
import com.legacy.glacidus.world.features.WorldGenBoosterIsland;
import com.legacy.glacidus.world.features.WorldGenCoreLakes;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.terraingen.ChunkGeneratorEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ChunkGeneratorGlacidus
implements IChunkGenerator {
    private double[] depthBuffer = new double[256];
    private double[] buffer;
    private NoiseGeneratorOctaves lperlinNoise1;
    private NoiseGeneratorOctaves lperlinNoise2;
    private NoiseGeneratorOctaves perlinNoise1;
    private NoiseGeneratorOctaves netherrackExculsivityNoiseGen;
    public NoiseGeneratorOctaves scaleNoise;
    public NoiseGeneratorOctaves depthNoise;
    double[] pnr;
    double[] ar;
    double[] br;
    double[] noiseData4;
    double[] dr;
    private MapGenBase caveGenerator = new MapGenGlacidusCaves();
    private MapGenBase ravineGenerator = new MapGenGlacidusRavine();
    private final WorldGenBoosterIsland boosterIsland = new WorldGenBoosterIsland();
    private World world;
    private Random random;

    public ChunkGeneratorGlacidus(World worldIn, long seed) {
        this.world = worldIn;
        this.random = new Random(seed);
        this.lperlinNoise1 = new NoiseGeneratorOctaves(this.random, 16);
        this.lperlinNoise2 = new NoiseGeneratorOctaves(this.random, 16);
        this.perlinNoise1 = new NoiseGeneratorOctaves(this.random, 8);
        this.netherrackExculsivityNoiseGen = new NoiseGeneratorOctaves(this.random, 4);
        this.scaleNoise = new NoiseGeneratorOctaves(this.random, 10);
        this.depthNoise = new NoiseGeneratorOctaves(this.random, 16);
        worldIn.func_181544_b(63);
    }

    public void prepareHeights(int p_185936_1_, int p_185936_2_, ChunkPrimer primer) {
        this.buffer = this.getHeights(this.buffer, p_185936_1_ * 4, 0, p_185936_2_ * 4, 5, 17, 5);
        for (int j1 = 0; j1 < 4; ++j1) {
            for (int k1 = 0; k1 < 4; ++k1) {
                for (int l1 = 0; l1 < 16; ++l1) {
                    double d1 = this.buffer[((j1 + 0) * 5 + k1 + 0) * 17 + l1 + 0];
                    double d2 = this.buffer[((j1 + 0) * 5 + k1 + 1) * 17 + l1 + 0];
                    double d3 = this.buffer[((j1 + 1) * 5 + k1 + 0) * 17 + l1 + 0];
                    double d4 = this.buffer[((j1 + 1) * 5 + k1 + 1) * 17 + l1 + 0];
                    double d5 = (this.buffer[((j1 + 0) * 5 + k1 + 0) * 17 + l1 + 1] - d1) * 0.125;
                    double d6 = (this.buffer[((j1 + 0) * 5 + k1 + 1) * 17 + l1 + 1] - d2) * 0.125;
                    double d7 = (this.buffer[((j1 + 1) * 5 + k1 + 0) * 17 + l1 + 1] - d3) * 0.125;
                    double d8 = (this.buffer[((j1 + 1) * 5 + k1 + 1) * 17 + l1 + 1] - d4) * 0.125;
                    for (int i2 = 0; i2 < 8; ++i2) {
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * 0.25;
                        double d13 = (d4 - d2) * 0.25;
                        for (int j2 = 0; j2 < 4; ++j2) {
                            double d15 = d10;
                            double d16 = (d11 - d10) * 0.25;
                            for (int k2 = 0; k2 < 4; ++k2) {
                                IBlockState iblockstate = null;
                                if (l1 * 8 + i2 < 24) {
                                    iblockstate = BlocksGlacidus.glacium.func_176223_P();
                                }
                                if (d15 > 0.0) {
                                    iblockstate = BlocksGlacidus.frozen_antinatric_stone.func_176223_P();
                                }
                                int l2 = j2 + j1 * 4;
                                int i3 = i2 + l1 * 8;
                                int j3 = k2 + k1 * 4;
                                if (i3 <= 26 && i3 > 0) {
                                    if (i3 <= 10 && iblockstate == null) {
                                        iblockstate = BlocksGlacidus.glacium.func_176223_P();
                                    }
                                    primer.func_177855_a(l2, i3 + 80, j3, iblockstate);
                                    if (iblockstate != null && iblockstate.func_177230_c() == BlocksGlacidus.glacium) {
                                        iblockstate = null;
                                        if (i3 <= 10) {
                                            iblockstate = Blocks.field_150353_l.func_176223_P();
                                        }
                                    }
                                    iblockstate = null;
                                    primer.func_177855_a(l2, i3, j3, iblockstate);
                                } else {
                                    if (i3 <= 80 && i3 >= 72 || i3 == 29) {
                                        iblockstate = BlocksGlacidus.frozen_antinatric_stone.func_176223_P();
                                    } else if (i3 <= 28 && i3 >= 23) {
                                        iblockstate = BlocksGlacidus.thawed_antinatric_stone.func_176223_P();
                                    }
                                    if (i3 <= 50 && i3 >= 25) {
                                        IBlockState newState = iblockstate;
                                        if (d15 >= 0.0) {
                                            newState = BlocksGlacidus.thawed_antinatric_stone.func_176223_P();
                                        }
                                        if (newState == BlocksGlacidus.frozen_antinatric_stone.func_176223_P()) {
                                            newState = Blocks.field_150353_l.func_176223_P();
                                        }
                                        primer.func_177855_a(l2, i3 - 24, j3, newState);
                                    }
                                    if (i3 <= 83 && i3 >= 81 && iblockstate == null) {
                                        iblockstate = BlocksGlacidus.glacium.func_176223_P();
                                    }
                                    if (i3 >= 90) {
                                        iblockstate = null;
                                    }
                                    if (i3 <= 63 && i3 >= 28) {
                                        if (i3 <= 35) {
                                            primer.func_177855_a(l2, i3, j3, BlocksGlacidus.thawed_antinatric_stone.func_176223_P());
                                        }
                                        i3 += 7;
                                    }
                                    if (i3 == 2 || i3 == 1) {
                                        iblockstate = BlocksGlacidus.thawed_antinatric_stone.func_176223_P();
                                    }
                                    primer.func_177855_a(l2, i3, j3, iblockstate);
                                }
                                d15 += d16;
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    public void buildSurfaces(int p_185937_1_, int p_185937_2_, ChunkPrimer primer) {
        if (!ForgeEventFactory.onReplaceBiomeBlocks((IChunkGenerator)this, (int)p_185937_1_, (int)p_185937_2_, (ChunkPrimer)primer, (World)this.world)) {
            return;
        }
        this.depthBuffer = this.netherrackExculsivityNoiseGen.func_76304_a(this.depthBuffer, p_185937_1_ * 16, p_185937_2_ * 16, 0, 16, 16, 1, 0.0625, 0.0625, 0.0625);
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                int i1 = -1;
                int data = (int)(3.0 + this.random.nextDouble() * 0.25);
                IBlockState iblockstate = BlocksGlacidus.lumicia_grass.func_176223_P();
                IBlockState iblockstate1 = BlocksGlacidus.lumicia_dirt.func_176223_P();
                for (int j1 = 127; j1 >= 0; --j1) {
                    if (j1 < 71 && j1 > 27) {
                        IBlockState iblockstate2 = primer.func_177856_a(k, j1, j);
                        if (iblockstate2.func_177230_c() != null && iblockstate2.func_185904_a() != Material.field_151579_a) {
                            if (iblockstate2.func_177230_c() != BlocksGlacidus.frozen_antinatric_stone && iblockstate2.func_177230_c() != BlocksGlacidus.thawed_antinatric_stone) continue;
                            if (i1 == -1) {
                                if (data <= 0) {
                                    iblockstate = Blocks.field_150350_a.func_176223_P();
                                    iblockstate1 = BlocksGlacidus.frozen_antinatric_stone.func_176223_P();
                                }
                                i1 = data;
                                if (j1 >= 0) {
                                    primer.func_177855_a(k, j1, j, iblockstate);
                                    continue;
                                }
                                primer.func_177855_a(k, j1, j, iblockstate1);
                                continue;
                            }
                            if (i1 <= 0) continue;
                            --i1;
                            primer.func_177855_a(k, j1, j, iblockstate1);
                            continue;
                        }
                        i1 = -1;
                        continue;
                    }
                    if (j1 != 0) continue;
                    primer.func_177855_a(k, j1, j, Blocks.field_150357_h.func_176223_P());
                }
            }
        }
    }

    public Chunk func_185932_a(int x, int z) {
        this.random.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        ChunkPrimer chunkprimer = new ChunkPrimer();
        this.prepareHeights(x, z, chunkprimer);
        this.buildSurfaces(x, z, chunkprimer);
        this.caveGenerator.func_186125_a(this.world, x, z, chunkprimer);
        this.ravineGenerator.func_186125_a(this.world, x, z, chunkprimer);
        Chunk chunk = new Chunk(this.world, chunkprimer, x, z);
        chunk.func_76603_b();
        return chunk;
    }

    private double[] getHeights(double[] p_185938_1_, int p_185938_2_, int p_185938_3_, int p_185938_4_, int p_185938_5_, int p_185938_6_, int p_185938_7_) {
        if (p_185938_1_ == null) {
            p_185938_1_ = new double[p_185938_5_ * p_185938_6_ * p_185938_7_];
        }
        ChunkGeneratorEvent.InitNoiseField event = new ChunkGeneratorEvent.InitNoiseField((IChunkGenerator)this, p_185938_1_, p_185938_2_, p_185938_3_, p_185938_4_, p_185938_5_, p_185938_6_, p_185938_7_);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.DENY) {
            return event.getNoisefield();
        }
        this.noiseData4 = this.scaleNoise.func_76304_a(this.noiseData4, p_185938_2_, p_185938_3_, p_185938_4_, p_185938_5_, 1, p_185938_7_, 1.0, 0.0, 1.0);
        this.dr = this.depthNoise.func_76304_a(this.dr, p_185938_2_, p_185938_3_, p_185938_4_, p_185938_5_, 1, p_185938_7_, 100.0, 0.0, 100.0);
        this.pnr = this.perlinNoise1.func_76304_a(this.pnr, p_185938_2_, p_185938_3_, p_185938_4_, p_185938_5_, p_185938_6_, p_185938_7_, 8.555150000000001, 34.2206, 8.555150000000001);
        this.ar = this.lperlinNoise1.func_76304_a(this.ar, p_185938_2_, p_185938_3_, p_185938_4_, p_185938_5_, p_185938_6_, p_185938_7_, 684.412, 2053.236, 684.412);
        this.br = this.lperlinNoise2.func_76304_a(this.br, p_185938_2_, p_185938_3_, p_185938_4_, p_185938_5_, p_185938_6_, p_185938_7_, 684.412, 2053.236, 684.412);
        int i = 0;
        double[] adouble = new double[p_185938_6_];
        for (int j = 0; j < p_185938_6_; ++j) {
            adouble[j] = Math.cos((double)j * Math.PI * 6.0 / (double)p_185938_6_) * 2.0;
            double d2 = j;
            if (j > p_185938_6_ / 2) {
                d2 = p_185938_6_ - 1 - j;
            }
            if (!(d2 < 4.0)) continue;
            d2 = 4.0 - d2;
            int n = j;
            adouble[n] = adouble[n] - d2 * d2 * d2 * 10.0;
        }
        for (int l = 0; l < p_185938_5_; ++l) {
            for (int i1 = 0; i1 < p_185938_7_; ++i1) {
                for (int k = 0; k < p_185938_6_; ++k) {
                    double d4 = adouble[k];
                    double d5 = this.ar[i] / 512.0;
                    double d6 = this.br[i] / 512.0;
                    double d7 = (this.pnr[i] / 10.0 + 1.0) / 2.0;
                    double d8 = d7 < 0.0 ? d5 : (d7 > 1.0 ? d6 : d5 + (d6 - d5) * d7);
                    d8 -= d4;
                    if (k > p_185938_6_ - 4) {
                        double d9 = (float)(k - (p_185938_6_ - 4)) / 3.0f;
                        d8 = d8 * (1.0 - d9) + -10.0 * d9;
                    }
                    if ((double)k < 0.0) {
                        double d10 = (0.0 - (double)k) / 4.0;
                        d10 = MathHelper.func_151237_a((double)d10, (double)0.0, (double)1.0);
                        d8 = d8 * (1.0 - d10) + -10.0 * d10;
                    }
                    p_185938_1_[i] = d8;
                    ++i;
                }
            }
        }
        return p_185938_1_;
    }

    public void func_185931_b(int x, int z) {
        BlockFalling.field_149832_M = true;
        int i = x * 16;
        int j = z * 16;
        BlockPos blockpos = new BlockPos(i, 0, j);
        Biome biome = this.world.func_180494_b(blockpos.func_177982_a(16, 0, 16));
        this.random.setSeed(this.world.func_72905_C());
        long k = this.random.nextLong() / 2L * 2L + 1L;
        long l = this.random.nextLong() / 2L * 2L + 1L;
        this.random.setSeed((long)x * k + (long)z * l ^ this.world.func_72905_C());
        ForgeEventFactory.onChunkPopulate((boolean)true, (IChunkGenerator)this, (World)this.world, (Random)this.random, (int)x, (int)z, (boolean)false);
        if (this.random.nextInt(24) == 0) {
            this.boosterIsland.func_180709_b(this.world, this.random, blockpos.func_177982_a(this.random.nextInt(16) + 8, 110 + this.random.nextInt(16), this.random.nextInt(16) + 8));
            if (this.random.nextInt(14) == 0) {
                this.boosterIsland.func_180709_b(this.world, this.random, blockpos.func_177982_a(this.random.nextInt(16) + 8, 110 + this.random.nextInt(16), this.random.nextInt(16) + 8));
            }
        }
        if (this.random.nextInt(5) == 0 && TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.random, (int)x, (int)z, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAKE)) {
            int i1 = this.random.nextInt(16) + 8;
            int j1 = this.random.nextInt(35) + 30;
            int k1 = this.random.nextInt(16) + 8;
            new WorldGenCoreLakes((Block)Blocks.field_150355_j).func_180709_b(this.world, this.random, blockpos.func_177982_a(i1, j1, k1));
        }
        if (this.random.nextInt(150) == 0 && TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.random, (int)x, (int)z, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAVA)) {
            int i2 = this.random.nextInt(16) + 8;
            int l2 = this.random.nextInt(this.random.nextInt(248) + 8);
            int k3 = this.random.nextInt(16) + 8;
            if (l2 < 60) {
                new WorldGenCoreLakes((Block)Blocks.field_150353_l).func_180709_b(this.world, this.random, blockpos.func_177982_a(i2, l2, k3));
            }
        }
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.random, (int)x, (int)z, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.GLOWSTONE)) {
            for (int j1 = 0; j1 < this.random.nextInt(this.random.nextInt(10) + 1); ++j1) {
                new WorldGenCoreCrysiumOre().func_180709_b(this.world, this.random, blockpos.func_177982_a(this.random.nextInt(16) + 8, this.random.nextInt(10) + 70, this.random.nextInt(16) + 8));
            }
        }
        biome.func_180624_a(this.world, this.random, new BlockPos(i, 0, j));
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.random, (int)x, (int)z, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ANIMALS)) {
            GlacidusEntitySpawner.performWorldGenSpawning(this.world, biome, i + 8, j + 8, 16, 16, this.random);
        }
        ForgeEventFactory.onChunkPopulate((boolean)false, (IChunkGenerator)this, (World)this.world, (Random)this.random, (int)x, (int)z, (boolean)false);
        BlockFalling.field_149832_M = false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        Biome biome = this.world.func_180494_b(pos);
        if (biome != null) {
            return biome.func_76747_a(creatureType);
        }
        return null;
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }

    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
        return null;
    }

    public void func_180514_a(Chunk chunkIn, int x, int z) {
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        return false;
    }
}

