/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.glacidus.util;

import com.google.common.base.Predicate;
import com.legacy.glacidus.blocks.BlocksGlacidus;
import net.minecraft.block.Block;
import net.minecraft.block.state.BlockWorldState;
import net.minecraft.block.state.pattern.BlockPattern;
import net.minecraft.block.state.pattern.BlockStateMatcher;
import net.minecraft.block.state.pattern.FactoryBlockPattern;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public class GlacidusUtils {
    private static BlockPattern bottomShape;
    private static BlockPattern middleShape;
    private static BlockPattern highMiddleShape;
    private static BlockPattern topShape;
    private static BlockPattern solidBottomShape;
    private static BlockPattern solidMiddleShape;
    private static BlockPattern solidHighMiddleShape;
    private static BlockPattern solidTopShape;

    public static void registerEvent(Object object) {
        MinecraftForge.EVENT_BUS.register(object);
    }

    private static void getOrCreateGlacidusPortalShape() {
        if (bottomShape == null) {
            bottomShape = FactoryBlockPattern.func_177660_a().func_177659_a(new String[]{"IIGII", "IAAAI", "IAAAI", "IAAAI", "IIIII"}).func_177662_a('G', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)Blocks.field_150426_aN))).func_177662_a('A', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)Blocks.field_150350_a))).func_177662_a('I', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)Blocks.field_150403_cj))).func_177661_b();
            solidBottomShape = FactoryBlockPattern.func_177660_a().func_177659_a(new String[]{"IIGII", "IXXXI", "IXXXI", "IXXXI", "IIIII"}).func_177662_a('X', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)BlocksGlacidus.glacidus_portal))).func_177662_a('G', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)Blocks.field_150426_aN))).func_177662_a('I', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)BlocksGlacidus.glacidus_portal_frame))).func_177661_b();
        }
        if (middleShape == null) {
            middleShape = FactoryBlockPattern.func_177660_a().func_177659_a(new String[]{"AAAAA", "AAAAA", "AAAAA", "IAAAI", "IIIII"}).func_177662_a('A', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.field_185928_a)).func_177662_a('I', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)Blocks.field_150403_cj))).func_177661_b();
            solidMiddleShape = FactoryBlockPattern.func_177660_a().func_177659_a(new String[]{"AAAAA", "AAAAA", "AAAAA", "IAAAI", "IIIII"}).func_177662_a('A', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.field_185928_a)).func_177662_a('I', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)BlocksGlacidus.glacidus_portal_frame))).func_177661_b();
        }
        if (highMiddleShape == null) {
            highMiddleShape = FactoryBlockPattern.func_177660_a().func_177659_a(new String[]{"AAAAA", "AAAAA", "AAAAA", "AAAAA", "IIIII"}).func_177662_a('A', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.field_185928_a)).func_177662_a('I', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)Blocks.field_150403_cj))).func_177661_b();
            solidHighMiddleShape = FactoryBlockPattern.func_177660_a().func_177659_a(new String[]{"AAAAA", "AAAAA", "AAAAA", "AAAAA", "IIIII"}).func_177662_a('A', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.field_185928_a)).func_177662_a('I', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)BlocksGlacidus.glacidus_portal_frame))).func_177661_b();
        }
        if (topShape == null) {
            topShape = FactoryBlockPattern.func_177660_a().func_177659_a(new String[]{"AAAAA", "AAAAA", "AAAAA", "AAAAA", "AIIIA"}).func_177662_a('A', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.field_185928_a)).func_177662_a('I', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)Blocks.field_150403_cj))).func_177661_b();
            solidTopShape = FactoryBlockPattern.func_177660_a().func_177659_a(new String[]{"AAAAA", "AAAAA", "AAAAA", "AAAAA", "AIIIA"}).func_177662_a('A', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.field_185928_a)).func_177662_a('I', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)BlocksGlacidus.glacidus_portal_frame))).func_177661_b();
        }
    }

    public static BlockPattern.PatternHelper matchesGlacidusSolidPortalShape(World world, BlockPos pos) {
        GlacidusUtils.getOrCreateGlacidusPortalShape();
        BlockPattern.PatternHelper bottomPattern = solidBottomShape.func_177681_a(world, pos);
        BlockPattern.PatternHelper middlePattern = solidMiddleShape.func_177681_a(world, pos.func_177984_a());
        BlockPattern.PatternHelper highMiddlePattern = solidHighMiddleShape.func_177681_a(world, pos.func_177981_b(2));
        BlockPattern.PatternHelper topPattern = solidTopShape.func_177681_a(world, pos.func_177981_b(3));
        if (bottomPattern != null && middlePattern != null && highMiddlePattern != null && topPattern != null) {
            return bottomPattern;
        }
        return null;
    }

    public static BlockPattern.PatternHelper matchesGlacidusPortalShape(World world, BlockPos pos) {
        GlacidusUtils.getOrCreateGlacidusPortalShape();
        BlockPattern.PatternHelper bottomPattern = bottomShape.func_177681_a(world, pos);
        BlockPattern.PatternHelper middlePattern = middleShape.func_177681_a(world, pos.func_177984_a());
        BlockPattern.PatternHelper highMiddlePattern = highMiddleShape.func_177681_a(world, pos.func_177981_b(2));
        BlockPattern.PatternHelper topPattern = topShape.func_177681_a(world, pos.func_177981_b(3));
        if (bottomPattern != null && middlePattern != null && highMiddlePattern != null && topPattern != null) {
            return bottomPattern;
        }
        return null;
    }

    public static BlockPos offsetPortalPosition(BlockPattern.PatternHelper blockpattern$patternhelper) {
        BlockPos pos = blockpattern$patternhelper.func_181117_a();
        EnumFacing facing = blockpattern$patternhelper.func_177668_c();
        if (facing == EnumFacing.EAST) {
            pos = pos.func_177967_a(facing, -3).func_177967_a(EnumFacing.NORTH, 3);
        } else if (facing == EnumFacing.WEST) {
            pos = pos.func_177967_a(facing, -1).func_177967_a(EnumFacing.NORTH, 3);
        } else if (facing == EnumFacing.NORTH) {
            pos = pos.func_177967_a(facing, -1).func_177967_a(EnumFacing.WEST, 3);
        } else if (facing == EnumFacing.SOUTH) {
            pos = pos.func_177967_a(facing, -3).func_177967_a(EnumFacing.WEST, 3);
        }
        return pos;
    }
}

