/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.glacidus.registry;

import com.legacy.glacidus.blocks.BlocksGlacidus;
import com.legacy.glacidus.client.sounds.GlacidusSounds;
import com.legacy.glacidus.items.ItemsGlacidus;
import com.legacy.glacidus.player.PlayerCapabilityProvider;
import com.legacy.glacidus.util.ModInfo;
import com.legacy.glacidus.world.WorldGlacidus;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RegistryEventHandler {
    @SubscribeEvent
    public void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getObject();
            event.addCapability(ModInfo.locate("playerCapability"), (ICapabilityProvider)new PlayerCapabilityProvider(player));
        }
    }

    @SubscribeEvent
    public void onRegisterBlocks(RegistryEvent.Register<Block> event) {
        BlocksGlacidus.setBlockRegistry((IForgeRegistry<Block>)event.getRegistry());
        BlocksGlacidus.initialization();
    }

    @SubscribeEvent
    public void onRegisterItems(RegistryEvent.Register<Item> event) {
        BlocksGlacidus.setItemRegistry((IForgeRegistry<Item>)event.getRegistry());
        ItemsGlacidus.setItemRegistry((IForgeRegistry<Item>)event.getRegistry());
        BlocksGlacidus.initialization();
        ItemsGlacidus.initialization();
    }

    @SubscribeEvent
    public void onRegisterBiomes(RegistryEvent.Register<Biome> event) {
        event.getRegistry().register((IForgeRegistryEntry)WorldGlacidus.baseBiome);
    }

    @SubscribeEvent
    public void onRegisterSounds(RegistryEvent.Register<SoundEvent> event) {
        GlacidusSounds.initialization((IForgeRegistry<SoundEvent>)event.getRegistry());
    }
}

